import React, { useEffect, useState } from 'react';
import { createUseStyles } from 'react-jss';
import { VDomRenderer } from '@jupyterlab/apputils';
import { NotebookListener } from './utils/NotebookListener';
import { ActiveNotebookListener } from './utils/ActiveNotebookListener';
import { Header } from './components/Header';
import { MainPanel } from './pages/MainPanel';
import { Spinning } from './components/Spinning';
import { UIStore } from './stores/UIStore';
import { NotebookPollingListener } from './utils/NotebookPollingListener';
import { rucioIcon } from './icons/RucioIcon';
const useStyles = createUseStyles({
    panel: {
        height: '100%',
        display: 'flex',
        flexDirection: 'column'
    },
    section: {
        flex: 1
    },
    content: {
        padding: '16px'
    },
    icon: {
        fontSize: '10pt',
        verticalAlign: 'middle'
    },
    iconText: {
        verticalAlign: 'middle',
        paddingLeft: '4px'
    }
});
const Panel = ({ instanceConfig }) => {
    const classes = useStyles();
    const { activeInstance, authType, instances } = instanceConfig;
    const [configLoaded, setConfigLoaded] = useState(false);
    useEffect(() => {
        const objActiveInstance = instances.find(i => i.name === activeInstance);
        UIStore.update(s => {
            s.activeInstance = objActiveInstance;
            s.activeAuthType = authType;
            s.instances = instances;
        });
        setConfigLoaded(true);
    }, [instanceConfig]);
    return (React.createElement("div", { className: classes.panel },
        React.createElement(Header, null),
        !!configLoaded && React.createElement(MainPanel, null),
        !configLoaded && (React.createElement("div", { className: classes.content },
            React.createElement(Spinning, { className: `${classes.icon} material-icons` }, "hourglass_top"),
            React.createElement("span", { className: classes.iconText }, "Loading...")))));
};
const ErrorPanel = ({ error }) => {
    const classes = useStyles();
    return React.createElement("div", { className: classes.content }, error);
};
const PANEL_CLASS = 'jp-RucioExtensionPanel';
export class SidebarPanel extends VDomRenderer {
    constructor(options, error) {
        super();
        super.addClass(PANEL_CLASS);
        super.title.closable = true;
        super.title.icon = rucioIcon;
        if (!options || error) {
            this.error = error || 'Failed to activate extension. Make sure that the extension is configured and installed properly.';
            return;
        }
        const { app, labShell, notebookTracker, instanceConfig } = options;
        this.app = app;
        this.instanceConfig = instanceConfig;
        this.notebookListener = new NotebookListener({
            labShell,
            notebookTracker,
            sessionManager: app.serviceManager.sessions
        });
        this.activeNotebookListener = new ActiveNotebookListener({
            labShell,
            notebookTracker,
            sessionManager: app.serviceManager.sessions,
            notebookListener: this.notebookListener
        });
        this.notebookPollingListener = new NotebookPollingListener(this.notebookListener);
    }
    render() {
        if (this.error) {
            return React.createElement(ErrorPanel, { error: this.error });
        }
        return React.createElement(Panel, { instanceConfig: this.instanceConfig });
    }
}
