from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal import Conversions


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Hold:
	"""Hold commands group definition. 2 total commands, 0 Sub-groups, 2 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("hold", core, parent)

	def reset(self) -> None:
		"""SCPI: [SOURce]:IQ:OUTPut:DIGital:OFLow:HOLD:RESet \n
		Snippet: driver.source.iq.output.digital.oflow.hold.reset() \n
		No command help available \n
		"""
		self._core.io.write(f'SOURce:IQ:OUTPut:DIGital:OFLow:HOLD:RESet')

	def reset_with_opc(self, opc_timeout_ms: int = -1) -> None:
		"""SCPI: [SOURce]:IQ:OUTPut:DIGital:OFLow:HOLD:RESet \n
		Snippet: driver.source.iq.output.digital.oflow.hold.reset_with_opc() \n
		No command help available \n
		Same as reset, but waits for the operation to complete before continuing further. Use the RsSmcv.utilities.opc_timeout_set() to set the timeout value. \n
			:param opc_timeout_ms: Maximum time to wait in milliseconds, valid only for this call."""
		self._core.io.write_with_opc(f'SOURce:IQ:OUTPut:DIGital:OFLow:HOLD:RESet', opc_timeout_ms)

	def get_state(self) -> bool:
		"""SCPI: [SOURce]:IQ:OUTPut:DIGital:OFLow:HOLD:STATe \n
		Snippet: value: bool = driver.source.iq.output.digital.oflow.hold.get_state() \n
		No command help available \n
			:return: state: No help available
		"""
		response = self._core.io.query_str('SOURce:IQ:OUTPut:DIGital:OFLow:HOLD:STATe?')
		return Conversions.str_to_bool(response)
