from .......Internal.Core import Core
from .......Internal.CommandsGroup import CommandsGroup
from .......Internal.Utilities import trim_str_response
from ....... import repcap


# noinspection PyPep8Naming,PyAttributeOutsideInit,SpellCheckingInspection
class Blocks:
	"""Blocks commands group definition. 1 total commands, 0 Sub-groups, 1 group commands"""

	def __init__(self, core: Core, parent):
		self._core = core
		self._cmd_group = CommandsGroup("blocks", core, parent)

	def get(self, physicalLayerPipe=repcap.PhysicalLayerPipe.Default) -> str:
		"""SCPI: [SOURce<HW>]:BB:A3TSc:PLP<CH>:TIL:BLOCks \n
		Snippet: value: str = driver.source.bb.a3Tsc.plp.til.blocks.get(physicalLayerPipe = repcap.PhysicalLayerPipe.Default) \n
		Queries the number of blocks contained in the current interleaving frame. \n
			:param physicalLayerPipe: optional repeated capability selector. Default value: Nr1 (settable in the interface 'Plp')
			:return: number_fec_blocks: string"""
		physicalLayerPipe_cmd_val = self._cmd_group.get_repcap_cmd_value(physicalLayerPipe, repcap.PhysicalLayerPipe)
		response = self._core.io.query_str(f'SOURce<HwInstance>:BB:A3TSc:PLP{physicalLayerPipe_cmd_val}:TIL:BLOCks?')
		return trim_str_response(response)
