import {
  AwsCredentialIdentity,
  AwsCredentialIdentityProvider,
} from "@aws-sdk/types";
export interface AssumeRoleWithWebIdentityParams {
  RoleArn: string;
  RoleSessionName: string;
  WebIdentityToken: string;
  ProviderId?: string;
  PolicyArns?: {
    arn?: string;
  }[];
  Policy?: string;
  DurationSeconds?: number;
}
declare type LowerCaseKey<T> = {
  [K in keyof T as `${Uncapitalize<string & K>}`]: T[K];
};
export interface FromWebTokenInit
  extends Pick<
    LowerCaseKey<AssumeRoleWithWebIdentityParams>,
    Exclude<
      keyof LowerCaseKey<AssumeRoleWithWebIdentityParams>,
      "roleSessionName"
    >
  > {
  roleSessionName?: string;
  roleAssumerWithWebIdentity?: (
    params: AssumeRoleWithWebIdentityParams
  ) => Promise<AwsCredentialIdentity>;
}
export declare const fromWebToken: (
  init: FromWebTokenInit
) => AwsCredentialIdentityProvider;
export {};
