"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEndpointsConfig = void 0;
const util_middleware_1 = require("@aws-sdk/util-middleware");
const getEndpointFromRegion_1 = require("./utils/getEndpointFromRegion");
const resolveEndpointsConfig = (input) => {
    var _a;
    const useDualstackEndpoint = (0, util_middleware_1.normalizeProvider)(input.useDualstackEndpoint);
    const { endpoint, useFipsEndpoint, urlParser } = input;
    return {
        ...input,
        tls: (_a = input.tls) !== null && _a !== void 0 ? _a : true,
        endpoint: endpoint
            ? (0, util_middleware_1.normalizeProvider)(typeof endpoint === "string" ? urlParser(endpoint) : endpoint)
            : () => (0, getEndpointFromRegion_1.getEndpointFromRegion)({ ...input, useDualstackEndpoint, useFipsEndpoint }),
        isCustomEndpoint: !!endpoint,
        useDualstackEndpoint,
    };
};
exports.resolveEndpointsConfig = resolveEndpointsConfig;
