import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetOpsSummaryResultFilterSensitiveLog } from "../models/models_1";
import { GetOpsSummaryRequestFilterSensitiveLog } from "../models/models_2";
import { deserializeAws_json1_1GetOpsSummaryCommand, serializeAws_json1_1GetOpsSummaryCommand, } from "../protocols/Aws_json1_1";
export class GetOpsSummaryCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, GetOpsSummaryCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "GetOpsSummaryCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: GetOpsSummaryRequestFilterSensitiveLog,
            outputFilterSensitiveLog: GetOpsSummaryResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1GetOpsSummaryCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1GetOpsSummaryCommand(output, context);
    }
}
