import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeInventoryDeletionsRequestFilterSensitiveLog, DescribeInventoryDeletionsResultFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1DescribeInventoryDeletionsCommand, serializeAws_json1_1DescribeInventoryDeletionsCommand, } from "../protocols/Aws_json1_1";
export class DescribeInventoryDeletionsCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeInventoryDeletionsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "DescribeInventoryDeletionsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeInventoryDeletionsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeInventoryDeletionsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1DescribeInventoryDeletionsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1DescribeInventoryDeletionsCommand(output, context);
    }
}
