# coding: utf-8

"""
Health Repository Provider Specifications for HIU

The following are the specifications for the APIs to be implemented at the Health Repository end if an entity is only serving the role of a HIU. The specs are essentially duplicates from the Gateway and Bridge, but put together so as to make it clear to *HIUs* which set of APIs they should implement to participate in the network.     1. The APIs are organized by the flows - **identification**, **consent flow**, **data flow** and **monitoring**. They represent the APIs that are expected to be available at the HIU end by the Gateway.    2. For majority of the APIs, if Gateway has initiated a call, there are corresponding callback APIs on the Gateway. e.g for **/consents/hiu/notify** API on HIU end, its expected that a corresponding callback API **/consents/hiu/on-notify** on Gateway is called. Such APIs are organized under the **Gateway** label.    3. Gateway relevant APIs for HIUs are grouped under **Gateway** label. These include the APIs that HIPs are required to call on the Gateway. For example, to request a CM for consent, HIU would call **/consent-requests/init** API on gateway.    4. **NOTE**, in some of the API documentations below, **X-HIP-ID** is mentioned in header (for example in /auth/on-init). These are the cases, when a particular API is applicable for both HIU and HIP (e.g an entity is playing the role of HRP representing both HIU and HIP). If you are only playing the role of HIP, then only X-HIU-ID header will be sent

The version of the OpenAPI document: 0.5
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from abdm.models.consent_artefact_response_consent_consent_detail_care_contexts_inner import (
    ConsentArtefactResponseConsentConsentDetailCareContextsInner,
)
from abdm.models.consent_artefact_response_consent_consent_detail_consent_manager import (
    ConsentArtefactResponseConsentConsentDetailConsentManager,
)
from abdm.models.consent_artefact_response_consent_consent_detail_hip import (
    ConsentArtefactResponseConsentConsentDetailHip,
)
from abdm.models.consent_artefact_response_consent_consent_detail_hiu import (
    ConsentArtefactResponseConsentConsentDetailHiu,
)
from abdm.models.consent_manager_patient_id import ConsentManagerPatientID
from abdm.models.hi_type_enum import HITypeEnum
from abdm.models.permission import Permission
from abdm.models.requester import Requester
from abdm.models.use_purpose import UsePurpose
from typing import Set
from typing_extensions import Self


class ConsentArtefactResponseConsentConsentDetail(BaseModel):
    """
    ConsentArtefactResponseConsentConsentDetail
    """  # noqa: E501

    schema_version: Optional[StrictStr] = Field(default=None, alias="schemaVersion")
    consent_id: StrictStr = Field(alias="consentId")
    created_at: datetime = Field(alias="createdAt")
    patient: ConsentManagerPatientID
    care_contexts: List[
        ConsentArtefactResponseConsentConsentDetailCareContextsInner
    ] = Field(alias="careContexts")
    purpose: UsePurpose
    hip: ConsentArtefactResponseConsentConsentDetailHip
    hiu: ConsentArtefactResponseConsentConsentDetailHiu
    consent_manager: ConsentArtefactResponseConsentConsentDetailConsentManager = Field(
        alias="consentManager"
    )
    requester: Requester
    hi_types: List[HITypeEnum] = Field(alias="hiTypes")
    permission: Permission
    __properties: ClassVar[List[str]] = [
        "schemaVersion",
        "consentId",
        "createdAt",
        "patient",
        "careContexts",
        "purpose",
        "hip",
        "hiu",
        "consentManager",
        "requester",
        "hiTypes",
        "permission",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConsentArtefactResponseConsentConsentDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of patient
        if self.patient:
            _dict["patient"] = self.patient.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in care_contexts (list)
        _items = []
        if self.care_contexts:
            for _item in self.care_contexts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["careContexts"] = _items
        # override the default output from pydantic by calling `to_dict()` of purpose
        if self.purpose:
            _dict["purpose"] = self.purpose.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hip
        if self.hip:
            _dict["hip"] = self.hip.to_dict()
        # override the default output from pydantic by calling `to_dict()` of hiu
        if self.hiu:
            _dict["hiu"] = self.hiu.to_dict()
        # override the default output from pydantic by calling `to_dict()` of consent_manager
        if self.consent_manager:
            _dict["consentManager"] = self.consent_manager.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requester
        if self.requester:
            _dict["requester"] = self.requester.to_dict()
        # override the default output from pydantic by calling `to_dict()` of permission
        if self.permission:
            _dict["permission"] = self.permission.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConsentArtefactResponseConsentConsentDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "schemaVersion": obj.get("schemaVersion"),
                "consentId": obj.get("consentId"),
                "createdAt": obj.get("createdAt"),
                "patient": ConsentManagerPatientID.from_dict(obj["patient"])
                if obj.get("patient") is not None
                else None,
                "careContexts": [
                    ConsentArtefactResponseConsentConsentDetailCareContextsInner.from_dict(
                        _item
                    )
                    for _item in obj["careContexts"]
                ]
                if obj.get("careContexts") is not None
                else None,
                "purpose": UsePurpose.from_dict(obj["purpose"])
                if obj.get("purpose") is not None
                else None,
                "hip": ConsentArtefactResponseConsentConsentDetailHip.from_dict(
                    obj["hip"]
                )
                if obj.get("hip") is not None
                else None,
                "hiu": ConsentArtefactResponseConsentConsentDetailHiu.from_dict(
                    obj["hiu"]
                )
                if obj.get("hiu") is not None
                else None,
                "consentManager": ConsentArtefactResponseConsentConsentDetailConsentManager.from_dict(
                    obj["consentManager"]
                )
                if obj.get("consentManager") is not None
                else None,
                "requester": Requester.from_dict(obj["requester"])
                if obj.get("requester") is not None
                else None,
                "hiTypes": obj.get("hiTypes"),
                "permission": Permission.from_dict(obj["permission"])
                if obj.get("permission") is not None
                else None,
            }
        )
        return _obj
