# coding: utf-8

# flake8: noqa
"""
Health Repository Provider Specifications for HIU

The following are the specifications for the APIs to be implemented at the Health Repository end if an entity is only serving the role of a HIU. The specs are essentially duplicates from the Gateway and Bridge, but put together so as to make it clear to *HIUs* which set of APIs they should implement to participate in the network.     1. The APIs are organized by the flows - **identification**, **consent flow**, **data flow** and **monitoring**. They represent the APIs that are expected to be available at the HIU end by the Gateway.    2. For majority of the APIs, if Gateway has initiated a call, there are corresponding callback APIs on the Gateway. e.g for **/consents/hiu/notify** API on HIU end, its expected that a corresponding callback API **/consents/hiu/on-notify** on Gateway is called. Such APIs are organized under the **Gateway** label.    3. Gateway relevant APIs for HIUs are grouped under **Gateway** label. These include the APIs that HIPs are required to call on the Gateway. For example, to request a CM for consent, HIU would call **/consent-requests/init** API on gateway.    4. **NOTE**, in some of the API documentations below, **X-HIP-ID** is mentioned in header (for example in /auth/on-init). These are the cases, when a particular API is applicable for both HIU and HIP (e.g an entity is playing the role of HRP representing both HIU and HIP). If you are only playing the role of HIP, then only X-HIU-ID header will be sent

The version of the OpenAPI document: 0.5
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

# import models into model package
from abdm.models.access_token_validity import AccessTokenValidity
from abdm.models.auth_confirm_identifier import AuthConfirmIdentifier
from abdm.models.auth_confirm_identifier_type import AuthConfirmIdentifierType
from abdm.models.auth_meta import AuthMeta
from abdm.models.authentication_mode import AuthenticationMode
from abdm.models.care_context_definition import CareContextDefinition
from abdm.models.certificate_or_key_get_schema import CertificateOrKeyGetSchema
from abdm.models.certs import Certs
from abdm.models.consent import Consent
from abdm.models.consent_acknowledgement import ConsentAcknowledgement
from abdm.models.consent_artefact_reference import ConsentArtefactReference
from abdm.models.consent_artefact_response import ConsentArtefactResponse
from abdm.models.consent_artefact_response_consent import ConsentArtefactResponseConsent
from abdm.models.consent_artefact_response_consent_consent_detail import (
    ConsentArtefactResponseConsentConsentDetail,
)
from abdm.models.consent_artefact_response_consent_consent_detail_care_contexts_inner import (
    ConsentArtefactResponseConsentConsentDetailCareContextsInner,
)
from abdm.models.consent_artefact_response_consent_consent_detail_consent_manager import (
    ConsentArtefactResponseConsentConsentDetailConsentManager,
)
from abdm.models.consent_artefact_response_consent_consent_detail_hip import (
    ConsentArtefactResponseConsentConsentDetailHip,
)
from abdm.models.consent_artefact_response_consent_consent_detail_hiu import (
    ConsentArtefactResponseConsentConsentDetailHiu,
)
from abdm.models.consent_fetch_request import ConsentFetchRequest
from abdm.models.consent_manager_patient_id import ConsentManagerPatientID
from abdm.models.consent_request import ConsentRequest
from abdm.models.consent_request_consent import ConsentRequestConsent
from abdm.models.consent_request_consent_patient import ConsentRequestConsentPatient
from abdm.models.consent_request_init_response import ConsentRequestInitResponse
from abdm.models.consent_request_init_response_consent_request import (
    ConsentRequestInitResponseConsentRequest,
)
from abdm.models.consent_request_status_request import ConsentRequestStatusRequest
from abdm.models.consent_status import ConsentStatus
from abdm.models.data_notification import DataNotification
from abdm.models.data_notification_entries_inner import DataNotificationEntriesInner
from abdm.models.date_range import DateRange
from abdm.models.entry_content import EntryContent
from abdm.models.entry_link import EntryLink
from abdm.models.error import Error
from abdm.models.error_response import ErrorResponse
from abdm.models.event_category_detail import EventCategoryDetail
from abdm.models.hi_request import HIRequest
from abdm.models.hi_request_hi_request import HIRequestHiRequest
from abdm.models.hi_type_enum import HITypeEnum
from abdm.models.hiu_consent_notification_event import HIUConsentNotificationEvent
from abdm.models.hiu_consent_notification_event_notification import (
    HIUConsentNotificationEventNotification,
)
from abdm.models.hiu_consent_notification_response import HIUConsentNotificationResponse
from abdm.models.hiu_consent_request_status import HIUConsentRequestStatus
from abdm.models.hiu_consent_request_status_consent_request import (
    HIUConsentRequestStatusConsentRequest,
)
from abdm.models.hiu_health_information_request_response import (
    HIUHealthInformationRequestResponse,
)
from abdm.models.hiu_health_information_request_response_hi_request import (
    HIUHealthInformationRequestResponseHiRequest,
)
from abdm.models.hiu_subscription import HIUSubscription
from abdm.models.hiu_subscription_context import HIUSubscriptionContext
from abdm.models.hiu_subscription_event_content import HIUSubscriptionEventContent
from abdm.models.hiu_subscription_notification import HIUSubscriptionNotification
from abdm.models.hiu_subscription_notification_acknowledgment import (
    HIUSubscriptionNotificationAcknowledgment,
)
from abdm.models.hiu_subscription_notification_acknowledgment_acknowledgement import (
    HIUSubscriptionNotificationAcknowledgmentAcknowledgement,
)
from abdm.models.hiu_subscription_notification_event import (
    HIUSubscriptionNotificationEvent,
)
from abdm.models.hiu_subscription_request_notification_acknowledgement import (
    HIUSubscriptionRequestNotificationAcknowledgement,
)
from abdm.models.hiu_subscription_request_notification_acknowledgement_acknowledgement import (
    HIUSubscriptionRequestNotificationAcknowledgementAcknowledgement,
)
from abdm.models.hiu_subscription_request_receipt import HIUSubscriptionRequestReceipt
from abdm.models.health_information_notification import HealthInformationNotification
from abdm.models.health_information_notification_notification import (
    HealthInformationNotificationNotification,
)
from abdm.models.health_information_notification_notification_notifier import (
    HealthInformationNotificationNotificationNotifier,
)
from abdm.models.health_information_notification_notification_status_notification import (
    HealthInformationNotificationNotificationStatusNotification,
)
from abdm.models.health_information_notification_notification_status_notification_status_responses_inner import (
    HealthInformationNotificationNotificationStatusNotificationStatusResponsesInner,
)
from abdm.models.heartbeat_response import HeartbeatResponse
from abdm.models.hiu_patient_status_notification import HiuPatientStatusNotification
from abdm.models.hiu_patient_status_notification_notification import (
    HiuPatientStatusNotificationNotification,
)
from abdm.models.hiu_patient_status_notification_notification_patient import (
    HiuPatientStatusNotificationNotificationPatient,
)
from abdm.models.identifier import Identifier
from abdm.models.identifier_type import IdentifierType
from abdm.models.key_material import KeyMaterial
from abdm.models.key_object import KeyObject
from abdm.models.open_id_configuration import OpenIdConfiguration
from abdm.models.organization_representation import OrganizationRepresentation
from abdm.models.patient_address import PatientAddress
from abdm.models.patient_auth_confirm_request import PatientAuthConfirmRequest
from abdm.models.patient_auth_confirm_request_credential import (
    PatientAuthConfirmRequestCredential,
)
from abdm.models.patient_auth_confirm_response import PatientAuthConfirmResponse
from abdm.models.patient_auth_confirm_response_auth import (
    PatientAuthConfirmResponseAuth,
)
from abdm.models.patient_auth_init_request import PatientAuthInitRequest
from abdm.models.patient_auth_init_request_query import PatientAuthInitRequestQuery
from abdm.models.patient_auth_init_request_query_requester import (
    PatientAuthInitRequestQueryRequester,
)
from abdm.models.patient_auth_init_response import PatientAuthInitResponse
from abdm.models.patient_auth_init_response_auth import PatientAuthInitResponseAuth
from abdm.models.patient_auth_mode_query_request import PatientAuthModeQueryRequest
from abdm.models.patient_auth_mode_query_request_query import (
    PatientAuthModeQueryRequestQuery,
)
from abdm.models.patient_auth_mode_query_request_query_requester import (
    PatientAuthModeQueryRequestQueryRequester,
)
from abdm.models.patient_auth_mode_query_response import PatientAuthModeQueryResponse
from abdm.models.patient_auth_mode_query_response_auth import (
    PatientAuthModeQueryResponseAuth,
)
from abdm.models.patient_auth_notification import PatientAuthNotification
from abdm.models.patient_auth_notification_acknowledgement import (
    PatientAuthNotificationAcknowledgement,
)
from abdm.models.patient_auth_notification_acknowledgement_acknowledgement import (
    PatientAuthNotificationAcknowledgementAcknowledgement,
)
from abdm.models.patient_auth_notification_auth import PatientAuthNotificationAuth
from abdm.models.patient_auth_purpose import PatientAuthPurpose
from abdm.models.patient_auth_requester import PatientAuthRequester
from abdm.models.patient_demographic import PatientDemographic
from abdm.models.patient_demographic_response import PatientDemographicResponse
from abdm.models.patient_gender import PatientGender
from abdm.models.patient_identification_request import PatientIdentificationRequest
from abdm.models.patient_identification_request_query import (
    PatientIdentificationRequestQuery,
)
from abdm.models.patient_identification_request_query_patient import (
    PatientIdentificationRequestQueryPatient,
)
from abdm.models.patient_identification_request_query_requester import (
    PatientIdentificationRequestQueryRequester,
)
from abdm.models.patient_identification_response import PatientIdentificationResponse
from abdm.models.patient_identification_response_patient import (
    PatientIdentificationResponsePatient,
)
from abdm.models.patient_status_notification import PatientStatusNotification
from abdm.models.permission import Permission
from abdm.models.permission_date_range import PermissionDateRange
from abdm.models.permission_frequency import PermissionFrequency
from abdm.models.request_reference import RequestReference
from abdm.models.requester import Requester
from abdm.models.requester_identifier import RequesterIdentifier
from abdm.models.session_request import SessionRequest
from abdm.models.session_response import SessionResponse
from abdm.models.subscription_approval_notification import (
    SubscriptionApprovalNotification,
)
from abdm.models.subscription_approval_notification_notification import (
    SubscriptionApprovalNotificationNotification,
)
from abdm.models.subscription_category import SubscriptionCategory
from abdm.models.subscription_period import SubscriptionPeriod
from abdm.models.subscription_request import SubscriptionRequest
from abdm.models.subscription_request_subscription import (
    SubscriptionRequestSubscription,
)
from abdm.models.subscription_status import SubscriptionStatus
from abdm.models.use_purpose import UsePurpose
