# coding: utf-8

"""
Health Repository Provider Specifications for HIU

The following are the specifications for the APIs to be implemented at the Health Repository end if an entity is only serving the role of a HIU. The specs are essentially duplicates from the Gateway and Bridge, but put together so as to make it clear to *HIUs* which set of APIs they should implement to participate in the network.     1. The APIs are organized by the flows - **identification**, **consent flow**, **data flow** and **monitoring**. They represent the APIs that are expected to be available at the HIU end by the Gateway.    2. For majority of the APIs, if Gateway has initiated a call, there are corresponding callback APIs on the Gateway. e.g for **/consents/hiu/notify** API on HIU end, its expected that a corresponding callback API **/consents/hiu/on-notify** on Gateway is called. Such APIs are organized under the **Gateway** label.    3. Gateway relevant APIs for HIUs are grouped under **Gateway** label. These include the APIs that HIPs are required to call on the Gateway. For example, to request a CM for consent, HIU would call **/consent-requests/init** API on gateway.    4. **NOTE**, in some of the API documentations below, **X-HIP-ID** is mentioned in header (for example in /auth/on-init). These are the cases, when a particular API is applicable for both HIU and HIP (e.g an entity is playing the role of HRP representing both HIU and HIP). If you are only playing the role of HIP, then only X-HIU-ID header will be sent

The version of the OpenAPI document: 0.5
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from abdm.models.patient_auth_confirm_response import PatientAuthConfirmResponse
from abdm.models.patient_auth_init_response import PatientAuthInitResponse
from abdm.models.patient_auth_mode_query_response import PatientAuthModeQueryResponse
from abdm.models.patient_auth_notification import PatientAuthNotification

from abdm.api_client import ApiClient, RequestSerialized
from abdm.api_response import ApiResponse
from abdm.rest import RESTResponseType


class UserAuthApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def v05_users_auth_notify_post(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_notification: PatientAuthNotification,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """notification API in case of DIRECT mode of authentication by the CM

        This API is called by CM to confirm authentication of users. The transactionId returned is same as that passed in /auth/on-init. The \"auth.status\" conveys whether the request was GRANTED or DENIED.    1. **auth.accessToken** - is specific to the purpose mentioned in the /auth/init. This token needs to be used for initiating the intended action. For example for HIP initiated linking of care-contexts   2. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.   3. The payload is conditional to the purpose of auth. If purpose specified in /auth/init is KYC or KYC_AND_LINK, then patient details are passed. **auth.accessToken** is passed only if the purpose is LINK or KYC_AND_LINK.

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_notification: (required)
        :type patient_auth_notification: PatientAuthNotification
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_notify_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_notification=patient_auth_notification,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v05_users_auth_notify_post_with_http_info(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_notification: PatientAuthNotification,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """notification API in case of DIRECT mode of authentication by the CM

        This API is called by CM to confirm authentication of users. The transactionId returned is same as that passed in /auth/on-init. The \"auth.status\" conveys whether the request was GRANTED or DENIED.    1. **auth.accessToken** - is specific to the purpose mentioned in the /auth/init. This token needs to be used for initiating the intended action. For example for HIP initiated linking of care-contexts   2. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.   3. The payload is conditional to the purpose of auth. If purpose specified in /auth/init is KYC or KYC_AND_LINK, then patient details are passed. **auth.accessToken** is passed only if the purpose is LINK or KYC_AND_LINK.

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_notification: (required)
        :type patient_auth_notification: PatientAuthNotification
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_notify_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_notification=patient_auth_notification,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v05_users_auth_notify_post_without_preload_content(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_notification: PatientAuthNotification,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """notification API in case of DIRECT mode of authentication by the CM

        This API is called by CM to confirm authentication of users. The transactionId returned is same as that passed in /auth/on-init. The \"auth.status\" conveys whether the request was GRANTED or DENIED.    1. **auth.accessToken** - is specific to the purpose mentioned in the /auth/init. This token needs to be used for initiating the intended action. For example for HIP initiated linking of care-contexts   2. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.   3. The payload is conditional to the purpose of auth. If purpose specified in /auth/init is KYC or KYC_AND_LINK, then patient details are passed. **auth.accessToken** is passed only if the purpose is LINK or KYC_AND_LINK.

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_notification: (required)
        :type patient_auth_notification: PatientAuthNotification
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_notify_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_notification=patient_auth_notification,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v05_users_auth_notify_post_serialize(
        self,
        authorization,
        x_hip_id,
        x_hiu_id,
        patient_auth_notification,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if authorization is not None:
            _header_params["Authorization"] = authorization
        if x_hip_id is not None:
            _header_params["X-HIP-ID"] = x_hip_id
        if x_hiu_id is not None:
            _header_params["X-HIU-ID"] = x_hiu_id
        # process the form parameters
        # process the body parameter
        if patient_auth_notification is not None:
            _body_params = patient_auth_notification

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/xml"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/xml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v0.5/users/auth/notify",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v05_users_auth_on_confirm_post(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_confirm_response: PatientAuthConfirmResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """callback API for /auth/confirm (in case of MEDIATED auth) to confirm user authentication or not

        This API is called by CM to confirm authentication of users.    1. **auth.accessToken** - is specific to the purpose mentioned in the /auth/init. This token needs to be used for initiating the intended action. For example for HIP initiated linking of care-contexts   2. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_confirm_response: (required)
        :type patient_auth_confirm_response: PatientAuthConfirmResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_confirm_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_confirm_response=patient_auth_confirm_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v05_users_auth_on_confirm_post_with_http_info(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_confirm_response: PatientAuthConfirmResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """callback API for /auth/confirm (in case of MEDIATED auth) to confirm user authentication or not

        This API is called by CM to confirm authentication of users.    1. **auth.accessToken** - is specific to the purpose mentioned in the /auth/init. This token needs to be used for initiating the intended action. For example for HIP initiated linking of care-contexts   2. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_confirm_response: (required)
        :type patient_auth_confirm_response: PatientAuthConfirmResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_confirm_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_confirm_response=patient_auth_confirm_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v05_users_auth_on_confirm_post_without_preload_content(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_confirm_response: PatientAuthConfirmResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """callback API for /auth/confirm (in case of MEDIATED auth) to confirm user authentication or not

        This API is called by CM to confirm authentication of users.    1. **auth.accessToken** - is specific to the purpose mentioned in the /auth/init. This token needs to be used for initiating the intended action. For example for HIP initiated linking of care-contexts   2. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_confirm_response: (required)
        :type patient_auth_confirm_response: PatientAuthConfirmResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_confirm_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_confirm_response=patient_auth_confirm_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v05_users_auth_on_confirm_post_serialize(
        self,
        authorization,
        x_hip_id,
        x_hiu_id,
        patient_auth_confirm_response,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if authorization is not None:
            _header_params["Authorization"] = authorization
        if x_hip_id is not None:
            _header_params["X-HIP-ID"] = x_hip_id
        if x_hiu_id is not None:
            _header_params["X-HIU-ID"] = x_hiu_id
        # process the form parameters
        # process the body parameter
        if patient_auth_confirm_response is not None:
            _body_params = patient_auth_confirm_response

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/xml"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/xml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v0.5/users/auth/on-confirm",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v05_users_auth_on_fetch_modes_post(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_mode_query_response: PatientAuthModeQueryResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Identification result for a consent-manager user-id

        If a patient is found then **auth** attribute contains the supported modes for the specified purpose.  Otherwise, error is raised for invalid requests or for non-existent id. Note in addition to the \"Authorization\" header, one of the following headers must be specified 1. **X-HIU-ID** if the requester is HIU (identified from /auth/fetch-modes requester.id) 2. **X-HIP-ID** if the requester is HIP (identified from /auth/fetch-modes requester.id)

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_mode_query_response: (required)
        :type patient_auth_mode_query_response: PatientAuthModeQueryResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_fetch_modes_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_mode_query_response=patient_auth_mode_query_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v05_users_auth_on_fetch_modes_post_with_http_info(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_mode_query_response: PatientAuthModeQueryResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Identification result for a consent-manager user-id

        If a patient is found then **auth** attribute contains the supported modes for the specified purpose.  Otherwise, error is raised for invalid requests or for non-existent id. Note in addition to the \"Authorization\" header, one of the following headers must be specified 1. **X-HIU-ID** if the requester is HIU (identified from /auth/fetch-modes requester.id) 2. **X-HIP-ID** if the requester is HIP (identified from /auth/fetch-modes requester.id)

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_mode_query_response: (required)
        :type patient_auth_mode_query_response: PatientAuthModeQueryResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_fetch_modes_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_mode_query_response=patient_auth_mode_query_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v05_users_auth_on_fetch_modes_post_without_preload_content(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_mode_query_response: PatientAuthModeQueryResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Identification result for a consent-manager user-id

        If a patient is found then **auth** attribute contains the supported modes for the specified purpose.  Otherwise, error is raised for invalid requests or for non-existent id. Note in addition to the \"Authorization\" header, one of the following headers must be specified 1. **X-HIU-ID** if the requester is HIU (identified from /auth/fetch-modes requester.id) 2. **X-HIP-ID** if the requester is HIP (identified from /auth/fetch-modes requester.id)

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_mode_query_response: (required)
        :type patient_auth_mode_query_response: PatientAuthModeQueryResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_fetch_modes_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_mode_query_response=patient_auth_mode_query_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v05_users_auth_on_fetch_modes_post_serialize(
        self,
        authorization,
        x_hip_id,
        x_hiu_id,
        patient_auth_mode_query_response,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if authorization is not None:
            _header_params["Authorization"] = authorization
        if x_hip_id is not None:
            _header_params["X-HIP-ID"] = x_hip_id
        if x_hiu_id is not None:
            _header_params["X-HIU-ID"] = x_hiu_id
        # process the form parameters
        # process the body parameter
        if patient_auth_mode_query_response is not None:
            _body_params = patient_auth_mode_query_response

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/xml"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/xml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v0.5/users/auth/on-fetch-modes",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def v05_users_auth_on_init_post(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_init_response: PatientAuthInitResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Response to user authentication initialization from HIP

        If the patient's id is valid, CM will return a transactionId as initialization of user auth. If the request is valid, then 'auth.mode' will convey how the authentication should be done. The authentication can be *mediated* or *direct*. For mediated authentication modes, HIP or HIU is epected to send over relevant code (OTP/token) or demographic info via subsequent API call to /auth/confirm. for direct authentication case, CM will notify requester through/users/auth/notify API.     1. **auth.mode** conveys whats the mode of authentication is, and what is expected from HIP/HIU in the subsequent /auth/confirm API call. Possible values        1. MOBILE_OTP - auth via OTP to registered mobile. Mediated.        2. AADHAAR_OTP - auth initiated with Aadhaar with OTP. Mediated.        3. DEMOGRAPHICS - auth initiated with demographic verification       4. DIRECT - for authentication directly with the patient. e.g. Mobile App, SMS. In this case, the HIP/HIU is not expected to call subsequent /auth/confirm call. CM will do direct authentication with the User (e.g. Mobile App, SMS etc) and will notify requester   2. **meta.expiry** conveys the expiry time of the token and the authentication session   3. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.    4. **NOTE**, only KYC purpose is applicable for HIU    The error section in the body, represents the potential errors that may have occurred. Possible reasons:   1. Patient id is invalid

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_init_response: (required)
        :type patient_auth_init_response: PatientAuthInitResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_init_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_init_response=patient_auth_init_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def v05_users_auth_on_init_post_with_http_info(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_init_response: PatientAuthInitResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Response to user authentication initialization from HIP

        If the patient's id is valid, CM will return a transactionId as initialization of user auth. If the request is valid, then 'auth.mode' will convey how the authentication should be done. The authentication can be *mediated* or *direct*. For mediated authentication modes, HIP or HIU is epected to send over relevant code (OTP/token) or demographic info via subsequent API call to /auth/confirm. for direct authentication case, CM will notify requester through/users/auth/notify API.     1. **auth.mode** conveys whats the mode of authentication is, and what is expected from HIP/HIU in the subsequent /auth/confirm API call. Possible values        1. MOBILE_OTP - auth via OTP to registered mobile. Mediated.        2. AADHAAR_OTP - auth initiated with Aadhaar with OTP. Mediated.        3. DEMOGRAPHICS - auth initiated with demographic verification       4. DIRECT - for authentication directly with the patient. e.g. Mobile App, SMS. In this case, the HIP/HIU is not expected to call subsequent /auth/confirm call. CM will do direct authentication with the User (e.g. Mobile App, SMS etc) and will notify requester   2. **meta.expiry** conveys the expiry time of the token and the authentication session   3. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.    4. **NOTE**, only KYC purpose is applicable for HIU    The error section in the body, represents the potential errors that may have occurred. Possible reasons:   1. Patient id is invalid

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_init_response: (required)
        :type patient_auth_init_response: PatientAuthInitResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_init_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_init_response=patient_auth_init_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def v05_users_auth_on_init_post_without_preload_content(
        self,
        authorization: Annotated[
            StrictStr,
            Field(
                description="Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge."
            ),
        ],
        x_hip_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information provider to which the request was intended."
            ),
        ],
        x_hiu_id: Annotated[
            StrictStr,
            Field(
                description="Identifier of the health information user to which the request was intended."
            ),
        ],
        patient_auth_init_response: PatientAuthInitResponse,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Response to user authentication initialization from HIP

        If the patient's id is valid, CM will return a transactionId as initialization of user auth. If the request is valid, then 'auth.mode' will convey how the authentication should be done. The authentication can be *mediated* or *direct*. For mediated authentication modes, HIP or HIU is epected to send over relevant code (OTP/token) or demographic info via subsequent API call to /auth/confirm. for direct authentication case, CM will notify requester through/users/auth/notify API.     1. **auth.mode** conveys whats the mode of authentication is, and what is expected from HIP/HIU in the subsequent /auth/confirm API call. Possible values        1. MOBILE_OTP - auth via OTP to registered mobile. Mediated.        2. AADHAAR_OTP - auth initiated with Aadhaar with OTP. Mediated.        3. DEMOGRAPHICS - auth initiated with demographic verification       4. DIRECT - for authentication directly with the patient. e.g. Mobile App, SMS. In this case, the HIP/HIU is not expected to call subsequent /auth/confirm call. CM will do direct authentication with the User (e.g. Mobile App, SMS etc) and will notify requester   2. **meta.expiry** conveys the expiry time of the token and the authentication session   3. **NOTE**, only one of **X-HIP-ID** or **X-HIU-ID** will be sent as part of header, not both.    4. **NOTE**, only KYC purpose is applicable for HIU    The error section in the body, represents the potential errors that may have occurred. Possible reasons:   1. Patient id is invalid

        :param authorization: Access token which was issued after successful login with gateway auth server, which will be sent by gateway to authenticate itself with API bridge. (required)
        :type authorization: str
        :param x_hip_id: Identifier of the health information provider to which the request was intended. (required)
        :type x_hip_id: str
        :param x_hiu_id: Identifier of the health information user to which the request was intended. (required)
        :type x_hiu_id: str
        :param patient_auth_init_response: (required)
        :type patient_auth_init_response: PatientAuthInitResponse
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._v05_users_auth_on_init_post_serialize(
            authorization=authorization,
            x_hip_id=x_hip_id,
            x_hiu_id=x_hiu_id,
            patient_auth_init_response=patient_auth_init_response,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ErrorResponse",
            "401": "ErrorResponse",
            "500": "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _v05_users_auth_on_init_post_serialize(
        self,
        authorization,
        x_hip_id,
        x_hiu_id,
        patient_auth_init_response,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:
        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if authorization is not None:
            _header_params["Authorization"] = authorization
        if x_hip_id is not None:
            _header_params["X-HIP-ID"] = x_hip_id
        if x_hiu_id is not None:
            _header_params["X-HIU-ID"] = x_hiu_id
        # process the form parameters
        # process the body parameter
        if patient_auth_init_response is not None:
            _body_params = patient_auth_init_response

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "application/xml"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json", "application/xml"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/v0.5/users/auth/on-init",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
