import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::FSx::FileSystem`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export interface CfnFileSystemProps {
    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype
     */
    readonly fileSystemType: string;
    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::FSx::FileSystem.BackupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid
     */
    readonly backupId?: string;
    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration
     */
    readonly lustreConfiguration?: CfnFileSystem.LustreConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity
     */
    readonly storageCapacity?: number;
    /**
     * `AWS::FSx::FileSystem.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype
     */
    readonly storageType?: string;
    /**
     * `AWS::FSx::FileSystem.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration
     */
    readonly windowsConfiguration?: CfnFileSystem.WindowsConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare class CfnFileSystem extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::FSx::FileSystem";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFileSystem;
    /**
     * @external
     * @cloudformationAttribute LustreMountName
     */
    readonly attrLustreMountName: string;
    /**
     * `AWS::FSx::FileSystem.FileSystemType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-filesystemtype
     */
    fileSystemType: string;
    /**
     * `AWS::FSx::FileSystem.SubnetIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::FSx::FileSystem.BackupId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-backupid
     */
    backupId: string | undefined;
    /**
     * `AWS::FSx::FileSystem.KmsKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::FSx::FileSystem.LustreConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-lustreconfiguration
     */
    lustreConfiguration: CfnFileSystem.LustreConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::FSx::FileSystem.SecurityGroupIds`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::FSx::FileSystem.StorageCapacity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagecapacity
     */
    storageCapacity: number | undefined;
    /**
     * `AWS::FSx::FileSystem.StorageType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-storagetype
     */
    storageType: string | undefined;
    /**
     * `AWS::FSx::FileSystem.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::FSx::FileSystem.WindowsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html#cfn-fsx-filesystem-windowsconfiguration
     */
    windowsConfiguration: CfnFileSystem.WindowsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::FSx::FileSystem`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFileSystemProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html
     */
    interface LustreConfigurationProperty {
        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutoImportPolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-autoimportpolicy
         */
        readonly autoImportPolicy?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-automaticbackupretentiondays
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.CopyTagsToBackups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-copytagstobackups
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-dailyautomaticbackupstarttime
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DeploymentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-deploymenttype
         */
        readonly deploymentType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.DriveCacheType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-drivecachetype
         */
        readonly driveCacheType?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ExportPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-exportpath
         */
        readonly exportPath?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importpath
         */
        readonly importPath?: string;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.ImportedFileChunkSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-importedfilechunksize
         */
        readonly importedFileChunkSize?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.PerUnitStorageThroughput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-perunitstoragethroughput
         */
        readonly perUnitStorageThroughput?: number;
        /**
         * `CfnFileSystem.LustreConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-lustreconfiguration.html#cfn-fsx-filesystem-lustreconfiguration-weeklymaintenancestarttime
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html
     */
    interface SelfManagedActiveDirectoryConfigurationProperty {
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DnsIps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-dnsips
         */
        readonly dnsIps?: string[];
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.DomainName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-domainname
         */
        readonly domainName?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.FileSystemAdministratorsGroup`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-filesystemadministratorsgroup
         */
        readonly fileSystemAdministratorsGroup?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.OrganizationalUnitDistinguishedName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-organizationalunitdistinguishedname
         */
        readonly organizationalUnitDistinguishedName?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-password
         */
        readonly password?: string;
        /**
         * `CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty.UserName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration-username
         */
        readonly userName?: string;
    }
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`.
 *
 * @external
 * @cloudformationResource AWS::FSx::FileSystem
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
export declare namespace CfnFileSystem {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html
     */
    interface WindowsConfigurationProperty {
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ActiveDirectoryId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-activedirectoryid
         */
        readonly activeDirectoryId?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.AutomaticBackupRetentionDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-automaticbackupretentiondays
         */
        readonly automaticBackupRetentionDays?: number;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.CopyTagsToBackups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-copytagstobackups
         */
        readonly copyTagsToBackups?: boolean | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DailyAutomaticBackupStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-dailyautomaticbackupstarttime
         */
        readonly dailyAutomaticBackupStartTime?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.DeploymentType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-deploymenttype
         */
        readonly deploymentType?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.PreferredSubnetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-preferredsubnetid
         */
        readonly preferredSubnetId?: string;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.SelfManagedActiveDirectoryConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-selfmanagedactivedirectoryconfiguration
         */
        readonly selfManagedActiveDirectoryConfiguration?: CfnFileSystem.SelfManagedActiveDirectoryConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.ThroughputCapacity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-throughputcapacity
         */
        readonly throughputCapacity?: number;
        /**
         * `CfnFileSystem.WindowsConfigurationProperty.WeeklyMaintenanceStartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-fsx-filesystem-windowsconfiguration.html#cfn-fsx-filesystem-windowsconfiguration-weeklymaintenancestarttime
         */
        readonly weeklyMaintenanceStartTime?: string;
    }
}
