"""
nsp is a Python package for extracting and visualizing activation patterns of PyTorch neural networks. It can
- extract the computational graph of a neural network as a directed graph.
- extract the activation pattern generated by an input of a neural network.
- compute the Fourier transform of an activation pattern (signal) in a neural network (directed graph) based on [1] and [2].
- visualize activation patterns and their Fourier coefficients.
"""

from .activations import Activations
from .transformer import Transformer
from .nngraph import NNGraph
from .visualizer import Visualizer
from .outputLoader import OutputLoader
