"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const common_1 = require("../utils/common");
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.pbSubnets = [];
        this.pvSubnets = [];
        this.natSubnets = [];
        this.peeringConnectionIds = {};
        this.vpc = new aws_cdk_lib_1.aws_ec2.Vpc(this, 'VPC', props.vpc);
        if (props.peeringConfigs) {
            const convertPeeringConfig = common_1.ObjToStrMap(props.peeringConfigs);
            convertPeeringConfig.forEach((createVpcPeering, key) => {
                let peeringConnectionIdByKey = new aws_cdk_lib_1.aws_ec2.CfnVPCPeeringConnection(this, `PeerDestination-${key}`, {
                    vpcId: this.vpc.vpcId,
                    peerVpcId: createVpcPeering.peeringVpcId,
                    peerOwnerId: createVpcPeering.peerOwnerId,
                    peerRoleArn: createVpcPeering.peerAssumeRoleArn,
                    peerRegion: createVpcPeering.peerRegion,
                });
                const tags = common_1.ObjToStrMap(createVpcPeering.tags);
                tags.forEach((v, k) => {
                    aws_cdk_lib_1.Tags.of(peeringConnectionIdByKey).add(k, v);
                });
                console.log(`test value ${peeringConnectionIdByKey}`);
                this.peeringConnectionIds[key] = peeringConnectionIdByKey;
            });
        }
        props.subnets.forEach((subnetProps) => {
            let subnet = this.createSubnet(subnetProps, this.vpc, this.peeringConnectionIds);
            subnet.forEach((sb) => {
                if (sb instanceof aws_cdk_lib_1.aws_ec2.PublicSubnet) {
                    this.pbSubnets.push(sb);
                }
                else if (sb instanceof aws_cdk_lib_1.aws_ec2.PrivateSubnet) {
                    this.pvSubnets.push(sb);
                }
                if (subnetProps.subnetGroupName == 'NATGateway' &&
                    sb instanceof aws_cdk_lib_1.aws_ec2.PublicSubnet) {
                    this.natSubnets.push(sb);
                }
            });
        });
        const internetGateway = new aws_cdk_lib_1.aws_ec2.CfnInternetGateway(this, 'InternetGateway', {});
        const att = new aws_cdk_lib_1.aws_ec2.CfnVPCGatewayAttachment(this, 'VPCGatewayAttachement', {
            internetGatewayId: internetGateway.ref,
            vpcId: this.vpc.vpcId,
        });
        this.pbSubnets.forEach((pb) => {
            pb.addDefaultInternetRoute(internetGateway.ref, att);
        });
        if (this.natSubnets.length > 0) {
            this.natProvider = aws_cdk_lib_1.aws_ec2.NatProvider.gateway();
            this.natProvider.configureNat({
                vpc: this.vpc,
                natSubnets: this.natSubnets,
                privateSubnets: this.pvSubnets,
            });
        }
    }
    createSubnet(option, vpc, peeringConnectionId) {
        const subnets = [];
        const SUBNETTYPE_TAG = 'aws-cdk:subnet-type';
        const SUBNETNAME_TAG = 'aws-cdk:subnet-name';
        const NAME_TAG = 'Name';
        if (option.availabilityZones.length != option.cidrBlock.length) {
            // eslint-disable-next-line max-len
            throw new Error("You cannot reference a Subnet's availability zone if it was not supplied. Add the availabilityZone when importing using option.fromSubnetAttributes()");
        }
        option.availabilityZones.forEach((az, index) => {
            let subnet = option.subnetType === aws_cdk_lib_1.aws_ec2.SubnetType.PUBLIC
                ? new aws_cdk_lib_1.aws_ec2.PublicSubnet(this, `${option.subnetGroupName}Subnet${index}`, {
                    availabilityZone: az,
                    cidrBlock: option.cidrBlock[index],
                    vpcId: vpc.vpcId,
                    mapPublicIpOnLaunch: true,
                })
                : new aws_cdk_lib_1.aws_ec2.PrivateSubnet(this, `${option.subnetGroupName}Subnet${index}`, {
                    availabilityZone: az,
                    cidrBlock: option.cidrBlock[index],
                    vpcId: vpc.vpcId,
                    mapPublicIpOnLaunch: false,
                });
            option.routes?.forEach((route, routeIndex) => {
                if (peeringConnectionId != undefined && route.existingVpcPeeringRouteKey != undefined) {
                    console.log(`peeringConnectionid ${peeringConnectionId}`);
                    console.log(`existingVpcPeeringRouteKey ${route.existingVpcPeeringRouteKey}`);
                    console.log(`object ${Object.keys(peeringConnectionId)}`);
                    console.log(`object get value ${peeringConnectionId[route.existingVpcPeeringRouteKey]}`);
                    let routeId = peeringConnectionId[route.existingVpcPeeringRouteKey];
                    console.log(routeId);
                    if (routeId != undefined) {
                        subnet.addRoute(`${option.subnetGroupName}${routeIndex}RouteEntry`, {
                            routerId: routeId.ref,
                            routerType: route.routerType,
                            destinationCidrBlock: route.destinationCidrBlock,
                        });
                    }
                }
                else if (route.routerId != undefined) {
                    subnet.addRoute(`${option.subnetGroupName}${routeIndex}RouteEntry`, {
                        routerId: route.routerId ?? '',
                        routerType: route.routerType,
                        destinationCidrBlock: route.destinationCidrBlock,
                    });
                }
            });
            aws_cdk_lib_1.Tags.of(subnet).add(SUBNETNAME_TAG, option.subnetGroupName);
            aws_cdk_lib_1.Tags.of(subnet).add(SUBNETTYPE_TAG, option.subnetType);
            if (option.tags != undefined) {
                const tags = common_1.ObjToStrMap(option.tags);
                tags.forEach((v, k) => {
                    aws_cdk_lib_1.Tags.of(subnet).add(k, v);
                });
            }
            subnets.push(subnet);
        });
        const nacl = new aws_cdk_lib_1.aws_ec2.NetworkAcl(this, `${option.subnetGroupName}NACL`, {
            vpc: vpc,
            subnetSelection: {
                subnets: subnets,
            },
        });
        aws_cdk_lib_1.Tags.of(nacl).add(NAME_TAG, nacl.node.path);
        option.ingressNetworkACL?.forEach((ingressNACL, index) => {
            new aws_cdk_lib_1.aws_ec2.NetworkAclEntry(this, `${option.subnetGroupName}IngressNACL-${index}`, {
                ruleNumber: 100 + index,
                cidr: ingressNACL.cidr,
                networkAcl: nacl,
                traffic: ingressNACL.traffic,
                direction: aws_cdk_lib_1.aws_ec2.TrafficDirection.INGRESS,
            });
        });
        option.egressNetworkACL?.forEach((ingressNACL, index) => {
            new aws_cdk_lib_1.aws_ec2.NetworkAclEntry(this, `${option.subnetGroupName}EgressNACL-${index}`, {
                ruleNumber: 100 + index,
                cidr: ingressNACL.cidr,
                networkAcl: nacl,
                traffic: ingressNACL.traffic,
                direction: aws_cdk_lib_1.aws_ec2.TrafficDirection.EGRESS,
            });
        });
        new aws_cdk_lib_1.CfnOutput(this, `${option.subnetGroupName}OutPutSubnets`, {
            value: subnets
                .map((subnet) => {
                return subnet.subnetId;
            })
                .join(','),
            description: `${option.subnetGroupName} subnets cross`,
        });
        new aws_cdk_lib_1.CfnOutput(this, `${option.subnetGroupName}OutPutNACL`, {
            value: nacl.networkAclId,
            description: `${option.subnetGroupName} subnets associated this nacl`,
        });
        return subnets;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@smallcase/cdk-vpc-module.Network", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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