from typing import Literal
from typing_extensions import TypeAlias


HtmlTags: TypeAlias = Literal[
    # Content sectioning
    "address",
    "article",
    "aside",
    "footer",
    "header",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "main",
    "nav",
    "section",
    # Text content
    "blockquote",
    "dd",
    "div",
    "dl",
    "dt",
    "figcaption",
    "figure",
    "hr",
    "li",
    "menu",
    "ol",
    "p",
    "pre",
    "ul",
    # Inline text semantics
    "a",
    "abbr",
    "b",
    "bdi",
    "bdo",
    "cite",
    "code",
    "data",
    "dfn",
    "em",
    "i",
    "kbd",
    "mark",
    "q",
    "rp",
    "rt",
    "ruby",
    "s",
    "samp",
    "small",
    "span",
    "strong",
    "sub",
    "sup",
    "time",
    "u",
    "var",
    "wbr",
    # Image and multimedia
    "area",
    "audio",
    "img",
    "map",
    "track",
    "video",
    # Embedded content
    "embed",
    "iframe",
    "object",
    "param",
    "picture",
    "portal",
    "source",
    # SVG and MathML
    "svg",
    "math",
    # Scripting
    "canvas",
    # Demarcating edits
    "del",
    "ins",
    # Table content
    "caption",
    "col",
    "colgroup",
    "table",
    "tbody",
    "td",
    "tfoot",
    "th",
    "thead",
    "tr",
    # Forms
    "button",
    "datalist",
    "fieldset",
    "form",
    "input",
    "label",
    "legend",
    "meter",
    "optgroup",
    "option",
    "output",
    "progress",
    "select",
    "textarea",
    # Interactive elements
    "details",
    "dialog",
    "summary",
]
