# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['photoshop',
 'photoshop.api',
 'photoshop.api.colors',
 'photoshop.api.open_options',
 'photoshop.api.save_options']

package_data = \
{'': ['*']}

install_requires = \
['comtypes==1.1.7']

setup_kwargs = {
    'name': 'photoshop-python-api',
    'version': '0.15.2',
    'description': 'Python API for Photoshop.',
    'long_description': '<p align="center">\n<img src="https://i.imgur.com/cjp1RH6.png" alt="logo"></a>\n</p>\n\n<p align="center">\n<a href="https://img.shields.io/pypi/pyversions/photoshop-python-api">\n<img src="https://img.shields.io/pypi/pyversions/photoshop-python-api" alt="python version"></a>\n<a href="https://badge.fury.io/py/photoshop-python-api">\n<img src="https://img.shields.io/pypi/v/photoshop-python-api?color=green" alt="PyPI version"></a>\n<a href="https://photoshop-python-api.readthedocs.io/en/master/?badge=master">\n<img src="https://readthedocs.org/projects/photoshop-python-api/badge/?version=master" alt="Documentation Status"></a>\n<img src="https://img.shields.io/pypi/dw/photoshop-python-api" alt="Downloads Status"></a>\n<a href="https://pepy.tech/badge/photoshop-python-api">\n<img src="https://pepy.tech/badge/photoshop-python-api" alt="Downloads"></a>\n<img src="https://img.shields.io/pypi/l/photoshop-python-api" alt="License"></a>\n<img src="https://img.shields.io/pypi/format/photoshop-python-api" alt="pypi format"></a>\n<a href="https://discord.gg/AnxSa6n">\n<img src="https://img.shields.io/discord/724615671400628314" alt="Chat on Discird"></a>\n<a href="https://github.com/loonghao/photoshop-python-api/graphs/commit-activity">\n<img src="https://img.shields.io/badge/Maintained%3F-yes-green.svg" alt="Maintenance"></a>\n\n<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->\n[![All Contributors](https://img.shields.io/badge/all_contributors-8-orange.svg?style=flat-square)](#contributors-)\n<!-- ALL-CONTRIBUTORS-BADGE:END --> \n</p>\n\n<p align="center">Python API for Photoshop.</p>\n\n<p align="center"><em>The example above was created with Photoshop Python API. Check it out at <a href="https://photoshop-python-api.readthedocs.io/en/master/examples.html.">photoshop-python-api.readthedocs.io/examples</a>.</em></p>\n\nHas been tested and used Photoshop version:\n\n| Photoshop Version | Supported          |\n| ----------------- | ------------------ |\n| 2020              | :white_check_mark: |\n| cc2019            | :white_check_mark: |\n| cc2018            | :white_check_mark: |\n| cc2017            | :white_check_mark: |\n\n\n\nInstalling\n----------\nYou can install via pip.\n\n```cmd\npip install photoshop_python_api\n```\nor through clone from Github.\n```git exclude\ngit clone https://github.com/loonghao/photoshop_python_api.git\n```\nInstall package.\n```cmd\npython setup.py install\n```\n\nSince it uses COM (Component Object Model) connect Photoshop, it can be used \nin any DCC software with a python interpreter.\n\n\nHello World\n-----------\n\n```python\n\nimport photoshop.api as ps\napp = ps.Application()\ndoc = app.documents.add()\nnew_doc = doc.artLayers.add()\ntext_color = ps.SolidColor()\ntext_color.rgb.green = 255\nnew_text_layer = new_doc\nnew_text_layer.kind = ps.LayerKind.TextLayer\nnew_text_layer.textItem.contents = \'Hello, World!\'\nnew_text_layer.textItem.position = [160, 167]\nnew_text_layer.textItem.size = 40\nnew_text_layer.textItem.color = text_color\noptions = ps.JPEGSaveOptions(quality=5)\n# # save to jpg\njpg = \'d:/hello_world.jpg\'\ndoc.saveAs(jpg, options, asCopy=True)\napp.doJavaScript(f\'alert("save to jpg: {jpg}")\')\n\n```\n![demo](https://i.imgur.com/25TrzbV.gif)\n\n\nPhotoshop Session\n-----------------\nUse it as context.\n\n```python\n\nfrom photoshop import Session\n\n\nwith Session(action="new_document") as ps:\n    doc = ps.active_document\n    text_color = ps.SolidColor()\n    text_color.rgb.green = 255\n    new_text_layer = doc.artLayers.add()\n    new_text_layer.kind = ps.LayerKind.TextLayer\n    new_text_layer.textItem.contents = \'Hello, World!\'\n    new_text_layer.textItem.position = [160, 167]\n    new_text_layer.textItem.size = 40\n    new_text_layer.textItem.color = text_color\n    options = ps.JPEGSaveOptions(quality=5)\n    jpg = \'d:/hello_world.jpg\'\n    doc.saveAs(jpg, options, asCopy=True)\n    ps.app.doJavaScript(f\'alert("save to jpg: {jpg}")\')\n\n\n```\n\n## Contributors ✨\n\nThanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore-start -->\n<!-- markdownlint-disable -->\n<table>\n  <tr>\n    <td align="center"><a href="https://github.com/loonghao"><img src="https://avatars1.githubusercontent.com/u/13111745?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Hal</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/commits?author=loonghao" title="Code">💻</a></td>\n    <td align="center"><a href="https://github.com/voodraizer"><img src="https://avatars0.githubusercontent.com/u/1332729?v=4?s=100" width="100px;" alt=""/><br /><sub><b>voodraizer</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3Avoodraizer" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/brunosly"><img src="https://avatars2.githubusercontent.com/u/4326547?v=4?s=100" width="100px;" alt=""/><br /><sub><b>brunosly</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3Abrunosly" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/tubi-carrillo"><img src="https://avatars3.githubusercontent.com/u/33004093?v=4?s=100" width="100px;" alt=""/><br /><sub><b>tubi</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3Atubi-carrillo" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/wjxiehaixin"><img src="https://avatars0.githubusercontent.com/u/48039822?v=4?s=100" width="100px;" alt=""/><br /><sub><b>wjxiehaixin</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3Awjxiehaixin" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="http://it.econline.net"><img src="https://avatars0.githubusercontent.com/u/993544?v=4?s=100" width="100px;" alt=""/><br /><sub><b>罗马钟</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3Aenzozhong" title="Bug reports">🐛</a></td>\n    <td align="center"><a href="https://github.com/ClementHector"><img src="https://avatars.githubusercontent.com/u/7068597?v=4?s=100" width="100px;" alt=""/><br /><sub><b>clement</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3AClementHector" title="Bug reports">🐛</a></td>\n  </tr>\n  <tr>\n    <td align="center"><a href="https://github.com/krevlinmen"><img src="https://avatars.githubusercontent.com/u/56278440?v=4?s=100" width="100px;" alt=""/><br /><sub><b>krevlinmen</b></sub></a><br /><a href="https://github.com/loonghao/photoshop-python-api/issues?q=author%3Akrevlinmen" title="Bug reports">🐛</a></td>\n  </tr>\n</table>\n\n<!-- markdownlint-restore -->\n<!-- prettier-ignore-end -->\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the [all-contributors](https://allcontributors.org) specification.\nContributions of any kind are welcome!\n\n\nhow to get Photoshop program ID\n-------------------------------\n```PS>\nGet-ChildItem "HKLM:\\SOFTWARE\\Classes" | \n  ?{ ($_.PSChildName -match "^[a-z]+\\.[a-z]+(\\.\\d+)?$") -and ($_.GetSubKeyNames() -contains "CLSID") } | \n  ?{ $_.PSChildName -match "Photoshop.Application" } | ft PSChildName\n```\n![get_program_id](https://i.imgur.com/UwPN7qq.png)\n\n[How to get a list of COM objects from the registry](https://rakhesh.com/powershell/how-to-get-a-list-of-com-objects-from-the-registry/)\n\nUseful links\n------------\n- https://theiviaxx.github.io/photoshop-docs/Photoshop/\n- http://wwwimages.adobe.com/www.adobe.com/content/dam/acom/en/devnet/photoshop/pdfs/photoshop-cc-javascript-ref-2015.pdf\n- https://github.com/lohriialo/photoshop-scripting-python\n- https://www.adobe.com/devnet/photoshop/scripting.html\n- https://www.youtube.com/playlist?list=PLUEniN8BpU8-Qmjyv3zyWaNvDYwJOJZ4m\n- http://yearbook.github.io/esdocs/#/Photoshop/Application\n- http://www.shining-lucy.com/wiki/page.php?id=appwiki:photoshop:ps_script\n- http://www.tonton-pixel.com/wp-content/uploads/DecisionTable.pdf\n- http://jongware.mit.edu/pscs5js_html/psjscs5/pc_Application.html\n- https://indd.adobe.com/view/a0207571-ff5b-4bbf-a540-07079bd21d75\n- http://shining-lucy.com/wiki/page.php?id=appwiki:photoshop:ps_script\n- http://web.archive.org/web/20140121053819/http://www.pcpix.com/Photoshop/char.html\n- http://www.tonton-pixel.com/scripts/utility-scripts/get-equivalent-id-code/index.html\n- https://github.com/Adobe-CEP/Samples/tree/master/PhotoshopEvents\n- https://evanmccall.wordpress.com/2015/03/09/how-to-develop-photoshop-tools-in-python\n',
    'author': 'longhao',
    'author_email': 'hal.long@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/loonghao/photoshop-python-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
