/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;

class ValencyChecker {
    private static final Map<ChemEl, Integer> expectedDefaultValency = new EnumMap<ChemEl, Integer>(ChemEl.class);
    private static final Map<ChemEl, Integer> valencyInHW = new EnumMap<ChemEl, Integer>(ChemEl.class);
    private static final Map<ChemEl, Map<Integer, Integer[]>> possibleStableValencies = new EnumMap<ChemEl, Map<Integer, Integer[]>>(ChemEl.class);

    ValencyChecker() {
    }

    static Integer getMaximumValency(ChemEl chemEl, int charge) {
        Integer[] possibleStableValenciesForElAndCharge;
        Map<Integer, Integer[]> possibleStableValenciesForEl = possibleStableValencies.get((Object)chemEl);
        if (possibleStableValenciesForEl != null && (possibleStableValenciesForElAndCharge = possibleStableValenciesForEl.get(charge)) != null) {
            return possibleStableValenciesForElAndCharge[possibleStableValenciesForElAndCharge.length - 1];
        }
        return null;
    }

    static Integer getMaximumValency(Atom a) {
        Integer maxVal = a.getLambdaConventionValency() != null ? Integer.valueOf(a.getLambdaConventionValency() + a.getProtonsExplicitlyAddedOrRemoved()) : ValencyChecker.getMaximumValency(a.getElement(), a.getCharge());
        return maxVal;
    }

    static boolean checkValency(Atom a) {
        int valency = a.getIncomingValency() + a.getOutValency();
        Integer maxVal = ValencyChecker.getMaximumValency(a);
        if (maxVal == null) {
            return true;
        }
        return valency <= maxVal;
    }

    static boolean checkValencyAvailableForBond(Atom a, int bondOrder) {
        int valency = a.getIncomingValency() + bondOrder;
        Integer maxVal = ValencyChecker.getMaximumValency(a);
        if (maxVal == null) {
            return true;
        }
        return valency <= maxVal;
    }

    static boolean checkValencyAvailableForReplacementByHeteroatom(Atom a, Atom heteroatom) {
        int valency = a.getIncomingValency();
        valency += a.hasSpareValency() ? 1 : 0;
        Integer maxValOfHeteroAtom = ValencyChecker.getMaximumValency(heteroatom.getElement(), heteroatom.getCharge());
        return maxValOfHeteroAtom == null || (valency += a.getOutValency()) <= maxValOfHeteroAtom;
    }

    static Integer getDefaultValency(ChemEl chemlEl) {
        return expectedDefaultValency.get((Object)chemlEl);
    }

    static Integer getHWValency(ChemEl chemEl) {
        return valencyInHW.get((Object)chemEl);
    }

    static Integer[] getPossibleValencies(ChemEl chemEl, int charge) {
        Map<Integer, Integer[]> possibleStableValenciesForEl = possibleStableValencies.get((Object)chemEl);
        if (possibleStableValenciesForEl == null) {
            return null;
        }
        return possibleStableValenciesForEl.get(charge);
    }

    static {
        expectedDefaultValency.put(ChemEl.B, 3);
        expectedDefaultValency.put(ChemEl.Al, 3);
        expectedDefaultValency.put(ChemEl.In, 3);
        expectedDefaultValency.put(ChemEl.Ga, 3);
        expectedDefaultValency.put(ChemEl.Tl, 3);
        expectedDefaultValency.put(ChemEl.C, 4);
        expectedDefaultValency.put(ChemEl.Si, 4);
        expectedDefaultValency.put(ChemEl.Ge, 4);
        expectedDefaultValency.put(ChemEl.Sn, 4);
        expectedDefaultValency.put(ChemEl.Pb, 4);
        expectedDefaultValency.put(ChemEl.N, 3);
        expectedDefaultValency.put(ChemEl.P, 3);
        expectedDefaultValency.put(ChemEl.As, 3);
        expectedDefaultValency.put(ChemEl.Sb, 3);
        expectedDefaultValency.put(ChemEl.Bi, 3);
        expectedDefaultValency.put(ChemEl.O, 2);
        expectedDefaultValency.put(ChemEl.S, 2);
        expectedDefaultValency.put(ChemEl.Se, 2);
        expectedDefaultValency.put(ChemEl.Te, 2);
        expectedDefaultValency.put(ChemEl.Po, 2);
        expectedDefaultValency.put(ChemEl.F, 1);
        expectedDefaultValency.put(ChemEl.Cl, 1);
        expectedDefaultValency.put(ChemEl.Br, 1);
        expectedDefaultValency.put(ChemEl.I, 1);
        expectedDefaultValency.put(ChemEl.At, 1);
        valencyInHW.put(ChemEl.F, 1);
        valencyInHW.put(ChemEl.Cl, 1);
        valencyInHW.put(ChemEl.Br, 1);
        valencyInHW.put(ChemEl.I, 1);
        valencyInHW.put(ChemEl.O, 2);
        valencyInHW.put(ChemEl.S, 2);
        valencyInHW.put(ChemEl.Se, 2);
        valencyInHW.put(ChemEl.Te, 2);
        valencyInHW.put(ChemEl.N, 3);
        valencyInHW.put(ChemEl.P, 3);
        valencyInHW.put(ChemEl.As, 3);
        valencyInHW.put(ChemEl.Sb, 3);
        valencyInHW.put(ChemEl.Bi, 3);
        valencyInHW.put(ChemEl.Si, 4);
        valencyInHW.put(ChemEl.Ge, 4);
        valencyInHW.put(ChemEl.Sn, 4);
        valencyInHW.put(ChemEl.Pb, 4);
        valencyInHW.put(ChemEl.B, 3);
        valencyInHW.put(ChemEl.Al, 3);
        valencyInHW.put(ChemEl.Ga, 3);
        valencyInHW.put(ChemEl.In, 3);
        valencyInHW.put(ChemEl.Tl, 3);
        valencyInHW.put(ChemEl.Hg, 2);
        valencyInHW.put(ChemEl.C, 4);
        possibleStableValencies.put(ChemEl.H, new HashMap());
        possibleStableValencies.put(ChemEl.He, new HashMap());
        possibleStableValencies.put(ChemEl.Li, new HashMap());
        possibleStableValencies.put(ChemEl.Be, new HashMap());
        possibleStableValencies.put(ChemEl.B, new HashMap());
        possibleStableValencies.put(ChemEl.C, new HashMap());
        possibleStableValencies.put(ChemEl.N, new HashMap());
        possibleStableValencies.put(ChemEl.O, new HashMap());
        possibleStableValencies.put(ChemEl.F, new HashMap());
        possibleStableValencies.put(ChemEl.Ne, new HashMap());
        possibleStableValencies.put(ChemEl.Na, new HashMap());
        possibleStableValencies.put(ChemEl.Mg, new HashMap());
        possibleStableValencies.put(ChemEl.Al, new HashMap());
        possibleStableValencies.put(ChemEl.Si, new HashMap());
        possibleStableValencies.put(ChemEl.P, new HashMap());
        possibleStableValencies.put(ChemEl.S, new HashMap());
        possibleStableValencies.put(ChemEl.Cl, new HashMap());
        possibleStableValencies.put(ChemEl.Ar, new HashMap());
        possibleStableValencies.put(ChemEl.K, new HashMap());
        possibleStableValencies.put(ChemEl.Ca, new HashMap());
        possibleStableValencies.put(ChemEl.Ga, new HashMap());
        possibleStableValencies.put(ChemEl.Ge, new HashMap());
        possibleStableValencies.put(ChemEl.As, new HashMap());
        possibleStableValencies.put(ChemEl.Se, new HashMap());
        possibleStableValencies.put(ChemEl.Br, new HashMap());
        possibleStableValencies.put(ChemEl.Kr, new HashMap());
        possibleStableValencies.put(ChemEl.Rb, new HashMap());
        possibleStableValencies.put(ChemEl.Sr, new HashMap());
        possibleStableValencies.put(ChemEl.In, new HashMap());
        possibleStableValencies.put(ChemEl.Sn, new HashMap());
        possibleStableValencies.put(ChemEl.Sb, new HashMap());
        possibleStableValencies.put(ChemEl.Te, new HashMap());
        possibleStableValencies.put(ChemEl.I, new HashMap());
        possibleStableValencies.put(ChemEl.Xe, new HashMap());
        possibleStableValencies.put(ChemEl.Cs, new HashMap());
        possibleStableValencies.put(ChemEl.Ba, new HashMap());
        possibleStableValencies.put(ChemEl.Tl, new HashMap());
        possibleStableValencies.put(ChemEl.Pb, new HashMap());
        possibleStableValencies.put(ChemEl.Bi, new HashMap());
        possibleStableValencies.put(ChemEl.Po, new HashMap());
        possibleStableValencies.put(ChemEl.At, new HashMap());
        possibleStableValencies.put(ChemEl.Rn, new HashMap());
        possibleStableValencies.put(ChemEl.Fr, new HashMap());
        possibleStableValencies.put(ChemEl.Ra, new HashMap());
        possibleStableValencies.get((Object)ChemEl.H).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.He).put(0, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Li).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Be).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.B).put(0, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.C).put(0, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.N).put(0, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.O).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.F).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Ne).put(0, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Na).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Mg).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.Al).put(0, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Si).put(0, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.P).put(0, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.S).put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Cl).put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Ar).put(0, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.K).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Ca).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.Ga).put(0, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Ge).put(0, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.As).put(0, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Se).put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Br).put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Kr).put(0, new Integer[]{0, 2});
        possibleStableValencies.get((Object)ChemEl.Rb).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Sr).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.In).put(0, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Sn).put(0, new Integer[]{2, 4});
        possibleStableValencies.get((Object)ChemEl.Sb).put(0, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Te).put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.I).put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Xe).put(0, new Integer[]{0, 2, 4, 6, 8});
        possibleStableValencies.get((Object)ChemEl.Cs).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Ba).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.Tl).put(0, new Integer[]{1, 3});
        possibleStableValencies.get((Object)ChemEl.Pb).put(0, new Integer[]{2, 4});
        possibleStableValencies.get((Object)ChemEl.Bi).put(0, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Po).put(0, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.At).put(0, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Rn).put(0, new Integer[]{0, 2, 4, 6, 8});
        possibleStableValencies.get((Object)ChemEl.Fr).put(0, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Ra).put(0, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.H).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Li).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Be).put(1, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Be).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.B).put(2, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.B).put(1, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.B).put(-1, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.B).put(-2, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.C).put(2, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.C).put(1, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.C).put(-1, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.C).put(-2, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.N).put(2, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.N).put(1, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.N).put(-1, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.N).put(-2, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.O).put(2, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.O).put(1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.O).put(-1, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.O).put(-2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.F).put(2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.F).put(1, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.F).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Na).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Na).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Mg).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Al).put(3, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Al).put(2, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Al).put(1, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.Al).put(-1, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.Al).put(-2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Si).put(2, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.Si).put(1, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Si).put(-1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Si).put(-2, new Integer[]{2});
        possibleStableValencies.get((Object)ChemEl.P).put(2, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.P).put(1, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.P).put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.P).put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.S).put(2, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.S).put(1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.S).put(-1, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.S).put(-2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Cl).put(2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Cl).put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Cl).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.K).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.K).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ca).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ca).put(1, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Ga).put(3, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ga).put(2, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Ga).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ga).put(-1, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.Ga).put(-2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Ge).put(4, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ge).put(1, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Ge).put(-1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Ge).put(-2, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.As).put(2, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.As).put(1, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.As).put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.As).put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.As).put(-3, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Se).put(2, new Integer[]{4});
        possibleStableValencies.get((Object)ChemEl.Se).put(1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Se).put(-1, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Se).put(-2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Br).put(2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Br).put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Br).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Rb).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Rb).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Sr).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Sr).put(1, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.In).put(3, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.In).put(2, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.In).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.In).put(-1, new Integer[]{2, 4});
        possibleStableValencies.get((Object)ChemEl.In).put(-2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Sn).put(4, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Sn).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Sn).put(1, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Sn).put(-1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Sn).put(-2, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Sb).put(3, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Sb).put(2, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Sb).put(1, new Integer[]{2, 4});
        possibleStableValencies.get((Object)ChemEl.Sb).put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Sb).put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Te).put(2, new Integer[]{2, 4});
        possibleStableValencies.get((Object)ChemEl.Te).put(1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Te).put(-1, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.Te).put(-2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.I).put(2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.I).put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.I).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Cs).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Cs).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ba).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ba).put(1, new Integer[]{1});
        possibleStableValencies.get((Object)ChemEl.Pb).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Pb).put(1, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Pb).put(-1, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.Pb).put(-2, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Bi).put(3, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Bi).put(2, new Integer[]{3});
        possibleStableValencies.get((Object)ChemEl.Bi).put(1, new Integer[]{2, 4});
        possibleStableValencies.get((Object)ChemEl.Bi).put(-1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.Bi).put(-2, new Integer[]{1, 3, 5, 7});
        possibleStableValencies.get((Object)ChemEl.At).put(2, new Integer[]{3, 5});
        possibleStableValencies.get((Object)ChemEl.At).put(1, new Integer[]{2, 4, 6});
        possibleStableValencies.get((Object)ChemEl.At).put(-1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Fr).put(1, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ra).put(2, new Integer[]{0});
        possibleStableValencies.get((Object)ChemEl.Ra).put(1, new Integer[]{1});
    }
}

