/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.PreProcessingException;

class StringTools {
    StringTools() {
    }

    static String stringListToString(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        int lastIndexOfList = list.size() - 1;
        for (int i = 0; i < lastIndexOfList; ++i) {
            sb.append(list.get(i));
            sb.append(separator);
        }
        if (lastIndexOfList >= 0) {
            sb.append(list.get(lastIndexOfList));
        }
        return sb.toString();
    }

    static String multiplyString(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    static String arrayToString(String[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        int lastIndexOfArray = stringArray.length - 1;
        for (int i = 0; i < lastIndexOfArray; ++i) {
            sb.append(stringArray[i]);
            sb.append(separator);
        }
        if (lastIndexOfArray >= 0) {
            sb.append(stringArray[lastIndexOfArray]);
        }
        return sb.toString();
    }

    static String convertNonAsciiAndNormaliseRepresentation(String s) throws PreProcessingException {
        StringBuilder sb = new StringBuilder(s.length());
        int l = s.length();
        block5: for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': {
                    sb.append(" ");
                    continue block5;
                }
                case '`': {
                    sb.append("'");
                    continue block5;
                }
                case '\"': {
                    sb.append("''");
                    continue block5;
                }
                default: {
                    if (c >= '\u0080') {
                        sb.append(StringTools.getReplacementForNonASCIIChar(c));
                        continue block5;
                    }
                    if (c <= '\u001f') continue block5;
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String getReplacementForNonASCIIChar(char c) throws PreProcessingException {
        switch (c) {
            case '\u03b1': {
                return "alpha";
            }
            case '\u03b2': {
                return "beta";
            }
            case '\u03b3': {
                return "gamma";
            }
            case '\u03b4': {
                return "delta";
            }
            case '\u03b5': {
                return "epsilon";
            }
            case '\u03b6': {
                return "zeta";
            }
            case '\u03b7': {
                return "eta";
            }
            case '\u03b8': {
                return "theta";
            }
            case '\u03b9': {
                return "iota";
            }
            case '\u03ba': {
                return "kappa";
            }
            case '\u03bb': {
                return "lambda";
            }
            case '\u03bc': {
                return "mu";
            }
            case '\u03bd': {
                return "nu";
            }
            case '\u03be': {
                return "xi";
            }
            case '\u03bf': {
                return "omicron";
            }
            case '\u03c0': {
                return "pi";
            }
            case '\u03c1': {
                return "rho";
            }
            case '\u03c2': {
                return "stigma";
            }
            case '\u03c3': {
                return "sigma";
            }
            case '\u03c4': {
                return "tau";
            }
            case '\u03c5': {
                return "upsilon";
            }
            case '\u03c6': {
                return "phi";
            }
            case '\u03c7': {
                return "chi";
            }
            case '\u03c8': {
                return "psi";
            }
            case '\u03c9': {
                return "omega";
            }
            case '\u1d05': {
                return "D";
            }
            case '\u029f': {
                return "L";
            }
            case '\u00b1': {
                return "+-";
            }
            case '\u2213': {
                return "-+";
            }
            case '\u2192': 
            case '\u2794': 
            case '\u2799': 
            case '\u279c': {
                return "->";
            }
            case '\u00c6': {
                return "AE";
            }
            case '\u00e6': {
                return "ae";
            }
            case '\u0152': {
                return "OE";
            }
            case '\u0153': {
                return "oe";
            }
            case '\u0132': {
                return "IJ";
            }
            case '\u0133': {
                return "ij";
            }
            case '\u1d6b': {
                return "ue";
            }
            case '\ufb00': {
                return "ff";
            }
            case '\ufb01': {
                return "fi";
            }
            case '\ufb02': {
                return "fl";
            }
            case '\ufb03': {
                return "ffi";
            }
            case '\ufb04': {
                return "ffl";
            }
            case '\ufb06': {
                return "st";
            }
            case '\u00e0': {
                return "a";
            }
            case '\u00c0': {
                return "A";
            }
            case '\u00e1': {
                return "a";
            }
            case '\u00c1': {
                return "A";
            }
            case '\u00e2': {
                return "a";
            }
            case '\u00c2': {
                return "A";
            }
            case '\u00e3': {
                return "a";
            }
            case '\u00c3': {
                return "A";
            }
            case '\u00e4': {
                return "a";
            }
            case '\u00c4': {
                return "A";
            }
            case '\u00e5': {
                return "a";
            }
            case '\u00c5': {
                return "A";
            }
            case '\u00e7': {
                return "c";
            }
            case '\u00c7': {
                return "C";
            }
            case '\u00e8': {
                return "e";
            }
            case '\u00c8': {
                return "E";
            }
            case '\u00e9': {
                return "e";
            }
            case '\u00c9': {
                return "E";
            }
            case '\u00ea': {
                return "e";
            }
            case '\u00ca': {
                return "E";
            }
            case '\u00eb': {
                return "e";
            }
            case '\u00cb': {
                return "E";
            }
            case '\u00ec': {
                return "i";
            }
            case '\u00cc': {
                return "I";
            }
            case '\u00ed': {
                return "i";
            }
            case '\u00cd': {
                return "I";
            }
            case '\u00ee': {
                return "i";
            }
            case '\u00ce': {
                return "I";
            }
            case '\u00ef': {
                return "i";
            }
            case '\u00cf': {
                return "I";
            }
            case '\u00f2': {
                return "o";
            }
            case '\u00d2': {
                return "O";
            }
            case '\u00f3': {
                return "o";
            }
            case '\u00d3': {
                return "O";
            }
            case '\u00f4': {
                return "o";
            }
            case '\u00d4': {
                return "O";
            }
            case '\u00f5': {
                return "o";
            }
            case '\u00d5': {
                return "O";
            }
            case '\u00f6': {
                return "o";
            }
            case '\u00d6': {
                return "O";
            }
            case '\u00f9': {
                return "u";
            }
            case '\u00d9': {
                return "U";
            }
            case '\u00fa': {
                return "u";
            }
            case '\u00da': {
                return "U";
            }
            case '\u00fb': {
                return "u";
            }
            case '\u00db': {
                return "U";
            }
            case '\u00fc': {
                return "u";
            }
            case '\u00dc': {
                return "U";
            }
            case '\u00fd': {
                return "y";
            }
            case '\u00dd': {
                return "Y";
            }
            case '\u0115': {
                return "e";
            }
            case '\u0114': {
                return "E";
            }
            case '\u0117': {
                return "e";
            }
            case '\u0116': {
                return "E";
            }
            case '\u2070': {
                return "0";
            }
            case '\u00b9': {
                return "1";
            }
            case '\u00b2': {
                return "2";
            }
            case '\u00b3': {
                return "3";
            }
            case '\u2074': {
                return "4";
            }
            case '\u2075': {
                return "5";
            }
            case '\u2076': {
                return "6";
            }
            case '\u2077': {
                return "7";
            }
            case '\u2078': {
                return "8";
            }
            case '\u2079': {
                return "9";
            }
            case '\u2080': {
                return "0";
            }
            case '\u2081': {
                return "1";
            }
            case '\u2082': {
                return "2";
            }
            case '\u2083': {
                return "3";
            }
            case '\u2084': {
                return "4";
            }
            case '\u2085': {
                return "5";
            }
            case '\u2086': {
                return "6";
            }
            case '\u2087': {
                return "7";
            }
            case '\u2088': {
                return "8";
            }
            case '\u2089': {
                return "9";
            }
            case '\u2018': {
                return "'";
            }
            case '\u2019': {
                return "'";
            }
            case '\u201b': {
                return "'";
            }
            case '\u02bc': {
                return "'";
            }
            case '\u201c': {
                return "''";
            }
            case '\u201d': {
                return "''";
            }
            case '\u2032': {
                return "'";
            }
            case '\u2033': {
                return "''";
            }
            case '\u2034': {
                return "'''";
            }
            case '\u2057': {
                return "''''";
            }
            case '\u02b9': {
                return "'";
            }
            case '\u02ba': {
                return "''";
            }
            case '\u2035': {
                return "'";
            }
            case '\u2036': {
                return "''";
            }
            case '\u2037': {
                return "'''";
            }
            case '\u00b4': {
                return "'";
            }
            case '\u02ca': {
                return "'";
            }
            case '\u0301': {
                return "'";
            }
            case '\u02dd': {
                return "''";
            }
            case '\u030b': {
                return "''";
            }
            case '\u2010': 
            case '\u2011': 
            case '\u2012': 
            case '\u2013': 
            case '\u2014': 
            case '\u2015': 
            case '\u2212': {
                return "-";
            }
            case '\u02dc': 
            case '\u223c': 
            case '\u301c': {
                return "~";
            }
            case '\uff0c': {
                return ",";
            }
            case '\uff1a': {
                return ":";
            }
            case '\uff1b': {
                return ";";
            }
            case '\uff08': {
                return "(";
            }
            case '\uff09': {
                return ")";
            }
            case '\uff3b': {
                return "[";
            }
            case '\uff3d': {
                return "]";
            }
            case '\u3010': {
                return "[";
            }
            case '\u3011': {
                return "]";
            }
            case '\uff5b': {
                return "{";
            }
            case '\uff5d': {
                return "}";
            }
            case '\u00df': {
                return "beta";
            }
            case '\u00a0': 
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': 
            case '\u202f': 
            case '\u205f': 
            case '\u3000': {
                return " ";
            }
            case '\u00ad': 
            case '\u200b': 
            case '\u200d': 
            case '\ufeff': {
                return "";
            }
        }
        throw new PreProcessingException("Unrecognised unicode character: " + c);
    }

    static List<String> arrayToList(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(array));
        return list;
    }

    static String removeDashIfPresent(String locantText) {
        if (locantText.endsWith("-")) {
            locantText = locantText.substring(0, locantText.length() - 1);
        }
        return locantText;
    }

    static int countTerminalPrimes(String locantText) {
        int numberOfPrimes = 0;
        for (int i = locantText.length() - 1; i > 0 && locantText.charAt(i) == '\''; --i) {
            ++numberOfPrimes;
        }
        return numberOfPrimes;
    }

    static boolean startsWithCaseInsensitive(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    static boolean startsWithCaseInsensitive(String str, int i, String prefix) {
        return str.regionMatches(true, i, prefix, 0, prefix.length());
    }

    static boolean endsWithCaseInsensitive(String str, String suffix) {
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return str.regionMatches(true, strOffset, suffix, 0, suffix.length());
    }

    static String lowerCaseAsciiString(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

