/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.CipOrderingException;
import uk.ac.cam.ch.wwmm.opsin.CipSequenceRules;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FusedRingNumberer;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OpsinWarning;
import uk.ac.cam.ch.wwmm.opsin.Ring;
import uk.ac.cam.ch.wwmm.opsin.SSSRFinder;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StereoGroup;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryException;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class StereochemistryHandler {
    private static final Logger LOG = LogManager.getLogger(StereochemistryHandler.class);
    private final BuildState state;
    private final Map<Atom, StereoAnalyser.StereoCentre> atomStereoCentreMap;
    private final Map<Bond, StereoAnalyser.StereoBond> bondStereoBondMap;
    private final Map<Atom, StereoAnalyser.StereoCentre> notExplicitlyDefinedStereoCentreMap;
    private final Map<Bond, StereoAnalyser.StereoBond> notExplicitlyDefinedStereoBondMap;

    StereochemistryHandler(BuildState state, Map<Atom, StereoAnalyser.StereoCentre> atomStereoCentreMap, Map<Bond, StereoAnalyser.StereoBond> bondStereoBondMap) {
        this.state = state;
        this.atomStereoCentreMap = atomStereoCentreMap;
        this.notExplicitlyDefinedStereoCentreMap = new HashMap<Atom, StereoAnalyser.StereoCentre>(atomStereoCentreMap);
        this.bondStereoBondMap = bondStereoBondMap;
        this.notExplicitlyDefinedStereoBondMap = new HashMap<Bond, StereoAnalyser.StereoBond>(bondStereoBondMap);
    }

    void applyStereochemicalElements(List<Element> stereoChemistryEls) throws StructureBuildingException {
        ArrayList<Element> locantedStereoChemistryEls = new ArrayList<Element>();
        ArrayList<Element> unlocantedStereoChemistryEls = new ArrayList<Element>();
        ArrayList<Element> carbohydrateStereoChemistryEls = new ArrayList<Element>();
        ArrayList<Element> globalRacemicOrRelative = new ArrayList<Element>();
        for (Element stereoChemistryElement : stereoChemistryEls) {
            if (stereoChemistryElement.getAttributeValue("locant") != null) {
                locantedStereoChemistryEls.add(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("carbohydrateConfigurationalPrefix")) {
                carbohydrateStereoChemistryEls.add(stereoChemistryElement);
                continue;
            }
            if (stereoChemistryElement.getAttributeValue("type").equals("RAC") || stereoChemistryElement.getAttributeValue("type").equals("REL")) {
                globalRacemicOrRelative.add(stereoChemistryElement);
                continue;
            }
            unlocantedStereoChemistryEls.add(stereoChemistryElement);
        }
        for (Element stereochemistryEl : locantedStereoChemistryEls) {
            try {
                this.matchStereochemistryToAtomsAndBonds(stereochemistryEl);
            }
            catch (StereochemistryException e) {
                if (this.state.n2sConfig.warnRatherThanFailOnUninterpretableStereochemistry()) {
                    this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        if (!carbohydrateStereoChemistryEls.isEmpty()) {
            this.processCarbohydrateStereochemistry(carbohydrateStereoChemistryEls);
        }
        for (Element stereochemistryEl : unlocantedStereoChemistryEls) {
            try {
                this.matchStereochemistryToAtomsAndBonds(stereochemistryEl);
            }
            catch (StereochemistryException e) {
                if (this.state.n2sConfig.warnRatherThanFailOnUninterpretableStereochemistry()) {
                    this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, e.getMessage());
                    continue;
                }
                throw e;
            }
        }
        if (globalRacemicOrRelative.size() > 1) {
            if (this.state.n2sConfig.warnRatherThanFailOnUninterpretableStereochemistry()) {
                this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, "More than one global indicator of rac- or rel- was specified");
            } else {
                throw new StructureBuildingException("More than one global indicator of rac- or rel- was specified");
            }
        }
        for (Element stereochemistryEl : globalRacemicOrRelative) {
            try {
                this.matchStereochemistryToAtomsAndBonds(stereochemistryEl);
            }
            catch (StereochemistryException e) {
                if (this.state.n2sConfig.warnRatherThanFailOnUninterpretableStereochemistry()) {
                    this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, e.getMessage());
                    continue;
                }
                throw e;
            }
        }
    }

    void removeRedundantStereoCentres(List<Atom> atomsWithPreDefinedAtomParity, List<Bond> bondsWithPreDefinedBondStereo) {
        for (Atom atom : atomsWithPreDefinedAtomParity) {
            if (this.atomStereoCentreMap.containsKey(atom)) continue;
            atom.setAtomParity(null);
        }
        for (Bond bond : bondsWithPreDefinedBondStereo) {
            if (this.bondStereoBondMap.containsKey(bond)) continue;
            bond.setBondStereo(null);
        }
    }

    private void matchStereochemistryToAtomsAndBonds(Element stereoChemistryEl) throws StructureBuildingException, StereochemistryException {
        String stereoChemistryType = stereoChemistryEl.getAttributeValue("type");
        if (stereoChemistryType.equals("RorS")) {
            this.assignStereoCentre(stereoChemistryEl);
        } else if (stereoChemistryType.equals("EorZ")) {
            this.assignStereoBond(stereoChemistryEl);
        } else if (stereoChemistryType.equals("cisOrTrans")) {
            if (!this.assignCisTransOnRing(stereoChemistryEl)) {
                this.assignStereoBond(stereoChemistryEl);
            }
        } else if (stereoChemistryType.equals("alphaOrBeta")) {
            this.assignAlphaBetaXiStereochem(stereoChemistryEl);
        } else if (stereoChemistryType.equals("dlStereochemistry")) {
            this.assignDlStereochem(stereoChemistryEl);
        } else if (stereoChemistryType.equals("RAC")) {
            this.applyGlobalRacOrRelFlags(stereoChemistryEl, StereoGroupType.Rac);
        } else if (stereoChemistryType.equals("REL")) {
            this.applyGlobalRacOrRelFlags(stereoChemistryEl, StereoGroupType.Rel);
        } else {
            if (stereoChemistryType.equals("endoExoSynAnti")) {
                throw new StereochemistryException(stereoChemistryType + " stereochemistry is not currently interpretable by OPSIN");
            }
            if (stereoChemistryType.equals("relativeCisTrans")) {
                throw new StereochemistryException(stereoChemistryType + " stereochemistry is not currently interpretable by OPSIN");
            }
            if (stereoChemistryType.equals("axial")) {
                throw new StereochemistryException(stereoChemistryType + " stereochemistry is not currently interpretable by OPSIN");
            }
            if (stereoChemistryType.equals("opticalRotation")) {
                this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, "Optical rotation cannot be algorithmically used to assign stereochemistry. This term was ignored: " + stereoChemistryEl.getValue());
            } else {
                throw new StructureBuildingException("Unexpected stereochemistry type: " + stereoChemistryType);
            }
        }
        stereoChemistryEl.detach();
    }

    private void processCarbohydrateStereochemistry(List<Element> carbohydrateStereoChemistryEls) throws StructureBuildingException {
        HashMap groupToStereochemEls = new HashMap();
        for (Element element : carbohydrateStereoChemistryEls) {
            Element nextGroup = OpsinTools.getNextSibling(element, "group");
            if (nextGroup == null || !"systematicCarbohydrateStemAldose".equals(nextGroup.getAttributeValue("subType")) && !"systematicCarbohydrateStemKetose".equals(nextGroup.getAttributeValue("subType"))) {
                throw new RuntimeException("OPSIN bug: Could not find carbohydrate chain stem to apply stereochemistry to");
            }
            if (groupToStereochemEls.get(nextGroup) == null) {
                groupToStereochemEls.put(nextGroup, new ArrayList());
            }
            ((List)groupToStereochemEls.get(nextGroup)).add(element);
        }
        for (Map.Entry entry : groupToStereochemEls.entrySet()) {
            this.assignCarbohydratePrefixStereochem((Element)entry.getKey(), (List)entry.getValue());
        }
    }

    private void applyGlobalRacOrRelFlags(Element stereoChemistryEl, StereoGroupType groupType) throws StructureBuildingException, StereochemistryException {
        Element wordParent;
        for (wordParent = stereoChemistryEl.getParent(); wordParent != null && !wordParent.getName().equals("word"); wordParent = wordParent.getParent()) {
        }
        if (wordParent == null) {
            return;
        }
        Element parentSubBracketOrRoot = stereoChemistryEl.getParent();
        ArrayList<Fragment> possibleFragments = new ArrayList<Fragment>(StructureBuildingMethods.findAlternativeFragments(parentSubBracketOrRoot));
        List<Element> adjacentGroupEls = OpsinTools.getDescendantElementsWithTagName(parentSubBracketOrRoot, "group");
        for (int i = adjacentGroupEls.size() - 1; i >= 0; --i) {
            possibleFragments.add(adjacentGroupEls.get(i).getFrag());
        }
        List<Element> words = OpsinTools.getNextSiblingsOfType(wordParent, "word");
        for (Element word : words) {
            List<Element> possibleGroups = OpsinTools.getDescendantElementsWithTagName(word, "group");
            for (int i = possibleGroups.size() - 1; i >= 0; --i) {
                possibleFragments.add(((Element)possibleGroups.get(i)).getFrag());
            }
        }
        ArrayList<Atom> undefinedStereo = new ArrayList<Atom>();
        ArrayList<Atom> definedStereo = new ArrayList<Atom>();
        for (Fragment fragment : possibleFragments) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom potentialStereoAtom : atomList) {
                if (potentialStereoAtom.getAtomParity() != null) {
                    definedStereo.add(potentialStereoAtom);
                    continue;
                }
                if (this.notExplicitlyDefinedStereoCentreMap.get(potentialStereoAtom) == null) continue;
                undefinedStereo.add(potentialStereoAtom);
            }
        }
        if (undefinedStereo.size() > 0) {
            if (undefinedStereo.size() > 1) {
                this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, "More than one undefined stereocenter for rac- or rel- mixture");
                return;
            }
            try {
                this.applyStereoChemistryToStereoCentre((Atom)undefinedStereo.get(0), this.notExplicitlyDefinedStereoCentreMap.get(undefinedStereo.get(0)), "R");
            }
            catch (CipOrderingException e) {
                this.state.addWarning(OpsinWarning.OpsinWarningType.STEREOCHEMISTRY_IGNORED, "Could not set rac- or rel- stereochemistry: " + e.getMessage());
                return;
            }
            ((Atom)undefinedStereo.get(0)).setStereoGroup(new StereoGroup(groupType));
            this.notExplicitlyDefinedStereoCentreMap.remove(undefinedStereo.get(0));
        } else {
            for (Atom atom : definedStereo) {
                atom.setStereoGroup(new StereoGroup(groupType));
            }
        }
    }

    private void assignStereoCentre(Element stereoChemistryEl) throws StructureBuildingException, StereochemistryException {
        Element parentSubBracketOrRoot = stereoChemistryEl.getParent();
        List<Fragment> possibleFragments = StructureBuildingMethods.findAlternativeFragments(parentSubBracketOrRoot);
        List<Element> adjacentGroupEls = OpsinTools.getDescendantElementsWithTagName(parentSubBracketOrRoot, "group");
        for (int i = adjacentGroupEls.size() - 1; i >= 0; --i) {
            possibleFragments.add(adjacentGroupEls.get(i).getFrag());
        }
        String locant = stereoChemistryEl.getAttributeValue("locant");
        String rOrS = stereoChemistryEl.getAttributeValue("value");
        String grpStr = stereoChemistryEl.getAttributeValue("stereoGroup");
        StereoGroupType grpType = grpStr != null ? StereoGroupType.valueOf(grpStr) : StereoGroupType.Unk;
        for (Fragment fragment : possibleFragments) {
            if (!this.attemptAssignmentOfStereoCentreToFragment(fragment, rOrS, locant, grpType)) continue;
            return;
        }
        Element possibleWordParent = parentSubBracketOrRoot.getParent();
        if (possibleWordParent.getName().equals("word") && possibleWordParent.getChild(0).equals(parentSubBracketOrRoot)) {
            List<Element> words = OpsinTools.getNextSiblingsOfType(possibleWordParent, "word");
            for (Element word : words) {
                List<Element> possibleGroups = OpsinTools.getDescendantElementsWithTagName(word, "group");
                for (int i = possibleGroups.size() - 1; i >= 0; --i) {
                    if (!this.attemptAssignmentOfStereoCentreToFragment(possibleGroups.get(i).getFrag(), rOrS, locant, grpType)) continue;
                    return;
                }
            }
        }
        throw new StereochemistryException("Could not find atom that: " + stereoChemistryEl.toXML() + " appeared to be referring to");
    }

    private boolean attemptAssignmentOfStereoCentreToFragment(Fragment fragment, String rOrS, String locant, StereoGroupType stereoType) throws StereochemistryException, StructureBuildingException {
        if (locant == null) {
            List<Atom> atomList = fragment.getAtomList();
            for (Atom potentialStereoAtom : atomList) {
                if (!this.notExplicitlyDefinedStereoCentreMap.containsKey(potentialStereoAtom)) continue;
                this.applyStereoChemistryToStereoCentre(potentialStereoAtom, this.notExplicitlyDefinedStereoCentreMap.get(potentialStereoAtom), rOrS);
                potentialStereoAtom.setStereoGroup(new StereoGroup(stereoType));
                this.notExplicitlyDefinedStereoCentreMap.remove(potentialStereoAtom);
                return true;
            }
        } else {
            Atom potentialStereoAtom = fragment.getAtomByLocant(locant);
            if (potentialStereoAtom != null && this.notExplicitlyDefinedStereoCentreMap.containsKey(potentialStereoAtom)) {
                this.applyStereoChemistryToStereoCentre(potentialStereoAtom, this.notExplicitlyDefinedStereoCentreMap.get(potentialStereoAtom), rOrS);
                potentialStereoAtom.setStereoGroup(new StereoGroup(stereoType));
                this.notExplicitlyDefinedStereoCentreMap.remove(potentialStereoAtom);
                return true;
            }
        }
        return false;
    }

    private void applyStereoChemistryToStereoCentre(Atom atom, StereoAnalyser.StereoCentre stereoCentre, String rOrS) throws StructureBuildingException, StereochemistryException {
        List<Atom> cipOrderedAtoms = stereoCentre.getCipOrderedAtoms();
        if (cipOrderedAtoms.size() != 4) {
            throw new StructureBuildingException("Only tetrahedral chirality is currently supported");
        }
        Atom[] atomRefs4 = new Atom[4];
        atomRefs4[0] = cipOrderedAtoms.get(cipOrderedAtoms.size() - 1);
        for (int i = 0; i < cipOrderedAtoms.size() - 1; ++i) {
            atomRefs4[i + 1] = cipOrderedAtoms.get(i);
        }
        if (rOrS.equals("R")) {
            atom.setAtomParity(atomRefs4, -1);
        } else if (rOrS.equals("S")) {
            atom.setAtomParity(atomRefs4, 1);
        } else {
            throw new StructureBuildingException("Unexpected stereochemistry type: " + rOrS);
        }
    }

    private void assignStereoBond(Element stereoChemistryEl) throws StructureBuildingException, StereochemistryException {
        Element parentSubBracketOrRoot = stereoChemistryEl.getParent();
        List<Fragment> possibleFragments = StructureBuildingMethods.findAlternativeFragments(parentSubBracketOrRoot);
        List<Element> adjacentGroupEls = OpsinTools.getDescendantElementsWithTagName(parentSubBracketOrRoot, "group");
        for (int i = adjacentGroupEls.size() - 1; i >= 0; --i) {
            possibleFragments.add(adjacentGroupEls.get(i).getFrag());
        }
        String locant = stereoChemistryEl.getAttributeValue("locant");
        String eOrZ = stereoChemistryEl.getAttributeValue("value");
        boolean isCisTrans = false;
        if (stereoChemistryEl.getAttributeValue("type").equals("cisOrTrans")) {
            isCisTrans = true;
            String cisOrTrans = stereoChemistryEl.getAttributeValue("value");
            if (cisOrTrans.equalsIgnoreCase("cis")) {
                eOrZ = "Z";
            } else if (cisOrTrans.equalsIgnoreCase("trans")) {
                eOrZ = "E";
            } else {
                throw new StructureBuildingException("Unexpected cis/trans stereochemistry type: " + (String)cisOrTrans);
            }
        }
        for (Fragment fragment : possibleFragments) {
            if (!this.attemptAssignmentOfStereoBondToFragment(fragment, eOrZ, locant, isCisTrans)) continue;
            return;
        }
        Element possibleWordParent = parentSubBracketOrRoot.getParent();
        if (possibleWordParent.getName().equals("word") && possibleWordParent.getAttributeValue("type").equals(WordType.substituent.toString())) {
            List<Element> words = OpsinTools.getChildElementsWithTagNameAndAttribute(possibleWordParent.getParent(), "word", "type", WordType.full.toString());
            for (Element word : words) {
                List<Element> possibleGroups = OpsinTools.getDescendantElementsWithTagName(word, "group");
                for (int i = possibleGroups.size() - 1; i >= 0; --i) {
                    if (!this.attemptAssignmentOfStereoBondToFragment(possibleGroups.get(i).getFrag(), eOrZ, locant, isCisTrans)) continue;
                    return;
                }
            }
        }
        if (isCisTrans) {
            throw new StereochemistryException("Could not find bond that: " + stereoChemistryEl.toXML() + " could refer unambiguously to");
        }
        throw new StereochemistryException("Could not find bond that: " + stereoChemistryEl.toXML() + " was referring to");
    }

    private boolean attemptAssignmentOfStereoBondToFragment(Fragment fragment, String eOrZ, String locant, boolean isCisTrans) throws StereochemistryException {
        block4: {
            block3: {
                if (locant != null) break block3;
                Set<Bond> bondSet = fragment.getBondSet();
                for (Bond potentialBond : bondSet) {
                    if (!this.notExplicitlyDefinedStereoBondMap.containsKey(potentialBond) || isCisTrans && !StereochemistryHandler.cisTransUnambiguousOnBond(potentialBond)) continue;
                    this.applyStereoChemistryToStereoBond(potentialBond, this.notExplicitlyDefinedStereoBondMap.get(potentialBond), eOrZ);
                    this.notExplicitlyDefinedStereoBondMap.remove(potentialBond);
                    return true;
                }
                List<Bond> sortedInterFragmentBonds = this.sortInterFragmentBonds(this.state.fragManager.getInterFragmentBonds(fragment), fragment);
                for (Bond potentialBond : sortedInterFragmentBonds) {
                    if (!this.notExplicitlyDefinedStereoBondMap.containsKey(potentialBond) || isCisTrans && !StereochemistryHandler.cisTransUnambiguousOnBond(potentialBond)) continue;
                    this.applyStereoChemistryToStereoBond(potentialBond, this.notExplicitlyDefinedStereoBondMap.get(potentialBond), eOrZ);
                    this.notExplicitlyDefinedStereoBondMap.remove(potentialBond);
                    return true;
                }
                break block4;
            }
            Atom firstAtomInBond = fragment.getAtomByLocant(locant);
            if (firstAtomInBond == null) break block4;
            List<Bond> bonds = firstAtomInBond.getBonds();
            for (Bond potentialBond : bonds) {
                if (!this.notExplicitlyDefinedStereoBondMap.containsKey(potentialBond) || isCisTrans && !StereochemistryHandler.cisTransUnambiguousOnBond(potentialBond)) continue;
                this.applyStereoChemistryToStereoBond(potentialBond, this.notExplicitlyDefinedStereoBondMap.get(potentialBond), eOrZ);
                this.notExplicitlyDefinedStereoBondMap.remove(potentialBond);
                return true;
            }
        }
        return false;
    }

    static boolean cisTransUnambiguousOnBond(Bond potentialBond) {
        List<Atom> neighbours1 = potentialBond.getFromAtom().getAtomNeighbours();
        boolean foundHydrogen1 = false;
        for (Atom neighbour : neighbours1) {
            if (neighbour.getElement() != ChemEl.H) continue;
            foundHydrogen1 = true;
        }
        List<Atom> neighbours2 = potentialBond.getToAtom().getAtomNeighbours();
        boolean foundHydrogen2 = false;
        for (Atom neighbour : neighbours2) {
            if (neighbour.getElement() != ChemEl.H) continue;
            foundHydrogen2 = true;
        }
        return foundHydrogen1 && foundHydrogen2;
    }

    private List<Bond> sortInterFragmentBonds(Set<Bond> interFragmentBonds, Fragment preferredOriginatingFragment) {
        ArrayList<Bond> interFragmentBondList = new ArrayList<Bond>();
        for (Bond bond : interFragmentBonds) {
            if (bond.getFromAtom().getFrag() == preferredOriginatingFragment) {
                interFragmentBondList.add(0, bond);
                continue;
            }
            interFragmentBondList.add(bond);
        }
        return interFragmentBondList;
    }

    private void applyStereoChemistryToStereoBond(Bond bond, StereoAnalyser.StereoBond stereoBond, String eOrZ) throws StereochemistryException {
        List<Atom> stereoBondAtoms = stereoBond.getOrderedStereoAtoms();
        Atom[] atomRefs4 = new Atom[]{stereoBondAtoms.get(0), stereoBondAtoms.get(1), stereoBondAtoms.get(2), stereoBondAtoms.get(3)};
        if (eOrZ.equals("E")) {
            bond.setBondStereoElement(atomRefs4, BondStereo.BondStereoValue.TRANS);
        } else if (eOrZ.equals("Z")) {
            bond.setBondStereoElement(atomRefs4, BondStereo.BondStereoValue.CIS);
        } else if (eOrZ.equals("EZ")) {
            bond.setBondStereo(null);
        } else {
            throw new IllegalArgumentException("Unexpected stereochemistry type: " + eOrZ);
        }
    }

    private boolean assignCisTransOnRing(Element stereoChemistryEl) throws StructureBuildingException {
        if (stereoChemistryEl.getAttribute("locant") != null) {
            return false;
        }
        Element parentSubBracketOrRoot = stereoChemistryEl.getParent();
        List<Fragment> possibleFragments = StructureBuildingMethods.findAlternativeFragments(parentSubBracketOrRoot);
        List<Element> adjacentGroupEls = OpsinTools.getDescendantElementsWithTagName(parentSubBracketOrRoot, "group");
        for (int i = adjacentGroupEls.size() - 1; i >= 0; --i) {
            possibleFragments.add(adjacentGroupEls.get(i).getFrag());
        }
        for (Fragment fragment : possibleFragments) {
            if (!this.attemptAssignmentOfCisTransRingStereoToFragment(fragment, stereoChemistryEl)) continue;
            return true;
        }
        Element possibleWordParent = parentSubBracketOrRoot.getParent();
        if (possibleWordParent.getName().equals("word") && possibleWordParent.getChild(0).equals(parentSubBracketOrRoot)) {
            List<Element> words = OpsinTools.getNextSiblingsOfType(possibleWordParent, "word");
            for (Element word : words) {
                List<Element> possibleGroups = OpsinTools.getDescendantElementsWithTagName(word, "group");
                for (int i = possibleGroups.size() - 1; i >= 0; --i) {
                    if (!this.attemptAssignmentOfCisTransRingStereoToFragment(possibleGroups.get(i).getFrag(), stereoChemistryEl)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean attemptAssignmentOfCisTransRingStereoToFragment(Fragment fragment, Element stereoChemistryEl) throws StructureBuildingException {
        List<Atom> atomList = fragment.getAtomList();
        ArrayList<Atom> chosenStereoAtoms = new ArrayList<Atom>();
        ArrayList<Atom> stereoAtomsWithTwoNonHydrogen = new ArrayList<Atom>();
        for (Atom potentialStereoAtom : atomList) {
            List<Atom> neighbours;
            if (!potentialStereoAtom.getAtomIsInACycle() || (neighbours = potentialStereoAtom.getAtomNeighbours()).size() != 4) continue;
            int hydrogenCount = 0;
            int acylicOrNotInFrag = 0;
            for (Atom neighbour : neighbours) {
                if (neighbour.getElement() == ChemEl.H) {
                    ++hydrogenCount;
                }
                if (neighbour.getAtomIsInACycle() && atomList.contains(neighbour)) continue;
                ++acylicOrNotInFrag;
            }
            if (hydrogenCount == 1 || hydrogenCount == 0 && acylicOrNotInFrag == 1) {
                chosenStereoAtoms.add(potentialStereoAtom);
                continue;
            }
            if (hydrogenCount != 0 || acylicOrNotInFrag != 2 || !this.notExplicitlyDefinedStereoCentreMap.containsKey(potentialStereoAtom)) continue;
            stereoAtomsWithTwoNonHydrogen.add(potentialStereoAtom);
        }
        boolean chooseAtomByCip = false;
        if (chosenStereoAtoms.size() < 2 && chosenStereoAtoms.size() + stereoAtomsWithTwoNonHydrogen.size() == 2) {
            chosenStereoAtoms.addAll(stereoAtomsWithTwoNonHydrogen);
            chooseAtomByCip = true;
        }
        if (chosenStereoAtoms.size() == 2) {
            Atom a1 = (Atom)chosenStereoAtoms.get(0);
            Atom a2 = (Atom)chosenStereoAtoms.get(1);
            if (a1.getAtomParity() != null && a2.getAtomParity() != null) {
                return false;
            }
            Set<Bond> peripheryBonds = this.determinePeripheryBonds(fragment);
            List<List<Atom>> paths = CycleDetector.getPathBetweenAtomsUsingBonds(a1, a2, peripheryBonds);
            if (paths.size() != 2) {
                return false;
            }
            this.applyStereoChemistryToCisTransOnRing(a1, a2, paths, atomList, stereoChemistryEl.getAttributeValue("value"), chooseAtomByCip);
            this.notExplicitlyDefinedStereoCentreMap.remove(chosenStereoAtoms.get(0));
            this.notExplicitlyDefinedStereoCentreMap.remove(chosenStereoAtoms.get(1));
            if (chooseAtomByCip) {
                this.state.addIsAmbiguous("Ring cis/trans applied to stereocenter where no hydrogen was present. Cahn-Ingold-Prelog rules used to determine which substituents are cis/trans, but other conventions may be in use");
            }
            return true;
        }
        return false;
    }

    private Set<Bond> determinePeripheryBonds(Fragment fragment) {
        List<Ring> rings = SSSRFinder.getSetOfSmallestRings(fragment);
        FusedRingNumberer.setupAdjacentFusedRingProperties(rings);
        HashSet<Bond> bondsToConsider = new HashSet<Bond>();
        for (Ring ring : rings) {
            for (Bond bond : ring.getBondList()) {
                bondsToConsider.add(bond);
            }
        }
        for (Ring ring : rings) {
            bondsToConsider.removeAll(ring.getFusedBonds());
        }
        return bondsToConsider;
    }

    private void applyStereoChemistryToCisTransOnRing(Atom a1, Atom a2, List<List<Atom>> paths, List<Atom> fragmentAtoms, String cisOrTrans, boolean chooseAtomByCip) throws StructureBuildingException {
        Atom secondPathAtom;
        Atom firstPathAtom;
        List<Atom> a1Neighbours = a1.getAtomNeighbours();
        Atom[] atomRefs4a1 = new Atom[4];
        atomRefs4a1[2] = firstPathAtom = paths.get(0).size() > 0 ? paths.get(0).get(0) : a2;
        atomRefs4a1[3] = secondPathAtom = paths.get(1).size() > 0 ? paths.get(1).get(0) : a2;
        a1Neighbours.remove(firstPathAtom);
        a1Neighbours.remove(secondPathAtom);
        if (firstPathAtom.equals(secondPathAtom)) {
            throw new StructureBuildingException("OPSIN Bug: cannot assign cis/trans on ring stereochemistry");
        }
        atomRefs4a1[1] = chooseAtomByCip ? this.getLowestCip(a1, a1Neighbours) : this.getHydrogenOrAcyclicOrOutsideOfFragment(a1Neighbours, fragmentAtoms);
        if (atomRefs4a1[1] == null) {
            throw new StructureBuildingException("OPSIN Bug: cannot assign cis/trans on ring stereochemistry");
        }
        a1Neighbours.remove(atomRefs4a1[1]);
        atomRefs4a1[0] = a1Neighbours.get(0);
        List<Atom> a2Neighbours = a2.getAtomNeighbours();
        Atom[] atomRefs4a2 = new Atom[4];
        atomRefs4a2[2] = firstPathAtom = paths.get(0).size() > 0 ? paths.get(0).get(paths.get(0).size() - 1) : a1;
        atomRefs4a2[3] = secondPathAtom = paths.get(1).size() > 0 ? paths.get(1).get(paths.get(1).size() - 1) : a1;
        a2Neighbours.remove(firstPathAtom);
        a2Neighbours.remove(secondPathAtom);
        if (firstPathAtom.equals(secondPathAtom)) {
            throw new StructureBuildingException("OPSIN Bug: cannot assign cis/trans on ring stereochemistry");
        }
        atomRefs4a2[1] = chooseAtomByCip ? this.getLowestCip(a2, a2Neighbours) : this.getHydrogenOrAcyclicOrOutsideOfFragment(a2Neighbours, fragmentAtoms);
        if (atomRefs4a2[1] == null) {
            throw new StructureBuildingException("OPSIN Bug: cannot assign cis/trans on ring stereochemistry");
        }
        a2Neighbours.remove(atomRefs4a2[1]);
        atomRefs4a2[0] = a2Neighbours.get(0);
        boolean enantiomer = false;
        if (a1.getAtomParity() != null) {
            if (!StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(atomRefs4a1, 1, a1.getAtomParity().getAtomRefs4(), a1.getAtomParity().getParity())) {
                enantiomer = true;
            }
        } else if (a2.getAtomParity() != null) {
            if (cisOrTrans.equals("cis")) {
                if (!StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(atomRefs4a2, -1, a2.getAtomParity().getAtomRefs4(), a2.getAtomParity().getParity())) {
                    enantiomer = true;
                }
            } else if (cisOrTrans.equals("trans") && !StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(atomRefs4a2, 1, a2.getAtomParity().getAtomRefs4(), a2.getAtomParity().getParity())) {
                enantiomer = true;
            }
        }
        if (enantiomer) {
            if (cisOrTrans.equals("cis")) {
                a1.setAtomParity(atomRefs4a1, -1);
                a2.setAtomParity(atomRefs4a2, 1);
            } else if (cisOrTrans.equals("trans")) {
                a1.setAtomParity(atomRefs4a1, -1);
                a2.setAtomParity(atomRefs4a2, -1);
            }
        } else if (cisOrTrans.equals("cis")) {
            a1.setAtomParity(atomRefs4a1, 1);
            a2.setAtomParity(atomRefs4a2, -1);
        } else if (cisOrTrans.equals("trans")) {
            a1.setAtomParity(atomRefs4a1, 1);
            a2.setAtomParity(atomRefs4a2, 1);
        }
    }

    private Atom getLowestCip(Atom a, List<Atom> atomsToConsider) {
        try {
            List<Atom> neigh = new CipSequenceRules(a).getNeighbouringAtomsInCipOrder();
            for (Atom atom : neigh) {
                if (!atomsToConsider.contains(atom)) continue;
                return atom;
            }
        }
        catch (CipOrderingException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Atom getHydrogenOrAcyclicOrOutsideOfFragment(List<Atom> atoms, List<Atom> fragmentAtoms) {
        for (Atom atom : atoms) {
            if (atom.getElement() != ChemEl.H) continue;
            return atom;
        }
        for (Atom atom : atoms) {
            if (atom.getAtomIsInACycle() && fragmentAtoms.contains(atom)) continue;
            return atom;
        }
        return null;
    }

    private void assignAlphaBetaXiStereochem(Element stereoChemistryEl) throws StructureBuildingException {
        Element parentSubBracketOrRoot = stereoChemistryEl.getParent();
        List<Fragment> possibleFragments = StructureBuildingMethods.findAlternativeFragments(parentSubBracketOrRoot);
        Fragment substituentGroup = null;
        if (parentSubBracketOrRoot.getName().equals("substituent")) {
            substituentGroup = parentSubBracketOrRoot.getFirstChildElement("group").getFrag();
        }
        List<Element> adjacentGroupEls = OpsinTools.getDescendantElementsWithTagName(parentSubBracketOrRoot, "group");
        for (int i = adjacentGroupEls.size() - 1; i >= 0; --i) {
            possibleFragments.add(adjacentGroupEls.get(i).getFrag());
        }
        String locant = stereoChemistryEl.getAttributeValue("locant");
        String alphaOrBeta = stereoChemistryEl.getAttributeValue("value");
        for (Fragment fragment : possibleFragments) {
            Atom potentialStereoAtom = fragment.getAtomByLocant(locant);
            if (potentialStereoAtom == null || !this.atomStereoCentreMap.containsKey(potentialStereoAtom)) continue;
            if (alphaOrBeta.equals("xi")) {
                potentialStereoAtom.setAtomParity(null);
            } else {
                String alphaBetaClockWiseAtomOrdering = fragment.getTokenEl().getAttributeValue("alphaBetaClockWiseAtomOrdering");
                if (alphaBetaClockWiseAtomOrdering == null) {
                    throw new StructureBuildingException("Identified fragment is not known to be able to support alpha/beta stereochemistry");
                }
                this.applyAlphaBetaStereochemistryToStereoCentre(potentialStereoAtom, fragment, alphaBetaClockWiseAtomOrdering, alphaOrBeta, substituentGroup);
            }
            this.notExplicitlyDefinedStereoCentreMap.remove(potentialStereoAtom);
            return;
        }
        throw new StructureBuildingException("Could not find atom that: " + stereoChemistryEl.toXML() + " appeared to be referring to");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyAlphaBetaStereochemistryToStereoCentre(Atom stereoAtom, Fragment fragment, String alphaBetaClockWiseAtomOrdering, String alphaOrBeta, Fragment substituentGroup) throws StructureBuildingException {
        List<String> ringOrder = StringTools.arrayToList(alphaBetaClockWiseAtomOrdering.split("/"));
        int positionInList = ringOrder.indexOf(stereoAtom.getFirstLocant());
        if (!stereoAtom.getAtomIsInACycle() || positionInList == -1) throw new StructureBuildingException("Unsupported stereocentre type for alpha/beta stereochemistry");
        Atom[] atomRefs4 = new Atom[4];
        List<Atom> neighbours = stereoAtom.getAtomNeighbours();
        if (neighbours.size() != 4) throw new StructureBuildingException("Unsupported stereocentre type for alpha/beta stereochemistry");
        int previousIndice = positionInList == 0 ? ringOrder.size() - 1 : positionInList - 1;
        int nextindice = positionInList == ringOrder.size() - 1 ? 0 : positionInList + 1;
        atomRefs4[0] = fragment.getAtomByLocantOrThrow(ringOrder.get(previousIndice));
        atomRefs4[3] = fragment.getAtomByLocantOrThrow(ringOrder.get(nextindice));
        neighbours.remove(atomRefs4[0]);
        neighbours.remove(atomRefs4[3]);
        Atom a1 = neighbours.get(0);
        Atom a2 = neighbours.get(1);
        if (fragment.getAtomList().contains(a1) && ringOrder.contains(a1.getFirstLocant())) {
            atomRefs4[1] = a1;
            atomRefs4[2] = a2;
        } else if (fragment.getAtomList().contains(a2) && ringOrder.contains(a2.getFirstLocant())) {
            atomRefs4[1] = a2;
            atomRefs4[2] = a1;
        } else if (a1.getElement() == ChemEl.H && a2.getElement() != ChemEl.H) {
            atomRefs4[1] = a2;
            atomRefs4[2] = a1;
        } else if (a2.getElement() == ChemEl.H && a1.getElement() != ChemEl.H) {
            atomRefs4[1] = a1;
            atomRefs4[2] = a2;
        } else if (substituentGroup != null && fragment != substituentGroup && substituentGroup.getAtomList().contains(a1)) {
            atomRefs4[1] = a1;
            atomRefs4[2] = a2;
        } else {
            if (substituentGroup == null || fragment == substituentGroup || !substituentGroup.getAtomList().contains(a2)) throw new StructureBuildingException("alpha/beta stereochemistry could not be determined at position " + stereoAtom.getFirstLocant());
            atomRefs4[1] = a2;
            atomRefs4[2] = a1;
        }
        AtomParity previousAtomParity = stereoAtom.getAtomParity();
        if (alphaOrBeta.equals("alpha")) {
            stereoAtom.setAtomParity(atomRefs4, 1);
        } else {
            if (!alphaOrBeta.equals("beta")) throw new StructureBuildingException("OPSIN Bug: malformed alpha/beta stereochemistry value");
            stereoAtom.setAtomParity(atomRefs4, -1);
        }
        if (this.notExplicitlyDefinedStereoCentreMap.containsKey(stereoAtom)) return;
        AtomParity newAtomParity = stereoAtom.getAtomParity();
        if (!(previousAtomParity == null ? newAtomParity != null : (newAtomParity == null ? previousAtomParity != null : !StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(previousAtomParity.getAtomRefs4(), previousAtomParity.getParity(), newAtomParity.getAtomRefs4(), newAtomParity.getParity())))) return;
        throw new StructureBuildingException("contradictory alpha/beta stereochemistry at position " + stereoAtom.getFirstLocant());
    }

    /*
     * WARNING - void declaration
     */
    private void assignCarbohydratePrefixStereochem(Element carbohydrateGroup, List<Element> carbohydrateStereoChemistryEls) throws StructureBuildingException {
        void var7_10;
        Fragment carbohydrate = carbohydrateGroup.getFrag();
        Set<Atom> atoms = this.notExplicitlyDefinedStereoCentreMap.keySet();
        ArrayList<Atom> stereocentresInCarbohydrate = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            Boolean isAnomeric;
            if (carbohydrate.getAtomByID(atom.getID()) == null || (isAnomeric = atom.getProperty(Atom.ISANOMERIC)) != null && isAnomeric.booleanValue()) continue;
            stereocentresInCarbohydrate.add(atom);
        }
        Collections.reverse(carbohydrateStereoChemistryEls);
        ArrayList stereocentreConfiguration = new ArrayList();
        for (Element carbohydrateStereoChemistryEl : carbohydrateStereoChemistryEls) {
            String[] values = carbohydrateStereoChemistryEl.getAttributeValue("value").split("/");
            Collections.addAll(stereocentreConfiguration, values);
        }
        if (stereocentresInCarbohydrate.size() != stereocentreConfiguration.size()) {
            throw new StructureBuildingException("Disagreement between number of stereocentres on carbohydrate: " + stereocentresInCarbohydrate.size() + " and centres defined by configurational prefixes: " + stereocentreConfiguration.size());
        }
        Collections.sort(stereocentresInCarbohydrate, new FragmentTools.SortByLocants());
        boolean bl = false;
        while (var7_10 < stereocentresInCarbohydrate.size()) {
            AtomParity atomParity;
            Atom stereoAtom = (Atom)stereocentresInCarbohydrate.get((int)var7_10);
            String configuration = (String)stereocentreConfiguration.get((int)var7_10);
            if (configuration.equals("r")) {
                atomParity = stereoAtom.getAtomParity();
                if (atomParity == null) {
                    throw new RuntimeException("OPSIN bug: stereochemistry was not defined on a carbohydrate stem, but it should been");
                }
            } else if (configuration.equals("l")) {
                atomParity = stereoAtom.getAtomParity();
                if (atomParity == null) {
                    throw new RuntimeException("OPSIN bug: stereochemistry was not defined on a carbohydrate stem, but it should been");
                }
                atomParity.setParity(-atomParity.getParity());
            } else if (configuration.equals("?")) {
                stereoAtom.setAtomParity(null);
            } else {
                throw new RuntimeException("OPSIN bug: unexpected carbohydrate stereochemistry configuration: " + configuration);
            }
            this.notExplicitlyDefinedStereoCentreMap.remove(stereoAtom);
            ++var7_10;
        }
    }

    private void assignDlStereochem(Element stereoChemistryEl) throws StructureBuildingException {
        String dOrL = stereoChemistryEl.getAttributeValue("value");
        Element elementToApplyTo = OpsinTools.getNextSiblingIgnoringCertainElements(stereoChemistryEl, new String[]{"stereoChemistry"});
        if (elementToApplyTo != null && elementToApplyTo.getName().equals("group") && this.attemptAssignmentOfDlStereoToFragment(elementToApplyTo.getFrag(), dOrL)) {
            return;
        }
        Element parentSubBracketOrRoot = stereoChemistryEl.getParent();
        List<Fragment> possibleFragments = StructureBuildingMethods.findAlternativeFragments(parentSubBracketOrRoot);
        List<Element> adjacentGroupEls = OpsinTools.getDescendantElementsWithTagName(parentSubBracketOrRoot, "group");
        for (int i = adjacentGroupEls.size() - 1; i >= 0; --i) {
            possibleFragments.add(adjacentGroupEls.get(i).getFrag());
        }
        for (Fragment fragment : possibleFragments) {
            if (!this.attemptAssignmentOfDlStereoToFragment(fragment, dOrL)) continue;
            return;
        }
        throw new StereochemistryException("Could not find stereocentre to apply " + dOrL.toUpperCase(Locale.ROOT) + " stereochemistry to");
    }

    private boolean attemptAssignmentOfDlStereoToFragment(Fragment fragment, String dOrL) throws StereochemistryException, StructureBuildingException {
        List<Atom> atomList = fragment.getAtomList();
        for (Atom potentialStereoAtom : atomList) {
            if (!this.notExplicitlyDefinedStereoCentreMap.containsKey(potentialStereoAtom) || potentialStereoAtom.getBondCount() != 4) continue;
            List<Atom> neighbours = potentialStereoAtom.getAtomNeighbours();
            Atom acidGroup = null;
            Atom amineOrAlcohol = null;
            Atom sideChain = null;
            Atom hydrogen = null;
            for (Atom atom : neighbours) {
                ChemEl el = atom.getElement();
                if (el == ChemEl.H) {
                    hydrogen = atom;
                    continue;
                }
                if (el == ChemEl.C) {
                    int chalcogenNeighbours = 0;
                    for (Atom neighbour2 : atom.getAtomNeighbours()) {
                        if (atom == neighbour2 || !neighbour2.getElement().isChalcogen()) continue;
                        ++chalcogenNeighbours;
                    }
                    if (chalcogenNeighbours > 0) {
                        acidGroup = atom;
                        continue;
                    }
                    sideChain = atom;
                    continue;
                }
                if (el != ChemEl.O && el != ChemEl.N) continue;
                amineOrAlcohol = atom;
            }
            if (acidGroup == null || amineOrAlcohol == null || sideChain == null || hydrogen == null) continue;
            Atom[] atomRefs4 = new Atom[]{acidGroup, sideChain, amineOrAlcohol, hydrogen};
            if (dOrL.equals("l") || dOrL.equals("ls")) {
                potentialStereoAtom.setAtomParity(atomRefs4, -1);
            } else if (dOrL.equals("d") || dOrL.equals("ds")) {
                potentialStereoAtom.setAtomParity(atomRefs4, 1);
            } else if (dOrL.equals("dl")) {
                potentialStereoAtom.setAtomParity(atomRefs4, 1);
                potentialStereoAtom.setStereoGroup(new StereoGroup(StereoGroupType.Rac, ++this.state.numRacGrps));
            } else {
                throw new RuntimeException("OPSIN bug: Unexpected value for D/L stereochemistry found: " + dOrL);
            }
            this.notExplicitlyDefinedStereoCentreMap.remove(potentialStereoAtom);
            return true;
        }
        return false;
    }

    static int swapsRequiredToSort(Atom[] atomRefs4) {
        Atom[] atomRefs4Copy = (Atom[])atomRefs4.clone();
        int swapsPerformed = 0;
        int i = atomRefs4Copy.length;
        while (--i >= 0) {
            boolean swapped = false;
            for (int j = 0; j < i; ++j) {
                if (atomRefs4Copy[j].getID() <= atomRefs4Copy[j + 1].getID()) continue;
                Atom temp = atomRefs4Copy[j + 1];
                atomRefs4Copy[j + 1] = atomRefs4Copy[j];
                atomRefs4Copy[j] = temp;
                ++swapsPerformed;
                swapped = true;
            }
            if (swapped) continue;
            return swapsPerformed;
        }
        return swapsPerformed;
    }

    static boolean checkEquivalencyOfAtomsRefs4AndParity(Atom[] atomRefs1, int atomParity1, Atom[] atomRefs2, int atomParity2) {
        int swaps1 = StereochemistryHandler.swapsRequiredToSort(atomRefs1);
        int swaps2 = StereochemistryHandler.swapsRequiredToSort(atomRefs2);
        if (atomParity1 < 0 && atomParity2 > 0 || atomParity1 > 0 && atomParity2 < 0) {
            ++swaps1;
        }
        return swaps1 % 2 == swaps2 % 2;
    }
}

