/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.Comparator;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;

class SortAtomsForMainGroupElementSymbols
implements Comparator<Atom> {
    SortAtomsForMainGroupElementSymbols() {
    }

    @Override
    public int compare(Atom a, Atom b) {
        int compare = a.getElement().compareTo(b.getElement());
        if (compare != 0) {
            return compare;
        }
        int aExpectedHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(a);
        int bExpectedHydrogen = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(b);
        if (aExpectedHydrogen > 0 && bExpectedHydrogen == 0) {
            return -1;
        }
        if (aExpectedHydrogen == 0 && bExpectedHydrogen > 0) {
            return 1;
        }
        List<String> locantsA = a.getLocants();
        List<String> locantsB = b.getLocants();
        if (locantsA.isEmpty() && !locantsB.isEmpty()) {
            return -1;
        }
        if (!locantsA.isEmpty() && locantsB.isEmpty()) {
            return 1;
        }
        return 0;
    }
}

