/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import dk.brics.automaton.RunAutomaton;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.AnnotatorState;
import uk.ac.cam.ch.wwmm.opsin.OpsinRadixTrie;
import uk.ac.cam.ch.wwmm.opsin.ParseRulesResults;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;
import uk.ac.cam.ch.wwmm.opsin.StringTools;

class ReverseParseRules {
    private final RunAutomaton chemAutomaton;
    private final char[] stateSymbols;
    private final OpsinRadixTrie[] symbolTokenNamesDictReversed;
    private final RunAutomaton[] symbolRegexAutomataDictReversed;
    private final Pattern[] symbolRegexesDictReversed;

    ReverseParseRules(ResourceManager resourceManager) throws IOException {
        resourceManager.populatedReverseTokenMappings();
        this.chemAutomaton = resourceManager.getReverseChemicalAutomaton();
        this.symbolTokenNamesDictReversed = resourceManager.getSymbolTokenNamesDictReversed();
        this.symbolRegexAutomataDictReversed = resourceManager.getSymbolRegexAutomataDictReversed();
        this.symbolRegexesDictReversed = resourceManager.getSymbolRegexesDictReversed();
        this.stateSymbols = this.chemAutomaton.getCharIntervals();
    }

    public ParseRulesResults getParses(String chemicalWord) throws ParsingException {
        AnnotatorState initialState = new AnnotatorState(this.chemAutomaton.getInitialState(), '\u0000', chemicalWord.length(), true, null);
        String chemicalWordLowerCase = StringTools.lowerCaseAsciiString(chemicalWord);
        ArrayDeque<AnnotatorState> asStack = new ArrayDeque<AnnotatorState>();
        asStack.add(initialState);
        int posInNameOfLastSuccessfulAnnotations = chemicalWord.length();
        ArrayList<AnnotatorState> successfulAnnotations = new ArrayList<AnnotatorState>();
        AnnotatorState longestAnnotation = initialState;
        int stateSymbolsSize = this.stateSymbols.length;
        while (!asStack.isEmpty()) {
            AnnotatorState as = (AnnotatorState)asStack.removeLast();
            int posInName = as.getPosInName();
            if (this.chemAutomaton.isAccept(as.getState()) && posInName <= posInNameOfLastSuccessfulAnnotations) {
                if (posInName < posInNameOfLastSuccessfulAnnotations) {
                    successfulAnnotations.clear();
                    posInNameOfLastSuccessfulAnnotations = posInName;
                } else if (successfulAnnotations.size() > 128) {
                    throw new ParsingException("Ambiguity in OPSIN's chemical grammar has produced more than 128 annotations. Parsing has been aborted. Please report this as a bug");
                }
                successfulAnnotations.add(as);
            }
            if (posInName < longestAnnotation.getPosInName()) {
                longestAnnotation = as;
            }
            for (int i = 0; i < stateSymbolsSize; ++i) {
                Pattern possibleRegex;
                int matchLength;
                RunAutomaton possibleAutomata;
                AnnotatorState newAs;
                List<Integer> possibleTokenisations;
                char annotationCharacter = this.stateSymbols[i];
                int potentialNextState = this.chemAutomaton.step(as.getState(), annotationCharacter);
                if (potentialNextState == -1) continue;
                OpsinRadixTrie possibleTokenisationsTrie = this.symbolTokenNamesDictReversed[i];
                if (possibleTokenisationsTrie != null && (possibleTokenisations = possibleTokenisationsTrie.findMatchesReadingStringRightToLeft(chemicalWordLowerCase, posInName)) != null) {
                    int l = possibleTokenisations.size();
                    for (int j = 0; j < l; ++j) {
                        int tokenizationIndex = possibleTokenisations.get(j);
                        newAs = new AnnotatorState(potentialNextState, annotationCharacter, tokenizationIndex, false, as);
                        asStack.add(newAs);
                    }
                }
                if ((possibleAutomata = this.symbolRegexAutomataDictReversed[i]) != null && (matchLength = this.runInReverse(possibleAutomata, chemicalWord, posInName)) != -1) {
                    int tokenizationIndex = posInName - matchLength;
                    AnnotatorState newAs2 = new AnnotatorState(potentialNextState, annotationCharacter, tokenizationIndex, true, as);
                    asStack.add(newAs2);
                }
                if ((possibleRegex = this.symbolRegexesDictReversed[i]) == null) continue;
                Matcher mat = possibleRegex.matcher(chemicalWord).region(0, posInName);
                mat.useTransparentBounds(true);
                if (!mat.find()) continue;
                int tokenizationIndex = posInName - mat.group(0).length();
                newAs = new AnnotatorState(potentialNextState, annotationCharacter, tokenizationIndex, true, as);
                asStack.add(newAs);
            }
        }
        ArrayList<ParseTokens> outputList = new ArrayList<ParseTokens>();
        String uninterpretableName = chemicalWord;
        String unparseableName = chemicalWord.substring(0, longestAnnotation.getPosInName());
        if (successfulAnnotations.size() > 0) {
            int bestAcceptPosInName = -1;
            for (AnnotatorState as : successfulAnnotations) {
                outputList.add(this.convertAnnotationStateToParseTokens(as, chemicalWord, chemicalWordLowerCase));
                bestAcceptPosInName = as.getPosInName();
            }
            uninterpretableName = chemicalWord.substring(0, bestAcceptPosInName);
        }
        return new ParseRulesResults(outputList, uninterpretableName, unparseableName);
    }

    private int runInReverse(RunAutomaton automaton, String s, int indexAfterFirstchar) {
        int state = automaton.getInitialState();
        int max = -1;
        int pos = indexAfterFirstchar - 1;
        while (true) {
            if (automaton.isAccept(state)) {
                max = indexAfterFirstchar - 1 - pos;
            }
            if (pos == -1 || (state = automaton.step(state, s.charAt(pos))) == -1) break;
            --pos;
        }
        return max;
    }

    private ParseTokens convertAnnotationStateToParseTokens(AnnotatorState as, String chemicalWord, String chemicalWordLowerCase) {
        AnnotatorState previousAs;
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<Character> annotations = new ArrayList<Character>();
        while ((previousAs = as.getPreviousAs()) != null) {
            if (as.isCaseSensitive()) {
                tokens.add(chemicalWord.substring(as.getPosInName(), previousAs.getPosInName()));
            } else {
                tokens.add(chemicalWordLowerCase.substring(as.getPosInName(), previousAs.getPosInName()));
            }
            annotations.add(Character.valueOf(as.getAnnot()));
            as = previousAs;
        }
        return new ParseTokens(tokens, annotations);
    }
}

