/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.CASTools;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.GroupingEl;
import uk.ac.cam.ch.wwmm.opsin.NameToStructureConfig;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.Parse;
import uk.ac.cam.ch.wwmm.opsin.ParseRules;
import uk.ac.cam.ch.wwmm.opsin.ParseTokens;
import uk.ac.cam.ch.wwmm.opsin.ParseWord;
import uk.ac.cam.ch.wwmm.opsin.ParsingException;
import uk.ac.cam.ch.wwmm.opsin.ResourceGetter;
import uk.ac.cam.ch.wwmm.opsin.ResourceManager;
import uk.ac.cam.ch.wwmm.opsin.ReverseParseRules;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;
import uk.ac.cam.ch.wwmm.opsin.Tokeniser;
import uk.ac.cam.ch.wwmm.opsin.TokenizationResult;
import uk.ac.cam.ch.wwmm.opsin.WordRules;
import uk.ac.cam.ch.wwmm.opsin.WordTools;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class Parser {
    private final Tokeniser tokeniser;
    private final WordRules wordRules;
    private final ResourceManager resourceManager;
    private final ParseRules parseRules;
    private static final Pattern matchSemiColonSpace = Pattern.compile("; ");
    private static final Pattern matchStoichiometryIndication = Pattern.compile("[ ]?[\\{\\[\\(](\\d+|\\?)([:/](\\d+|\\?))+[\\}\\]\\)]$");
    private static final Logger LOG = LogManager.getLogger(Parser.class);

    Parser() throws IOException {
        ResourceGetter resources = new ResourceGetter("uk/ac/cam/ch/wwmm/opsin/resources/");
        this.wordRules = new WordRules(resources);
        this.resourceManager = new ResourceManager(resources);
        this.parseRules = new ParseRules(this.resourceManager);
        this.tokeniser = new Tokeniser(this.parseRules);
    }

    Parser(WordRules wordRules, Tokeniser tokeniser, ResourceManager resourceManager) {
        this.wordRules = wordRules;
        this.resourceManager = resourceManager;
        this.tokeniser = tokeniser;
        this.parseRules = tokeniser.getParseRules();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Element> parse(NameToStructureConfig n2sConfig, String name) throws ParsingException {
        List<Parse> parses;
        boolean allowSpaceRemoval;
        TokenizationResult tokenizationResult2;
        Matcher m;
        Integer[] componentRatios = null;
        if ((name.endsWith(")") || name.endsWith("]") || name.endsWith("}")) && (m = matchStoichiometryIndication.matcher(name)).find()) {
            componentRatios = Parser.processStoichiometryIndication(m.group());
            name = m.replaceAll("");
        }
        Parse parse = null;
        if (name.contains(", ")) {
            try {
                tokenizationResult2 = this.tokeniser.tokenize(CASTools.uninvertCASName(name, this.parseRules), false);
                if (tokenizationResult2.isSuccessfullyTokenized()) {
                    parse = tokenizationResult2.getParse();
                }
            }
            catch (ParsingException tokenizationResult2) {}
        } else if (name.contains("; ") && (tokenizationResult2 = this.tokeniser.tokenize(matchSemiColonSpace.matcher(name).replaceAll(" "), false)).isSuccessfullyTokenized()) {
            parse = tokenizationResult2.getParse();
        }
        if (parse == null) {
            allowSpaceRemoval = true;
            TokenizationResult tokenizationResult3 = this.tokeniser.tokenize(name, true);
            if (tokenizationResult3.isSuccessfullyTokenized()) {
                parse = tokenizationResult3.getParse();
            } else {
                if (!n2sConfig.isDetailedFailureAnalysis()) throw new ParsingException(name + " is unparsable due to the following being uninterpretable: " + tokenizationResult3.getUninterpretableName() + " The following was not parseable: " + tokenizationResult3.getUnparsableName());
                this.generateExactParseFailureReason(tokenizationResult3, name);
            }
        } else {
            allowSpaceRemoval = false;
        }
        if ((parses = this.generateParseCombinations(parse)).isEmpty()) {
            throw new ParsingException("No parses could be found for " + name);
        }
        ArrayList<Element> results = new ArrayList<Element>();
        ParsingException preciseException = null;
        for (Parse pp : parses) {
            GroupingEl moleculeEl = new GroupingEl("molecule");
            moleculeEl.addAttribute(new Attribute("name", name));
            for (ParseWord pw : pp.getWords()) {
                GroupingEl word = new GroupingEl("word");
                ((Element)moleculeEl).addChild(word);
                List<ParseTokens> parseTokens = pw.getParseTokens();
                if (parseTokens.size() != 1) {
                    throw new ParsingException("OPSIN bug: parseWord should have exactly 1 annotations after creating additional parses step");
                }
                ParseTokens tokensForWord = parseTokens.get(0);
                WordType wordType = OpsinTools.determineWordType(tokensForWord.getAnnotations());
                word.addAttribute(new Attribute("type", wordType.toString()));
                String value = pw.getWord();
                if (value.startsWith("-")) {
                    value = value.substring(1);
                }
                word.addAttribute(new Attribute("value", value));
                this.writeWordXML(word, tokensForWord.getTokens(), WordTools.chunkAnnotations(tokensForWord.getAnnotations()));
            }
            try {
                this.wordRules.groupWordsIntoWordRules(moleculeEl, n2sConfig, allowSpaceRemoval, componentRatios);
            }
            catch (ParsingException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(e.getMessage(), (Throwable)e);
                continue;
            }
            try {
                if (componentRatios != null) {
                    this.applyStoichiometryIndicationToWordRules(moleculeEl, componentRatios);
                }
                if (moleculeEl.getAttributeValue("isSalt") != null && ((Element)moleculeEl).getChildElements("wordRule").size() < 2) {
                    throw new ParsingException(name + " is apparently a salt, but the name only contained one component. The name could be describing a class of compounds");
                }
                results.add(moleculeEl);
            }
            catch (ParsingException e) {
                preciseException = e;
            }
        }
        if (!results.isEmpty()) return results;
        if (preciseException == null) throw new ParsingException(name + " could be parsed but OPSIN was unsure of the meaning of the words. This error will occur, by default, if a name is just a substituent");
        throw preciseException;
    }

    static Integer[] processStoichiometryIndication(String ratioString) throws ParsingException {
        ratioString = ratioString.trim();
        String[] ratioStrings = (ratioString = ratioString.substring(1, ratioString.length() - 1)).split(":");
        if (ratioStrings.length == 1) {
            ratioStrings = ratioString.split("/");
        }
        Integer[] componentRatios = new Integer[ratioStrings.length];
        for (int i = 0; i < ratioStrings.length; ++i) {
            String currentRatio = ratioStrings[i];
            if (currentRatio.contains("/")) {
                throw new ParsingException("Unexpected / in component ratio declaration");
            }
            componentRatios[i] = currentRatio.equals("?") ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(currentRatio));
        }
        return componentRatios;
    }

    private void generateExactParseFailureReason(TokenizationResult tokenizationResult, String name) throws ParsingException {
        ReverseParseRules reverseParseRules;
        try {
            reverseParseRules = new ReverseParseRules(this.resourceManager);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load resources for parsing names from right to left!", e);
        }
        String uninterpretableLR = tokenizationResult.getUninterpretableName();
        String unparseableLR = tokenizationResult.getUnparsableName();
        TokenizationResult reverseTokenizationResult = this.tokeniser.tokenizeRightToLeft(reverseParseRules, uninterpretableLR, true);
        String uninterpretableRL = reverseTokenizationResult.getUninterpretableName();
        String unparseableRL = reverseTokenizationResult.getUnparsableName();
        int indiceToTruncateUpTo = uninterpretableLR.length() - unparseableLR.length();
        StringBuilder message = new StringBuilder();
        message.append(name);
        if (!uninterpretableRL.equals("")) {
            String uninterpretableInContext;
            message.append(" was uninterpretable due to the following section of the name: ");
            message.append(uninterpretableRL);
            if (indiceToTruncateUpTo <= unparseableRL.length() && !(uninterpretableInContext = unparseableRL.substring(indiceToTruncateUpTo)).equals("")) {
                message.append("  The following was not understandable in the context it was used: ");
                message.append(uninterpretableInContext);
            }
        } else {
            message.append(" has no tokens unknown to OPSIN but does not conform to its grammar. ");
            message.append("From left to right it is unparsable due to the following being uninterpretable:");
            message.append(uninterpretableLR);
            message.append(" The following of which was not parseable: ");
            message.append(unparseableLR);
        }
        throw new ParsingException(message.toString());
    }

    private List<Parse> generateParseCombinations(Parse parse) throws ParsingException {
        int numberOfCombinations = 1;
        List<ParseWord> parseWords = parse.getWords();
        for (ParseWord pw : parseWords) {
            int parsesForWord = pw.getParseTokens().size();
            if ((numberOfCombinations *= parsesForWord) <= 128) continue;
            throw new ParsingException("Too many different combinations of word interpretation are possible (>128) i.e. name contains too many terms that OPSIN finds ambiguous to interpret");
        }
        if (numberOfCombinations == 1) {
            return Arrays.asList(parse);
        }
        ArrayList<Parse> parses = new ArrayList<Parse>();
        ArrayDeque<Parse> parseQueue = new ArrayDeque<Parse>();
        parseQueue.add(new Parse(parse.getName()));
        while (!parseQueue.isEmpty()) {
            Parse currentParse = (Parse)parseQueue.removeFirst();
            int wordsInCurrentParse = currentParse.getWords().size();
            if (wordsInCurrentParse == parseWords.size()) {
                parses.add(currentParse);
                continue;
            }
            ParseWord referenceWord = parseWords.get(wordsInCurrentParse);
            List<ParseTokens> referenceWordParseTokens = referenceWord.getParseTokens();
            for (int i = referenceWordParseTokens.size() - 1; i >= 0; --i) {
                ParseTokens parseTokens = referenceWordParseTokens.get(i);
                Parse parseWithNextWord = i > 0 ? currentParse.deepCopy() : currentParse;
                ParseWord newParseWord = new ParseWord(referenceWord.getWord(), Arrays.asList(parseTokens));
                parseWithNextWord.addWord(newParseWord);
                parseQueue.add(parseWithNextWord);
            }
        }
        return parses;
    }

    void writeWordXML(Element wordEl, List<String> tokens, List<List<Character>> annotations) throws ParsingException {
        int annotNumber = 0;
        int annotPos = 0;
        GroupingEl chunk = new GroupingEl("substituent");
        wordEl.addChild(chunk);
        TokenEl lastTokenElement = null;
        for (String token : tokens) {
            TokenEl tokenElement;
            if (annotPos >= annotations.get(annotNumber).size()) {
                annotPos = 0;
                ++annotNumber;
                chunk = new GroupingEl("substituent");
                wordEl.addChild(chunk);
                lastTokenElement = null;
            }
            if ((tokenElement = this.resourceManager.makeTokenElement(token, annotations.get(annotNumber).get(annotPos))) != null) {
                ((Element)chunk).addChild(tokenElement);
                lastTokenElement = tokenElement;
            } else if (lastTokenElement != null && token.length() > 0) {
                if (lastTokenElement.getAttribute("subsequentUnsemanticToken") != null) {
                    lastTokenElement.getAttribute("subsequentUnsemanticToken").setValue(lastTokenElement.getAttributeValue("subsequentUnsemanticToken") + token);
                } else {
                    lastTokenElement.addAttribute(new Attribute("subsequentUnsemanticToken", token));
                }
            }
            ++annotPos;
        }
        WordType wordType = WordType.valueOf(wordEl.getAttributeValue("type"));
        if (wordType == WordType.full) {
            chunk.setName("root");
        } else if (wordType == WordType.functionalTerm) {
            chunk.setName("functionalTerm");
        }
    }

    private void applyStoichiometryIndicationToWordRules(Element moleculeEl, Integer[] componentRatios) throws ParsingException {
        List<Element> wordRules = moleculeEl.getChildElements("wordRule");
        if (wordRules.size() != componentRatios.length) {
            throw new ParsingException("Component and stoichiometry indication indication mismatch. OPSIN believes there to be " + wordRules.size() + " components but " + componentRatios.length + " ratios were given!");
        }
        for (int i = 0; i < componentRatios.length; ++i) {
            wordRules.get(i).addAttribute(new Attribute("stoichiometry", String.valueOf(componentRatios[i])));
        }
    }
}

