/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiKeyOutput;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiOutput;
import io.github.dan2097.jnainchi.InchiStatus;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.JnaInchi;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.NameToStructure;
import uk.ac.cam.ch.wwmm.opsin.OpsinResult;
import uk.ac.cam.ch.wwmm.opsin.StereoGroup;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;

public class NameToInchi {
    private static final Logger LOG = LogManager.getLogger(NameToInchi.class);
    private NameToStructure n2s = NameToStructure.getInstance();

    public String parseToInchi(String name) {
        OpsinResult result = this.n2s.parseChemicalName(name);
        return NameToInchi.convertResultToInChI(result);
    }

    public String parseToStdInchi(String name) {
        OpsinResult result = this.n2s.parseChemicalName(name);
        return NameToInchi.convertResultToStdInChI(result);
    }

    public String parseToStdInchiKey(String name) {
        OpsinResult result = this.n2s.parseChemicalName(name);
        return NameToInchi.convertResultToStdInChIKey(result);
    }

    public static String convertResultToInChI(OpsinResult result) {
        return NameToInchi.convertResultToInChI(result, false);
    }

    public static String convertResultToStdInChI(OpsinResult result) {
        return NameToInchi.convertResultToInChI(result, true);
    }

    public static String convertResultToStdInChIKey(OpsinResult result) {
        String stdInchi = NameToInchi.convertResultToInChI(result, true);
        if (stdInchi != null) {
            try {
                InchiKeyOutput key = JnaInchi.inchiToInchiKey(stdInchi);
                return key.getInchiKey();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    private static String convertResultToInChI(OpsinResult result, boolean produceStdInChI) {
        if (result.getStructure() != null) {
            String inchi = null;
            try {
                inchi = NameToInchi.opsinFragmentToInchi(result.getStructure(), produceStdInChI);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
                return null;
            }
            if (inchi == null) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(inchi);
            }
            return inchi;
        }
        return null;
    }

    private static String opsinFragmentToInchi(Fragment frag, boolean produceStdInChI) {
        HashMap<Integer, InchiAtom> opsinIdAtomMap = new HashMap<Integer, InchiAtom>();
        InchiOptions.InchiOptionsBuilder optionsBuilder = new InchiOptions.InchiOptionsBuilder();
        optionsBuilder.withFlag(InchiFlag.AuxNone);
        if (!produceStdInChI) {
            optionsBuilder.withFlag(InchiFlag.FixedH);
        }
        InchiInput input = new InchiInput();
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            InchiAtom inchiAtom = new InchiAtom(atom.getElement().toString());
            input.addAtom(inchiAtom);
            inchiAtom.setCharge(atom.getCharge());
            Integer isotope = atom.getIsotope();
            if (isotope != null) {
                inchiAtom.setIsotopicMass(isotope);
            }
            opsinIdAtomMap.put(atom.getID(), inchiAtom);
        }
        Set<Bond> bondList = frag.getBondSet();
        for (Bond bond : bondList) {
            input.addBond(new InchiBond((InchiAtom)opsinIdAtomMap.get(bond.getFrom()), (InchiAtom)opsinIdAtomMap.get(bond.getTo()), InchiBondType.of((byte)bond.getOrder())));
        }
        for (Atom atom : atomList) {
            StereoGroupType stereoGroupType;
            AtomParity atomParity = atom.getAtomParity();
            if (atomParity == null || ((stereoGroupType = atomParity.getStereoGroup().getType()) == StereoGroupType.Rac || stereoGroupType == StereoGroupType.Rel) && NameToInchi.countStereoGroup(atom) == 1) continue;
            Atom[] atomRefs4 = atomParity.getAtomRefs4();
            int[] atomRefs4AsInt = new int[4];
            for (int i = 0; i < atomRefs4.length; ++i) {
                atomRefs4AsInt[i] = atomRefs4[i].getID();
            }
            InchiStereoParity parity = InchiStereoParity.UNKNOWN;
            if (atomParity.getParity() > 0) {
                parity = InchiStereoParity.EVEN;
            } else if (atomParity.getParity() < 0) {
                parity = InchiStereoParity.ODD;
            }
            input.addStereo(InchiStereo.createTetrahedralStereo((InchiAtom)opsinIdAtomMap.get(atom.getID()), (InchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[0]), (InchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[1]), (InchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[2]), (InchiAtom)opsinIdAtomMap.get(atomRefs4AsInt[3]), parity));
        }
        for (Bond bond : bondList) {
            BondStereo bondStereo = bond.getBondStereo();
            if (bondStereo == null) continue;
            Atom[] atomRefs4 = bondStereo.getAtomRefs4();
            int[] atomRefs4Ids = new int[4];
            for (int i = 0; i < atomRefs4.length; ++i) {
                atomRefs4Ids[i] = atomRefs4[i].getID();
            }
            if (BondStereo.BondStereoValue.CIS.equals((Object)bondStereo.getBondStereoValue())) {
                input.addStereo(InchiStereo.createDoubleBondStereo((InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[0]), (InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[1]), (InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[2]), (InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[3]), InchiStereoParity.ODD));
                continue;
            }
            if (!BondStereo.BondStereoValue.TRANS.equals((Object)bondStereo.getBondStereoValue())) continue;
            input.addStereo(InchiStereo.createDoubleBondStereo((InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[0]), (InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[1]), (InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[2]), (InchiAtom)opsinIdAtomMap.get(atomRefs4Ids[3]), InchiStereoParity.EVEN));
        }
        InchiOutput inchiOutput = JnaInchi.toInchi(input, optionsBuilder.build());
        InchiStatus ret = inchiOutput.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Inchi generation status: " + (Object)((Object)ret));
            if (InchiStatus.SUCCESS != ret) {
                LOG.debug(inchiOutput.getMessage());
            }
        }
        if (InchiStatus.SUCCESS != ret && InchiStatus.WARNING != ret) {
            return null;
        }
        return inchiOutput.getInchi();
    }

    private static int countStereoGroup(Atom atom) {
        StereoGroup refGroup = atom.getAtomParity().getStereoGroup();
        int count = 0;
        for (Atom a : atom.getFrag()) {
            AtomParity atomParity = a.getAtomParity();
            if (atomParity == null || !atomParity.getStereoGroup().equals(refGroup)) continue;
            ++count;
        }
        return count;
    }
}

