/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.AmbiguityChecker;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.CycleDetector;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FunctionalReplacement;
import uk.ac.cam.ch.wwmm.opsin.FusedRingBuilder;
import uk.ac.cam.ch.wwmm.opsin.GroupingEl;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StereoGroup;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;
import uk.ac.cam.ch.wwmm.opsin.StereochemistryHandler;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.SuffixApplier;
import uk.ac.cam.ch.wwmm.opsin.SuffixRule;
import uk.ac.cam.ch.wwmm.opsin.SuffixRuleType;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordRulesOmittedSpaceCorrector;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class ComponentProcessor {
    private static final Pattern matchAddedHydrogenBracket = Pattern.compile("[\\[\\(\\{]([^\\[\\(\\{]*)H[\\]\\)\\}]");
    private static final Pattern matchElementSymbolOrAminoAcidLocant = Pattern.compile("[A-Z][a-z]?'*(\\d+[a-z]?'*)?");
    private static final Pattern matchChalcogenReplacement = Pattern.compile("thio|seleno|telluro");
    private static final Pattern matchGroupsThatAreAlsoInlineSuffixes = Pattern.compile("carbon|oxy|sulfen|sulfin|sulfon|selenen|selenin|selenon|telluren|tellurin|telluron");
    private static final String[] traditionalAlkanePositionNames = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta"};
    private final FunctionalReplacement functionalReplacement;
    private final SuffixApplier suffixApplier;
    private final BuildState state;
    private static final Map<String, String[]> specialHWRings = new HashMap<String, String[]>();

    ComponentProcessor(BuildState state, SuffixApplier suffixApplier) {
        this.state = state;
        this.suffixApplier = suffixApplier;
        this.functionalReplacement = new FunctionalReplacement(state);
    }

    void processParse(Element parse) throws ComponentGenerationException, StructureBuildingException {
        List<Element> words = OpsinTools.getDescendantElementsWithTagName(parse, "word");
        int wordCount = words.size();
        for (int i = wordCount - 1; i >= 0; --i) {
            List<Element> children;
            Element word = words.get(i);
            String wordRule = OpsinTools.getParentWordRule(word).getAttributeValue("wordRule");
            this.state.currentWordRule = WordRule.valueOf(wordRule);
            if (word.getAttributeValue("type").equals(WordType.functionalTerm.toString())) continue;
            List<Element> roots = OpsinTools.getDescendantElementsWithTagName(word, "root");
            if (roots.size() > 1) {
                throw new ComponentGenerationException("Multiple roots, but only 0 or 1 were expected. Found: " + roots.size());
            }
            List<Element> substituents = OpsinTools.getDescendantElementsWithTagName(word, "substituent");
            List<Element> substituentsAndRoot = OpsinTools.combineElementLists(substituents, roots);
            List<Element> brackets = OpsinTools.getDescendantElementsWithTagName(word, "bracket");
            List<Element> substituentsAndRootAndBrackets = OpsinTools.combineElementLists(substituentsAndRoot, brackets);
            List<Element> groups = OpsinTools.getDescendantElementsWithTagName(word, "group");
            for (Element group : groups) {
                Fragment thisFrag = ComponentProcessor.resolveGroup(this.state, group);
                this.processChargeAndOxidationNumberSpecification(group, thisFrag);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.applyDLPrefixes(subOrRoot);
                this.processCarbohydrates(subOrRoot);
            }
            Element finalSubOrRootInWord = word.getChild(word.getChildCount() - 1);
            while (!finalSubOrRootInWord.getName().equals("root") && !finalSubOrRootInWord.getName().equals("substituent")) {
                children = OpsinTools.getChildElementsWithTagNames(finalSubOrRootInWord, new String[]{"root", "substituent", "bracket"});
                if (children.isEmpty()) {
                    throw new ComponentGenerationException("Unable to find finalSubOrRootInWord");
                }
                finalSubOrRootInWord = (Element)children.get(children.size() - 1);
            }
            for (Element subOrRootOrBracket : substituentsAndRootAndBrackets) {
                this.determineLocantMeaning(subOrRootOrBracket, finalSubOrRootInWord);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.processMultipliers(subOrRoot);
                this.detectConjunctiveSuffixGroups(subOrRoot, groups);
                this.matchLocantsToDirectFeatures(subOrRoot);
                List<Element> groupsOfSubOrRoot = subOrRoot.getChildElements("group");
                if (groupsOfSubOrRoot.size() <= 0) continue;
                Element lastGroupInSubOrRoot = groupsOfSubOrRoot.get(groupsOfSubOrRoot.size() - 1);
                this.preliminaryProcessSuffixes(lastGroupInSubOrRoot, subOrRoot.getChildElements("suffix"));
            }
            for (int j = substituents.size() - 1; j >= 0; --j) {
                Element substituent = substituents.get(j);
                if (!substituent.getChildElements("group").isEmpty()) continue;
                boolean removed = this.removeAndMoveToAppropriateGroupIfHydroSubstituent(substituent);
                if (!removed) {
                    removed = ComponentProcessor.removeAndMoveToAppropriateGroupIfSubtractivePrefix(substituent);
                }
                if (!removed) {
                    removed = this.removeAndMoveToAppropriateGroupIfRingBridge(substituent);
                }
                if (!removed) {
                    throw new RuntimeException("OPSIN Bug: Encountered substituent with no group!: " + substituent.toXML());
                }
                substituents.remove(j);
                substituentsAndRoot.remove(substituent);
                substituentsAndRootAndBrackets.remove(substituent);
            }
            this.functionalReplacement.processAcidReplacingFunctionalClassNomenclature(finalSubOrRootInWord, word);
            if (this.functionalReplacement.processPrefixFunctionalReplacementNomenclature(groups, substituents)) {
                substituentsAndRoot = OpsinTools.combineElementLists(substituents, roots);
                substituentsAndRootAndBrackets = OpsinTools.combineElementLists(substituentsAndRoot, brackets);
            }
            this.handleGroupIrregularities(groups);
            for (Element subOrRoot : substituentsAndRoot) {
                this.processHW(subOrRoot);
                FusedRingBuilder.processFusedRings(this.state, subOrRoot);
                this.processFusedRingBridges(subOrRoot);
                this.assignElementSymbolLocants(subOrRoot);
                this.processRingAssemblies(subOrRoot);
                this.processPolyCyclicSpiroNomenclature(subOrRoot);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.applyLambdaConvention(subOrRoot);
                this.handleMultiRadicals(subOrRoot);
            }
            this.addImplicitBracketsToAminoAcids(groups, brackets);
            for (Element substituent : substituents) {
                this.matchLocantsToIndirectFeatures(substituent);
                this.addImplicitBracketsWhenSubstituentHasTwoLocants(substituent, brackets);
                this.implicitlyBracketToPreviousSubstituentIfAppropriate(substituent, brackets);
            }
            for (Element root : roots) {
                this.matchLocantsToIndirectFeatures(root);
            }
            for (Element subOrRoot : substituentsAndRoot) {
                this.assignImplicitLocantsToDiTerminalSuffixes(subOrRoot);
                this.processConjunctiveNomenclature(subOrRoot);
                this.suffixApplier.resolveSuffixes(subOrRoot.getFirstChildElement("group"), subOrRoot.getChildElements("suffix"));
                if (!subOrRoot.getName().equals("substituent")) continue;
                this.moveSubstituentDetachableHetAtomRepl(subOrRoot);
            }
            this.moveErroneouslyPositionedLocantsAndMultipliers(brackets);
            children = OpsinTools.getChildElementsWithTagNames(word, new String[]{"root", "substituent", "bracket"});
            this.addImplicitBracketsWhenFirstSubstituentHasTwoMultipliers(children.get(0), brackets);
            while (children.size() == 1) {
                children = OpsinTools.getChildElementsWithTagNames(children.get(0), new String[]{"root", "substituent", "bracket"});
            }
            if (children.size() > 0) {
                this.assignLocantsToMultipliedRootIfPresent(children.get(children.size() - 1));
            }
            substituentsAndRootAndBrackets = OpsinTools.combineElementLists(substituentsAndRoot, brackets);
            for (Element subBracketOrRoot : substituentsAndRootAndBrackets) {
                this.assignLocantsAndMultipliers(subBracketOrRoot);
            }
            this.processBiochemicalLinkageDescriptors(substituents, brackets);
            this.processWordLevelMultiplierIfApplicable(word, roots, wordCount);
        }
        new WordRulesOmittedSpaceCorrector(this.state, parse).correctOmittedSpaces();
    }

    static Fragment resolveGroup(BuildState state, Element group) throws StructureBuildingException, ComponentGenerationException {
        String groupValue = group.getAttributeValue("value");
        String labelsValue = group.getAttributeValue("labels");
        Fragment thisFrag = state.fragManager.buildSMILES(groupValue, group, labelsValue != null ? labelsValue : "none");
        group.setFrag(thisFrag);
        ComponentProcessor.processXyleneLikeNomenclature(state, group, thisFrag);
        ComponentProcessor.setFragmentDefaultInAtomIfSpecified(thisFrag, group);
        ComponentProcessor.setFragmentFunctionalAtomsIfSpecified(group, thisFrag);
        ComponentProcessor.applyTraditionalAlkaneNumberingIfAppropriate(group, thisFrag);
        ComponentProcessor.applyHomologyGroupLabelsIfSpecified(group, thisFrag);
        if ("elementaryAtom".equals(group.getAttributeValue("type"))) {
            for (Atom a : thisFrag) {
                a.setImplicitHydrogenAllowed(false);
            }
        }
        return thisFrag;
    }

    private static void processXyleneLikeNomenclature(BuildState state, Element group, Fragment parentFrag) throws StructureBuildingException, ComponentGenerationException {
        Atom atomOnParentFrag;
        int i;
        Object previousEl;
        String reference;
        AtomReferenceType referenceType;
        String[] description;
        boolean ambiguous = false;
        if (group.getAttribute("addGroup") != null) {
            List<String> locantValues;
            String addGroupInformation = group.getAttributeValue("addGroup");
            ArrayList<AddGroup> groupsToBeAdded = new ArrayList<AddGroup>();
            for (String groupToBeAdded : addGroupInformation.split(";")) {
                description = groupToBeAdded.split(" ");
                if (description.length < 3 || description.length > 4) {
                    throw new ComponentGenerationException("malformed addGroup tag");
                }
                String smiles = description[0];
                referenceType = AtomReferenceType.valueOf(description[1].toUpperCase(Locale.ROOT));
                reference = description[2];
                Fragment fragToAdd = description.length == 4 ? state.fragManager.buildSMILES(smiles, group, description[3]) : state.fragManager.buildSMILES(smiles, group, "none");
                groupsToBeAdded.add(new AddGroup(fragToAdd, new AtomReference(referenceType, reference)));
            }
            previousEl = OpsinTools.getPreviousSibling(group);
            if (previousEl != null && ((Element)previousEl).getName().equals("locant") && ((locantValues = StringTools.arrayToList(((Element)previousEl).getValue().split(","))).size() == groupsToBeAdded.size() || locantValues.size() + 1 == groupsToBeAdded.size()) && ComponentProcessor.locantAreAcceptableForXyleneLikeNomenclatures(locantValues, group)) {
                boolean assignlocants = true;
                if (locantValues.size() != groupsToBeAdded.size()) {
                    String locant;
                    AddGroup groupInformation = (AddGroup)groupsToBeAdded.get(0);
                    switch (groupInformation.atomReference.referenceType) {
                        case DEFAULTLOCANT: 
                        case LOCANT: {
                            locant = parentFrag.getAtomByLocantOrThrow(groupInformation.atomReference.reference).getFirstLocant();
                            break;
                        }
                        case DEFAULTID: 
                        case ID: {
                            locant = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt(groupInformation.atomReference.reference) - 1).getFirstLocant();
                            break;
                        }
                        default: {
                            throw new ComponentGenerationException("malformed addGroup tag");
                        }
                    }
                    if (locant == null || !locant.equals("1")) {
                        assignlocants = false;
                    }
                }
                if (assignlocants) {
                    for (int i2 = groupsToBeAdded.size() - 1; i2 >= 0; --i2) {
                        AddGroup groupInformation = (AddGroup)groupsToBeAdded.get(i2);
                        if (locantValues.size() <= 0) break;
                        groupInformation.atomReference = new AtomReference(AtomReferenceType.LOCANT, locantValues.get(locantValues.size() - 1));
                        locantValues.remove(locantValues.size() - 1);
                    }
                    group.removeAttribute(group.getAttribute("frontLocantsExpected"));
                    ((Element)previousEl).detach();
                }
            }
            for (i = 0; i < groupsToBeAdded.size(); ++i) {
                AddGroup groupInformation = (AddGroup)groupsToBeAdded.get(i);
                Fragment newFrag = groupInformation.frag;
                switch (groupInformation.atomReference.referenceType) {
                    case DEFAULTLOCANT: {
                        ambiguous = true;
                    }
                    case LOCANT: {
                        if (groupInformation.atomReference.reference.equals("required")) {
                            throw new ComponentGenerationException(group.getValue() + " requires an allowed locant");
                        }
                        atomOnParentFrag = parentFrag.getAtomByLocantOrThrow(groupInformation.atomReference.reference);
                        break;
                    }
                    case DEFAULTID: {
                        ambiguous = true;
                    }
                    case ID: {
                        atomOnParentFrag = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt(groupInformation.atomReference.reference) - 1);
                        break;
                    }
                    default: {
                        throw new ComponentGenerationException("malformed addGroup tag");
                    }
                }
                if (newFrag.getOutAtomCount() > 1) {
                    throw new ComponentGenerationException("too many outAtoms on group to be added");
                }
                if (newFrag.getOutAtomCount() == 1) {
                    OutAtom newFragOutAtom = newFrag.getOutAtom(0);
                    newFrag.removeOutAtom(newFragOutAtom);
                    state.fragManager.incorporateFragment(newFrag, newFragOutAtom.getAtom(), parentFrag, atomOnParentFrag, newFragOutAtom.getValency());
                    continue;
                }
                Atom atomOnNewFrag = newFrag.getDefaultInAtomOrFirstAtom();
                state.fragManager.incorporateFragment(newFrag, atomOnNewFrag, parentFrag, atomOnParentFrag, 1);
            }
        }
        if (group.getAttributeValue("addHeteroAtom") != null) {
            List<String> locantValues;
            String addHeteroAtomInformation = group.getAttributeValue("addHeteroAtom");
            ArrayList<AddHeteroatom> heteroAtomsToBeAdded = new ArrayList<AddHeteroatom>();
            for (String heteroAtomToBeAdded : addHeteroAtomInformation.split(";")) {
                description = heteroAtomToBeAdded.split(" ");
                if (description.length != 3) {
                    throw new ComponentGenerationException("malformed addHeteroAtom tag");
                }
                String heteroAtomSmiles = description[0];
                referenceType = AtomReferenceType.valueOf(description[1].toUpperCase(Locale.ROOT));
                reference = description[2];
                heteroAtomsToBeAdded.add(new AddHeteroatom(heteroAtomSmiles, new AtomReference(referenceType, reference)));
            }
            previousEl = OpsinTools.getPreviousSibling(group);
            if (previousEl != null && ((Element)previousEl).getName().equals("locant") && (locantValues = StringTools.arrayToList(((Element)previousEl).getValue().split(","))).size() == heteroAtomsToBeAdded.size() && ComponentProcessor.locantAreAcceptableForXyleneLikeNomenclatures(locantValues, group)) {
                for (int i3 = heteroAtomsToBeAdded.size() - 1; i3 >= 0; --i3) {
                    AddHeteroatom groupInformation = (AddHeteroatom)heteroAtomsToBeAdded.get(i3);
                    groupInformation.atomReference = new AtomReference(AtomReferenceType.LOCANT, locantValues.get(locantValues.size() - 1));
                    locantValues.remove(locantValues.size() - 1);
                }
                group.removeAttribute(group.getAttribute("frontLocantsExpected"));
                ((Element)previousEl).detach();
            }
            for (i = 0; i < heteroAtomsToBeAdded.size(); ++i) {
                AddHeteroatom heteroAtomInformation = (AddHeteroatom)heteroAtomsToBeAdded.get(i);
                Atom atomOnParentFrag2 = null;
                switch (heteroAtomInformation.atomReference.referenceType) {
                    case DEFAULTLOCANT: {
                        ambiguous = true;
                    }
                    case LOCANT: {
                        if (heteroAtomInformation.atomReference.reference.equals("required")) {
                            throw new ComponentGenerationException(group.getValue() + " requires an allowed locant");
                        }
                        atomOnParentFrag2 = parentFrag.getAtomByLocantOrThrow(heteroAtomInformation.atomReference.reference);
                        break;
                    }
                    case DEFAULTID: {
                        ambiguous = true;
                    }
                    case ID: {
                        atomOnParentFrag2 = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt(heteroAtomInformation.atomReference.reference) - 1);
                        break;
                    }
                    default: {
                        throw new ComponentGenerationException("malformed addHeteroAtom tag");
                    }
                }
                state.fragManager.replaceAtomWithSmiles(atomOnParentFrag2, heteroAtomInformation.heteroAtomSmiles);
            }
        }
        if (group.getAttributeValue("addBond") != null && !"hantzschWidman".equals(group.getAttributeValue("subType"))) {
            List<String> locantValues;
            String addBondInformation = group.getAttributeValue("addBond");
            ArrayList<AddBond> bondsToBeAdded = new ArrayList<AddBond>();
            for (String bondToBeAdded : addBondInformation.split(";")) {
                description = bondToBeAdded.split(" ");
                if (description.length != 3) {
                    throw new ComponentGenerationException("malformed addBond tag");
                }
                int bondOrder = Integer.parseInt(description[0]);
                referenceType = AtomReferenceType.valueOf(description[1].toUpperCase(Locale.ROOT));
                reference = description[2];
                bondsToBeAdded.add(new AddBond(bondOrder, new AtomReference(referenceType, reference)));
            }
            boolean locanted = false;
            Element previousEl2 = OpsinTools.getPreviousSibling(group);
            if (previousEl2 != null && previousEl2.getName().equals("locant") && (locantValues = StringTools.arrayToList(previousEl2.getValue().split(","))).size() == bondsToBeAdded.size() && ComponentProcessor.locantAreAcceptableForXyleneLikeNomenclatures(locantValues, group)) {
                for (int i4 = bondsToBeAdded.size() - 1; i4 >= 0; --i4) {
                    AddBond bondInformation = (AddBond)bondsToBeAdded.get(i4);
                    bondInformation.atomReference = new AtomReference(AtomReferenceType.LOCANT, locantValues.get(locantValues.size() - 1));
                    locantValues.remove(locantValues.size() - 1);
                }
                group.removeAttribute(group.getAttribute("frontLocantsExpected"));
                previousEl2.detach();
                locanted = true;
            }
            for (int i5 = 0; i5 < bondsToBeAdded.size(); ++i5) {
                AddBond bondInformation = (AddBond)bondsToBeAdded.get(i5);
                switch (bondInformation.atomReference.referenceType) {
                    case DEFAULTLOCANT: {
                        ambiguous = true;
                    }
                    case LOCANT: {
                        if (bondInformation.atomReference.reference.equals("required")) {
                            throw new ComponentGenerationException(group.getValue() + " requires an allowed locant");
                        }
                        atomOnParentFrag = parentFrag.getAtomByLocantOrThrow(bondInformation.atomReference.reference);
                        break;
                    }
                    case DEFAULTID: {
                        ambiguous = true;
                    }
                    case ID: {
                        atomOnParentFrag = parentFrag.getAtomByIDOrThrow(parentFrag.getIdOfFirstAtom() + Integer.parseInt(bondInformation.atomReference.reference) - 1);
                        break;
                    }
                    default: {
                        throw new ComponentGenerationException("malformed addBond tag");
                    }
                }
                Bond b = FragmentTools.unsaturate(atomOnParentFrag, bondInformation.bondOrder, parentFrag);
                if (locanted || b.getOrder() != 2 || parentFrag.getAtomCount() != 5 || !b.getFromAtom().getAtomIsInACycle() || !b.getToAtom().getAtomIsInACycle()) continue;
                b.setOrder(1);
                b.getFromAtom().setSpareValency(true);
                b.getToAtom().setSpareValency(true);
            }
        }
        if (ambiguous) {
            state.addIsAmbiguous(group.getValue() + " describes multiple structures");
        }
    }

    private static boolean locantAreAcceptableForXyleneLikeNomenclatures(List<String> locantValues, Element group) {
        if (group.getAttribute("frontLocantsExpected") == null) {
            throw new IllegalArgumentException("Group must have frontLocantsExpected to implement xylene-like nomenclature");
        }
        List<String> allowedLocants = Arrays.asList(group.getAttributeValue("frontLocantsExpected").split(","));
        for (String locant : locantValues) {
            if (allowedLocants.contains(locant)) continue;
            return false;
        }
        return true;
    }

    private static void setFragmentDefaultInAtomIfSpecified(Fragment thisFrag, Element group) throws StructureBuildingException {
        String defaultInLocant = group.getAttributeValue("defaultInLocant");
        String defaultInId = group.getAttributeValue("defaultInID");
        if (defaultInLocant != null) {
            thisFrag.setDefaultInAtom(thisFrag.getAtomByLocantOrThrow(defaultInLocant));
        } else if (defaultInId != null) {
            thisFrag.setDefaultInAtom(thisFrag.getAtomByIDOrThrow(thisFrag.getIdOfFirstAtom() + Integer.parseInt(defaultInId) - 1));
        }
    }

    private static void setFragmentFunctionalAtomsIfSpecified(Element group, Fragment thisFrag) throws StructureBuildingException {
        if (group.getAttribute("functionalIDs") != null) {
            String[] functionalIDs;
            for (String functionalID : functionalIDs = group.getAttributeValue("functionalIDs").split(",")) {
                thisFrag.addFunctionalAtom(thisFrag.getAtomByIDOrThrow(thisFrag.getIdOfFirstAtom() + Integer.parseInt(functionalID) - 1));
            }
        }
    }

    private static void applyTraditionalAlkaneNumberingIfAppropriate(Element group, Fragment thisFrag) {
        block11: {
            String groupType;
            block10: {
                Atom nextAtom;
                groupType = group.getAttributeValue("type");
                if (!groupType.equals("acidStem")) break block10;
                List<Atom> atomList = thisFrag.getAtomList();
                Atom startingAtom = thisFrag.getFirstAtom();
                if (group.getAttribute("suffixAppliesTo") != null) {
                    String suffixAppliesTo = group.getAttributeValue("suffixAppliesTo");
                    String[] suffixAppliesToArr = suffixAppliesTo.split(",");
                    if (suffixAppliesToArr.length != 1) {
                        return;
                    }
                    startingAtom = atomList.get(Integer.parseInt(suffixAppliesToArr[0]) - 1);
                }
                List<Atom> neighbours = startingAtom.getAtomNeighbours();
                int counter = -1;
                Atom previousAtom = startingAtom;
                for (int i = neighbours.size() - 1; i >= 0; --i) {
                    if (neighbours.get(i).getElement() == ChemEl.C) continue;
                    neighbours.remove(i);
                }
                while (neighbours.size() == 1 && ++counter <= 5 && !(nextAtom = neighbours.get(0)).getAtomIsInACycle()) {
                    String traditionalLocant = traditionalAlkanePositionNames[counter];
                    if (!nextAtom.hasLocant(traditionalLocant)) {
                        nextAtom.addLocant(traditionalLocant);
                    }
                    neighbours = nextAtom.getAtomNeighbours();
                    neighbours.remove(previousAtom);
                    for (int i = neighbours.size() - 1; i >= 0; --i) {
                        if (neighbours.get(i).getElement() == ChemEl.C) continue;
                        neighbours.remove(i);
                    }
                    previousAtom = nextAtom;
                }
                break block11;
            }
            if (!groupType.equals("chain") || !"alkaneStem".equals(group.getAttributeValue("subType"))) break block11;
            List<Atom> atomList = thisFrag.getAtomList();
            if (atomList.size() == 1) {
                return;
            }
            Element possibleSuffix = OpsinTools.getNextSibling(group, "suffix");
            Boolean terminalSuffixWithNoSuffixPrefixPresent = false;
            if (possibleSuffix != null && "terminal".equals(possibleSuffix.getAttributeValue("subType")) && possibleSuffix.getAttribute("suffixPrefix") == null) {
                terminalSuffixWithNoSuffixPrefixPresent = true;
            }
            for (Atom atom : atomList) {
                String firstLocant = atom.getFirstLocant();
                if (atom.getAtomIsInACycle() || firstLocant == null || firstLocant.length() != 1 || !Character.isDigit(firstLocant.charAt(0))) continue;
                int locantNumber = Integer.parseInt(firstLocant);
                if (terminalSuffixWithNoSuffixPrefixPresent.booleanValue()) {
                    if (locantNumber <= 1 || locantNumber > 7) continue;
                    atom.addLocant(traditionalAlkanePositionNames[locantNumber - 2]);
                    continue;
                }
                if (locantNumber <= 0 || locantNumber > 6) continue;
                atom.addLocant(traditionalAlkanePositionNames[locantNumber - 1]);
            }
        }
    }

    private static void applyHomologyGroupLabelsIfSpecified(Element group, Fragment frag) {
        String homologyValsStr = group.getAttributeValue("homology");
        if (homologyValsStr != null) {
            String[] vals = homologyValsStr.split(";");
            ArrayList<Atom> homologyAtoms = new ArrayList<Atom>();
            for (Atom a : frag) {
                if (a.getElement() != ChemEl.R) continue;
                homologyAtoms.add(a);
            }
            int count = vals.length;
            if (count != homologyAtoms.size()) {
                throw new RuntimeException("OPSIN Bug: Number of homology atoms should match number of homology labels! for: " + group.getValue());
            }
            for (int i = 0; i < count; ++i) {
                ((Atom)homologyAtoms.get(i)).setProperty(Atom.HOMOLOGY_GROUP, vals[i]);
            }
        }
    }

    private void processChargeAndOxidationNumberSpecification(Element group, Fragment frag) {
        Element nextEl;
        if ("ousIcAtom".equals(group.getAttributeValue("subType"))) {
            String oxidationStates = group.getAttributeValue("commonOxidationStatesAndMax");
            if (oxidationStates == null) {
                throw new RuntimeException("commonOxidationStatesAndMax should be specified on: " + group.getValue());
            }
            frag.getFirstAtom().setProperty(Atom.OXIDATION_NUMBER, Integer.parseInt(oxidationStates.split(":")[0]));
        }
        if ((nextEl = OpsinTools.getNextSibling(group)) != null) {
            if (nextEl.getName().equals("chargeSpecifier")) {
                frag.getFirstAtom().setCharge(Integer.parseInt(nextEl.getAttributeValue("value")));
                nextEl.detach();
            }
            if (nextEl.getName().equals("oxidationNumberSpecifier")) {
                frag.getFirstAtom().setProperty(Atom.OXIDATION_NUMBER, Integer.parseInt(nextEl.getAttributeValue("value")));
                nextEl.detach();
            }
        }
    }

    private boolean removeAndMoveToAppropriateGroupIfHydroSubstituent(Element substituent) throws ComponentGenerationException {
        List<Element> hydroElements = substituent.getChildElements("hydro");
        if (hydroElements.size() > 0) {
            Element targetRing = null;
            Element adjacentSubOrRootOrBracket = OpsinTools.getNextSibling(substituent);
            if (adjacentSubOrRootOrBracket == null) {
                throw new ComponentGenerationException("Cannot find ring for hydro substituent to apply to");
            }
            Element potentialRing = adjacentSubOrRootOrBracket.getFirstChildElement("group");
            if (potentialRing != null && this.containsCyclicAtoms(potentialRing)) {
                Element possibleLocantInFrontOfHydro = OpsinTools.getPreviousSibling(hydroElements.get(0));
                if (possibleLocantInFrontOfHydro != null && possibleLocantInFrontOfHydro.getName().equals("locant") && possibleLocantInFrontOfHydro.getValue().split(",").length == 1) {
                    targetRing = potentialRing;
                } else {
                    Element possibleLocantInFrontOfRing = OpsinTools.getPreviousSibling(potentialRing, "locant");
                    if (possibleLocantInFrontOfRing != null) {
                        if (potentialRing.getAttribute("frontLocantsExpected") != null) {
                            String[] expectedLocants;
                            String locantValue = possibleLocantInFrontOfRing.getValue();
                            for (String expectedLocant : expectedLocants = potentialRing.getAttributeValue("frontLocantsExpected").split(",")) {
                                if (!locantValue.equals(expectedLocant)) continue;
                                targetRing = potentialRing;
                                break;
                            }
                        }
                        if ("fusionRing".equals(potentialRing.getAttributeValue("subType")) && (potentialRing.getValue().equals("benzo") || potentialRing.getValue().equals("benz")) && !OpsinTools.getNextSibling(potentialRing).getName().equals("fusion")) {
                            targetRing = potentialRing;
                        }
                    } else {
                        targetRing = potentialRing;
                    }
                }
            }
            if (targetRing == null) {
                Element nextSubOrRootOrBracketFromLast = substituent.getParent().getChild(substituent.getParent().getChildCount() - 1);
                while (!nextSubOrRootOrBracketFromLast.equals(substituent)) {
                    potentialRing = nextSubOrRootOrBracketFromLast.getFirstChildElement("group");
                    if (potentialRing != null && this.containsCyclicAtoms(potentialRing)) {
                        targetRing = potentialRing;
                        break;
                    }
                    nextSubOrRootOrBracketFromLast = OpsinTools.getPreviousSibling(nextSubOrRootOrBracketFromLast);
                }
            }
            if (targetRing == null) {
                throw new ComponentGenerationException("Cannot find ring for hydro substituent to apply to");
            }
            List<Element> children = substituent.getChildElements();
            Element targetSubstituent = targetRing.getParent();
            if (targetSubstituent.equals(adjacentSubOrRootOrBracket)) {
                for (int i = children.size() - 1; i >= 0; --i) {
                    Element child = children.get(i);
                    if (child.getName().equals("hyphen")) continue;
                    child.detach();
                    targetSubstituent.insertChild(child, 0);
                }
            } else {
                boolean inDetachablePrefix = true;
                for (int i = children.size() - 1; i >= 0; --i) {
                    Element child = children.get(i);
                    String elName = child.getName();
                    if (elName.equals("hyphen")) continue;
                    if (inDetachablePrefix && elName.equals("hydro")) {
                        child.detach();
                        targetSubstituent.insertChild(child, 0);
                        continue;
                    }
                    if (elName.equals("stereoChemistry")) {
                        inDetachablePrefix = false;
                        child.detach();
                        adjacentSubOrRootOrBracket.insertChild(child, 0);
                        continue;
                    }
                    throw new ComponentGenerationException("Unexpected term found before detachable hydro prefix: " + child.getValue());
                }
            }
            substituent.detach();
            return true;
        }
        return false;
    }

    static boolean removeAndMoveToAppropriateGroupIfSubtractivePrefix(Element substituent) throws ComponentGenerationException {
        List<Element> subtractivePrefixes = substituent.getChildElements("subtractivePrefix");
        if (subtractivePrefixes.size() > 0) {
            Element targetGroup;
            Element biochemicalGroup = null;
            Element standardGroup = null;
            Element adjacentSubOrRootOrBracket = OpsinTools.getNextSibling(substituent);
            Element nextSubOrRootOrBracket = adjacentSubOrRootOrBracket;
            if (nextSubOrRootOrBracket == null) {
                throw new ComponentGenerationException("Unable to find group for: " + subtractivePrefixes.get(0).getValue() + " to apply to!");
            }
            while (nextSubOrRootOrBracket != null) {
                Element groupToConsider = nextSubOrRootOrBracket.getFirstChildElement("group");
                if (groupToConsider != null) {
                    if (OpsinTools.isBiochemical(groupToConsider.getAttributeValue("type"), groupToConsider.getAttributeValue("subType"))) {
                        biochemicalGroup = groupToConsider;
                        if (OpsinTools.getPreviousSiblingsOfType(biochemicalGroup, "locant").isEmpty()) {
                            break;
                        }
                    } else {
                        standardGroup = groupToConsider;
                    }
                }
                nextSubOrRootOrBracket = OpsinTools.getNextSibling(nextSubOrRootOrBracket);
            }
            Element element = targetGroup = biochemicalGroup != null ? biochemicalGroup : standardGroup;
            if (targetGroup == null) {
                throw new ComponentGenerationException("Unable to find group for: " + subtractivePrefixes.get(0).getValue() + " to apply to!");
            }
            List<Element> children = substituent.getChildElements();
            Element targetSubstituent = targetGroup.getParent();
            if (targetSubstituent.equals(adjacentSubOrRootOrBracket)) {
                for (int i = children.size() - 1; i >= 0; --i) {
                    Element child = children.get(i);
                    if (child.getName().equals("hyphen")) continue;
                    child.detach();
                    targetSubstituent.insertChild(child, 0);
                }
            } else {
                boolean inDetachablePrefix = true;
                for (int i = children.size() - 1; i >= 0; --i) {
                    Element child = children.get(i);
                    String elName = child.getName();
                    if (elName.equals("hyphen")) continue;
                    if (inDetachablePrefix && elName.equals("subtractivePrefix")) {
                        child.detach();
                        targetSubstituent.insertChild(child, 0);
                        continue;
                    }
                    if (elName.equals("stereoChemistry")) {
                        inDetachablePrefix = false;
                        child.detach();
                        adjacentSubOrRootOrBracket.insertChild(child, 0);
                        continue;
                    }
                    throw new ComponentGenerationException("Unexpected term found before detachable substractive prefix: " + child.getValue());
                }
            }
            substituent.detach();
            return true;
        }
        return false;
    }

    private boolean removeAndMoveToAppropriateGroupIfRingBridge(Element substituent) throws ComponentGenerationException {
        List<Element> ringBridges = substituent.getChildElements("fusedRingBridge");
        if (ringBridges.size() > 0) {
            Element adjacentSubOrRootOrBracket = OpsinTools.getNextSibling(substituent);
            Element nextSubOrRootOrBracket = adjacentSubOrRootOrBracket;
            if (nextSubOrRootOrBracket == null) {
                throw new ComponentGenerationException("Unable to find group for: " + ringBridges.get(0).getValue() + " to apply to!");
            }
            Element targetGroup = null;
            Element standardGroup = null;
            while (nextSubOrRootOrBracket != null) {
                Element groupToConsider = nextSubOrRootOrBracket.getFirstChildElement("group");
                if (groupToConsider != null) {
                    if (this.containsCyclicAtoms(groupToConsider) && OpsinTools.getPreviousSiblingsOfType(groupToConsider, "locant").isEmpty()) {
                        targetGroup = groupToConsider;
                        break;
                    }
                    standardGroup = groupToConsider;
                }
                nextSubOrRootOrBracket = OpsinTools.getNextSibling(nextSubOrRootOrBracket);
            }
            if (targetGroup == null) {
                targetGroup = standardGroup;
            }
            if (targetGroup == null) {
                throw new ComponentGenerationException("Unable to find group for: " + ringBridges.get(0).getValue() + " to apply to!");
            }
            List<Element> children = substituent.getChildElements();
            Element targetSubstituent = targetGroup.getParent();
            if (targetSubstituent.equals(adjacentSubOrRootOrBracket)) {
                for (int i = children.size() - 1; i >= 0; --i) {
                    Element child = children.get(i);
                    if (child.getName().equals("hyphen")) continue;
                    child.detach();
                    targetSubstituent.insertChild(child, 0);
                }
            } else {
                boolean inDetachablePrefix = true;
                for (int i = children.size() - 1; i >= 0; --i) {
                    Element child = children.get(i);
                    String elName = child.getName();
                    if (elName.equals("hyphen")) continue;
                    if (inDetachablePrefix && (elName.equals("fusedRingBridge") || elName.equals("colonOrSemiColonDelimitedLocant") || elName.equals("locant"))) {
                        child.detach();
                        targetSubstituent.insertChild(child, 0);
                        continue;
                    }
                    if (elName.equals("stereoChemistry")) {
                        inDetachablePrefix = false;
                        child.detach();
                        adjacentSubOrRootOrBracket.insertChild(child, 0);
                        continue;
                    }
                    throw new ComponentGenerationException("Unexpected term found before detachable ring bridge: " + child.getValue());
                }
            }
            substituent.detach();
            return true;
        }
        return false;
    }

    private boolean containsCyclicAtoms(Element potentialRing) {
        Fragment potentialRingFrag = potentialRing.getFrag();
        List<Atom> atomList = potentialRingFrag.getAtomList();
        for (Atom atom : atomList) {
            if (!atom.getAtomIsInACycle()) continue;
            return true;
        }
        return false;
    }

    private void determineLocantMeaning(Element subOrBracketOrRoot, Element finalSubOrRootInWord) throws StructureBuildingException, ComponentGenerationException {
        List<Element> locants = subOrBracketOrRoot.getChildElements("locant");
        Element group = subOrBracketOrRoot.getFirstChildElement("group");
        for (Element locant : locants) {
            String[] locantValues = locant.getValue().split(",");
            if (locantValues.length <= 1) continue;
            Element afterLocant = OpsinTools.getNextSibling(locant);
            int structuralBracketDepth = 0;
            Element multiplierEl = null;
            while (afterLocant != null) {
                String elName = afterLocant.getName();
                if (elName.equals("structuralOpenBracket")) {
                    ++structuralBracketDepth;
                } else if (elName.equals("structuralCloseBracket")) {
                    --structuralBracketDepth;
                }
                if (structuralBracketDepth != 0) {
                    afterLocant = OpsinTools.getNextSibling(afterLocant);
                    continue;
                }
                if (elName.equals("locant")) break;
                if (elName.equals("multiplier")) {
                    if (locantValues.length == Integer.parseInt(afterLocant.getAttributeValue("value"))) {
                        if (afterLocant.equals(OpsinTools.getNextSiblingIgnoringCertainElements(locant, new String[]{"indicatedHydrogen"}))) {
                            multiplierEl = afterLocant;
                            break;
                        }
                        Element afterMultiplier = OpsinTools.getNextSibling(afterLocant);
                        if (afterMultiplier != null && (afterMultiplier.getName().equals("suffix") || afterMultiplier.getName().equals("infix") || afterMultiplier.getName().equals("unsaturator") || afterMultiplier.getName().equals("group"))) {
                            multiplierEl = afterLocant;
                            break;
                        }
                    }
                    if (afterLocant.equals(OpsinTools.getNextSibling(locant))) {
                        multiplierEl = afterLocant;
                    }
                } else if (elName.equals("ringAssemblyMultiplier") && afterLocant.equals(OpsinTools.getNextSibling(locant))) {
                    multiplierEl = afterLocant;
                    if (!FragmentTools.allAtomsInRingAreIdentical(group.getFrag())) {
                        break;
                    }
                } else if (elName.equals("fusedRingBridge") && locantValues.length == 2 && afterLocant.equals(OpsinTools.getNextSibling(locant))) break;
                afterLocant = OpsinTools.getNextSibling(afterLocant);
            }
            if (multiplierEl != null) {
                if (Integer.parseInt(multiplierEl.getAttributeValue("value")) == locantValues.length) {
                    boolean locantModified = false;
                    if (locantValues[locantValues.length - 1].endsWith("'") && group != null && subOrBracketOrRoot.indexOf(group) > subOrBracketOrRoot.indexOf(locant)) {
                        if (group.getAttribute("outIDs") != null && group.getAttributeValue("outIDs").split(",").length > 1) {
                            locantModified = this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord);
                        } else {
                            Element afterGroup = OpsinTools.getNextSibling(group);
                            int inlineSuffixCount = 0;
                            int multiplier = 1;
                            while (afterGroup != null) {
                                if (afterGroup.getName().equals("multiplier")) {
                                    multiplier = Integer.parseInt(afterGroup.getAttributeValue("value"));
                                } else if (afterGroup.getName().equals("suffix") && afterGroup.getAttributeValue("type").equals("inline")) {
                                    inlineSuffixCount += multiplier;
                                    multiplier = 1;
                                }
                                afterGroup = OpsinTools.getNextSibling(afterGroup);
                            }
                            if (inlineSuffixCount >= 2) {
                                locantModified = this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord);
                            }
                        }
                    }
                    if (locantModified || OpsinTools.getNextSibling(locant).equals(multiplierEl)) continue;
                    locant.detach();
                    OpsinTools.insertBefore(multiplierEl, locant);
                    continue;
                }
                if (this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord)) continue;
                throw new ComponentGenerationException("Mismatch between locant and multiplier counts (" + Integer.toString(locantValues.length) + " and " + multiplierEl.getAttributeValue("value") + "):" + locant.getValue());
            }
            if (this.checkSpecialLocantUses(locant, locantValues, finalSubOrRootInWord)) continue;
            throw new ComponentGenerationException("Multiple locants without a multiplier: " + locant.toXML());
        }
    }

    private boolean checkSpecialLocantUses(Element locant, String[] locantValues, Element finalSubOrRootInWord) throws ComponentGenerationException {
        Element finalSub;
        Element group;
        List<Element> substituents;
        boolean detectedMultiplicativeNomenclature;
        int count = locantValues.length;
        Element currentElem = OpsinTools.getNextSibling(locant);
        int heteroCount = 0;
        int multiplierValue = 1;
        while (currentElem != null && !currentElem.getName().equals("group")) {
            if (currentElem.getName().equals("heteroatom")) {
                heteroCount += multiplierValue;
                multiplierValue = 1;
            } else {
                if (!currentElem.getName().equals("multiplier")) break;
                multiplierValue = Integer.parseInt(currentElem.getAttributeValue("value"));
            }
            currentElem = OpsinTools.getNextSibling(currentElem);
        }
        if (currentElem != null && currentElem.getName().equals("group")) {
            Element potentialGroupAfterBenzo;
            if (currentElem.getAttributeValue("subType").equals("hantzschWidman")) {
                if (heteroCount == count) {
                    return true;
                }
                if (heteroCount > 1) {
                    return false;
                }
            }
            if (heteroCount == 0 && currentElem.getAttribute("outIDs") != null) {
                String[] outIDs = currentElem.getAttributeValue("outIDs").split(",", -1);
                Fragment groupFragment = currentElem.getFrag();
                if (count == outIDs.length && groupFragment.getAtomCount() > 1) {
                    int idOfFirstAtomInFrag = groupFragment.getIdOfFirstAtom();
                    boolean foundLocantNotPresentOnFragment = false;
                    for (int i = outIDs.length - 1; i >= 0; --i) {
                        Atom a = groupFragment.getAtomByLocant(locantValues[i]);
                        if (a == null) {
                            foundLocantNotPresentOnFragment = true;
                            break;
                        }
                        outIDs[i] = Integer.toString(a.getID() - idOfFirstAtomInFrag + 1);
                    }
                    if (!foundLocantNotPresentOnFragment) {
                        currentElem.getAttribute("outIDs").setValue(StringTools.arrayToString(outIDs, ","));
                        locant.detach();
                        return true;
                    }
                }
            } else if ((currentElem.getValue().equals("benz") || currentElem.getValue().equals("benzo")) && (potentialGroupAfterBenzo = OpsinTools.getNextSibling(currentElem, "group")) != null) {
                return true;
            }
        }
        if (currentElem != null) {
            String name = currentElem.getName();
            if (name.equals("polyCyclicSpiro")) {
                return true;
            }
            if (name.equals("fusedRingBridge") && count == 2) {
                return true;
            }
            if (name.equals("suffix") && "cycleformer".equals(currentElem.getAttributeValue("subType")) && count == 2) {
                currentElem.addAttribute(new Attribute("locant", locant.getValue()));
                locant.detach();
                return true;
            }
            if (name.equals("subtractivePrefix") && "anhydro".equals(currentElem.getAttributeValue("type"))) {
                if (count != 2) {
                    throw new ComponentGenerationException("Two locants are required before an anhydro prefix, but found: " + locant.getValue());
                }
                currentElem.addAttribute(new Attribute("locant", locant.getValue()));
                locant.detach();
                return true;
            }
        }
        if (detectedMultiplicativeNomenclature = this.detectMultiplicativeNomenclature(locant, locantValues, finalSubOrRootInWord)) {
            return true;
        }
        if (currentElem != null && count == 2 && currentElem.getName().equals("group")) {
            if ("epoxyLike".equals(currentElem.getAttributeValue("subType"))) {
                return true;
            }
            if ("yes".equals(currentElem.getAttributeValue("iminoLike"))) {
                currentElem.getAttribute("subType").setValue("epoxyLike");
                return true;
            }
        }
        Element parentElem = locant.getParent();
        if (count == 2 && parentElem.getName().equals("bracket") && (substituents = parentElem.getChildElements("substituent")).size() > 0 && "epoxyLike".equals((group = (finalSub = substituents.get(substituents.size() - 1)).getFirstChildElement("group")).getAttributeValue("subType"))) {
            locant.detach();
            OpsinTools.insertBefore(group, locant);
            return true;
        }
        return false;
    }

    private boolean detectMultiplicativeNomenclature(Element locant, String[] locantValues, Element finalSubOrRootInWord) {
        int count = locantValues.length;
        Element multiplier = finalSubOrRootInWord.getChild(0);
        if (finalSubOrRootInWord.getParent().getName().equals("bracket")) {
            if (!multiplier.getName().equals("multiplier")) {
                multiplier = finalSubOrRootInWord.getParent().getChild(0);
            } else {
                Element elAfterMultiplier = OpsinTools.getNextSibling(multiplier);
                String elName = elAfterMultiplier.getName();
                if (elName.equals("heteroatom") || elName.equals("subtractivePrefix") || elName.equals("hydro") && !elAfterMultiplier.getValue().startsWith("per") || elName.equals("fusedRingBridge")) {
                    multiplier = finalSubOrRootInWord.getParent().getChild(0);
                }
            }
        }
        Element commonParent = locant.getParent().getParent();
        for (Element parentOfMultiplier = multiplier.getParent(); parentOfMultiplier != null; parentOfMultiplier = parentOfMultiplier.getParent()) {
            if (!commonParent.equals(parentOfMultiplier) || !locantValues[count - 1].endsWith("'") || !multiplier.getName().equals("multiplier") || OpsinTools.getNextSibling(multiplier).getName().equals("multiplicativeLocant") || Integer.parseInt(multiplier.getAttributeValue("value")) != count) continue;
            locant.setName("multiplicativeLocant");
            locant.detach();
            OpsinTools.insertAfter(multiplier, locant);
            return true;
        }
        return false;
    }

    private void applyDLPrefixes(Element subOrRoot) throws ComponentGenerationException {
        List<Element> dlStereochemistryEls = OpsinTools.getChildElementsWithTagNameAndAttribute(subOrRoot, "stereoChemistry", "type", "dlStereochemistry");
        for (Element dlStereochemistry : dlStereochemistryEls) {
            String dlStereochemistryValue = dlStereochemistry.getAttributeValue("value");
            Element elementToApplyTo = OpsinTools.getNextSibling(dlStereochemistry);
            if (elementToApplyTo == null) continue;
            String type = elementToApplyTo.getAttributeValue("type");
            if ("opticalRotation".equals(type)) {
                if ((elementToApplyTo = OpsinTools.getNextSibling(elementToApplyTo)) == null) continue;
                type = elementToApplyTo.getAttributeValue("type");
            }
            if ("aminoAcid".equals(type)) {
                if (!this.applyDlStereochemistryToAminoAcid(elementToApplyTo, dlStereochemistryValue)) {
                    continue;
                }
            } else if ("carbohydrate".equals(type)) {
                this.applyDlStereochemistryToCarbohydrate(elementToApplyTo, dlStereochemistryValue);
            } else {
                if (!"carbohydrateConfigurationalPrefix".equals(type)) continue;
                ComponentProcessor.applyDlStereochemistryToCarbohydrateConfigurationalPrefix(elementToApplyTo, dlStereochemistryValue);
            }
            dlStereochemistry.detach();
        }
    }

    boolean applyDlStereochemistryToAminoAcid(Element aminoAcidEl, String dlStereochemistryValue) throws ComponentGenerationException {
        block10: {
            boolean invert;
            ArrayList<Atom> atomsWithParities;
            block9: {
                Fragment aminoAcid = aminoAcidEl.getFrag();
                List<Atom> atomList = aminoAcid.getAtomList();
                atomsWithParities = new ArrayList<Atom>();
                for (Atom atom : atomList) {
                    if (atom.getAtomParity() == null) continue;
                    atomsWithParities.add(atom);
                }
                if (atomsWithParities.isEmpty()) {
                    return false;
                }
                if (!dlStereochemistryValue.equals("dl")) break block9;
                int grpnum = ++this.state.numRacGrps;
                for (Atom atom : atomsWithParities) {
                    atom.setStereoGroup(new StereoGroup(StereoGroupType.Rac, grpnum));
                }
                break block10;
            }
            if (dlStereochemistryValue.equals("l") || dlStereochemistryValue.equals("ls")) {
                invert = false;
            } else if (dlStereochemistryValue.equals("d") || dlStereochemistryValue.equals("ds")) {
                invert = true;
            } else {
                throw new RuntimeException("OPSIN bug: Unexpected value for D/L stereochemistry found before amino acid: " + dlStereochemistryValue);
            }
            if ("yes".equals(aminoAcidEl.getAttributeValue("naturalEntIsOpposite"))) {
                boolean bl = invert = !invert;
            }
            if (!invert) break block10;
            for (Atom atom : atomsWithParities) {
                atom.getAtomParity().setParity(-atom.getAtomParity().getParity());
            }
        }
        return true;
    }

    void applyDlStereochemistryToCarbohydrate(Element carbohydrateEl, String dlStereochemistryValue) throws ComponentGenerationException {
        block12: {
            StereoGroupType grp;
            int grpnum;
            ArrayList<Atom> atomsWithParities;
            block11: {
                boolean invert;
                Fragment carbohydrate = carbohydrateEl.getFrag();
                List<Atom> atomList = carbohydrate.getAtomList();
                atomsWithParities = new ArrayList<Atom>();
                for (Atom atom : atomList) {
                    if (atom.getAtomParity() == null) continue;
                    atomsWithParities.add(atom);
                }
                if (atomsWithParities.isEmpty()) {
                    throw new ComponentGenerationException("D/L stereochemistry :" + dlStereochemistryValue + " found before achiral carbohydrate");
                }
                grpnum = 0;
                if (dlStereochemistryValue.equals("dl")) {
                    invert = false;
                    grp = StereoGroupType.Rac;
                    grpnum = ++this.state.numRacGrps;
                } else if (dlStereochemistryValue.equals("d") || dlStereochemistryValue.equals("dg")) {
                    invert = false;
                    grp = StereoGroupType.Abs;
                } else if (dlStereochemistryValue.equals("l") || dlStereochemistryValue.equals("lg")) {
                    invert = true;
                    grp = StereoGroupType.Abs;
                } else {
                    throw new ComponentGenerationException("Unexpected value for D/L stereochemistry found before carbohydrate: " + dlStereochemistryValue);
                }
                if ("yes".equals(carbohydrateEl.getAttributeValue("naturalEntIsOpposite"))) {
                    boolean bl = invert = !invert;
                }
                if (!invert) break block11;
                for (Atom atom : atomsWithParities) {
                    atom.getAtomParity().setParity(-atom.getAtomParity().getParity());
                    atom.setStereoGroup(new StereoGroup(grp, grpnum));
                }
                break block12;
            }
            if (grp == StereoGroupType.Abs) break block12;
            for (Atom atom : atomsWithParities) {
                atom.setStereoGroup(new StereoGroup(grp, grpnum));
            }
        }
    }

    static void applyDlStereochemistryToCarbohydrateConfigurationalPrefix(Element elementToApplyTo, String dlStereochemistryValue) throws ComponentGenerationException {
        if (!dlStereochemistryValue.equals("d") && !dlStereochemistryValue.equals("dg")) {
            if (dlStereochemistryValue.equals("l") || dlStereochemistryValue.equals("lg")) {
                String[] values = elementToApplyTo.getAttributeValue("value").split("/", -1);
                StringBuilder sb = new StringBuilder();
                for (String value : values) {
                    if (value.equals("r")) {
                        sb.append("l");
                    } else if (value.equals("l")) {
                        sb.append("r");
                    } else {
                        throw new RuntimeException("OPSIN Bug: Invalid carbohydrate prefix value: " + elementToApplyTo.getAttributeValue("value"));
                    }
                    sb.append("/");
                }
                String newVal = sb.toString().substring(0, sb.length() - 1);
                elementToApplyTo.getAttribute("value").setValue(newVal);
            } else if (dlStereochemistryValue.equals("dl")) {
                String[] values = elementToApplyTo.getAttributeValue("value").split("/");
                String newVal = "?" + StringTools.multiplyString("/?", values.length - 1);
                elementToApplyTo.getAttribute("value").setValue(newVal);
            } else {
                throw new ComponentGenerationException("Unexpected value for D/L stereochemistry found before carbohydrate prefix: " + dlStereochemistryValue);
            }
        }
    }

    private void processCarbohydrates(Element subOrRoot) throws StructureBuildingException {
        List<Element> carbohydrates = OpsinTools.getChildElementsWithTagNameAndAttribute(subOrRoot, "group", "type", "carbohydrate");
        for (Element carbohydrate : carbohydrates) {
            boolean isAldose;
            Fragment carbohydrateFrag = carbohydrate.getFrag();
            String subtype = carbohydrate.getAttributeValue("subType");
            if ("carbohydrateStemKetose".equals(subtype)) {
                isAldose = false;
            } else if ("carbohydrateStemAldose".equals(subtype) || "systematicCarbohydrateStemAldose".equals(subtype)) {
                isAldose = true;
            } else {
                Attribute anomericId = carbohydrate.getAttribute("suffixAppliesTo");
                if (anomericId == null) continue;
                Atom anomericCarbon = carbohydrateFrag.getAtomByID(carbohydrateFrag.getIdOfFirstAtom() + Integer.parseInt(anomericId.getValue()) - 1);
                if ("apioFuranose".equals(subtype)) {
                    Element suffix = OpsinTools.getNextSibling(carbohydrate);
                    if (suffix != null && suffix.getName().equals("suffix")) {
                        suffix.addAttribute(new Attribute("locantID", String.valueOf(anomericCarbon.getID())));
                    }
                } else {
                    this.applyAlphaBetaStereoToCyclisedCarbohydrate(carbohydrate, anomericCarbon);
                }
                carbohydrate.removeAttribute(anomericId);
                continue;
            }
            boolean cyclisationPerformed = false;
            Attribute anomericId = carbohydrate.getAttribute("suffixAppliesTo");
            if (anomericId == null) {
                throw new StructureBuildingException("OPSIN bug: Missing suffixAppliesTo on: " + carbohydrate.getValue());
            }
            Atom potentialCarbonyl = carbohydrateFrag.getAtomByID(carbohydrateFrag.getIdOfFirstAtom() + Integer.parseInt(anomericId.getValue()) - 1);
            if (potentialCarbonyl == null) {
                throw new StructureBuildingException("OPSIN bug: " + anomericId.getValue() + " did not point to an atom on: " + carbohydrate.getValue());
            }
            carbohydrate.removeAttribute(anomericId);
            Element nextSibling = OpsinTools.getNextSibling(carbohydrate);
            while (nextSibling != null) {
                Element nextNextSibling = OpsinTools.getNextSibling(nextSibling);
                String elName = nextSibling.getName();
                if (elName.equals("suffix")) {
                    Element suffix = nextSibling;
                    String value = suffix.getAttributeValue("value");
                    if (value.equals("dialdose") || value.equals("aric acid") || value.equals("arate")) {
                        if (!isAldose) {
                            throw new StructureBuildingException(value + " may only be used with aldoses");
                        }
                        if (cyclisationPerformed) {
                            throw new StructureBuildingException("OPSIN bug: " + value + " not expected after carbohydrate cycliser");
                        }
                        this.processAldoseDiSuffix(value, carbohydrate, potentialCarbonyl);
                        suffix.detach();
                    } else if (value.startsWith("uron")) {
                        suffix.addAttribute(new Attribute("locant", String.valueOf(carbohydrateFrag.getChainLength())));
                    } else if (!cyclisationPerformed && (value.equals("ulose") || value.equals("osulose"))) {
                        if (value.equals("ulose")) {
                            isAldose = false;
                            if ("systematicCarbohydrateStemAldose".equals(subtype)) {
                                carbohydrate.getAttribute("subType").setValue("systematicCarbohydrateStemKetose");
                            }
                        }
                        potentialCarbonyl = this.processUloseSuffix(carbohydrate, suffix, potentialCarbonyl);
                        suffix.detach();
                    } else if (value.equals("itol") || value.equals("yl") || value.equals("glycoside")) {
                        suffix.addAttribute(new Attribute("locant", potentialCarbonyl.getFirstLocant()));
                        if (value.equals("glycoside") && OpsinTools.getParentWordRule(subOrRoot).getAttributeValue("wordRule").equals(WordRule.simple.toString())) {
                            throw new StructureBuildingException("A glycoside requires a space-separated substituent e.g. methyl alpha-D-glucopyranoside");
                        }
                    }
                } else if (elName.equals("carbohydrateRingSize")) {
                    if (cyclisationPerformed) {
                        throw new StructureBuildingException("OPSIN bug: Carbohydate cyclised twice!");
                    }
                    Element ringSize = nextSibling;
                    this.cycliseCarbohydrateAndApplyAlphaBetaStereo(carbohydrate, ringSize, potentialCarbonyl);
                    ringSize.detach();
                    cyclisationPerformed = true;
                } else if (!elName.equals("locant") && !elName.equals("multiplier") && !elName.equals("unsaturator") && !elName.equals("colonOrSemiColonDelimitedLocant")) break;
                nextSibling = nextNextSibling;
            }
            if (cyclisationPerformed) continue;
            this.applyUnspecifiedRingSizeCyclisationIfPresent(carbohydrate, potentialCarbonyl);
        }
    }

    private void applyUnspecifiedRingSizeCyclisationIfPresent(Element group, Atom potentialCarbonyl) throws StructureBuildingException {
        String value;
        Element alphaOrBetaLocantEl;
        boolean cyclise = false;
        Element possibleYl = OpsinTools.getNextSibling(group);
        if (possibleYl != null && possibleYl.getName().equals("suffix")) {
            if (possibleYl.getAttributeValue("value").equals("yl")) {
                cyclise = true;
            } else if ((possibleYl = OpsinTools.getNextSibling(possibleYl)) != null && possibleYl.getName().equals("suffix") && possibleYl.getAttributeValue("value").equals("yl")) {
                cyclise = true;
            }
        }
        if (!cyclise && (alphaOrBetaLocantEl = OpsinTools.getPreviousSiblingIgnoringCertainElements(group, new String[]{"stereoChemistry"})) != null && alphaOrBetaLocantEl.getName().equals("locant") && ((value = alphaOrBetaLocantEl.getValue()).equals("alpha") || value.equals("beta") || value.equals("alpha,beta") || value.equals("beta,alpha"))) {
            cyclise = true;
        }
        if (cyclise) {
            TokenEl ringSize = new TokenEl("carbohydrateRingSize");
            String sugarStem = group.getValue();
            if (group.getFrag().hasLocant("5") && !sugarStem.equals("rib") && !sugarStem.equals("fruct")) {
                ringSize.addAttribute(new Attribute("value", "6"));
            } else {
                ringSize.addAttribute(new Attribute("value", "5"));
            }
            OpsinTools.insertAfter(group, ringSize);
            this.cycliseCarbohydrateAndApplyAlphaBetaStereo(group, ringSize, potentialCarbonyl);
            ringSize.detach();
        }
    }

    private Atom processUloseSuffix(Element group, Element suffix, Atom potentialCarbonyl) throws StructureBuildingException {
        Atom backboneAtom;
        ArrayList<String> locantsToConvertToKetones = new ArrayList<String>();
        Element potentialLocantOrMultiplier = OpsinTools.getPreviousSibling(suffix);
        if (potentialLocantOrMultiplier.getName().equals("multiplier")) {
            int multVal = Integer.parseInt(potentialLocantOrMultiplier.getAttributeValue("value"));
            Element locant = OpsinTools.getPreviousSibling(potentialLocantOrMultiplier);
            if (locant != null && locant.getName().equals("locant")) {
                String[] locantStrs = locant.getValue().split(",");
                if (locantStrs.length != multVal) {
                    throw new StructureBuildingException("Mismatch between locant and multiplier counts (" + locantStrs.length + " and " + multVal + "):" + locant.getValue());
                }
                Collections.addAll(locantsToConvertToKetones, locantStrs);
                locant.detach();
            } else {
                for (int i = 0; i < multVal; ++i) {
                    locantsToConvertToKetones.add(String.valueOf(i + 2));
                }
            }
            potentialLocantOrMultiplier.detach();
        } else {
            Element locant = potentialLocantOrMultiplier;
            if (!locant.getName().equals("locant")) {
                locant = OpsinTools.getPreviousSibling(group);
            }
            if (locant != null && locant.getName().equals("locant")) {
                String locantStr = locant.getValue();
                if (locantStr.split(",").length != 1) {
                    throw new StructureBuildingException("Incorrect number of locants for ul suffix: " + locantStr);
                }
                locantsToConvertToKetones.add(locantStr);
                locant.detach();
            } else {
                locantsToConvertToKetones.add("2");
            }
        }
        Fragment frag = group.getFrag();
        if (suffix.getAttributeValue("value").equals("ulose")) {
            Atom aldehydeAtom = potentialCarbonyl;
            boolean foundBond = false;
            for (Bond bond : aldehydeAtom.getBonds()) {
                Atom otherAtom;
                if (bond.getOrder() != 2 || (otherAtom = bond.getOtherAtom(aldehydeAtom)).getElement() != ChemEl.O || otherAtom.getCharge() != 0 || otherAtom.getBondCount() != 1) continue;
                bond.setOrder(1);
                foundBond = true;
                break;
            }
            if (!foundBond) {
                throw new StructureBuildingException("OPSIN bug: Unable to convert aldose to ketose");
            }
            potentialCarbonyl = backboneAtom = frag.getAtomByLocantOrThrow((String)locantsToConvertToKetones.get(0));
        }
        for (String locantStr : locantsToConvertToKetones) {
            backboneAtom = frag.getAtomByLocantOrThrow(locantStr);
            boolean foundBond = false;
            for (Bond bond : backboneAtom.getBonds()) {
                Atom otherAtom;
                if (bond.getOrder() != 1 || (otherAtom = bond.getOtherAtom(backboneAtom)).getElement() != ChemEl.O || otherAtom.getCharge() != 0 || otherAtom.getBondCount() != 1) continue;
                bond.setOrder(2);
                foundBond = true;
                break;
            }
            if (!foundBond) {
                throw new StructureBuildingException("Failed to find hydroxy group at position:" + locantStr);
            }
            backboneAtom.setAtomParity(null);
        }
        return potentialCarbonyl;
    }

    private void cycliseCarbohydrateAndApplyAlphaBetaStereo(Element carbohydrateGroup, Element ringSize, Atom potentialCarbonyl) throws StructureBuildingException {
        int locantOfCarbonyl;
        Fragment frag = carbohydrateGroup.getFrag();
        String ringSizeVal = ringSize.getAttributeValue("value");
        Element potentialLocant = OpsinTools.getPreviousSibling(ringSize);
        Atom carbonylCarbon = null;
        Atom atomToJoinWith = null;
        if (potentialLocant.getName().equals("locant")) {
            String[] locants = potentialLocant.getValue().split(",");
            if (locants.length != 2) {
                throw new StructureBuildingException("Expected 2 locants in front of sugar ring size specifier but found: " + potentialLocant.getValue());
            }
            try {
                int firstLocant = Integer.parseInt((String)locants[0]);
                int secondLocant = Integer.parseInt((String)locants[1]);
                if (Math.abs(secondLocant - firstLocant) != Integer.parseInt(ringSizeVal) - 2) {
                    throw new StructureBuildingException("Mismatch between ring size: " + ringSizeVal + " and ring size specified by locants: " + (Math.abs(secondLocant - firstLocant) + 2));
                }
            }
            catch (NumberFormatException e) {
                throw new StructureBuildingException("Locants for ring should be numeric but were: " + potentialLocant.getValue());
            }
            carbonylCarbon = frag.getAtomByLocantOrThrow((String)locants[0]);
            atomToJoinWith = frag.getAtomByLocantOrThrow("O" + (String)locants[1]);
            potentialLocant.detach();
        }
        if (carbonylCarbon == null && (carbonylCarbon = potentialCarbonyl) == null) {
            throw new RuntimeException("OPSIN bug: Could not find carbonyl carbon in carbohydrate");
        }
        for (Bond b : carbonylCarbon.getBonds()) {
            if (b.getOrder() != 2) continue;
            b.setOrder(1);
            break;
        }
        try {
            locantOfCarbonyl = Integer.parseInt(carbonylCarbon.getFirstLocant());
        }
        catch (Exception e) {
            throw new RuntimeException("OPSIN bug: Could not determine locant of carbonyl carbon in carbohydrate", e);
        }
        if (atomToJoinWith == null) {
            String locantToJoinWith = String.valueOf(locantOfCarbonyl + Integer.parseInt(ringSizeVal) - 2);
            atomToJoinWith = frag.getAtomByLocant("O" + locantToJoinWith);
            if (atomToJoinWith == null) {
                throw new StructureBuildingException("Carbohydrate was not an inappropriate length to form a ring of size: " + ringSizeVal);
            }
        }
        this.state.fragManager.createBond(carbonylCarbon, atomToJoinWith, 1);
        CycleDetector.assignWhetherAtomsAreInCycles(frag);
        this.applyAlphaBetaStereoToCyclisedCarbohydrate(carbohydrateGroup, carbonylCarbon);
    }

    private void applyAlphaBetaStereoToCyclisedCarbohydrate(Element carbohydrateGroup, Atom carbonylCarbon) {
        Fragment frag = carbohydrateGroup.getFrag();
        Element alphaOrBetaLocantEl = OpsinTools.getPreviousSiblingIgnoringCertainElements(carbohydrateGroup, new String[]{"stereoChemistry"});
        if (alphaOrBetaLocantEl != null && alphaOrBetaLocantEl.getName().equals("locant")) {
            String val;
            Element stereoPrefixAfterAlphaBeta = OpsinTools.getNextSibling(alphaOrBetaLocantEl);
            Atom anomericReferenceAtom = this.getAnomericReferenceAtom(frag);
            if (anomericReferenceAtom == null) {
                throw new RuntimeException("OPSIN bug: Unable to determine anomeric reference atom in: " + carbohydrateGroup.getValue());
            }
            this.applyAnomerStereochemistryIfPresent(alphaOrBetaLocantEl, carbonylCarbon, anomericReferenceAtom);
            if (carbonylCarbon.getAtomParity() != null && ("systematicCarbohydrateStemAldose".equals(carbohydrateGroup.getAttributeValue("subType")) || "systematicCarbohydrateStemKetose".equals(carbohydrateGroup.getAttributeValue("subType"))) && (val = stereoPrefixAfterAlphaBeta.getAttributeValue("value")).substring(val.length() - 1, val.length()).equals("l")) {
                AtomParity atomParity = carbonylCarbon.getAtomParity();
                atomParity.setParity(-atomParity.getParity());
            }
        }
        carbonylCarbon.setProperty(Atom.ISANOMERIC, true);
    }

    private void processAldoseDiSuffix(String suffixValue, Element group, Atom aldehydeAtom) throws StructureBuildingException {
        Fragment frag = group.getFrag();
        Atom alcoholAtom = frag.getAtomByLocantOrThrow(String.valueOf(frag.getChainLength()));
        if (suffixValue.equals("aric acid") || suffixValue.equals("arate")) {
            FragmentTools.removeTerminalOxygen(this.state, alcoholAtom, 1);
            Fragment f = this.state.fragManager.buildSMILES("O", group, "none");
            this.state.fragManager.incorporateFragment(f, f.getFirstAtom(), frag, alcoholAtom, 2);
            f = this.state.fragManager.buildSMILES("O", group, "none");
            Atom hydroxyAtom = f.getFirstAtom();
            if (suffixValue.equals("arate")) {
                hydroxyAtom.addChargeAndProtons(-1, -1);
            }
            this.state.fragManager.incorporateFragment(f, f.getFirstAtom(), frag, alcoholAtom, 1);
            frag.addFunctionalAtom(hydroxyAtom);
            f = this.state.fragManager.buildSMILES("O", group, "none");
            hydroxyAtom = f.getFirstAtom();
            if (suffixValue.equals("arate")) {
                hydroxyAtom.addChargeAndProtons(-1, -1);
            }
            this.state.fragManager.incorporateFragment(f, f.getFirstAtom(), frag, aldehydeAtom, 1);
            frag.addFunctionalAtom(hydroxyAtom);
        } else if (suffixValue.equals("dialdose")) {
            FragmentTools.removeTerminalOxygen(this.state, alcoholAtom, 1);
            Fragment f = this.state.fragManager.buildSMILES("O", group, "none");
            this.state.fragManager.incorporateFragment(f, f.getFirstAtom(), frag, alcoholAtom, 2);
        } else {
            throw new IllegalArgumentException("OPSIN Bug: Unexpected suffix value: " + suffixValue);
        }
    }

    private Atom getAnomericReferenceAtom(Fragment frag) {
        List<Atom> atomList = frag.getAtomList();
        int highestLocantfound = Integer.MIN_VALUE;
        Atom configurationalAtom = null;
        for (Atom a : atomList) {
            if (a.getAtomParity() == null) continue;
            try {
                int intVal;
                String locant = a.getFirstLocant();
                if (locant == null || (intVal = Integer.parseInt(locant)) <= highestLocantfound) continue;
                highestLocantfound = intVal;
                configurationalAtom = a;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return configurationalAtom;
    }

    private void applyAnomerStereochemistryIfPresent(Element alphaOrBetaLocantEl, Atom anomericAtom, Atom anomericReferenceAtom) {
        String value = alphaOrBetaLocantEl.getValue();
        if (value.equals("alpha") || value.equals("beta")) {
            Atom[] referenceAtomRefs4 = this.getDeterministicAtomRefs4ForReferenceAtom(anomericReferenceAtom);
            boolean flip = StereochemistryHandler.checkEquivalencyOfAtomsRefs4AndParity(referenceAtomRefs4, 1, anomericReferenceAtom.getAtomParity().getAtomRefs4(), anomericReferenceAtom.getAtomParity().getParity());
            Atom[] atomRefs4 = this.getDeterministicAtomRefs4ForAnomericAtom(anomericAtom);
            if (flip) {
                if (value.equals("alpha")) {
                    anomericAtom.setAtomParity(atomRefs4, 1);
                } else {
                    anomericAtom.setAtomParity(atomRefs4, -1);
                }
            } else if (value.equals("alpha")) {
                anomericAtom.setAtomParity(atomRefs4, -1);
            } else {
                anomericAtom.setAtomParity(atomRefs4, 1);
            }
            alphaOrBetaLocantEl.detach();
        } else if (value.equals("alpha,beta") || value.equals("beta,alpha")) {
            alphaOrBetaLocantEl.detach();
        }
    }

    private Atom[] getDeterministicAtomRefs4ForReferenceAtom(Atom referenceAtom) {
        List<Atom> neighbours = referenceAtom.getAtomNeighbours();
        if (neighbours.size() != 3) {
            throw new RuntimeException("OPSIN bug: Unexpected number of atoms connected to anomeric reference atom of carbohydrate");
        }
        String nextLowestLocant = String.valueOf(Integer.parseInt(referenceAtom.getFirstLocant()) - 1);
        Atom[] atomRefs4 = new Atom[4];
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement() == ChemEl.O) {
                atomRefs4[0] = neighbour;
                continue;
            }
            if (neighbour.getElement() == ChemEl.C) {
                if (neighbour.getFirstLocant().equals(nextLowestLocant)) {
                    atomRefs4[1] = neighbour;
                    continue;
                }
                atomRefs4[2] = neighbour;
                continue;
            }
            throw new RuntimeException("OPSIN bug: Unexpected atom element type connected to for anomeric reference atom");
        }
        atomRefs4[3] = AtomParity.hydrogen;
        for (Atom atom : atomRefs4) {
            if (atom != null) continue;
            throw new RuntimeException("OPSIN bug: Unable to determine atomRefs4 for anomeric reference atom");
        }
        return atomRefs4;
    }

    private Atom[] getDeterministicAtomRefs4ForAnomericAtom(Atom anomericAtom) {
        List<Atom> neighbours = anomericAtom.getAtomNeighbours();
        Atom[] atomRefs4 = new Atom[4];
        if (neighbours.size() != 3 && neighbours.size() != 4) {
            if (neighbours.size() == 2 && anomericAtom.getOutValency() == 1) {
                atomRefs4[1] = AtomParity.deoxyHydrogen;
            } else {
                throw new RuntimeException("OPSIN bug: Unexpected number of atoms connected to anomeric atom of carbohydrate");
            }
        }
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement() == ChemEl.C) {
                if (neighbour.getAtomIsInACycle()) {
                    atomRefs4[0] = neighbour;
                    continue;
                }
                atomRefs4[3] = neighbour;
                continue;
            }
            if (neighbour.getElement() == ChemEl.O) {
                int incomingVal = neighbour.getIncomingValency();
                if (incomingVal == 1) {
                    atomRefs4[1] = neighbour;
                    continue;
                }
                if (incomingVal == 2) {
                    atomRefs4[2] = neighbour;
                    continue;
                }
                throw new RuntimeException("OPSIN bug: Unexpected valency on oxygen in carbohydrate");
            }
            throw new RuntimeException("OPSIN bug: Unexpected atom element type connected to anomeric atom of carbohydrate");
        }
        if (atomRefs4[3] == null) {
            atomRefs4[3] = AtomParity.hydrogen;
        }
        for (Atom atom : atomRefs4) {
            if (atom != null) continue;
            throw new RuntimeException("OPSIN bug: Unable to assign anomeric carbon stereochemistry on carbohydrate");
        }
        return atomRefs4;
    }

    private void processMultipliers(Element subOrRoot) {
        List<Element> multipliers = subOrRoot.getChildElements("multiplier");
        for (Element multiplier : multipliers) {
            Element featureToMultiply;
            String nextName;
            Element possibleLocant = OpsinTools.getPreviousSibling(multiplier);
            String[] locants = null;
            if (possibleLocant != null) {
                String possibleLocantElName = possibleLocant.getName();
                if (possibleLocantElName.equals("locant")) {
                    locants = possibleLocant.getValue().split(",");
                } else if (possibleLocantElName.equals("colonOrSemiColonDelimitedLocant")) {
                    locants = StringTools.removeDashIfPresent(possibleLocant.getValue()).split(":");
                }
            }
            if (!(nextName = (featureToMultiply = OpsinTools.getNextSibling(multiplier)).getName()).equals("unsaturator") && !nextName.equals("suffix") && !nextName.equals("subtractivePrefix") && (!nextName.equals("heteroatom") || "group".equals(multiplier.getAttributeValue("type"))) && !nextName.equals("hydro")) continue;
            int mvalue = Integer.parseInt(multiplier.getAttributeValue("value"));
            if (mvalue > 1) {
                featureToMultiply.addAttribute(new Attribute("multiplied", "multiplied"));
            }
            for (int i = mvalue - 1; i >= 1; --i) {
                Element newElement = featureToMultiply.copy();
                if (locants != null && locants.length == mvalue) {
                    newElement.addAttribute(new Attribute("locant", locants[i]));
                }
                OpsinTools.insertAfter(featureToMultiply, newElement);
            }
            multiplier.detach();
            if (locants == null || locants.length != mvalue) continue;
            featureToMultiply.addAttribute(new Attribute("locant", locants[0]));
            possibleLocant.detach();
        }
    }

    private void detectConjunctiveSuffixGroups(Element subOrRoot, List<Element> allGroups) throws ComponentGenerationException, StructureBuildingException {
        List<Element> groups = subOrRoot.getChildElements("group");
        if (groups.size() > 1) {
            int i;
            ArrayList<Element> conjunctiveGroups = new ArrayList<Element>();
            Element ringGroup = null;
            for (int i2 = groups.size() - 1; i2 >= 0; --i2) {
                Element group = groups.get(i2);
                if (group.getAttributeValue("type").equals("ring")) {
                    ringGroup = group;
                    break;
                }
                conjunctiveGroups.add(group);
            }
            if (conjunctiveGroups.isEmpty()) {
                return;
            }
            if (ringGroup == null) {
                throw new ComponentGenerationException("OPSIN bug: unable to find ring associated with conjunctive suffix group");
            }
            if (conjunctiveGroups.size() != 1) {
                throw new ComponentGenerationException("OPSIN Bug: Two groups exactly should be present at this point when processing conjunctive nomenclature");
            }
            Element primaryConjunctiveGroup = (Element)conjunctiveGroups.get(0);
            Fragment primaryConjunctiveFrag = primaryConjunctiveGroup.getFrag();
            List<Atom> atomList = primaryConjunctiveFrag.getAtomList();
            for (Atom atom : atomList) {
                atom.clearLocants();
            }
            ArrayList<Element> suffixes = new ArrayList<Element>();
            Element possibleSuffix = OpsinTools.getNextSibling(primaryConjunctiveGroup);
            while (possibleSuffix != null) {
                if (possibleSuffix.getName().equals("suffix")) {
                    suffixes.add(possibleSuffix);
                }
                possibleSuffix = OpsinTools.getNextSibling(possibleSuffix);
            }
            this.preliminaryProcessSuffixes(primaryConjunctiveGroup, suffixes);
            this.suffixApplier.resolveSuffixes(primaryConjunctiveGroup, suffixes);
            for (Element suffix : suffixes) {
                suffix.detach();
            }
            primaryConjunctiveGroup.setName("conjunctiveSuffixGroup");
            allGroups.remove(primaryConjunctiveGroup);
            Element possibleMultiplier = OpsinTools.getPreviousSibling(primaryConjunctiveGroup);
            boolean alphaIsPosition1 = atomList.get(0).getIncomingValency() < 3;
            int counter = 0;
            int n = i = alphaIsPosition1 ? 0 : 1;
            while (i < atomList.size()) {
                Atom a = atomList.get(i);
                if (counter == 0) {
                    a.addLocant("alpha");
                } else if (counter == 1) {
                    a.addLocant("beta");
                } else if (counter == 2) {
                    a.addLocant("gamma");
                } else if (counter == 3) {
                    a.addLocant("delta");
                } else if (counter == 4) {
                    a.addLocant("epsilon");
                } else if (counter == 5) {
                    a.addLocant("zeta");
                } else if (counter == 6) {
                    a.addLocant("eta");
                }
                ++counter;
                ++i;
            }
            if ("multiplier".equals(possibleMultiplier.getName())) {
                int multiplier = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                for (int i3 = 1; i3 < multiplier; ++i3) {
                    Element conjunctiveSuffixGroup = primaryConjunctiveGroup.copy();
                    Fragment newFragment = this.state.fragManager.copyAndRelabelFragment(primaryConjunctiveFrag, i3);
                    newFragment.setTokenEl(conjunctiveSuffixGroup);
                    conjunctiveSuffixGroup.setFrag(newFragment);
                    conjunctiveGroups.add(conjunctiveSuffixGroup);
                    OpsinTools.insertAfter(primaryConjunctiveGroup, conjunctiveSuffixGroup);
                }
                Element possibleLocant = OpsinTools.getPreviousSibling(possibleMultiplier);
                possibleMultiplier.detach();
                if (possibleLocant.getName().equals("locant")) {
                    String[] locants = possibleLocant.getValue().split(",");
                    if (locants.length != multiplier) {
                        throw new ComponentGenerationException("mismatch between number of locants and multiplier in conjunctive nomenclature routine");
                    }
                    for (int i4 = 0; i4 < locants.length; ++i4) {
                        ((Element)conjunctiveGroups.get(i4)).addAttribute(new Attribute("locant", locants[i4]));
                    }
                    possibleLocant.detach();
                }
            }
        }
    }

    private void matchLocantsToDirectFeatures(Element subOrRoot) throws ComponentGenerationException {
        List<Element> locants = subOrRoot.getChildElements("locant");
        List<Element> groups = subOrRoot.getChildElements("group");
        for (Element group : groups) {
            List<Element> deltas;
            if (!group.getAttributeValue("subType").equals("hantzschWidman")) continue;
            if (group.getAttribute("addBond") != null && (deltas = subOrRoot.getChildElements("delta")).isEmpty()) {
                TokenEl delta = new TokenEl("delta");
                Element appropriateLocant = OpsinTools.getPreviousSiblingIgnoringCertainElements(group, new String[]{"heteroatom", "multiplier"});
                if (appropriateLocant != null && appropriateLocant.getName().equals("locant") && appropriateLocant.getValue().split(",").length == 1) {
                    ((Element)delta).setValue(appropriateLocant.getValue());
                    OpsinTools.insertBefore(appropriateLocant, delta);
                    appropriateLocant.detach();
                    locants.remove(appropriateLocant);
                } else {
                    ((Element)delta).setValue("");
                    subOrRoot.insertChild(delta, 0);
                }
            }
            if (locants.size() <= 0) continue;
            Element locantBeforeHWSystem = null;
            ArrayList<Element> heteroAtoms = new ArrayList<Element>();
            int indexOfGroup = subOrRoot.indexOf(group);
            for (int j = indexOfGroup - 1; j >= 0; --j) {
                String elName = subOrRoot.getChild(j).getName();
                if (elName.equals("locant")) {
                    locantBeforeHWSystem = subOrRoot.getChild(j);
                    break;
                }
                if (!elName.equals("heteroatom")) break;
                Element heteroAtom = subOrRoot.getChild(j);
                heteroAtoms.add(heteroAtom);
                if (heteroAtom.getAttribute("locant") != null) break;
            }
            Collections.reverse(heteroAtoms);
            if (locantBeforeHWSystem == null) continue;
            String[] locantValues = locantBeforeHWSystem.getValue().split(",");
            if (locantValues.length == 1 && group.getFrag().getAtomCount() <= 10) {
                locants.remove(locantBeforeHWSystem);
                continue;
            }
            if (locantValues.length == heteroAtoms.size()) {
                for (int j = 0; j < locantValues.length; ++j) {
                    String locantValue = locantValues[j];
                    ((Element)heteroAtoms.get(j)).addAttribute(new Attribute("locant", locantValue));
                }
                locantBeforeHWSystem.detach();
                locants.remove(locantBeforeHWSystem);
                continue;
            }
            if (heteroAtoms.size() <= 1) continue;
            throw new ComponentGenerationException("Mismatch between number of locants and Hantzsch-Widman heteroatoms");
        }
        this.assignSingleLocantsToAdjacentFeatures(locants);
    }

    private void assignSingleLocantsToAdjacentFeatures(List<Element> locants) {
        for (Element locant : locants) {
            String[] locantValues = locant.getValue().split(",");
            Element referent = OpsinTools.getNextSibling(locant);
            if (referent == null || locantValues.length != 1) continue;
            String refName = referent.getName();
            if (refName.equals("isotopeSpecification")) {
                if ((referent = OpsinTools.getNextSibling(referent)) == null) {
                    return;
                }
                refName = referent.getName();
            }
            if (referent.getAttribute("locant") != null || referent.getAttribute("multiplied") != null || !refName.equals("unsaturator") && !refName.equals("suffix") && !refName.equals("heteroatom") && !refName.equals("conjunctiveSuffixGroup") && !refName.equals("subtractivePrefix") && (!refName.equals("hydro") || referent.getValue().startsWith("per"))) continue;
            referent.addAttribute(new Attribute("locant", locantValues[0]));
            locant.detach();
        }
    }

    private void preliminaryProcessSuffixes(Element group, List<Element> suffixes) throws ComponentGenerationException, StructureBuildingException {
        Fragment suffixableFragment = group.getFrag();
        if (group.getAttribute("suffixAppliesTo") != null) {
            this.processSuffixAppliesTo(group, suffixes, suffixableFragment);
        } else {
            for (Element suffix : suffixes) {
                if (suffix.getAttribute("additionalValue") == null) continue;
                throw new ComponentGenerationException("suffix: " + suffix.getValue() + " used on an inappropriate group");
            }
        }
        this.applyDefaultLocantsToSuffixesIfApplicable(group, suffixableFragment);
        List<Fragment> suffixFragments = this.resolveGroupAddingSuffixes(suffixes, suffixableFragment);
        this.state.xmlSuffixMap.put(group, suffixFragments);
        boolean suffixesResolved = false;
        if (group.getAttributeValue("type").equals("chalcogenAcidStem")) {
            this.suffixApplier.resolveSuffixes(group, suffixes);
            suffixesResolved = true;
        }
        this.processSuffixPrefixes(suffixes);
        this.functionalReplacement.processInfixFunctionalReplacementNomenclature(suffixes, suffixFragments);
        this.processRemovalOfHydroxyGroupsRules(suffixes, suffixableFragment);
        if (group.getValue().equals("oxal")) {
            this.suffixApplier.resolveSuffixes(group, suffixes);
            group.getAttribute("type").setValue("nonCarboxylicAcid");
            suffixesResolved = true;
        }
        if (suffixesResolved) {
            for (int i = suffixes.size() - 1; i >= 0; --i) {
                Element suffix = suffixes.remove(i);
                suffix.detach();
            }
        }
        if (group.getAttribute("numberOfFunctionalAtomsToRemove") != null) {
            int numberToRemove = Integer.parseInt(group.getAttributeValue("numberOfFunctionalAtomsToRemove"));
            if (numberToRemove > suffixableFragment.getFunctionalAtomCount()) {
                throw new ComponentGenerationException("Too many hydrogen for the number of positions on non carboxylic acid");
            }
            for (int i = 0; i < numberToRemove; ++i) {
                Atom functionalAtom = suffixableFragment.removeFunctionalAtom(0).getAtom();
                functionalAtom.neutraliseCharge();
            }
        }
    }

    private void applyDefaultLocantsToSuffixesIfApplicable(Element group, Fragment suffixableFragment) {
        String defaultLocantsAtrValue = group.getAttributeValue("suffixAppliesToByDefault");
        if (defaultLocantsAtrValue != null) {
            String[] suffixInstructions = defaultLocantsAtrValue.split(",");
            Element suffix = OpsinTools.getNextNonChargeSuffix(group);
            if (suffix != null) {
                ArrayList<Element> suffixes = new ArrayList<Element>();
                while (suffix != null) {
                    suffixes.add(suffix);
                    suffix = OpsinTools.getNextNonChargeSuffix(suffix);
                }
                if (suffixInstructions.length == suffixes.size()) {
                    int firstIdInFragment = suffixableFragment.getIdOfFirstAtom();
                    for (int i = 0; i < suffixInstructions.length; ++i) {
                        String suffixInstruction = suffixInstructions[i];
                        ((Element)suffixes.get(i)).addAttribute(new Attribute("defaultLocantID", Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstruction) - 1)));
                    }
                }
            }
        }
    }

    private void processSuffixAppliesTo(Element group, List<Element> suffixes, Fragment suffixableFragment) throws ComponentGenerationException {
        Element suffix = OpsinTools.getNextNonChargeSuffix(group);
        if (suffix == null) {
            if (group.getAttributeValue("type").equals("acidStem")) {
                throw new ComponentGenerationException("No suffix where suffix was expected");
            }
        } else {
            if (suffixes.size() > 1 && group.getAttributeValue("type").equals("acidStem")) {
                throw new ComponentGenerationException("More than one suffix detected on trivial polyAcid. Not believed to be allowed");
            }
            String suffixInstruction = group.getAttributeValue("suffixAppliesTo");
            String[] suffixInstructions = suffixInstruction.split(",");
            int firstIdInFragment = suffixableFragment.getIdOfFirstAtom();
            if ("cycleformer".equals(suffix.getAttributeValue("subType"))) {
                if (suffixInstructions.length != 2) {
                    throw new ComponentGenerationException("suffix: " + suffix.getValue() + " used on an inappropriate group");
                }
                String[] locantIds = new String[]{Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstructions[0]) - 1), Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstructions[1]) - 1)};
                suffix.addAttribute(new Attribute("locantID", StringTools.arrayToString(locantIds, ",")));
                return;
            }
            boolean symmetricSuffixes = true;
            if (suffix.getAttribute("additionalValue") != null) {
                if (suffixInstructions.length < 2) {
                    throw new ComponentGenerationException("suffix: " + suffix.getValue() + " used on an inappropriate group");
                }
                symmetricSuffixes = false;
            }
            if (suffix.getAttribute("locant") == null) {
                suffix.addAttribute(new Attribute("locantID", Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstructions[0]) - 1)));
            }
            for (int i = 1; i < suffixInstructions.length; ++i) {
                TokenEl newSuffix = new TokenEl("suffix");
                if (symmetricSuffixes) {
                    newSuffix.addAttribute(new Attribute("value", suffix.getAttributeValue("value")));
                    newSuffix.addAttribute(new Attribute("type", suffix.getAttributeValue("type")));
                    if (suffix.getAttribute("subType") != null) {
                        newSuffix.addAttribute(new Attribute("subType", suffix.getAttributeValue("subType")));
                    }
                    if (suffix.getAttribute("infix") != null && suffix.getAttributeValue("infix").startsWith("=")) {
                        newSuffix.addAttribute(new Attribute("infix", suffix.getAttributeValue("infix")));
                    }
                } else {
                    newSuffix.addAttribute(new Attribute("value", suffix.getAttributeValue("additionalValue")));
                    newSuffix.addAttribute(new Attribute("type", "root"));
                }
                newSuffix.addAttribute(new Attribute("locantID", Integer.toString(firstIdInFragment + Integer.parseInt(suffixInstructions[i]) - 1)));
                OpsinTools.insertAfter(suffix, newSuffix);
                suffixes.add(newSuffix);
            }
        }
    }

    private List<Fragment> resolveGroupAddingSuffixes(List<Element> suffixes, Fragment frag) throws StructureBuildingException, ComponentGenerationException {
        ArrayList<Fragment> suffixFragments = new ArrayList<Fragment>();
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixApplier.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        for (Element suffix : suffixes) {
            String suffixValue = suffix.getAttributeValue("value");
            Atom atomLikelyToBeUsedBySuffix = null;
            String locant = suffix.getAttributeValue("locant");
            String locantId = suffix.getAttributeValue("locantID");
            if (locant != null && locant.indexOf(44) == -1) {
                atomLikelyToBeUsedBySuffix = frag.getAtomByLocant(locant);
            } else if (locantId != null && locantId.indexOf(44) == -1) {
                atomLikelyToBeUsedBySuffix = frag.getAtomByIDOrThrow(Integer.parseInt(locantId));
            }
            if (atomLikelyToBeUsedBySuffix == null) {
                atomLikelyToBeUsedBySuffix = frag.getFirstAtom();
            }
            boolean cyclic = atomLikelyToBeUsedBySuffix.getAtomIsInACycle();
            List<SuffixRule> suffixRules = this.suffixApplier.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            Fragment suffixFrag = null;
            block8: for (SuffixRule suffixRule : suffixRules) {
                switch (suffixRule.getType()) {
                    case addgroup: {
                        String[] relativeIdsOfOutAtoms;
                        String outIdsAtr;
                        String labels = suffixRule.getAttributeValue("labels");
                        if (labels == null) {
                            labels = "none";
                        }
                        suffixFrag = this.state.fragManager.buildSMILES(suffixRule.getAttributeValue("SMILES"), "suffix", labels);
                        List<Atom> atomList = suffixFrag.getAtomList();
                        String functionalIdsAtr = suffixRule.getAttributeValue("functionalIDs");
                        if (functionalIdsAtr != null) {
                            String[] relativeIdsOfFunctionalAtoms;
                            for (String relativeId : relativeIdsOfFunctionalAtoms = functionalIdsAtr.split(",")) {
                                int atomIndice = Integer.parseInt(relativeId) - 1;
                                if (atomIndice >= atomList.size()) {
                                    throw new StructureBuildingException("Check suffixRules.xml: Atom requested to have a functionalAtom was not within the suffix fragment");
                                }
                                suffixFrag.addFunctionalAtom(atomList.get(atomIndice));
                            }
                        }
                        if ((outIdsAtr = suffixRule.getAttributeValue("outIDs")) == null) break;
                        for (String relativeId : relativeIdsOfOutAtoms = outIdsAtr.split(",")) {
                            int atomIndice = Integer.parseInt(relativeId) - 1;
                            if (atomIndice >= atomList.size()) {
                                throw new StructureBuildingException("Check suffixRules.xml: Atom requested to have a outAtom was not within the suffix fragment");
                            }
                            suffixFrag.addOutAtom(atomList.get(atomIndice), 1, (Boolean)true);
                        }
                        continue block8;
                    }
                    case addSuffixPrefixIfNonePresentAndCyclic: {
                        if (!cyclic || suffix.getAttribute("suffixPrefix") != null) break;
                        suffix.addAttribute(new Attribute("suffixPrefix", suffixRule.getAttributeValue("SMILES")));
                        break;
                    }
                    case addFunctionalAtomsToHydroxyGroups: {
                        if (suffixFrag != null) {
                            throw new ComponentGenerationException("addFunctionalAtomsToHydroxyGroups is not currently compatable with the addGroup suffix rule");
                        }
                        this.addFunctionalAtomsToHydroxyGroups(atomLikelyToBeUsedBySuffix);
                        break;
                    }
                    case chargeHydroxyGroups: {
                        if (suffixFrag != null) {
                            throw new ComponentGenerationException("chargeHydroxyGroups is not currently compatable with the addGroup suffix rule");
                        }
                        this.chargeHydroxyGroups(atomLikelyToBeUsedBySuffix);
                        break;
                    }
                    case removeTerminalOxygen: {
                        if (suffixFrag != null) {
                            throw new ComponentGenerationException("removeTerminalOxygen is not currently compatible with the addGroup suffix rule");
                        }
                        int bondOrder = Integer.parseInt(suffixRule.getAttributeValue("order"));
                        FragmentTools.removeTerminalOxygen(this.state, atomLikelyToBeUsedBySuffix, bondOrder);
                        break;
                    }
                }
            }
            if (suffixFrag == null) continue;
            suffixFragments.add(suffixFrag);
            suffix.setFrag(suffixFrag);
        }
        return suffixFragments;
    }

    private void processRemovalOfHydroxyGroupsRules(List<Element> suffixes, Fragment frag) throws ComponentGenerationException {
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixApplier.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        for (Element suffix : suffixes) {
            String suffixValue = suffix.getAttributeValue("value");
            List<SuffixRule> suffixRules = this.suffixApplier.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            for (SuffixRule suffixRule : suffixRules) {
                SuffixRuleType type = suffixRule.getType();
                if (type == SuffixRuleType.convertHydroxyGroupsToOutAtoms) {
                    this.convertHydroxyGroupsToOutAtoms(frag);
                    continue;
                }
                if (type != SuffixRuleType.convertHydroxyGroupsToPositiveCharge) continue;
                this.convertHydroxyGroupsToPositiveCharge(frag);
            }
        }
    }

    private void addFunctionalAtomsToHydroxyGroups(Atom atom) throws StructureBuildingException {
        List<Atom> neighbours = atom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement() != ChemEl.O || neighbour.getCharge() != 0 || neighbour.getBondCount() != 1 || atom.getBondToAtomOrThrow(neighbour).getOrder() != 1) continue;
            neighbour.getFrag().addFunctionalAtom(neighbour);
        }
    }

    private void chargeHydroxyGroups(Atom atom) throws StructureBuildingException {
        List<Atom> neighbours = atom.getAtomNeighbours();
        for (Atom neighbour : neighbours) {
            if (neighbour.getElement() != ChemEl.O || neighbour.getCharge() != 0 || neighbour.getBondCount() != 1 || atom.getBondToAtomOrThrow(neighbour).getOrder() != 1) continue;
            neighbour.addChargeAndProtons(-1, -1);
        }
    }

    private void convertHydroxyGroupsToOutAtoms(Fragment frag) {
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            Atom adjacentAtom;
            if (atom.getElement() != ChemEl.O || atom.getCharge() != 0 || atom.getBondCount() != 1 || atom.getFirstBond().getOrder() != 1 || atom.getOutValency() != 0 || (adjacentAtom = atom.getAtomNeighbours().get(0)).getElement() == ChemEl.O) continue;
            this.state.fragManager.removeAtomAndAssociatedBonds(atom);
            frag.addOutAtom(adjacentAtom, 1, (Boolean)true);
        }
    }

    private void convertHydroxyGroupsToPositiveCharge(Fragment frag) {
        List<Atom> atomList = frag.getAtomList();
        for (Atom atom : atomList) {
            Atom adjacentAtom;
            if (atom.getElement() != ChemEl.O || atom.getCharge() != 0 || atom.getBondCount() != 1 || atom.getFirstBond().getOrder() != 1 || atom.getOutValency() != 0 || (adjacentAtom = atom.getAtomNeighbours().get(0)).getElement() == ChemEl.O) continue;
            this.state.fragManager.removeAtomAndAssociatedBonds(atom);
            adjacentAtom.addChargeAndProtons(1, -1);
        }
    }

    private void processSuffixPrefixes(List<Element> suffixes) throws StructureBuildingException {
        for (Element suffix : suffixes) {
            if (suffix.getAttribute("suffixPrefix") == null) continue;
            Fragment suffixPrefixFrag = this.state.fragManager.buildSMILES(suffix.getAttributeValue("suffixPrefix"), "suffix", "none");
            this.addFunctionalAtomsToHydroxyGroups(suffixPrefixFrag.getFirstAtom());
            if (suffix.getValue().endsWith("ate") || suffix.getValue().endsWith("at")) {
                this.chargeHydroxyGroups(suffixPrefixFrag.getFirstAtom());
            }
            Atom firstAtomOfPrefix = suffixPrefixFrag.getFirstAtom();
            firstAtomOfPrefix.addLocant("X");
            Fragment suffixFrag = suffix.getFrag();
            this.state.fragManager.incorporateFragment(suffixPrefixFrag, suffixFrag);
            Atom theR = suffixFrag.getFirstAtom();
            List<Atom> neighbours = theR.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                Bond b = theR.getBondToAtomOrThrow(neighbour);
                this.state.fragManager.removeBond(b);
                this.state.fragManager.createBond(neighbour, firstAtomOfPrefix, b.getOrder());
            }
            this.state.fragManager.createBond(firstAtomOfPrefix, theR, 1);
        }
    }

    static boolean checkLocantPresentOnPotentialRoot(BuildState state, Element startingElement, String locant) throws StructureBuildingException {
        List<Element> conjunctiveGroups;
        List<Fragment> suffixes;
        Fragment groupFrag;
        Element group;
        int indexOfCurrentElement;
        List<Element> siblings;
        Element parent;
        Element currentElement;
        boolean foundSibling = false;
        ArrayDeque<Element> s = new ArrayDeque<Element>();
        s.add(startingElement);
        boolean doneFirstIteration = false;
        while (s.size() > 0) {
            currentElement = (Element)s.removeLast();
            parent = currentElement.getParent();
            siblings = OpsinTools.getChildElementsWithTagNames(parent, new String[]{"bracket", "substituent", "root"});
            indexOfCurrentElement = parent.indexOf(currentElement);
            for (Element bracketOrSub : siblings) {
                if (!doneFirstIteration && parent.indexOf(bracketOrSub) <= indexOfCurrentElement) continue;
                if (bracketOrSub.getName().equals("bracket")) {
                    if (bracketOrSub.getAttribute("type") == null) continue;
                    s.add(bracketOrSub.getChild(0));
                } else {
                    group = bracketOrSub.getFirstChildElement("group");
                    groupFrag = group.getFrag();
                    if (groupFrag.hasLocant(locant)) {
                        return true;
                    }
                    suffixes = state.xmlSuffixMap.get(group);
                    if (suffixes != null) {
                        for (Fragment fragment : suffixes) {
                            if (!fragment.hasLocant(locant)) continue;
                            return true;
                        }
                    }
                    conjunctiveGroups = OpsinTools.getNextSiblingsOfType(group, "conjunctiveSuffixGroup");
                    for (Element conjunctiveGroup : conjunctiveGroups) {
                        if (!conjunctiveGroup.getFrag().hasLocant(locant)) continue;
                        return true;
                    }
                }
                foundSibling = true;
            }
            doneFirstIteration = true;
        }
        if (!foundSibling) {
            s = new ArrayDeque();
            s.add(startingElement);
            doneFirstIteration = false;
            while (s.size() > 0) {
                currentElement = (Element)s.removeLast();
                parent = currentElement.getParent();
                siblings = OpsinTools.getChildElementsWithTagNames(parent, new String[]{"bracket", "substituent", "root"});
                indexOfCurrentElement = parent.indexOf(currentElement);
                for (Element bracketOrSub : siblings) {
                    if (!doneFirstIteration && parent.indexOf(bracketOrSub) <= indexOfCurrentElement) continue;
                    if (bracketOrSub.getName().equals("bracket")) {
                        s.add(bracketOrSub.getChild(0));
                        continue;
                    }
                    group = bracketOrSub.getFirstChildElement("group");
                    groupFrag = group.getFrag();
                    if (groupFrag.hasLocant(locant)) {
                        return true;
                    }
                    suffixes = state.xmlSuffixMap.get(group);
                    if (suffixes != null) {
                        for (Fragment fragment : suffixes) {
                            if (!fragment.hasLocant(locant)) continue;
                            return true;
                        }
                    }
                    conjunctiveGroups = OpsinTools.getNextSiblingsOfType(group, "conjunctiveSuffixGroup");
                    for (Element conjunctiveGroup : conjunctiveGroups) {
                        if (!conjunctiveGroup.getFrag().hasLocant(locant)) continue;
                        return true;
                    }
                }
                doneFirstIteration = true;
            }
        }
        return false;
    }

    private void handleGroupIrregularities(List<Element> groups) throws StructureBuildingException, ComponentGenerationException {
        for (Element group : groups) {
            Element suffixAfterGroup;
            Element previousGroup;
            List<Element> previousSubstGroups;
            Element previousSubstituent;
            Fragment frag;
            int chainLength;
            Element prev2;
            Element previous;
            String groupValue = group.getValue();
            if (groupValue.equals("porphyrin") || groupValue.equals("porphin")) {
                List<Element> hydrogenAddingEls = group.getParent().getChildElements("indicatedHydrogen");
                boolean implicitHydrogenExplicitlySet = false;
                for (Element hydrogenAddingEl : hydrogenAddingEls) {
                    String locant = hydrogenAddingEl.getAttributeValue("locant");
                    if (locant == null || !locant.equals("21") && !locant.equals("22") && !locant.equals("23") && !locant.equals("24")) continue;
                    implicitHydrogenExplicitlySet = true;
                }
                if (!implicitHydrogenExplicitlySet) {
                    Fragment frag2 = group.getFrag();
                    frag2.getAtomByLocantOrThrow("21").setSpareValency(false);
                    frag2.getAtomByLocantOrThrow("23").setSpareValency(false);
                }
            } else if (groupValue.equals("xanthate") || groupValue.equals("xanthat") || groupValue.equals("xanthic acid") || groupValue.equals("xanthicacid")) {
                Element wordRule = OpsinTools.getParentWordRule(group);
                if (wordRule.getAttributeValue("wordRule").equals(WordRule.simple.toString()) && OpsinTools.getDescendantElementsWithTagName(wordRule, "substituent").isEmpty()) {
                    throw new ComponentGenerationException(groupValue + " describes a class of compounds rather than a particular compound");
                }
            } else if ((groupValue.equals("adenosin") || groupValue.equals("cytidin") || groupValue.equals("guanosin") || groupValue.equals("inosin") || groupValue.equals("uridin") || groupValue.equals("xanthosin")) && (previous = OpsinTools.getPreviousSibling(group)) != null && previous.getName().equals("subtractivePrefix") && previous.getAttributeValue("type").equals("deoxy") && previous.getAttributeValue("value").equals("O") && previous.getAttribute("locant") == null && ((prev2 = OpsinTools.getPrevious(previous)) == null || !prev2.getName().equals("subtractivePrefix"))) {
                Fragment frag3 = group.getFrag();
                StructureBuildingMethods.applySubtractivePrefix(this.state, frag3, ChemEl.O, "2'");
                previous.detach();
            }
            if (!"yes".equals(group.getAttributeValue("usableAsAJoiner")) || group.getAttribute("defaultInID") != null || group.getAttribute("defaultInLocant") != null || (chainLength = (frag = group.getFrag()).getChainLength()) <= 1) continue;
            boolean connectEndToEndWithPreviousSub = true;
            if (group.getAttributeValue("type").equals("chain") && "alkaneStem".equals(group.getAttributeValue("subType")) && (previousSubstituent = OpsinTools.getPreviousSibling(group.getParent())) != null && (previousSubstGroups = previousSubstituent.getChildElements("group")).size() == 1 && (previousGroup = previousSubstGroups.get(0)).getAttributeValue("type").equals("chain") && "alkaneStem".equals(previousGroup.getAttributeValue("subType")) && ((suffixAfterGroup = OpsinTools.getNextSibling(previousGroup, "suffix")) == null || suffixAfterGroup.getFrag() == null || suffixAfterGroup.getFrag().getOutAtomCount() == 0)) {
                connectEndToEndWithPreviousSub = false;
            }
            if (!connectEndToEndWithPreviousSub) continue;
            Element parent = group.getParent();
            while (parent.getName().equals("bracket")) {
                parent = parent.getParent();
            }
            if (parent.getName().equals("root")) continue;
            group.addAttribute(new Attribute("defaultInID", Integer.toString(chainLength)));
            frag.setDefaultInAtom(frag.getAtomByLocantOrThrow(Integer.toString(chainLength)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processHW(Element subOrRoot) throws StructureBuildingException, ComponentGenerationException {
        List<Element> hwGroups = OpsinTools.getChildElementsWithTagNameAndAttribute(subOrRoot, "group", "subType", "hantzschWidman");
        for (Element group : hwGroups) {
            Element possibleBenzo;
            String[] specialRingInformation;
            Matcher m;
            Fragment hwRing = group.getFrag();
            List<Atom> atomList = hwRing.getAtomList();
            boolean noLocants = true;
            ArrayList<Element> prevs = new ArrayList<Element>();
            Element prev = OpsinTools.getPreviousSibling(group);
            while (prev != null && prev.getName().equals("heteroatom")) {
                prevs.add(prev);
                if (prev.getAttribute("locant") != null) {
                    noLocants = false;
                }
                prev = OpsinTools.getPreviousSibling(prev);
            }
            Collections.reverse(prevs);
            ArrayList<Element> heteroatomsToProcess = prevs;
            if (atomList.size() == 6 && group.getValue().equals("an")) {
                boolean hasNitrogen = false;
                boolean hasSiorGeorSnorPb = false;
                boolean saturatedRing = true;
                for (Element element : heteroatomsToProcess) {
                    String heteroAtomElement = element.getAttributeValue("value");
                    m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(heteroAtomElement);
                    if (!m.find()) {
                        throw new ComponentGenerationException("Failed to extract element from Hantzsch-Widman heteroatom");
                    }
                    heteroAtomElement = m.group();
                    if (heteroAtomElement.equals("N")) {
                        hasNitrogen = true;
                    }
                    if (!heteroAtomElement.equals("Si") && !heteroAtomElement.equals("Ge") && !heteroAtomElement.equals("Sn") && !heteroAtomElement.equals("Pb")) continue;
                    hasSiorGeorSnorPb = true;
                }
                for (Atom atom : atomList) {
                    if (!atom.hasSpareValency()) continue;
                    saturatedRing = false;
                }
                if (saturatedRing && !hasNitrogen && hasSiorGeorSnorPb) {
                    throw new ComponentGenerationException("Blocked Hantzsch-Widman system (6 member saturated ring with no nitrogen but has Si/Ge/Sn/Pb)");
                }
            }
            StringBuilder nameSB = new StringBuilder();
            for (Element heteroatom : heteroatomsToProcess) {
                String hetValue = heteroatom.getValue();
                if (hetValue.endsWith("a")) {
                    nameSB.append(hetValue.substring(0, hetValue.length() - 1));
                    continue;
                }
                nameSB.append(hetValue);
            }
            nameSB.append(group.getValue());
            String name = nameSB.toString();
            group.setValue(name);
            if (noLocants && heteroatomsToProcess.size() > 0 && (specialRingInformation = specialHWRings.get(name)) != null) {
                void var15_29;
                String specialInstruction = specialRingInformation[0];
                if (!specialInstruction.equals("")) {
                    if (specialInstruction.equals("blocked")) {
                        throw new ComponentGenerationException("Blocked Hantzsch-Widman system");
                    }
                    if (specialInstruction.equals("saturated")) {
                        for (Atom a : atomList) {
                            a.setSpareValency(false);
                        }
                    } else if (specialInstruction.equals("not_icacid")) {
                        Element element;
                        if (group.getAttribute("subsequentUnsemanticToken") == null && (element = OpsinTools.getNextSibling(group)) != null && element.getName().equals("suffix") && element.getAttribute("locant") == null && element.getAttributeValue("value").equals("ic")) {
                            throw new ComponentGenerationException(name + element.getValue() + " appears to be a generic class name, not a Hantzsch-Widman ring");
                        }
                    } else if (specialInstruction.equals("not_nothingOrOlate")) {
                        Element element;
                        if (group.getAttribute("subsequentUnsemanticToken") == null && ((element = OpsinTools.getNextSibling(group)) == null || element != null && element.getName().equals("suffix") && element.getAttribute("locant") == null && element.getAttributeValue("value").equals("ate"))) {
                            throw new ComponentGenerationException(name + " has the syntax for a Hantzsch-Widman ring but probably does not mean that in this context");
                        }
                    } else {
                        throw new ComponentGenerationException("OPSIN Bug: Unrecognised special Hantzsch-Widman ring instruction");
                    }
                }
                boolean bl = true;
                while (var15_29 < specialRingInformation.length) {
                    Atom a;
                    a = hwRing.getAtomByLocantOrThrow(Integer.toString((int)var15_29));
                    a.setElement(ChemEl.valueOf(specialRingInformation[var15_29]));
                    ++var15_29;
                }
                for (Element p : heteroatomsToProcess) {
                    p.detach();
                }
                heteroatomsToProcess.clear();
            }
            Iterator it = heteroatomsToProcess.iterator();
            while (it.hasNext()) {
                Element heteroatom = (Element)it.next();
                String string = heteroatom.getAttributeValue("locant");
                if (string == null) continue;
                String elementReplacement = heteroatom.getAttributeValue("value");
                m = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(elementReplacement);
                if (!m.find()) {
                    throw new ComponentGenerationException("Failed to extract element from Hantzsch-Widman heteroatom");
                }
                elementReplacement = m.group();
                Atom a = hwRing.getAtomByLocantOrThrow(string);
                a.setElement(ChemEl.valueOf(elementReplacement));
                if (heteroatom.getAttribute("lambda") != null) {
                    a.setLambdaConventionValency(Integer.parseInt(heteroatom.getAttributeValue("lambda")));
                }
                heteroatom.detach();
                it.remove();
            }
            List<Element> deltaEls = subOrRoot.getChildElements("delta");
            for (Element element : deltaEls) {
                String locantOfDoubleBond = element.getValue();
                if (locantOfDoubleBond.equals("")) {
                    TokenEl newUnsaturator = new TokenEl("unsaturator");
                    newUnsaturator.addAttribute(new Attribute("value", "2"));
                    OpsinTools.insertAfter(group, newUnsaturator);
                } else {
                    Atom firstInDoubleBond = hwRing.getAtomByLocantOrThrow(locantOfDoubleBond);
                    FragmentTools.unsaturate(firstInDoubleBond, 2, hwRing);
                }
                element.detach();
            }
            int hetAtomsToProcess = heteroatomsToProcess.size();
            if (hetAtomsToProcess <= 0) continue;
            ArrayList<Atom> arrayList = new ArrayList<Atom>();
            for (Atom atom : atomList) {
                if (atom.getElement() != ChemEl.C) continue;
                arrayList.add(atom);
            }
            if (!(hetAtomsToProcess <= 1 || hetAtomsToProcess >= arrayList.size() - 1 || (possibleBenzo = OpsinTools.getPreviousSibling(group, "group")) != null && (possibleBenzo.getValue().equals("benz") || possibleBenzo.getValue().equals("benzo")) || "o".equals(group.getAttributeValue("subsequentUnsemanticToken")))) {
                this.state.addIsAmbiguous("Heteroatom positioning in the Hantzsch-Widman name " + name);
            }
            if (hetAtomsToProcess > arrayList.size()) {
                throw new StructureBuildingException(hetAtomsToProcess + " heteroatoms were specified for a Hantzsch-Widman ring with only " + arrayList.size() + " atoms");
            }
            for (int i = 0; i < hetAtomsToProcess; ++i) {
                Element heteroatom = (Element)heteroatomsToProcess.get(i);
                String elementReplacement = heteroatom.getAttributeValue("value");
                Matcher m2 = OpsinTools.MATCH_ELEMENT_SYMBOL.matcher(elementReplacement);
                if (!m2.find()) {
                    throw new ComponentGenerationException("Failed to extract element from Hantzsch-Widman heteroatom");
                }
                elementReplacement = m2.group();
                Atom a = (Atom)arrayList.get(i);
                a.setElement(ChemEl.valueOf(elementReplacement));
                if (heteroatom.getAttribute("lambda") != null) {
                    a.setLambdaConventionValency(Integer.parseInt(heteroatom.getAttributeValue("lambda")));
                }
                heteroatom.detach();
            }
        }
    }

    private void assignElementSymbolLocants(Element subOrRoot) throws StructureBuildingException {
        List<Element> groups = subOrRoot.getChildElements("group");
        Element lastGroupElementInSubOrRoot = groups.get(groups.size() - 1);
        ArrayList<Fragment> suffixFragments = new ArrayList<Fragment>((Collection)this.state.xmlSuffixMap.get(lastGroupElementInSubOrRoot));
        Fragment suffixableFragment = lastGroupElementInSubOrRoot.getFrag();
        List<Element> conjunctiveGroups = subOrRoot.getChildElements("conjunctiveSuffixGroup");
        for (Element group : conjunctiveGroups) {
            suffixFragments.add(group.getFrag());
        }
        FragmentTools.assignElementLocants(suffixableFragment, suffixFragments);
        for (int i = groups.size() - 2; i >= 0; --i) {
            FragmentTools.assignElementLocants(groups.get(i).getFrag(), new ArrayList<Fragment>());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processRingAssemblies(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        ringAssemblyMultipliers = subOrRoot.getChildElements("ringAssemblyMultiplier");
        for (Element multiplier : ringAssemblyMultipliers) {
            mvalue = Integer.parseInt(multiplier.getAttributeValue("value"));
            ringJoiningLocants = new ArrayList<Object>();
            potentialLocant = OpsinTools.getPreviousSibling(multiplier);
            group = OpsinTools.getNextSibling(multiplier, "group");
            if (potentialLocant != null && (potentialLocant.getName().equals("colonOrSemiColonDelimitedLocant") || potentialLocant.getName().equals("locant"))) {
                if ("orthoMetaPara".equals(potentialLocant.getAttributeValue("type"))) {
                    locant2 = potentialLocant.getValue();
                    locant1 = "1";
                    locantArrayList = new ArrayList();
                    locantArrayList.add("1");
                    locantArrayList.add("1'");
                    ringJoiningLocants.add(locantArrayList);
                    for (i = 1; i < mvalue - 1; ++i) {
                        locantArrayList = new ArrayList<E>();
                        locantArrayList.add(locant2 + StringTools.multiplyString("'", i));
                        locantArrayList.add(locant1 + StringTools.multiplyString("'", i + 1));
                        ringJoiningLocants.add(locantArrayList);
                    }
                    potentialLocant.detach();
                } else {
                    locantText = StringTools.removeDashIfPresent(potentialLocant.getValue());
                    perRingLocantArray = OpsinTools.MATCH_COLONORSEMICOLON.split(locantText);
                    if (perRingLocantArray.length != mvalue - 1) {
                        throw new ComponentGenerationException("Disagreement between number of locants(" + locantText + ") and ring assembly multiplier: " + mvalue);
                    }
                    if (perRingLocantArray.length != 1 || perRingLocantArray[0].split(",").length != 1) {
                        for (String ringLocantArray : perRingLocantArray) {
                            locantArray = ringLocantArray.split(",");
                            if (locantArray.length != 2) {
                                throw new ComponentGenerationException("missing locant, expected 2 locants: " + ringLocantArray);
                            }
                            ringJoiningLocants.add(Arrays.asList(locantArray));
                        }
                        potentialLocant.detach();
                    }
                }
            }
            fragmentToResolveAndDuplicate = group.getFrag();
            nextEl = OpsinTools.getNextSibling(multiplier);
            if (nextEl.getName().equals("structuralOpenBracket")) {
                elementToResolve = new GroupingEl("substituent");
                currentEl = nextEl;
                nextEl = OpsinTools.getNextSibling(currentEl);
                currentEl.detach();
                while (nextEl != null && !nextEl.getName().equals("structuralCloseBracket")) {
                    currentEl = nextEl;
                    nextEl = OpsinTools.getNextSibling(currentEl);
                    currentEl.detach();
                    elementToResolve.addChild(currentEl);
                }
                if (nextEl != null) {
                    nextEl.detach();
                }
            } else {
                elementToResolve = this.determineElementsToResolveIntoRingAssembly(multiplier, ringJoiningLocants.size(), fragmentToResolveAndDuplicate.getOutAtomCount());
            }
            suffixes = elementToResolve.getChildElements("suffix");
            this.suffixApplier.resolveSuffixes(group, suffixes);
            bondOrder = 1;
            if (fragmentToResolveAndDuplicate.getOutAtomCount() > 1) {
                throw new StructureBuildingException("Ring assembly fragment should have one or no OutAtoms; not more than one!");
            }
            if (fragmentToResolveAndDuplicate.getOutAtomCount() == 1) {
                bondOrder = fragmentToResolveAndDuplicate.getOutAtom(0).getValency();
            }
            v0 = twoRingsJoinedUsingSuffixPosition = ringJoiningLocants.isEmpty() != false && mvalue == 2 && fragmentToResolveAndDuplicate.getOutAtomCount() == 1;
            if (!twoRingsJoinedUsingSuffixPosition && fragmentToResolveAndDuplicate.getOutAtomCount() == 1) {
                fragmentToResolveAndDuplicate.removeOutAtom(0);
            }
            StructureBuildingMethods.resolveLocantedFeatures(this.state, elementToResolve);
            StructureBuildingMethods.resolveUnLocantedFeatures(this.state, elementToResolve);
            group.detach();
            OpsinTools.insertAfter(multiplier, group);
            if (twoRingsJoinedUsingSuffixPosition) {
                clone = this.state.fragManager.copyAndRelabelFragment(fragmentToResolveAndDuplicate, 1);
                atomOnParent = fragmentToResolveAndDuplicate.getOutAtom(0).getAtom();
                atomOnClone = clone.getOutAtom(0).getAtom();
                fragmentToResolveAndDuplicate.removeOutAtom(0);
                clone.removeOutAtom(0);
                this.state.fragManager.incorporateFragment(clone, atomOnClone, fragmentToResolveAndDuplicate, atomOnParent, bondOrder);
            } else {
                clonedFragments = new ArrayList<Fragment>();
                for (j = 1; j < mvalue; ++j) {
                    clonedFragments.add(this.state.fragManager.copyAndRelabelFragment(fragmentToResolveAndDuplicate, j));
                }
                lastRingUnlocantedBondedTo = null;
                for (i = 0; i < mvalue - 1; ++i) {
                    clone = (Fragment)clonedFragments.get(i);
                    if (ringJoiningLocants.size() > 0) {
                        atomOnParent = fragmentToResolveAndDuplicate.getAtomByLocantOrThrow((String)((List)ringJoiningLocants.get(i)).get(0));
                        secondLocant = (String)((List)ringJoiningLocants.get(i)).get(1);
                        if (mvalue == 2 && !secondLocant.endsWith("'")) {
                            try {
                                atomOnLatestClone = clone.getAtomByLocantOrThrow(secondLocant);
                            }
                            catch (StructureBuildingException e) {
                                atomOnLatestClone = clone.getAtomByLocant(secondLocant + "'");
                                if (atomOnLatestClone != null) ** GOTO lbl113
                                throw e;
                            }
                        } else {
                            atomOnLatestClone = clone.getAtomByLocantOrThrow(secondLocant);
                        }
                    } else {
                        potentialAtomsOnParent = lastRingUnlocantedBondedTo == null ? FragmentTools.findSubstituableAtoms(fragmentToResolveAndDuplicate, bondOrder) : FragmentTools.findSubstituableAtoms(lastRingUnlocantedBondedTo, bondOrder);
                        potentialAtomsOnClone = FragmentTools.findSubstituableAtoms(clone, bondOrder);
                        if (potentialAtomsOnParent.isEmpty() || potentialAtomsOnClone.isEmpty()) {
                            throw new StructureBuildingException("Unable to find suitable atom for unlocanted ring assembly construction");
                        }
                        if (AmbiguityChecker.isSubstitutionAmbiguous(potentialAtomsOnParent, 1)) {
                            this.state.addIsAmbiguous("Choice of atoms to form ring assembly: " + group.getValue());
                        }
                        if (AmbiguityChecker.isSubstitutionAmbiguous(potentialAtomsOnClone, 1)) {
                            this.state.addIsAmbiguous("Choice of atoms to form ring assembly: " + group.getValue());
                        }
                        atomOnParent = potentialAtomsOnParent.get(0);
                        atomOnLatestClone = potentialAtomsOnClone.get(0);
                        lastRingUnlocantedBondedTo = clone;
                    }
lbl113:
                    // 4 sources

                    this.state.fragManager.incorporateFragment(clone, atomOnLatestClone, fragmentToResolveAndDuplicate, atomOnParent, bondOrder);
                }
            }
            group.setValue(multiplier.getValue() + group.getValue());
            possibleOpenStructuralBracket = OpsinTools.getPreviousSibling(multiplier);
            if (possibleOpenStructuralBracket != null && possibleOpenStructuralBracket.getName().equals("structuralOpenBracket")) {
                OpsinTools.getNextSibling(possibleOpenStructuralBracket, "structuralCloseBracket").detach();
                possibleOpenStructuralBracket.detach();
            }
            multiplier.detach();
        }
    }

    private Element determineElementsToResolveIntoRingAssembly(Element multiplier, int ringJoiningLocants, int outAtomCount) throws ComponentGenerationException {
        Element parent;
        GroupingEl elementToResolve = new GroupingEl("substituent");
        boolean groupFound = false;
        boolean inlineSuffixSeen = outAtomCount > 0;
        Element currentEl = OpsinTools.getNextSibling(multiplier);
        while (currentEl != null) {
            Element nextEl = OpsinTools.getNextSibling(currentEl);
            if (!groupFound) {
                currentEl.detach();
                ((Element)elementToResolve).addChild(currentEl);
                if (currentEl.getName().equals("group")) {
                    groupFound = true;
                }
            } else if (currentEl.getName().equals("suffix")) {
                String suffixType = currentEl.getAttributeValue("type");
                if (suffixType.equals("charge") && currentEl.getAttribute("locant") == null) {
                    currentEl.detach();
                    ((Element)elementToResolve).addChild(currentEl);
                } else {
                    if (inlineSuffixSeen || !suffixType.equals("inline") || currentEl.getAttributeValue("multiplied") != null || currentEl.getAttribute("locant") != null && (!"2".equals(multiplier.getAttributeValue("value")) || ringJoiningLocants != 0) || currentEl.getFrag() != null) break;
                    inlineSuffixSeen = true;
                    currentEl.detach();
                    ((Element)elementToResolve).addChild(currentEl);
                }
            } else {
                if (!currentEl.getName().equals("unsaturator") || currentEl.getAttribute("locant") != null) break;
                currentEl.detach();
                ((Element)elementToResolve).addChild(currentEl);
            }
            currentEl = nextEl;
        }
        if (!(parent = multiplier.getParent()).getName().equals("substituent") && OpsinTools.getChildElementsWithTagNameAndAttribute(parent, "suffix", "type", "inline").size() > 0) {
            throw new ComponentGenerationException("Unexpected radical adding suffix on ring assembly");
        }
        return elementToResolve;
    }

    private void processPolyCyclicSpiroNomenclature(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        List<Element> polyCyclicSpiros = subOrRoot.getChildElements("polyCyclicSpiro");
        if (polyCyclicSpiros.size() > 0) {
            Element polyCyclicSpiroDescriptor = polyCyclicSpiros.get(0);
            String value = polyCyclicSpiroDescriptor.getAttributeValue("value");
            if (value.equals("spiro")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processNonIdenticalPolyCyclicSpiro(polyCyclicSpiroDescriptor);
            } else if (value.equals("spiroOldMethod")) {
                this.processOldMethodPolyCyclicSpiro(polyCyclicSpiros);
            } else if (value.equals("spirobi")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processSpiroBiOrTer(polyCyclicSpiroDescriptor, 2);
            } else if (value.equals("spiroter")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processSpiroBiOrTer(polyCyclicSpiroDescriptor, 3);
            } else if (value.equals("dispiroter")) {
                if (polyCyclicSpiros.size() != 1) {
                    throw new ComponentGenerationException("Nested polyspiro systems are not supported");
                }
                this.processDispiroter(polyCyclicSpiroDescriptor);
            } else {
                throw new ComponentGenerationException("Unsupported spiro system encountered");
            }
            polyCyclicSpiroDescriptor.detach();
        }
    }

    private void processNonIdenticalPolyCyclicSpiro(Element polyCyclicSpiroDescriptor) throws ComponentGenerationException, StructureBuildingException {
        Element expectedMultiplier;
        Element subOrRoot = polyCyclicSpiroDescriptor.getParent();
        Element openBracket = OpsinTools.getNextSibling(polyCyclicSpiroDescriptor);
        if (!openBracket.getName().equals("structuralOpenBracket")) {
            throw new ComponentGenerationException("OPSIN Bug: Open bracket not found where open bracket expeced");
        }
        List<Element> spiroBracketElements = OpsinTools.getSiblingsUpToElementWithTagName(openBracket, "structuralCloseBracket");
        Element closeBracket = OpsinTools.getNextSibling(spiroBracketElements.get(spiroBracketElements.size() - 1));
        if (closeBracket == null || !closeBracket.getName().equals("structuralCloseBracket")) {
            throw new ComponentGenerationException("OPSIN Bug: Open bracket not found where open bracket expeced");
        }
        ArrayList<Element> groups = new ArrayList<Element>();
        for (Element spiroBracketElement : spiroBracketElements) {
            Matcher m2;
            String name = spiroBracketElement.getName();
            if (name.equals("group")) {
                groups.add(spiroBracketElement);
                continue;
            }
            if (!name.equals("spiroLocant")) continue;
            Element spiroLocant = spiroBracketElement;
            String[] locants = StringTools.removeDashIfPresent(spiroLocant.getValue()).split(",");
            if (locants.length != 2) {
                throw new ComponentGenerationException("Incorrect number of locants found before component of polycyclic spiro system");
            }
            boolean changed = false;
            Matcher m1 = matchAddedHydrogenBracket.matcher(locants[0]);
            if (m1.find()) {
                TokenEl addedHydrogenElement = new TokenEl("addedHydrogen");
                String addedHydrogenLocant = m1.group(1);
                int primes = StringTools.countTerminalPrimes(addedHydrogenLocant);
                if (primes > 0 && primes == groups.size() - 1) {
                    addedHydrogenLocant = addedHydrogenLocant.substring(0, addedHydrogenLocant.length() - primes);
                }
                addedHydrogenElement.addAttribute(new Attribute("locant", addedHydrogenLocant));
                OpsinTools.insertBefore(spiroLocant, addedHydrogenElement);
                locants[0] = m1.replaceAll("");
                changed = true;
            }
            if ((m2 = matchAddedHydrogenBracket.matcher(locants[1])).find()) {
                TokenEl addedHydrogenElement = new TokenEl("addedHydrogen");
                String addedHydrogenLocant = m2.group(1);
                int primes = StringTools.countTerminalPrimes(addedHydrogenLocant);
                if (primes > 0 && primes == groups.size()) {
                    addedHydrogenLocant = addedHydrogenLocant.substring(0, addedHydrogenLocant.length() - primes);
                }
                addedHydrogenElement.addAttribute(new Attribute("locant", addedHydrogenLocant));
                OpsinTools.insertAfter(spiroLocant, addedHydrogenElement);
                locants[1] = m2.replaceAll("");
                changed = true;
            }
            if (changed) {
                spiroLocant.addAttribute(new Attribute("type", "addedHydrogenLocant"));
            }
            spiroLocant.setValue(StringTools.arrayToString(locants, ","));
        }
        int groupCount = groups.size();
        if (groupCount < 2) {
            throw new ComponentGenerationException("OPSIN Bug: Atleast two groups were expected in polycyclic spiro system");
        }
        Element firstGroup = (Element)groups.get(0);
        ArrayList<Element> firstGroupEls = new ArrayList<Element>();
        int indexOfOpenBracket = subOrRoot.indexOf(openBracket);
        Element firstSpiroLocant = OpsinTools.getNextSibling(firstGroup, "spiroLocant");
        if (firstSpiroLocant == null) {
            throw new ComponentGenerationException("Unable to find spiroLocant for polycyclic spiro system");
        }
        int indexOfFirstSpiroLocant = subOrRoot.indexOf(firstSpiroLocant);
        for (int i = indexOfOpenBracket + 1; i < indexOfFirstSpiroLocant; ++i) {
            firstGroupEls.add(subOrRoot.getChild(i));
        }
        this.resolveFeaturesOntoGroup(firstGroupEls);
        HashSet<Atom> spiroAtoms = new HashSet<Atom>();
        for (int i = 1; i < groupCount; ++i) {
            Element nextGroup = (Element)groups.get(i);
            Element spiroLocant = OpsinTools.getNextSibling((Element)groups.get(i - 1), "spiroLocant");
            if (spiroLocant == null) {
                throw new ComponentGenerationException("Unable to find spiroLocant for polycyclic spiro system");
            }
            String[] locants = spiroLocant.getValue().split(",");
            locants[0] = OpsinTools.fixLocantCapitalisation(locants[0]);
            locants[1] = OpsinTools.fixLocantCapitalisation(locants[1]);
            ArrayList<Element> nextGroupEls = new ArrayList<Element>();
            int indexOfLocant = subOrRoot.indexOf(spiroLocant);
            int indexOfNextSpiroLocantOrEndOfSpiro = subOrRoot.indexOf(i + 1 < groupCount ? OpsinTools.getNextSibling(nextGroup, "spiroLocant") : OpsinTools.getNextSibling(nextGroup, "structuralCloseBracket"));
            for (int j = indexOfLocant + 1; j < indexOfNextSpiroLocantOrEndOfSpiro; ++j) {
                nextGroupEls.add(subOrRoot.getChild(j));
            }
            this.resolveFeaturesOntoGroup(nextGroupEls);
            spiroLocant.detach();
            Fragment nextFragment = nextGroup.getFrag();
            FragmentTools.relabelNumericLocants(nextFragment.getAtomList(), StringTools.multiplyString("'", i));
            String secondLocant = locants[1];
            Atom atomOnNextFragment = secondLocant.endsWith("'") ? nextFragment.getAtomByLocantOrThrow(locants[1]) : nextFragment.getAtomByLocantOrThrow(locants[1] + "'");
            Atom atomToBeReplaced = null;
            for (int j = 0; j < i && (atomToBeReplaced = ((Element)groups.get(j)).getFrag().getAtomByLocant(locants[0])) == null; ++j) {
            }
            if (atomToBeReplaced == null) {
                throw new ComponentGenerationException("Could not find the atom with locant " + locants[0] + " for use in polycyclic spiro system");
            }
            spiroAtoms.add(atomToBeReplaced);
            if (atomToBeReplaced.getElement() != atomOnNextFragment.getElement()) {
                if (atomToBeReplaced.getElement() != ChemEl.C && atomOnNextFragment.getElement() == ChemEl.C) {
                    atomOnNextFragment.setElement(atomToBeReplaced.getElement());
                } else if (atomToBeReplaced.getElement() != ChemEl.C && atomOnNextFragment.getElement() != ChemEl.C) {
                    throw new ComponentGenerationException("Disagreement between which element the spiro atom should be: " + (Object)((Object)atomToBeReplaced.getElement()) + " and " + (Object)((Object)atomOnNextFragment.getElement()));
                }
            }
            if (atomToBeReplaced.hasSpareValency()) {
                atomOnNextFragment.setSpareValency(true);
            }
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnNextFragment);
        }
        if (spiroAtoms.size() > 1 && (expectedMultiplier = OpsinTools.getPreviousSibling(polyCyclicSpiroDescriptor)) != null && expectedMultiplier.getName().equals("multiplier") && Integer.parseInt(expectedMultiplier.getAttributeValue("value")) == spiroAtoms.size()) {
            expectedMultiplier.detach();
        }
        Element rootGroup = (Element)groups.get(groupCount - 1);
        Fragment rootFrag = rootGroup.getFrag();
        String name = rootGroup.getValue();
        for (int i = 0; i < groupCount - 1; ++i) {
            Element group = (Element)groups.get(i);
            this.state.fragManager.incorporateFragment(group.getFrag(), rootFrag);
            name = group.getValue() + name;
            group.detach();
        }
        rootGroup.setValue(polyCyclicSpiroDescriptor.getValue() + name);
        openBracket.detach();
        closeBracket.detach();
    }

    private void processOldMethodPolyCyclicSpiro(List<Element> spiroElements) throws ComponentGenerationException, StructureBuildingException {
        Element firstSpiro = spiroElements.get(0);
        Element subOrRoot = firstSpiro.getParent();
        Element firstEl = subOrRoot.getChild(0);
        List<Element> elementsToResolve = OpsinTools.getSiblingsUpToElementWithTagName(firstEl, "polyCyclicSpiro");
        elementsToResolve.add(0, firstEl);
        this.resolveFeaturesOntoGroup(elementsToResolve);
        for (int i = 0; i < spiroElements.size(); ++i) {
            Atom atomOnParentFrag;
            Atom atomToBeReplaced;
            Element currentSpiro = spiroElements.get(i);
            Element previousGroup = OpsinTools.getPreviousSibling(currentSpiro, "group");
            if (previousGroup == null) {
                throw new ComponentGenerationException("OPSIN bug: unable to locate group before polycylic spiro descriptor");
            }
            Element nextGroup = OpsinTools.getNextSibling(currentSpiro, "group");
            if (nextGroup == null) {
                throw new ComponentGenerationException("OPSIN bug: unable to locate group after polycylic spiro descriptor");
            }
            Fragment previousFrag = previousGroup.getFrag();
            Fragment parentFrag = nextGroup.getFrag();
            FragmentTools.relabelNumericLocants(parentFrag.getAtomList(), StringTools.multiplyString("'", i + 1));
            elementsToResolve = OpsinTools.getSiblingsUpToElementWithTagName(currentSpiro, "polyCyclicSpiro");
            this.resolveFeaturesOntoGroup(elementsToResolve);
            String locant1 = null;
            Element possibleFirstLocant = OpsinTools.getPreviousSibling(currentSpiro);
            if (possibleFirstLocant != null && possibleFirstLocant.getName().equals("locant")) {
                if (possibleFirstLocant.getValue().split(",").length == 1) {
                    locant1 = possibleFirstLocant.getValue();
                    possibleFirstLocant.detach();
                } else {
                    throw new ComponentGenerationException("Malformed locant before polycyclic spiro descriptor");
                }
            }
            if (locant1 != null) {
                atomToBeReplaced = previousFrag.getAtomByLocantOrThrow(locant1);
            } else {
                List<Atom> potentialAtoms = FragmentTools.findSubstituableAtoms(previousFrag, 2);
                if (potentialAtoms.isEmpty()) {
                    throw new StructureBuildingException("No suitable atom found for spiro fusion");
                }
                if (AmbiguityChecker.isSubstitutionAmbiguous(potentialAtoms, 1)) {
                    this.state.addIsAmbiguous("Choice of atom for spiro fusion on: " + previousGroup.getValue());
                }
                atomToBeReplaced = potentialAtoms.get(0);
            }
            String locant2 = null;
            Element possibleSecondLocant = OpsinTools.getNextSibling(currentSpiro);
            if (possibleSecondLocant != null && possibleSecondLocant.getName().equals("locant")) {
                if (possibleSecondLocant.getValue().split(",").length == 1) {
                    locant2 = possibleSecondLocant.getValue();
                    possibleSecondLocant.detach();
                } else {
                    throw new ComponentGenerationException("Malformed locant after polycyclic spiro descriptor");
                }
            }
            if (locant2 != null) {
                atomOnParentFrag = parentFrag.getAtomByLocantOrThrow(locant2);
            } else {
                List<Atom> potentialAtoms = FragmentTools.findSubstituableAtoms(parentFrag, 2);
                if (potentialAtoms.isEmpty()) {
                    throw new StructureBuildingException("No suitable atom found for spiro fusion");
                }
                if (AmbiguityChecker.isSubstitutionAmbiguous(potentialAtoms, 1)) {
                    this.state.addIsAmbiguous("Choice of atom for spiro fusion on: " + nextGroup.getValue());
                }
                atomOnParentFrag = potentialAtoms.get(0);
            }
            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnParentFrag);
            if (atomToBeReplaced.hasSpareValency()) {
                atomOnParentFrag.setSpareValency(true);
            }
            if (atomToBeReplaced.getCharge() != 0 && atomOnParentFrag.getCharge() == 0) {
                atomOnParentFrag.setCharge(atomToBeReplaced.getCharge());
                atomOnParentFrag.setProtonsExplicitlyAddedOrRemoved(atomToBeReplaced.getProtonsExplicitlyAddedOrRemoved());
            }
            this.state.fragManager.incorporateFragment(previousFrag, parentFrag);
            nextGroup.setValue(previousGroup.getValue() + currentSpiro.getValue() + nextGroup.getValue());
            previousGroup.detach();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processSpiroBiOrTer(Element polyCyclicSpiroDescriptor, int components) throws ComponentGenerationException, StructureBuildingException {
        locant = OpsinTools.getPreviousSibling(polyCyclicSpiroDescriptor);
        if (locant != null && locant.getName().equals("locant")) ** GOTO lbl7
        if (components == 2) {
            locantText = "1,1'";
        } else {
            throw new ComponentGenerationException("Unable to find locant indicating atoms to form polycyclic spiro system!");
lbl7:
            // 1 sources

            locantText = locant.getValue();
            locant.detach();
        }
        locants = locantText.split(",");
        if (locants.length != components) {
            throw new ComponentGenerationException("Mismatch between spiro descriptor and number of locants provided");
        }
        group = OpsinTools.getNextSibling(polyCyclicSpiroDescriptor, "group");
        if (group == null) {
            throw new ComponentGenerationException("Cannot find group to which spirobi/ter descriptor applies");
        }
        this.determineFeaturesToResolveInSingleComponentSpiro(polyCyclicSpiroDescriptor);
        fragment = group.getFrag();
        clones = new ArrayList<Fragment>();
        for (i = 1; i < components; ++i) {
            clones.add(this.state.fragManager.copyAndRelabelFragment(fragment, i));
        }
        atomOnOriginalFragment = fragment.getAtomByLocantOrThrow(locants[0]);
        for (i = 1; i < components; ++i) {
            clone = (Fragment)clones.get(i - 1);
            if (components == 2 && !locants[i].endsWith("'")) {
                try {
                    atomToBeReplaced = clone.getAtomByLocantOrThrow(locants[i]);
                }
                catch (StructureBuildingException e) {
                    atomToBeReplaced = clone.getAtomByLocant(locants[i] + "'");
                    if (atomToBeReplaced != null) ** GOTO lbl34
                    throw e;
                }
            } else {
                atomToBeReplaced = clone.getAtomByLocantOrThrow(locants[i]);
            }
lbl34:
            // 3 sources

            this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnOriginalFragment);
            if (!atomToBeReplaced.hasSpareValency()) continue;
            atomOnOriginalFragment.setSpareValency(true);
        }
        for (Fragment clone : clones) {
            this.state.fragManager.incorporateFragment(clone, fragment);
        }
        group.setValue(polyCyclicSpiroDescriptor.getValue() + group.getValue());
    }

    private void processDispiroter(Element polyCyclicSpiroDescriptor) throws StructureBuildingException, ComponentGenerationException {
        String value = polyCyclicSpiroDescriptor.getValue();
        value = value.substring(0, value.length() - 10);
        value = StringTools.removeDashIfPresent(value);
        String[] locants = value.split(":");
        Element group = OpsinTools.getNextSibling(polyCyclicSpiroDescriptor, "group");
        if (group == null) {
            throw new ComponentGenerationException("Cannot find group to which dispiroter descriptor applies");
        }
        this.determineFeaturesToResolveInSingleComponentSpiro(polyCyclicSpiroDescriptor);
        Fragment fragment = group.getFrag();
        ArrayList<Fragment> clones = new ArrayList<Fragment>();
        for (int i = 1; i < 3; ++i) {
            clones.add(this.state.fragManager.copyAndRelabelFragment(fragment, i));
        }
        for (Fragment clone : clones) {
            this.state.fragManager.incorporateFragment(clone, fragment);
        }
        String[] locants1 = locants[0].split(",");
        Atom atomOnLessPrimedFragment = fragment.getAtomByLocantOrThrow(OpsinTools.fixLocantCapitalisation(locants1[0]));
        Atom atomToBeReplaced = fragment.getAtomByLocantOrThrow(OpsinTools.fixLocantCapitalisation(locants1[1]));
        this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnLessPrimedFragment);
        if (atomToBeReplaced.hasSpareValency()) {
            atomOnLessPrimedFragment.setSpareValency(true);
        }
        String[] locants2 = locants[1].split(",");
        atomOnLessPrimedFragment = fragment.getAtomByLocantOrThrow(OpsinTools.fixLocantCapitalisation(locants2[0]));
        atomToBeReplaced = fragment.getAtomByLocantOrThrow(OpsinTools.fixLocantCapitalisation(locants2[1]));
        this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToBeReplaced, atomOnLessPrimedFragment);
        if (atomToBeReplaced.hasSpareValency()) {
            atomOnLessPrimedFragment.setSpareValency(true);
        }
        group.setValue("dispiroter" + group.getValue());
    }

    private void determineFeaturesToResolveInSingleComponentSpiro(Element polyCyclicSpiroDescriptor) throws StructureBuildingException, ComponentGenerationException {
        List<Element> elementsToResolve;
        Element possibleOpenBracket = OpsinTools.getNextSibling(polyCyclicSpiroDescriptor);
        if (possibleOpenBracket.getName().equals("structuralOpenBracket")) {
            possibleOpenBracket.detach();
            elementsToResolve = OpsinTools.getSiblingsUpToElementWithTagName(polyCyclicSpiroDescriptor, "structuralCloseBracket");
            OpsinTools.getNextSibling(elementsToResolve.get(elementsToResolve.size() - 1)).detach();
        } else {
            elementsToResolve = OpsinTools.getSiblingsUpToElementWithTagName(polyCyclicSpiroDescriptor, "group");
        }
        this.resolveFeaturesOntoGroup(elementsToResolve);
    }

    private void resolveFeaturesOntoGroup(List<Element> elementsToResolve) throws StructureBuildingException, ComponentGenerationException {
        if (elementsToResolve.isEmpty()) {
            return;
        }
        GroupingEl substituentToResolve = new GroupingEl("substituent");
        Element parent = elementsToResolve.get(0).getParent();
        int index = parent.indexOf(elementsToResolve.get(0));
        Element group = null;
        ArrayList<Element> suffixes = new ArrayList<Element>();
        Element locant = null;
        for (Element element : elementsToResolve) {
            String elName = element.getName();
            if (elName.equals("group")) {
                group = element;
            } else if (elName.equals("suffix")) {
                suffixes.add(element);
            } else if (elName.equals("locant") && group == null) {
                locant = element;
            }
            element.detach();
            ((Element)substituentToResolve).addChild(element);
        }
        if (group == null) {
            throw new ComponentGenerationException("OPSIN bug: group element should of been given to method");
        }
        if (locant != null) {
            List<Element> locantAble = this.findElementsMissingIndirectLocants(substituentToResolve, locant);
            String[] locantValues = locant.getValue().split(",");
            if (locantAble.size() >= locantValues.length) {
                for (int i = 0; i < locantValues.length; ++i) {
                    String locantValue = locantValues[i];
                    ((Element)locantAble.get(i)).addAttribute(new Attribute("locant", locantValue));
                }
                locant.detach();
            }
        }
        if (!suffixes.isEmpty()) {
            this.suffixApplier.resolveSuffixes(group, suffixes);
            for (Element suffix : suffixes) {
                suffix.detach();
            }
        }
        if (((Element)substituentToResolve).getChildCount() != 0) {
            StructureBuildingMethods.resolveLocantedFeatures(this.state, substituentToResolve);
            StructureBuildingMethods.resolveUnLocantedFeatures(this.state, substituentToResolve);
            List<Element> children = ((Element)substituentToResolve).getChildElements();
            for (int i = children.size() - 1; i >= 0; --i) {
                Element child = children.get(i);
                child.detach();
                parent.insertChild(child, index);
            }
        }
    }

    private void processFusedRingBridges(Element subOrRoot) throws StructureBuildingException {
        List<Element> bridges = subOrRoot.getChildElements("fusedRingBridge");
        int bridgeCount = bridges.size();
        if (bridgeCount == 0) {
            return;
        }
        Element groupEl = OpsinTools.getNextSibling(bridges.get(bridgeCount - 1), "group");
        Fragment ringFrag = groupEl.getFrag();
        LinkedHashMap<Fragment, Atom[]> bridgeToRingAtoms = new LinkedHashMap<Fragment, Atom[]>();
        for (Element bridge : bridges) {
            Element possibleMultiplier = OpsinTools.getPreviousSibling(bridge);
            ArrayList<String[]> locants = null;
            int multiplier = 1;
            if (possibleMultiplier != null) {
                if (possibleMultiplier.getName().equals("multiplier")) {
                    multiplier = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                    Element possibleLocant = OpsinTools.getPreviousSibling(possibleMultiplier);
                    possibleMultiplier.detach();
                    if (possibleLocant != null && possibleLocant.getName().equals("colonOrSemiColonDelimitedLocant")) {
                        locants = new ArrayList<String[]>();
                        String[] locantsForEachMultiple = StringTools.removeDashIfPresent(possibleLocant.getValue()).split(":");
                        if (locantsForEachMultiple.length != multiplier) {
                            throw new RuntimeException("Mismatch between locant and multiplier counts (" + locantsForEachMultiple.length + " and " + multiplier + "): " + possibleLocant.getValue());
                        }
                        for (String locantsForInstance : locantsForEachMultiple) {
                            String[] locantArray = locantsForInstance.split(",");
                            if (locantArray.length != 2) {
                                throw new RuntimeException("Expected two locants per bridge, but was: " + possibleLocant.getValue());
                            }
                            locants.add(locantArray);
                        }
                        possibleLocant.detach();
                    }
                } else {
                    String[] locantArray;
                    Element possibleLocant = possibleMultiplier;
                    if (possibleLocant != null && possibleLocant.getName().equals("locant") && (locantArray = possibleLocant.getValue().split(",")).length == 2) {
                        locants = new ArrayList();
                        locants.add(locantArray);
                        possibleLocant.detach();
                    }
                }
            }
            for (int i = 0; i < multiplier; ++i) {
                Atom[] ringAtoms;
                Fragment bridgeFrag = this.state.fragManager.buildSMILES(bridge.getAttributeValue("value"), groupEl, "none");
                if (locants != null) {
                    String[] locantArray = (String[])locants.get(i);
                    if (locantArray.length == 2) {
                        bridgeFrag.getOutAtom(0).setLocant(locantArray[0]);
                        bridgeFrag.getOutAtom(1).setLocant(locantArray[1]);
                    }
                    ringAtoms = StructureBuildingMethods.formEpoxide(this.state, bridgeFrag, ringFrag.getDefaultInAtomOrFirstAtom());
                } else {
                    List<Atom> possibleAtoms = FragmentTools.findSubstituableAtoms(ringFrag, 1);
                    if (possibleAtoms.isEmpty()) {
                        throw new StructureBuildingException("Unable to find suitable atom to form bridge");
                    }
                    if (AmbiguityChecker.isSubstitutionAmbiguous(possibleAtoms, 1)) {
                        this.state.addIsAmbiguous("Addition of bridge to: " + groupEl.getValue());
                    }
                    ringAtoms = StructureBuildingMethods.formEpoxide(this.state, bridgeFrag, possibleAtoms.get(0));
                }
                bridgeToRingAtoms.put(bridgeFrag, ringAtoms);
                this.state.fragManager.incorporateFragment(bridgeFrag, ringFrag);
            }
            bridge.detach();
        }
        int highestLocant = this.getHighestNumericLocant(ringFrag);
        ArrayList bridgeFragments = new ArrayList(bridgeToRingAtoms.keySet());
        Collections.sort(bridgeFragments, new SortBridgesByHighestLocantedBridgehead(bridgeToRingAtoms));
        for (Fragment bridgeFragment : bridgeFragments) {
            List<Atom> bridgeFragmentAtoms = bridgeFragment.getAtomList();
            Atom[] ringAtoms = (Atom[])bridgeToRingAtoms.get(bridgeFragment);
            if (ComponentProcessor.getLocantNumber(ringAtoms[0]) <= ComponentProcessor.getLocantNumber(ringAtoms[1])) {
                for (int i = bridgeFragmentAtoms.size() - 1; i >= 0; --i) {
                    bridgeFragmentAtoms.get(i).addLocant(String.valueOf(++highestLocant));
                }
                continue;
            }
            for (Atom atom : bridgeFragmentAtoms) {
                atom.addLocant(String.valueOf(++highestLocant));
            }
        }
    }

    private static int getLocantNumber(Atom atom) {
        Matcher m;
        String locant = atom.getFirstLocant();
        if (locant != null && (m = OpsinTools.MATCH_NUMERIC_LOCANT.matcher(locant)).matches()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    private int getHighestNumericLocant(Fragment ringFrag) {
        int i = 1;
        while (ringFrag.getAtomByLocant(String.valueOf(i)) != null) {
            ++i;
        }
        return i - 1;
    }

    private void applyLambdaConvention(Element subOrRoot) throws StructureBuildingException {
        List<Element> lambdaConventionEls = subOrRoot.getChildElements("lambdaConvention");
        for (Element lambdaConventionEl : lambdaConventionEls) {
            Fragment frag = subOrRoot.getFirstChildElement("group").getFrag();
            if (lambdaConventionEl.getAttribute("locant") != null) {
                frag.getAtomByLocantOrThrow(lambdaConventionEl.getAttributeValue("locant")).setLambdaConventionValency(Integer.parseInt(lambdaConventionEl.getAttributeValue("lambda")));
            } else {
                if (frag.getAtomCount() != 1) {
                    throw new StructureBuildingException("Ambiguous use of lambda convention. Fragment has more than 1 atom but no locant was specified for the lambda");
                }
                frag.getFirstAtom().setLambdaConventionValency(Integer.parseInt(lambdaConventionEl.getAttributeValue("lambda")));
            }
            lambdaConventionEl.detach();
        }
    }

    private void handleMultiRadicals(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        int totalOutAtoms;
        String[] locantValues;
        Element possibleLocant;
        int outAtomCount;
        Element beforeGroup;
        Element group = subOrRoot.getFirstChildElement("group");
        String groupValue = group.getValue();
        Fragment thisFrag = group.getFrag();
        if ((groupValue.equals("methylene") || groupValue.equals("methylen") || groupValue.equals("oxy") || matchChalcogenReplacement.matcher(groupValue).matches()) && (beforeGroup = OpsinTools.getPreviousSibling(group)) != null && beforeGroup.getName().equals("multiplier") && beforeGroup.getAttributeValue("type").equals("basic") && OpsinTools.getPreviousSibling(beforeGroup) == null) {
            int multiplierVal = Integer.parseInt(beforeGroup.getAttributeValue("value"));
            if (!this.unsuitableForFormingChainMultiradical(group, beforeGroup)) {
                if (groupValue.equals("methylene") || groupValue.equals("methylen")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("C", multiplierVal));
                } else if (groupValue.equals("oxy")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("O", multiplierVal));
                } else if (groupValue.equals("thio")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("S", multiplierVal));
                } else if (groupValue.equals("seleno")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("[SeH?]", multiplierVal));
                } else if (groupValue.equals("telluro")) {
                    group.getAttribute("value").setValue(StringTools.multiplyString("[TeH?]", multiplierVal));
                } else {
                    throw new ComponentGenerationException("unexpected group value");
                }
                group.getAttribute("outIDs").setValue("1," + Integer.parseInt(beforeGroup.getAttributeValue("value")));
                group.setValue(beforeGroup.getValue() + groupValue);
                beforeGroup.detach();
                if (group.getAttribute("labels") != null) {
                    group.getAttribute("labels").setValue("numeric");
                } else {
                    group.addAttribute(new Attribute("labels", "numeric"));
                }
                this.state.fragManager.removeFragment(thisFrag);
                thisFrag = ComponentProcessor.resolveGroup(this.state, group);
                group.removeAttribute(group.getAttribute("usableAsAJoiner"));
            }
        }
        if (group.getAttribute("outIDs") != null) {
            String[] radicalPositions = group.getAttributeValue("outIDs").split(",");
            int firstIdInFrag = thisFrag.getIdOfFirstAtom();
            for (String radicalID : radicalPositions) {
                thisFrag.addOutAtom(firstIdInFrag + Integer.parseInt(radicalID) - 1, 1, (Boolean)true);
            }
        }
        if ((outAtomCount = thisFrag.getOutAtomCount()) >= 2) {
            if (groupValue.equals("amine") || groupValue.equals("amin")) {
                Element previousGroup = OpsinTools.getPreviousGroup(group);
                Element nextGroup = OpsinTools.getNextGroup(group);
                if (previousGroup == null || previousGroup.getFrag().getOutAtomCount() < 2 || nextGroup == null) {
                    throw new ComponentGenerationException("Invalid use of amine as a substituent!");
                }
            }
            if (this.state.currentWordRule == WordRule.polymer && outAtomCount >= 3) {
                int valency = 0;
                for (int i = 2; i < outAtomCount; ++i) {
                    OutAtom nextOutAtom = thisFrag.getOutAtom(i);
                    valency += nextOutAtom.getValency();
                    thisFrag.removeOutAtom(nextOutAtom);
                }
                thisFrag.getOutAtom(1).setValency(thisFrag.getOutAtom(1).getValency() + valency);
            }
        }
        if (outAtomCount == 2 && "epoxyLike".equals(group.getAttributeValue("subType")) && (possibleLocant = OpsinTools.getPreviousSibling(group)) != null && (locantValues = possibleLocant.getValue().split(",")).length == 2) {
            thisFrag.getOutAtom(0).setLocant(locantValues[0]);
            thisFrag.getOutAtom(1).setLocant(locantValues[1]);
            possibleLocant.detach();
            subOrRoot.addAttribute(new Attribute("locant", locantValues[0]));
        }
        if ((totalOutAtoms = outAtomCount + this.calculateOutAtomsToBeAddedFromInlineSuffixes(group, subOrRoot.getChildElements("suffix"))) >= 2) {
            group.addAttribute(new Attribute("isAMultiRadical", Integer.toString(totalOutAtoms)));
        }
    }

    private boolean unsuitableForFormingChainMultiradical(Element group, Element multiplierBeforeGroup) {
        Element previousGroup = OpsinTools.getPreviousGroup(group);
        if (previousGroup != null) {
            if (previousGroup.getAttribute("isAMultiRadical") != null) {
                if (previousGroup.getAttributeValue("acceptsAdditiveBonds") != null && OpsinTools.getPreviousSibling(previousGroup.getParent()) != null) {
                    return false;
                }
                if (OpsinTools.getPrevious(multiplierBeforeGroup).getName().equals("multiplier")) {
                    return false;
                }
                return previousGroup.getAttributeValue("isAMultiRadical").equals(multiplierBeforeGroup.getAttributeValue("value"));
            }
            if (OpsinTools.getPreviousSibling(previousGroup, "multiplier") == null) {
                Fragment previousGroupFrag = previousGroup.getFrag();
                int outAtomValency = 0;
                if (previousGroupFrag.getOutAtomCount() == 1) {
                    outAtomValency = previousGroupFrag.getOutAtom(0).getValency();
                } else {
                    Element suffix = OpsinTools.getNextSibling(previousGroup, "suffix");
                    if (suffix != null && suffix.getAttributeValue("value").equals("ylidene")) {
                        outAtomValency = 2;
                    }
                    if (suffix != null && suffix.getAttributeValue("value").equals("ylidyne")) {
                        outAtomValency = 3;
                    }
                }
                if (outAtomValency == Integer.parseInt(multiplierBeforeGroup.getAttributeValue("value"))) {
                    return true;
                }
            }
        }
        return false;
    }

    private int calculateOutAtomsToBeAddedFromInlineSuffixes(Element group, List<Element> suffixes) throws ComponentGenerationException {
        int outAtomsThatWillBeAdded = 0;
        Fragment frag = group.getFrag();
        String groupType = frag.getType();
        String subgroupType = frag.getSubType();
        String suffixTypeToUse = null;
        suffixTypeToUse = this.suffixApplier.isGroupTypeWithSpecificSuffixRules(groupType) ? groupType : "standardGroup";
        List<Fragment> suffixList = this.state.xmlSuffixMap.get(group);
        for (Fragment fragment : suffixList) {
            outAtomsThatWillBeAdded += fragment.getOutAtomCount();
        }
        for (Element element : suffixes) {
            String suffixValue = element.getAttributeValue("value");
            List<SuffixRule> suffixRules = this.suffixApplier.getSuffixRuleTags(suffixTypeToUse, suffixValue, subgroupType);
            for (SuffixRule suffixRule : suffixRules) {
                if (suffixRule.getType() != SuffixRuleType.setOutAtom) continue;
                ++outAtomsThatWillBeAdded;
            }
        }
        return outAtomsThatWillBeAdded;
    }

    private void addImplicitBracketsToAminoAcids(List<Element> groups, List<Element> brackets) {
        for (int i = groups.size() - 1; i >= 0; --i) {
            Element possibleLocant;
            Element group = groups.get(i);
            if (!group.getAttributeValue("type").equals("aminoAcid") || OpsinTools.getNextGroup(group) == null || (possibleLocant = OpsinTools.getPreviousSiblingIgnoringCertainElements(group, new String[]{"multiplier"})) != null && possibleLocant.getName().equals("locant")) continue;
            Element subOrRoot = group.getParent();
            Element previous = OpsinTools.getPreviousSibling(subOrRoot);
            ArrayList<Element> previousElements = new ArrayList<Element>();
            while (previous != null && (previous.getName().equals("substituent") || previous.getName().equals("bracket"))) {
                previousElements.add(previous);
                previous = OpsinTools.getPreviousSibling(previous);
            }
            if (previousElements.size() <= 0) continue;
            Collections.reverse(previousElements);
            GroupingEl bracket = new GroupingEl("bracket");
            bracket.addAttribute(new Attribute("type", "implicit"));
            Element parent = subOrRoot.getParent();
            int indexToInsertAt = parent.indexOf((Element)previousElements.get(0));
            for (Element element : previousElements) {
                element.detach();
                ((Element)bracket).addChild(element);
            }
            subOrRoot.detach();
            ((Element)bracket).addChild(subOrRoot);
            parent.insertChild(bracket, indexToInsertAt);
            brackets.add(bracket);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void implicitlyBracketToPreviousSubstituentIfAppropriate(Element substituent, List<Element> brackets) throws ComponentGenerationException, StructureBuildingException {
        Element desiredGroup;
        Element possibleMultiplier;
        void var16_26;
        Element suffix;
        Element firstChildElementOfElementAfterSubstituent;
        String firstElInSubName = substituent.getChild(0).getName();
        if (firstElInSubName.equals("locant") || firstElInSubName.equals("multiplier") || firstElInSubName.equals("stereoChemistry")) {
            return;
        }
        Element substituentGroup = substituent.getFirstChildElement("group");
        if (substituentGroup.getAttribute("usableAsAJoiner") == null) {
            return;
        }
        Element elementBeforeSubstituent = OpsinTools.getPreviousSibling(substituent);
        if (elementBeforeSubstituent == null || !elementBeforeSubstituent.getName().equals("substituent") && !elementBeforeSubstituent.getName().equals("bracket")) {
            return;
        }
        boolean sulfonylLike = matchGroupsThatAreAlsoInlineSuffixes.matcher(substituentGroup.getValue()).matches();
        Element elementAftersubstituent = OpsinTools.getNextSibling(substituent);
        if (elementAftersubstituent != null && !sulfonylLike && elementBeforeSubstituent.getName().equals("bracket") && !"implicit".equals(elementBeforeSubstituent.getAttributeValue("type")) && elementAftersubstituent.getName().equals("bracket") && ((firstChildElementOfElementAfterSubstituent = elementAftersubstituent.getChild(0)).getName().equals("substituent") || firstChildElementOfElementAfterSubstituent.getName().equals("bracket")) && !OpsinTools.getPrevious(firstChildElementOfElementAfterSubstituent).getName().equals("hyphen")) {
            return;
        }
        if (!(this.isSubBracketOrRoot(elementAftersubstituent) || elementAftersubstituent == null && this.locantedEsterImplicitBracketSpecialCase(substituent, elementBeforeSubstituent))) {
            return;
        }
        Element elementDirectlyBeforeSubstituent = OpsinTools.getPrevious(substituent.getChild(0));
        if (!sulfonylLike && elementDirectlyBeforeSubstituent.getName().equals("hyphen")) {
            return;
        }
        List<Element> groupElements = OpsinTools.getDescendantElementsWithTagName(elementBeforeSubstituent, "group");
        Element lastGroupOfElementBeforeSub = groupElements.get(groupElements.size() - 1);
        if (lastGroupOfElementBeforeSub == null) {
            throw new ComponentGenerationException("No group where group was expected");
        }
        if (this.substituentsAreEndToEndAlkyls(substituentGroup, lastGroupOfElementBeforeSub, elementBeforeSubstituent)) {
            return;
        }
        Fragment frag = substituentGroup.getFrag();
        if (lastGroupOfElementBeforeSub.getAttribute("isAMultiRadical") != null && lastGroupOfElementBeforeSub.getAttribute("acceptsAdditiveBonds") == null && lastGroupOfElementBeforeSub.getAttribute("iminoLike") == null) {
            return;
        }
        if (substituentGroup.getAttribute("isAMultiRadical") != null) {
            if (substituentGroup.getAttribute("acceptsAdditiveBonds") == null && substituentGroup.getAttribute("iminoLike") == null) {
                return;
            }
            boolean isSubstitutable = false;
            for (Atom atom : frag) {
                if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(atom) <= 0) continue;
                isSubstitutable = true;
                break;
            }
            if (!isSubstitutable && elementAftersubstituent != null && elementAftersubstituent.getChild(0).getName().equals("multiplier") && frag.getOutAtomCount() == Integer.parseInt(elementAftersubstituent.getChild(0).getAttributeValue("value"))) {
                String elType = elementAftersubstituent.getName();
                if (elType.equals("root")) {
                    return;
                }
                if (elType.equals("substituent")) {
                    List<Element> groups = OpsinTools.getDescendantElementsWithTagName(elementAftersubstituent, "group");
                    for (Element element : groups) {
                        if (element.getAttribute("isAMultiRadical") == null) continue;
                        return;
                    }
                } else if (elType.equals("bracket") && OpsinTools.getDescendantElementsWithTagName(elementAftersubstituent, "root").size() > 0) {
                    return;
                }
            }
        }
        if (lastGroupOfElementBeforeSub.getAttribute("iminoLike") != null && substituentGroup.getAttribute("iminoLike") != null) {
            return;
        }
        if (this.implicitBracketWouldPreventAdditiveBonding(elementBeforeSubstituent, elementAftersubstituent)) {
            return;
        }
        if (this.implicitBracketWouldPreventConnectionToAmineSuffix(elementBeforeSubstituent, elementAftersubstituent)) {
            return;
        }
        if (substituentGroup.getValue().equals("sulf") && frag.getAtomCount() == 1 && (suffix = OpsinTools.getNextSiblingIgnoringCertainElements(substituentGroup, new String[]{"unsaturator"})) != null && suffix.getAttributeValue("value").equals("ylidene")) {
            substituentGroup.removeAttribute(substituentGroup.getAttribute("usableAsAJoiner"));
            return;
        }
        if ("perhalogeno".equals(lastGroupOfElementBeforeSub.getAttributeValue("subType"))) {
            return;
        }
        if (frag.getAtomCount() == 1 && frag.getFirstAtom().getElement() == ChemEl.Si) {
            elementBeforeSubstituent = this.determineSubstitutentForSilylImplicitBracketting(elementBeforeSubstituent, 3);
        }
        ArrayList<Element> locantRelatedElements = new ArrayList<Element>();
        String[] locantValues = null;
        ArrayList<Element> stereoChemistryElements = new ArrayList<Element>();
        List<Element> childrenOfElementBeforeSubstituent = elementBeforeSubstituent.getChildElements();
        for (Element childOfElBeforeSub : childrenOfElementBeforeSubstituent) {
            String currentElementName = childOfElBeforeSub.getName();
            if (currentElementName.equals("stereoChemistry")) {
                stereoChemistryElements.add(childOfElBeforeSub);
                continue;
            }
            if (!currentElementName.equals("locant") || locantValues != null) break;
            locantRelatedElements.add(childOfElBeforeSub);
            locantValues = childOfElBeforeSub.getValue().split(",");
        }
        boolean bl = false;
        if (locantValues != null) {
            void var16_23;
            Element elAfterLocant = OpsinTools.getNextSibling((Element)locantRelatedElements.get(0));
            for (String locantText : locantValues) {
                if (frag.getAtomCount() != 1 && frag.hasLocant(locantText) && !matchElementSymbolOrAminoAcidLocant.matcher(locantText).find() && (locantValues.length != 1 || !elAfterLocant.getName().equals("multiplier"))) continue;
                if (ComponentProcessor.checkLocantPresentOnPotentialRoot(this.state, substituent, locantText)) {
                    boolean bl2 = true;
                    break;
                }
                if (frag.getAtomCount() == 1 && frag.hasLocant(locantText)) continue;
                boolean bl3 = true;
                break;
            }
            if (var16_23 != false && locantValues.length > 1) {
                if (elAfterLocant != null && elAfterLocant.getName().equals("multiplier")) {
                    Element shouldBeAGroupOrSubOrBracket = OpsinTools.getNextSiblingIgnoringCertainElements(elAfterLocant, new String[]{"multiplier"});
                    if (shouldBeAGroupOrSubOrBracket != null) {
                        if (shouldBeAGroupOrSubOrBracket.getName().equals("group") && elAfterLocant.getAttributeValue("type").equals("group") || sulfonylLike) {
                            locantRelatedElements.add(elAfterLocant);
                        } else if ("orthoMetaPara".equals(((Element)locantRelatedElements.get(0)).getAttributeValue("type"))) {
                            ((Element)locantRelatedElements.get(0)).setValue(locantValues[1]);
                        } else {
                            if (frag.getAtomCount() != 1) return;
                            locantRelatedElements.add(elAfterLocant);
                        }
                    } else {
                        boolean bl4 = false;
                    }
                } else {
                    boolean bl5 = false;
                }
            }
        }
        GroupingEl bracket = new GroupingEl("bracket");
        bracket.addAttribute(new Attribute("type", "implicit"));
        for (Element stereoChemistryElement : stereoChemistryElements) {
            stereoChemistryElement.detach();
            ((Element)bracket).addChild(stereoChemistryElement);
        }
        if (var16_26 != false) {
            for (Element locantElement : locantRelatedElements) {
                locantElement.detach();
                ((Element)bracket).addChild(locantElement);
            }
        }
        if (locantRelatedElements.isEmpty() && (possibleMultiplier = childrenOfElementBeforeSubstituent.get(0)).getName().equals("multiplier") && (sulfonylLike || possibleMultiplier.getAttributeValue("type").equals("group")) && (desiredGroup = OpsinTools.getNextSiblingIgnoringCertainElements(possibleMultiplier, new String[]{"multiplier"})) != null && desiredGroup.getName().equals("group")) {
            possibleMultiplier.detach();
            ((Element)bracket).addChild(possibleMultiplier);
        }
        Element parent = substituent.getParent();
        int startIndex = parent.indexOf(elementBeforeSubstituent);
        int endIndex = parent.indexOf(substituent);
        for (int i = 0; i <= endIndex - startIndex; ++i) {
            Element n = parent.getChild(startIndex);
            n.detach();
            ((Element)bracket).addChild(n);
        }
        parent.insertChild(bracket, startIndex);
        brackets.add(bracket);
    }

    private boolean substituentsAreEndToEndAlkyls(Element group, Element precedingGroup, Element precedingGroupSubstituent) {
        if (!this.isPotentialAlkyl(group) || !this.isPotentialAlkyl(precedingGroup)) {
            return false;
        }
        Element suffixAfterGroup = OpsinTools.getNextSibling(precedingGroup, "suffix");
        if (suffixAfterGroup != null && suffixAfterGroup.getFrag() != null && suffixAfterGroup.getFrag().getOutAtomCount() > 0) {
            return false;
        }
        Element locant = null;
        Element multiplier = null;
        for (Element childOfElBeforeSub : precedingGroupSubstituent.getChildElements()) {
            String elName = childOfElBeforeSub.getName();
            if (elName.equals("locant")) {
                locant = childOfElBeforeSub;
                Element next = OpsinTools.getNextSibling(childOfElBeforeSub);
                if (next == null || !next.getName().equals("multiplier")) break;
                multiplier = next;
                break;
            }
            if (elName.equals("stereoChemistry")) continue;
            break;
        }
        if (locant != null) {
            Fragment frag;
            Element nextGroup;
            String[] locantVals = locant.getValue().split(",");
            if (!this.fragHasLocants(group.getFrag(), locantVals) && (multiplier == null || Integer.parseInt(multiplier.getAttributeValue("value")) == locantVals.length) && this.isSimpleAlkyl(group) && this.isSimpleAlkyl(precedingGroup)) {
                return true;
            }
            return multiplier != null && Integer.parseInt(multiplier.getAttributeValue("value")) == 2 && (nextGroup = OpsinTools.getNextGroup(group)) != null && (frag = nextGroup.getFrag()).getAtomCount() == 1 && frag.getFirstAtom().getElement() == ChemEl.Si;
        }
        return true;
    }

    private boolean fragHasLocants(Fragment frag, String[] locantVals) {
        for (String locantVal : locantVals) {
            if (frag.hasLocant(locantVal)) continue;
            return false;
        }
        return true;
    }

    private boolean isPotentialAlkyl(Element group) {
        String type = group.getAttributeValue("type");
        return type.equals("chain") && group.getAttributeValue("subType").equals("alkaneStem") || type.equals("acidStem");
    }

    private boolean isSimpleAlkyl(Element group) {
        Element suffix = OpsinTools.getNextSibling(group, "suffix");
        String type = group.getAttributeValue("type");
        return type.equals("chain") && group.getAttributeValue("subType").equals("alkaneStem") && suffix != null && suffix.getValue().equals("yl");
    }

    private boolean implicitBracketWouldPreventAdditiveBonding(Element elementBeforeSubstituent, Element elementAftersubstituent) {
        Element groupAfterSubstituent;
        if (elementAftersubstituent != null && elementAftersubstituent.getName().equals("substituent") && (groupAfterSubstituent = elementAftersubstituent.getFirstChildElement("group")).getAttribute("acceptsAdditiveBonds") != null && !this.isSubBracketOrRoot(OpsinTools.getNextSibling(elementAftersubstituent)) && elementBeforeSubstituent.getChild(0).getName().equals("locant")) {
            Fragment additiveAcceptingFrag = groupAfterSubstituent.getFrag();
            Element viableSubstituent = elementBeforeSubstituent;
            while (viableSubstituent != null) {
                Element possibleLocant;
                if ((viableSubstituent.getName().equals("substituent") || viableSubstituent.getName().equals("bracket")) && (possibleLocant = viableSubstituent.getChild(0)).getName().equals("locant") && additiveAcceptingFrag.getFirstAtom().equals(additiveAcceptingFrag.getAtomByLocant(possibleLocant.getValue()))) {
                    return false;
                }
                viableSubstituent = OpsinTools.getPreviousSibling(viableSubstituent);
            }
            return true;
        }
        return false;
    }

    private boolean implicitBracketWouldPreventConnectionToAmineSuffix(Element elementBeforeSubstituent, Element elementAftersubstituent) {
        String val;
        return elementAftersubstituent != null && elementAftersubstituent.getName().equals("root") && elementAftersubstituent.getChildCount() == 1 && ((val = elementAftersubstituent.getValue()).equals("amine") || val.equals("amin")) && elementBeforeSubstituent.getChild(0).getName().equals("locant");
    }

    private Element determineSubstitutentForSilylImplicitBracketting(Element el, int expectedSubstituents) {
        Element elToUse = el;
        while (elToUse != null && (elToUse.getName().equals("substituent") || elToUse.getName().equals("bracket"))) {
            Element childToConsider;
            int multiplier = 1;
            boolean locantPresent = false;
            int index = 0;
            int childCount = elToUse.getChildCount();
            if ((childToConsider = elToUse.getChild(index++)).getName().equals("locant")) {
                locantPresent = true;
                Element element = childToConsider = index < childCount ? elToUse.getChild(index++) : null;
            }
            if (childToConsider != null && childToConsider.getName().equals("multiplier")) {
                multiplier = Integer.parseInt(childToConsider.getAttributeValue("value"));
                Element element = childToConsider = index < childCount ? elToUse.getChild(index++) : null;
            }
            if (childToConsider == null || !childToConsider.getName().equals("group") && !childToConsider.getName().equals("substituent")) {
                return el;
            }
            if ((expectedSubstituents -= multiplier) <= 0) {
                if (expectedSubstituents < 0) {
                    return el;
                }
                return elToUse;
            }
            if (locantPresent) {
                return el;
            }
            elToUse = OpsinTools.getPreviousSibling(elToUse);
        }
        return el;
    }

    private boolean locantedEsterImplicitBracketSpecialCase(Element substituent, Element elementBeforeSubstituent) {
        return substituent.getParent().getName().equals("word") && OpsinTools.getPreviousSibling(elementBeforeSubstituent) == null && (this.state.currentWordRule == WordRule.ester || this.state.currentWordRule == WordRule.functionalClassEster || this.state.currentWordRule == WordRule.multiEster || this.state.currentWordRule == WordRule.acetal);
    }

    /*
     * WARNING - void declaration
     */
    private void matchLocantsToIndirectFeatures(Element subOrRoot) throws StructureBuildingException {
        List<Element> locantEls = this.findLocantsThatCouldBeIndirectLocants(subOrRoot);
        if (locantEls.size() > 0) {
            Fragment fragmentAfterLocant;
            Element parentEl;
            Element group = subOrRoot.getFirstChildElement("group");
            Element lastLocant = locantEls.get(locantEls.size() - 1);
            String[] locantValues = lastLocant.getValue().split(",");
            if (locantValues.length == 1 && group.getAttribute("frontLocantsExpected") != null) {
                String[] allowedLocants;
                for (String string : allowedLocants = group.getAttributeValue("frontLocantsExpected").split(",")) {
                    if (!locantValues[0].equals(string)) continue;
                    Element expectedSuffix = OpsinTools.getNextSibling(group);
                    if (expectedSuffix == null || !expectedSuffix.getName().equals("suffix") || expectedSuffix.getAttribute("locant") != null) break;
                    expectedSuffix.addAttribute(new Attribute("locant", locantValues[0]));
                    lastLocant.detach();
                    return;
                }
            }
            boolean allowIndirectLocants = true;
            if (this.state.currentWordRule == WordRule.multiEster && !"addedHydrogenLocant".equals(lastLocant.getAttributeValue("type")) && (parentEl = subOrRoot.getParent()).getName().equals("word") && parentEl.getAttributeValue("type").equals("substituent") && parentEl.getChildCount() == 1 && locantValues.length == 1 && !"orthoMetaPara".equals(lastLocant.getAttributeValue("type"))) {
                allowIndirectLocants = false;
            }
            if ((fragmentAfterLocant = group.getFrag()).getAtomCount() <= 1) {
                allowIndirectLocants = false;
            }
            if (allowIndirectLocants) {
                if (!"addedHydrogenLocant".equals(lastLocant.getAttributeValue("type")) && locantEls.size() == 1 && group.getAttribute("isAMultiRadical") == null && locantValues.length == 1 && ComponentProcessor.checkLocantPresentOnPotentialRoot(this.state, subOrRoot, locantValues[0]) && OpsinTools.getPreviousSibling(lastLocant, "locant") == null) {
                    return;
                }
                boolean assignableToIndirectFeatures = true;
                List<Element> locantAble = this.findElementsMissingIndirectLocants(subOrRoot, lastLocant);
                if (locantAble.size() < locantValues.length) {
                    assignableToIndirectFeatures = false;
                } else {
                    for (String locantValue : locantValues) {
                        if (fragmentAfterLocant.hasLocant(locantValue)) continue;
                        assignableToIndirectFeatures = false;
                    }
                }
                if (!assignableToIndirectFeatures) {
                    if (locantValues.length == 1) {
                        List<Fragment> list = this.state.xmlSuffixMap.get(group);
                        if (matchElementSymbolOrAminoAcidLocant.matcher(locantValues[0]).matches()) {
                            return;
                        }
                        for (Fragment suffix : list) {
                            if (!suffix.hasLocant(locantValues[0])) continue;
                            Atom dummyRAtom = suffix.getFirstAtom();
                            List<Atom> neighbours = dummyRAtom.getAtomNeighbours();
                            Bond b = null;
                            block3: for (Atom atom : neighbours) {
                                List<String> neighbourLocants = atom.getLocants();
                                for (String neighbourLocant : neighbourLocants) {
                                    if (!OpsinTools.MATCH_NUMERIC_LOCANT.matcher(neighbourLocant).matches()) continue;
                                    b = dummyRAtom.getBondToAtomOrThrow(atom);
                                    break block3;
                                }
                            }
                            if (b == null) continue;
                            this.state.fragManager.removeBond(b);
                            this.state.fragManager.createBond(dummyRAtom, suffix.getAtomByLocantOrThrow(locantValues[0]), b.getOrder());
                            lastLocant.detach();
                        }
                    }
                } else {
                    void var10_17;
                    boolean bl = false;
                    while (var10_17 < locantValues.length) {
                        String locantValue = locantValues[var10_17];
                        locantAble.get((int)var10_17).addAttribute(new Attribute("locant", locantValue));
                        ++var10_17;
                    }
                    lastLocant.detach();
                }
            }
        }
    }

    private List<Element> findLocantsThatCouldBeIndirectLocants(Element subOrRoot) {
        List<Element> children = subOrRoot.getChildElements();
        ArrayList<Element> locantEls = new ArrayList<Element>();
        for (Element el : children) {
            if (el.getName().equals("locant")) {
                Element afterLocant = OpsinTools.getNextSibling(el);
                if (afterLocant != null && afterLocant.getName().equals("multiplier")) continue;
                locantEls.add(el);
                continue;
            }
            if (!el.getName().equals("group")) continue;
            break;
        }
        return locantEls;
    }

    private List<Element> findElementsMissingIndirectLocants(Element subOrRoot, Element locantEl) {
        ArrayList<Element> locantAble = new ArrayList<Element>();
        List<Element> childrenOfSubOrBracketOrRoot = subOrRoot.getChildElements();
        for (Element el : childrenOfSubOrBracketOrRoot) {
            Element group;
            String type;
            String name = el.getName();
            if (!name.equals("suffix") && !name.equals("unsaturator") && !name.equals("conjunctiveSuffixGroup") || el.getAttribute("locant") != null || el.getAttribute("locantID") != null || el.getAttribute("multiplied") != null || subOrRoot.indexOf(el) <= subOrRoot.indexOf(locantEl) || name.equals("suffix") && ((type = (group = OpsinTools.getPreviousSibling(el, "group")).getAttributeValue("type")).equals("acidStem") && !"cycleformer".equals(el.getAttributeValue("subType")) || type.equals("nonCarboxylicAcid") || type.equals("chalcogenAcidStem"))) continue;
            locantAble.add(el);
        }
        return locantAble;
    }

    private void assignImplicitLocantsToDiTerminalSuffixes(Element subOrRoot) throws StructureBuildingException {
        int chainLength;
        Element hopefullyAChain;
        Element terminalSuffix2;
        Element terminalSuffix1 = subOrRoot.getFirstChildElement("suffix");
        if (terminalSuffix1 != null && this.isATerminalSuffix(terminalSuffix1) && OpsinTools.getNextSibling(terminalSuffix1) != null && this.isATerminalSuffix(terminalSuffix2 = OpsinTools.getNextSibling(terminalSuffix1)) && (hopefullyAChain = OpsinTools.getPreviousSibling(terminalSuffix1, "group")) != null && hopefullyAChain.getAttributeValue("type").equals("chain") && (chainLength = hopefullyAChain.getFrag().getChainLength()) >= 2) {
            terminalSuffix1.addAttribute(new Attribute("locant", "1"));
            terminalSuffix2.addAttribute(new Attribute("locant", Integer.toString(chainLength)));
        }
    }

    private boolean isATerminalSuffix(Element suffix) {
        return suffix.getName().equals("suffix") && suffix.getAttribute("locant") == null && (suffix.getAttributeValue("type").equals("inline") || "terminal".equals(suffix.getAttributeValue("subType")));
    }

    private void processConjunctiveNomenclature(Element subOrRoot) throws ComponentGenerationException, StructureBuildingException {
        List<Element> conjunctiveGroups = subOrRoot.getChildElements("conjunctiveSuffixGroup");
        int conjunctiveGroupCount = conjunctiveGroups.size();
        if (conjunctiveGroupCount > 0) {
            Element ringGroup = subOrRoot.getFirstChildElement("group");
            Fragment ringFrag = ringGroup.getFrag();
            if (ringFrag.getOutAtomCount() != 0) {
                throw new ComponentGenerationException("OPSIN Bug: Ring fragment should have no radicals");
            }
            for (int i = 0; i < conjunctiveGroupCount; ++i) {
                Element conjunctiveGroup = conjunctiveGroups.get(i);
                Fragment conjunctiveFragment = conjunctiveGroup.getFrag();
                String locant = conjunctiveGroup.getAttributeValue("locant");
                Atom atomToConnectToOnConjunctiveFrag = FragmentTools.lastNonSuffixCarbonWithSufficientValency(conjunctiveFragment);
                if (atomToConnectToOnConjunctiveFrag == null) {
                    throw new ComponentGenerationException("OPSIN Bug: Unable to find non suffix carbon with sufficient valency");
                }
                if (locant != null) {
                    this.state.fragManager.createBond(atomToConnectToOnConjunctiveFrag, ringFrag.getAtomByLocantOrThrow(locant), 1);
                } else {
                    List<Atom> possibleAtoms = FragmentTools.findSubstituableAtoms(ringFrag, 1);
                    if (possibleAtoms.isEmpty()) {
                        throw new StructureBuildingException("No suitable atom found for conjunctive operation");
                    }
                    if (AmbiguityChecker.isSubstitutionAmbiguous(possibleAtoms, 1)) {
                        this.state.addIsAmbiguous("Connection of conjunctive group to: " + ringGroup.getValue());
                    }
                    this.state.fragManager.createBond(atomToConnectToOnConjunctiveFrag, possibleAtoms.get(0), 1);
                }
                this.state.fragManager.incorporateFragment(conjunctiveFragment, ringFrag);
            }
        }
    }

    private void processBiochemicalLinkageDescriptors(List<Element> substituents, List<Element> brackets) throws StructureBuildingException {
        Element bioLinkLocant;
        List<Element> bioLinkLocants;
        for (Element substituent : substituents) {
            bioLinkLocants = substituent.getChildElements("biochemicalLinkage");
            if (bioLinkLocants.size() <= 0) continue;
            if (bioLinkLocants.size() > 1) {
                throw new RuntimeException("OPSIN Bug: More than 1 biochemical linkage locant associated with subsituent");
            }
            bioLinkLocant = bioLinkLocants.get(0);
            String bioLinkLocantStr = bioLinkLocant.getValue();
            bioLinkLocantStr = bioLinkLocantStr.substring(1, bioLinkLocantStr.length() - 1);
            this.checkAndApplyFirstLocantOfBiochemicalLinkage(substituent, bioLinkLocantStr);
            int secondLocantStartPos = Math.max(bioLinkLocantStr.lastIndexOf(62), bioLinkLocantStr.lastIndexOf(45)) + 1;
            String locantToConnectTo = bioLinkLocantStr.substring(secondLocantStartPos);
            Element parent = substituent.getParent();
            Attribute locantAtr = new Attribute("locant", "O" + locantToConnectTo);
            Element elementAfterSubstituent = OpsinTools.getNextSibling(substituent);
            boolean hasAdjacentGroupToSubstitute = this.isSubBracketOrRoot(elementAfterSubstituent);
            boolean bracketAdded = false;
            if (hasAdjacentGroupToSubstitute) {
                Element previous = OpsinTools.getPreviousSibling(substituent);
                ArrayList<Element> previousElements = new ArrayList<Element>();
                while (previous != null && (previous.getName().equals("substituent") || previous.getName().equals("bracket"))) {
                    previousElements.add(previous);
                    previous = OpsinTools.getPreviousSibling(previous);
                }
                if (previousElements.size() > 0) {
                    Collections.reverse(previousElements);
                    GroupingEl bracket = new GroupingEl("bracket");
                    bracket.addAttribute(locantAtr);
                    int indexToInsertAt = parent.indexOf((Element)previousElements.get(0));
                    for (Element element : previousElements) {
                        element.detach();
                        ((Element)bracket).addChild(element);
                    }
                    substituent.detach();
                    ((Element)bracket).addChild(substituent);
                    parent.insertChild(bracket, indexToInsertAt);
                    brackets.add(bracket);
                    bracketAdded = true;
                    if (substituent.getAttribute("locant") != null) {
                        throw new StructureBuildingException("Substituent with biochemical linkage descriptor should not also have a locant: " + substituent.getAttributeValue("locant"));
                    }
                }
            }
            if (!bracketAdded) {
                Element elToAddAtrTo = parent.getName().equals("bracket") && !hasAdjacentGroupToSubstitute ? parent : substituent;
                if (elToAddAtrTo.getAttribute("locant") != null) {
                    throw new StructureBuildingException("Substituent with biochemical linkage descriptor should not also have a locant: " + elToAddAtrTo.getAttributeValue("locant"));
                }
                elToAddAtrTo.addAttribute(locantAtr);
            }
            bioLinkLocant.detach();
        }
        for (Element bracket : brackets) {
            bioLinkLocants = bracket.getChildElements("biochemicalLinkage");
            if (bioLinkLocants.size() <= 0) continue;
            if (bioLinkLocants.size() > 1) {
                throw new RuntimeException("OPSIN Bug: More than 1 biochemical linkage locant associated with bracket");
            }
            bioLinkLocant = bioLinkLocants.get(0);
            Element substituent = OpsinTools.getPreviousSibling(bioLinkLocant);
            if (substituent == null || !substituent.getName().equals("substituent")) {
                throw new RuntimeException("OPSIN Bug: Substituent expected before biochemical linkage locant");
            }
            String bioLinkLocantStr = bioLinkLocant.getValue();
            bioLinkLocantStr = bioLinkLocantStr.substring(1, bioLinkLocantStr.length() - 1);
            this.checkAndApplyFirstLocantOfBiochemicalLinkage(substituent, bioLinkLocantStr);
            int secondLocantStartPos = Math.max(bioLinkLocantStr.lastIndexOf(62), bioLinkLocantStr.lastIndexOf(45)) + 1;
            String locantToConnectTo = bioLinkLocantStr.substring(secondLocantStartPos);
            if (bracket.getAttribute("locant") != null) {
                throw new StructureBuildingException("Substituent with biochemical linkage descriptor should not also have a locant: " + bracket.getAttributeValue("locant"));
            }
            bracket.addAttribute(new Attribute("locant", "O" + locantToConnectTo));
            bioLinkLocant.detach();
        }
    }

    private boolean isSubBracketOrRoot(Element element) {
        return element != null && (element.getName().equals("substituent") || element.getName().equals("bracket") || element.getName().equals("root"));
    }

    private void checkAndApplyFirstLocantOfBiochemicalLinkage(Element substituent, String biochemicalLinkage) throws StructureBuildingException {
        Element group = substituent.getFirstChildElement("group");
        Fragment frag = group.getFrag();
        String firstLocant = biochemicalLinkage.substring(0, biochemicalLinkage.indexOf(45));
        if (group.getAttributeValue("type").equals("carbohydrate")) {
            Atom anomericAtom = frag.getAtomByLocantOrThrow(firstLocant);
            boolean anomericIsOutAtom = false;
            for (int i = 0; i < frag.getOutAtomCount(); ++i) {
                if (!frag.getOutAtom(i).getAtom().equals(anomericAtom)) continue;
                anomericIsOutAtom = true;
            }
            if (!anomericIsOutAtom) {
                throw new StructureBuildingException("Invalid glycoside linkage descriptor. Locant: " + firstLocant + " should point to the anomeric carbon");
            }
        } else {
            Atom positionOfPhospho = frag.getAtomByLocantOrThrow("O" + firstLocant);
            if (positionOfPhospho.getBondCount() != 1) {
                throw new StructureBuildingException(firstLocant + " should be the carbon to which a hydroxy group is attached!");
            }
            if (frag.getOutAtomCount() == 1) {
                Atom atomToConnect = frag.getOutAtom(0).getAtom();
                this.state.fragManager.createBond(positionOfPhospho, atomToConnect, 1);
            } else {
                throw new RuntimeException("OPSIN Bug: Biochemical linkage only expected on groups with 1 OutAtom");
            }
        }
        if (OpsinTools.getNextGroup(group) == null) {
            throw new StructureBuildingException("Biochemical linkage descriptor should be followed by another biochemical: " + biochemicalLinkage);
        }
    }

    private void moveSubstituentDetachableHetAtomRepl(Element substituent) throws ComponentGenerationException {
        Element child = substituent.getChild(0);
        ArrayList<Element> locantededHeteroAtomRepls = new ArrayList<Element>();
        while (child != null && child.getName().equals("heteroatom") && child.getAttribute("locant") != null) {
            locantededHeteroAtomRepls.add(child);
            child = OpsinTools.getNextSibling(child);
        }
        if (!locantededHeteroAtomRepls.isEmpty() && child != null && child.getName().equals("locant")) {
            Element rightMostGroup = null;
            Element nextSubOrRootOrBracket = OpsinTools.getNextSibling(substituent);
            while (nextSubOrRootOrBracket != null) {
                Element groupToConsider = nextSubOrRootOrBracket.getFirstChildElement("group");
                if (groupToConsider != null) {
                    rightMostGroup = groupToConsider;
                }
                nextSubOrRootOrBracket = OpsinTools.getNextSibling(nextSubOrRootOrBracket);
            }
            if (rightMostGroup == null) {
                throw new ComponentGenerationException("Unable to find group for: " + substituent.getChild(0).getValue() + " to apply to!");
            }
            Element rightMostGroupParent = rightMostGroup.getParent();
            for (int i = locantededHeteroAtomRepls.size() - 1; i >= 0; --i) {
                Element locantededHeteroAtomRepl = (Element)locantededHeteroAtomRepls.get(i);
                locantededHeteroAtomRepl.detach();
                rightMostGroupParent.insertChild(locantededHeteroAtomRepl, 0);
            }
        }
    }

    private void moveErroneouslyPositionedLocantsAndMultipliers(List<Element> brackets) {
        for (int i = brackets.size() - 1; i >= 0; --i) {
            List<Element> substituentContent;
            Element bracket = brackets.get(i);
            List<Element> childElements = bracket.getChildElements();
            boolean hyphenPresent = false;
            int childCount = childElements.size();
            if (childCount == 2) {
                for (int j = childCount - 1; j >= 0; --j) {
                    if (!childElements.get(j).getName().equals("hyphen")) continue;
                    hyphenPresent = true;
                }
            }
            if (childCount != 1 && (!hyphenPresent || childCount != 2) || (substituentContent = childElements.get(0).getChildElements()).size() < 2) continue;
            Element locant = null;
            Element multiplier = null;
            Element possibleMultiplier = substituentContent.get(0);
            if (substituentContent.get(0).getName().equals("locant")) {
                locant = substituentContent.get(0);
                possibleMultiplier = substituentContent.get(1);
            }
            if (possibleMultiplier.getName().equals("multiplier")) {
                multiplier = possibleMultiplier;
            }
            if (locant != null) {
                if (multiplier != null && locant.getValue().split(",").length != Integer.parseInt(multiplier.getAttributeValue("value"))) continue;
                locant.detach();
                OpsinTools.insertBefore(childElements.get(0), locant);
            }
            if (multiplier == null) continue;
            multiplier.detach();
            OpsinTools.insertBefore(childElements.get(0), multiplier);
        }
    }

    private void addImplicitBracketsWhenFirstSubstituentHasTwoMultipliers(Element substituent, List<Element> brackets) {
        Element child;
        if (!substituent.getName().equals("substituent")) {
            return;
        }
        ArrayList<Element> multipliers = new ArrayList<Element>();
        int len = substituent.getChildCount();
        for (int i = 0; i < len && (child = substituent.getChild(i)).getName().equals("multiplier"); ++i) {
            multipliers.add(child);
        }
        if (multipliers.size() != 2) {
            return;
        }
        GroupingEl bracket = new GroupingEl("bracket");
        bracket.addAttribute(new Attribute("type", "implicit"));
        Element parent = substituent.getParent();
        List<Element> elsToAddToBracket = parent.getChildElements();
        Element wordMultiplier = (Element)multipliers.get(0);
        wordMultiplier.detach();
        ((Element)bracket).addChild(wordMultiplier);
        for (Element el : elsToAddToBracket) {
            el.detach();
            ((Element)bracket).addChild(el);
        }
        parent.addChild(bracket);
        brackets.add(bracket);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assignLocantsToMultipliedRootIfPresent(Element rightMostElement) throws ComponentGenerationException, StructureBuildingException {
        List<Element> multipliers = rightMostElement.getChildElements("multiplier");
        if (multipliers.size() == 1) {
            Element multiplier = multipliers.get(0);
            if (OpsinTools.getPrevious(multiplier) == null) {
                throw new StructureBuildingException("OPSIN bug: Unacceptable input to function");
            }
            List<Element> locants = rightMostElement.getChildElements("multiplicativeLocant");
            if (locants.size() > 1) {
                throw new ComponentGenerationException("OPSIN bug: Only none or one multiplicative locant expected");
            }
            int multiVal = Integer.parseInt(multiplier.getAttributeValue("value"));
            if (locants.isEmpty()) {
                rightMostElement.addAttribute(new Attribute("inLocants", "default"));
                return;
            } else {
                Element locantEl = locants.get(0);
                String[] locantValues = locantEl.getValue().split(",");
                if (locantValues.length != multiVal) throw new ComponentGenerationException("Mismatch between number of locants and number of roots");
                rightMostElement.addAttribute(new Attribute("inLocants", locantEl.getValue()));
                locantEl.detach();
            }
            return;
        } else {
            if (!rightMostElement.getName().equals("bracket")) return;
            this.assignLocantsToMultipliedRootIfPresent(rightMostElement.getChild(rightMostElement.getChildCount() - 1));
        }
    }

    private void addImplicitBracketsWhenSubstituentHasTwoLocants(Element substituent, List<Element> brackets) {
        List<Element> locants;
        Element siblingSubstituent = OpsinTools.getNextSibling(substituent);
        if (siblingSubstituent != null && siblingSubstituent.getName().equals("substituent") && (locants = this.getLocantsAtStartOfSubstituent(substituent)).size() == 2 && this.locantsAreSingular(locants) && this.getLocantsAtStartOfSubstituent(siblingSubstituent).isEmpty()) {
            GroupingEl bracket = new GroupingEl("bracket");
            bracket.addAttribute(new Attribute("type", "implicit"));
            Element parent = substituent.getParent();
            int indexToInsertAt = parent.indexOf(substituent);
            int elementsToMove = substituent.indexOf(locants.get(0)) + 1;
            for (int i = 0; i < elementsToMove; ++i) {
                Element locantOrStereoToMove = substituent.getChild(0);
                locantOrStereoToMove.detach();
                ((Element)bracket).addChild(locantOrStereoToMove);
            }
            substituent.detach();
            siblingSubstituent.detach();
            ((Element)bracket).addChild(substituent);
            ((Element)bracket).addChild(siblingSubstituent);
            parent.insertChild(bracket, indexToInsertAt);
            brackets.add(bracket);
        }
    }

    private List<Element> getLocantsAtStartOfSubstituent(Element substituent) {
        ArrayList<Element> locants = new ArrayList<Element>();
        int len = substituent.getChildCount();
        for (int i = 0; i < len; ++i) {
            Element child = substituent.getChild(i);
            String currentElementName = child.getName();
            if (currentElementName.equals("locant")) {
                locants.add(child);
                continue;
            }
            if (!currentElementName.equals("stereoChemistry")) break;
        }
        return locants;
    }

    private boolean locantsAreSingular(List<Element> locants) {
        for (Element locant : locants) {
            if (locant.getValue().split(",").length <= 1) continue;
            return false;
        }
        return true;
    }

    private void assignLocantsAndMultipliers(Element subOrBracket) throws ComponentGenerationException, StructureBuildingException {
        List<Element> locants = subOrBracket.getChildElements("locant");
        int multiplier = 1;
        List<Element> multipliers = subOrBracket.getChildElements("multiplier");
        Element parentElem = subOrBracket.getParent();
        boolean oneBelowWordLevel = parentElem.getName().equals("word");
        Element groupIfPresent = subOrBracket.getFirstChildElement("group");
        if (multipliers.size() > 0) {
            if (multipliers.size() > 1) {
                throw new ComponentGenerationException(subOrBracket.getName() + " has multiple multipliers, unable to determine meaning!");
            }
            if (oneBelowWordLevel && OpsinTools.getNextSibling(subOrBracket) == null && OpsinTools.getPreviousSibling(subOrBracket) == null) {
                return;
            }
            multiplier = Integer.parseInt(multipliers.get(0).getAttributeValue("value"));
            subOrBracket.addAttribute(new Attribute("multiplier", multipliers.get(0).getAttributeValue("value")));
            if (groupIfPresent != null && "perhalogeno".equals(groupIfPresent.getAttributeValue("subType"))) {
                throw new StructureBuildingException(groupIfPresent.getValue() + " cannot be multiplied");
            }
        }
        if (locants.size() > 0) {
            if (multiplier == 1 && oneBelowWordLevel && OpsinTools.getPreviousSibling(subOrBracket) == null && this.wordLevelLocantsAllowed(subOrBracket, locants.size())) {
                Element locant = locants.remove(0);
                if (locant.getValue().split(",").length != 1) {
                    throw new ComponentGenerationException("Multiplier and locant count failed to agree; All locants could not be assigned!");
                }
                parentElem.addAttribute(new Attribute("locant", locant.getValue()));
                locant.detach();
                if (locants.isEmpty()) {
                    return;
                }
            }
            if (subOrBracket.getName().equals("root")) {
                this.locantsToDebugString(locants);
                throw new ComponentGenerationException(this.locantsToDebugString(locants));
            }
            if (locants.size() != 1) {
                throw new ComponentGenerationException(this.locantsToDebugString(locants));
            }
            Element locantEl = locants.get(0);
            String[] locantValues = locantEl.getValue().split(",");
            if (multiplier != locantValues.length) {
                throw new ComponentGenerationException("Multiplier and locant count failed to agree; All locants could not be assigned!");
            }
            Element parent = subOrBracket.getParent();
            if (!(parent.getName().equals("word") && parent.getAttributeValue("type").equals(WordType.full.toString()) && this.state.currentWordRule.equals((Object)WordRule.carbonylDerivative))) {
                List<Element> children = parent.getChildElements();
                boolean foundSomethingToSubstitute = false;
                for (int i = parent.indexOf(subOrBracket) + 1; i < children.size(); ++i) {
                    if (children.get(i).getName().equals("hyphen")) continue;
                    foundSomethingToSubstitute = true;
                }
                if (!foundSomethingToSubstitute) {
                    throw new ComponentGenerationException(this.locantsToDebugString(locants));
                }
            }
            if (groupIfPresent != null && "perhalogeno".equals(groupIfPresent.getAttributeValue("subType"))) {
                throw new StructureBuildingException(groupIfPresent.getValue() + " cannot be locanted");
            }
            subOrBracket.addAttribute(new Attribute("locant", locantEl.getValue()));
            locantEl.detach();
        }
    }

    private String locantsToDebugString(List<Element> locants) {
        StringBuilder message = new StringBuilder("Unable to assign all locants. ");
        message.append(locants.size() > 1 ? "These locants " : "This locant ");
        message.append(locants.size() > 1 ? "were " : "was ");
        message.append("not assigned: ");
        for (Element locant : locants) {
            message.append(locant.getValue());
            message.append(" ");
        }
        return message.toString();
    }

    private boolean wordLevelLocantsAllowed(Element subBracketOrRoot, int numberOflocants) {
        Element wordRule;
        List<Element> words;
        Element ateWord;
        Element parentElem = subBracketOrRoot.getParent();
        if (!(WordType.valueOf(parentElem.getAttributeValue("type")) != WordType.substituent || OpsinTools.getNextSibling(subBracketOrRoot) != null && numberOflocants < 2 || this.state.currentWordRule != WordRule.ester && this.state.currentWordRule != WordRule.functionalClassEster && this.state.currentWordRule != WordRule.multiEster && this.state.currentWordRule != WordRule.acetal)) {
            return true;
        }
        if ((this.state.currentWordRule == WordRule.potentialAlcoholEster || this.state.currentWordRule == WordRule.amineDiConjunctiveSuffix || this.state.currentWordRule == WordRule.ester && (OpsinTools.getNextSibling(subBracketOrRoot) == null || numberOflocants >= 2)) && parentElem.getName().equals("word") && parentElem == (ateWord = (words = (wordRule = parentElem.getParent()).getChildElements("word")).get(words.size() - 1))) {
            return true;
        }
        return this.state.currentWordRule == WordRule.acidReplacingFunctionalGroup && parentElem.getName().equals("word") && (OpsinTools.getNextSibling(subBracketOrRoot) == null || numberOflocants >= 2) && parentElem.getParent().indexOf(parentElem) > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processWordLevelMultiplierIfApplicable(Element word, List<Element> roots, int wordCount) throws StructureBuildingException, ComponentGenerationException {
        if (word.getChildCount() == 1) {
            int i;
            Element firstSubBrackOrRoot = word.getChild(0);
            Element multiplier = firstSubBrackOrRoot.getFirstChildElement("multiplier");
            if (multiplier == null) return;
            int multiVal = Integer.parseInt(multiplier.getAttributeValue("value"));
            List<Element> locants = firstSubBrackOrRoot.getChildElements("locant");
            boolean assignLocants = false;
            boolean wordLevelLocants = this.wordLevelLocantsAllowed(firstSubBrackOrRoot, locants.size());
            if (locants.size() > 1) {
                throw new ComponentGenerationException("Unable to assign all locants");
            }
            String[] locantValues = null;
            if (locants.size() == 1) {
                locantValues = locants.get(0).getValue().split(",");
                if (locantValues.length != multiVal) throw new ComponentGenerationException("Unable to assign all locants");
                assignLocants = true;
                locants.get(0).detach();
                if (!wordLevelLocants) throw new ComponentGenerationException(this.locantsToDebugString(locants));
                word.addAttribute(new Attribute("locant", locantValues[0]));
            }
            this.checkForNonConfusedWithNona(multiplier);
            if (wordCount == 1 && !this.isMonoFollowedByElement(multiplier, multiVal)) {
                throw new StructureBuildingException("Unexpected multiplier found at start of word. Perhaps the name is trivial e.g. triphosgene");
            }
            if (multiVal == 1) {
                return;
            }
            ArrayList<Element> elementsNotToBeMultiplied = new ArrayList<Element>();
            for (i = firstSubBrackOrRoot.indexOf(multiplier) - 1; i >= 0; --i) {
                Element el = firstSubBrackOrRoot.getChild(i);
                el.detach();
                elementsNotToBeMultiplied.add(el);
            }
            multiplier.detach();
            for (i = multiVal - 1; i >= 1; --i) {
                Element clone = this.state.fragManager.cloneElement(this.state, word);
                if (assignLocants) {
                    clone.getAttribute("locant").setValue(locantValues[i]);
                }
                OpsinTools.insertAfter(word, clone);
            }
            for (Element el : elementsNotToBeMultiplied) {
                firstSubBrackOrRoot.insertChild(el, 0);
            }
            return;
        } else {
            if (roots.size() != 1 || OpsinTools.getDescendantElementsWithTagName(roots.get(0), "fractionalMultiplier").size() <= 0) return;
            throw new StructureBuildingException("Unexpected fractional multiplier found within chemical name");
        }
    }

    private void checkForNonConfusedWithNona(Element multiplier) throws StructureBuildingException {
        if (multiplier.getValue().equals("non")) {
            String subsequentUnsemanticToken = multiplier.getAttributeValue("subsequentUnsemanticToken");
            if (subsequentUnsemanticToken != null && subsequentUnsemanticToken.toLowerCase(Locale.ROOT).startsWith("a")) {
                return;
            }
            throw new StructureBuildingException("\"non\" probably means \"not\". If a multiplier of value 9 was intended \"nona\" should be used");
        }
    }

    private boolean isMonoFollowedByElement(Element multiplier, int multiVal) {
        Element possibleElement;
        return multiVal == 1 && (possibleElement = OpsinTools.getNextSibling(multiplier)) != null && possibleElement.getName().equals("group") && ("elementaryAtom".equals(possibleElement.getAttributeValue("type")) || possibleElement.getValue().equals("hydrogen"));
    }

    static {
        specialHWRings.put("oxin", new String[]{"blocked"});
        specialHWRings.put("azin", new String[]{"blocked"});
        specialHWRings.put("selenin", new String[]{"not_icacid", "Se", "C", "C", "C", "C", "C"});
        specialHWRings.put("tellurin", new String[]{"not_icacid", "Te", "C", "C", "C", "C", "C"});
        specialHWRings.put("thiol", new String[]{"not_nothingOrOlate", "S", "C", "C", "C", "C"});
        specialHWRings.put("selenol", new String[]{"not_nothingOrOlate", "Se", "C", "C", "C", "C"});
        specialHWRings.put("tellurol", new String[]{"not_nothingOrOlate", "Te", "C", "C", "C", "C"});
        specialHWRings.put("oxazol", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazol", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazol", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazol", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxazolidin", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazolidin", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazolidin", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazolidin", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxazolid", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazolid", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazolid", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazolid", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxazolin", new String[]{"", "O", "C", "N", "C", "C"});
        specialHWRings.put("thiazolin", new String[]{"", "S", "C", "N", "C", "C"});
        specialHWRings.put("selenazolin", new String[]{"", "Se", "C", "N", "C", "C"});
        specialHWRings.put("tellurazolin", new String[]{"", "Te", "C", "N", "C", "C"});
        specialHWRings.put("oxoxolan", new String[]{"", "O", "C", "O", "C", "C"});
        specialHWRings.put("oxoxol", new String[]{"", "O", "C", "O", "C", "C"});
        specialHWRings.put("oxoxan", new String[]{"", "O", "C", "C", "O", "C", "C"});
        specialHWRings.put("oxoxin", new String[]{"", "O", "C", "C", "O", "C", "C"});
        specialHWRings.put("boroxin", new String[]{"saturated", "O", "B", "O", "B", "O", "B"});
        specialHWRings.put("borazin", new String[]{"saturated", "N", "B", "N", "B", "N", "B"});
        specialHWRings.put("borthiin", new String[]{"saturated", "S", "B", "S", "B", "S", "B"});
    }

    private static class SortBridgesByHighestLocantedBridgehead
    implements Comparator<Fragment> {
        private final Map<Fragment, Atom[]> bridgeToRingAtoms;

        SortBridgesByHighestLocantedBridgehead(Map<Fragment, Atom[]> bridgeToRingAtoms) {
            this.bridgeToRingAtoms = bridgeToRingAtoms;
        }

        @Override
        public int compare(Fragment bridge1, Fragment bridge2) {
            Atom[] ringAtoms2;
            int bridge2HighestRingLocant;
            Atom[] ringAtoms1 = this.bridgeToRingAtoms.get(bridge1);
            int bridge1HighestRingLocant = Math.max(ComponentProcessor.getLocantNumber(ringAtoms1[0]), ComponentProcessor.getLocantNumber(ringAtoms1[1]));
            if (bridge1HighestRingLocant > (bridge2HighestRingLocant = Math.max(ComponentProcessor.getLocantNumber((ringAtoms2 = this.bridgeToRingAtoms.get(bridge2))[0]), ComponentProcessor.getLocantNumber(ringAtoms2[1])))) {
                return -1;
            }
            if (bridge1HighestRingLocant < bridge2HighestRingLocant) {
                return 1;
            }
            return 0;
        }
    }

    private static class AddBond {
        private final int bondOrder;
        private AtomReference atomReference;

        AddBond(int bondOrder, AtomReference atomReference) {
            this.bondOrder = bondOrder;
            this.atomReference = atomReference;
        }
    }

    private static class AddHeteroatom {
        private final String heteroAtomSmiles;
        private AtomReference atomReference;

        AddHeteroatom(String heteroAtomSmiles, AtomReference atomReference) {
            this.heteroAtomSmiles = heteroAtomSmiles;
            this.atomReference = atomReference;
        }
    }

    private static class AddGroup {
        private final Fragment frag;
        private AtomReference atomReference;

        AddGroup(Fragment frag, AtomReference atomReference) {
            this.frag = frag;
            this.atomReference = atomReference;
        }
    }

    private static class AtomReference {
        private final AtomReferenceType referenceType;
        private final String reference;

        AtomReference(AtomReferenceType referenceType, String reference) {
            this.referenceType = referenceType;
            this.reference = reference;
        }
    }

    private static enum AtomReferenceType {
        ID,
        DEFAULTID,
        LOCANT,
        DEFAULTLOCANT;

    }
}

