/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.AtomParity;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.IndentingXMLStreamWriter;
import uk.ac.cam.ch.wwmm.opsin.StereoGroup;
import uk.ac.cam.ch.wwmm.opsin.StereoGroupType;

class CMLWriter {
    static final String CML_NAMESPACE = "http://www.xml-cml.org/schema";
    private static final XMLOutputFactory factory = new WstxOutputFactory();
    private final XMLStreamWriter writer;

    CMLWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    static String generateCml(Fragment structure, String chemicalName) {
        return CMLWriter.generateCml(structure, chemicalName, false);
    }

    static String generateIndentedCml(Fragment structure, String chemicalName) {
        return CMLWriter.generateCml(structure, chemicalName, true);
    }

    private static String generateCml(Fragment structure, String chemicalName, boolean indent) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(out, "UTF-8");
            if (indent) {
                xmlWriter = new IndentingXMLStreamWriter(xmlWriter, 2);
            }
            CMLWriter cmlWriter = new CMLWriter(xmlWriter);
            cmlWriter.writeCmlStart();
            cmlWriter.writeMolecule(structure, chemicalName, 1);
            cmlWriter.writeCmlEnd();
            xmlWriter.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM doesn't support UTF-8...but it should do!");
        }
    }

    void writeCmlStart() {
        try {
            this.writer.writeStartElement("cml");
            this.writer.writeDefaultNamespace(CML_NAMESPACE);
            this.writer.writeAttribute("convention", "conventions:molecular");
            this.writer.writeNamespace("conventions", "http://www.xml-cml.org/convention/");
            this.writer.writeNamespace("cmlDict", "http://www.xml-cml.org/dictionary/cml/");
            this.writer.writeNamespace("nameDict", "http://www.xml-cml.org/dictionary/cml/name/");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    void writeCmlEnd() {
        try {
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    void writeMolecule(Fragment structure, String chemicalName, int id) throws XMLStreamException {
        this.writer.writeStartElement("molecule");
        this.writer.writeAttribute("id", "m" + id);
        this.writer.writeStartElement("name");
        this.writer.writeAttribute("dictRef", "nameDict:unknown");
        this.writer.writeCharacters(chemicalName);
        this.writer.writeEndElement();
        if (structure != null) {
            this.writer.writeStartElement("atomArray");
            for (Atom atom : structure) {
                this.writeAtom(atom);
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement("bondArray");
            for (Bond bond : structure.getBondSet()) {
                this.writeBond(bond);
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private void writeAtom(Atom atom) throws XMLStreamException {
        StereoGroupType stereoGroupType;
        AtomParity atomParity;
        this.writer.writeStartElement("atom");
        this.writer.writeAttribute("id", "a" + Integer.toString(atom.getID()));
        this.writer.writeAttribute("elementType", atom.getElement().toString());
        if (atom.getCharge() != 0) {
            this.writer.writeAttribute("formalCharge", Integer.toString(atom.getCharge()));
        }
        if (atom.getIsotope() != null) {
            this.writer.writeAttribute("isotopeNumber", Integer.toString(atom.getIsotope()));
        }
        if (atom.getElement() != ChemEl.H) {
            int hydrogenCount = 0;
            List<Atom> neighbours = atom.getAtomNeighbours();
            for (Atom neighbour : neighbours) {
                if (neighbour.getElement() != ChemEl.H) continue;
                ++hydrogenCount;
            }
            if (hydrogenCount == 0) {
                this.writer.writeAttribute("hydrogenCount", "0");
            }
        }
        if ((atomParity = atom.getAtomParity()) != null && ((stereoGroupType = atomParity.getStereoGroup().getType()) != StereoGroupType.Rac && stereoGroupType != StereoGroupType.Rel || this.countStereoGroup(atom) != 1)) {
            this.writeAtomParity(atomParity);
        }
        for (String locant : atom.getLocants()) {
            this.writer.writeStartElement("label");
            this.writer.writeAttribute("value", locant);
            this.writer.writeAttribute("dictRef", "cmlDict:locant");
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private int countStereoGroup(Atom atom) {
        StereoGroup refGroup = atom.getAtomParity().getStereoGroup();
        int count = 0;
        for (Atom a : atom.getFrag()) {
            AtomParity atomParity = a.getAtomParity();
            if (atomParity == null || !atomParity.getStereoGroup().equals(refGroup)) continue;
            ++count;
        }
        return count;
    }

    private void writeAtomParity(AtomParity atomParity) throws XMLStreamException {
        this.writer.writeStartElement("atomParity");
        this.writeAtomRefs4(atomParity.getAtomRefs4());
        this.writer.writeCharacters(Integer.toString(atomParity.getParity()));
        this.writer.writeEndElement();
    }

    private void writeBond(Bond bond) throws XMLStreamException {
        this.writer.writeStartElement("bond");
        this.writer.writeAttribute("id", "a" + Integer.toString(bond.getFrom()) + "_a" + Integer.toString(bond.getTo()));
        this.writer.writeAttribute("atomRefs2", "a" + Integer.toString(bond.getFrom()) + " a" + Integer.toString(bond.getTo()));
        switch (bond.getOrder()) {
            case 1: {
                this.writer.writeAttribute("order", "S");
                break;
            }
            case 2: {
                this.writer.writeAttribute("order", "D");
                break;
            }
            case 3: {
                this.writer.writeAttribute("order", "T");
                break;
            }
            default: {
                this.writer.writeAttribute("order", "unknown");
            }
        }
        BondStereo bondStereo = bond.getBondStereo();
        if (bondStereo != null) {
            this.writeBondStereo(bondStereo);
        }
        this.writer.writeEndElement();
    }

    private void writeBondStereo(BondStereo bondStereo) throws XMLStreamException {
        this.writer.writeStartElement("bondStereo");
        this.writeAtomRefs4(bondStereo.getAtomRefs4());
        this.writer.writeCharacters(bondStereo.getBondStereoValue().toString());
        this.writer.writeEndElement();
    }

    private void writeAtomRefs4(Atom[] atomRefs4) throws XMLStreamException {
        StringBuilder atomRefsSb = new StringBuilder();
        for (int i = 0; i < atomRefs4.length - 1; ++i) {
            atomRefsSb.append('a');
            atomRefsSb.append(atomRefs4[i].getID());
            atomRefsSb.append(' ');
        }
        atomRefsSb.append('a');
        atomRefsSb.append(atomRefs4[atomRefs4.length - 1].getID());
        this.writer.writeAttribute("atomRefs4", atomRefsSb.toString());
    }

    static {
        factory.setProperty("com.ctc.wstx.outputEscapeCr", false);
    }
}

