# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ccautils']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil>=2.8.1,<3.0.0', 'toml>=0.10.0,<0.11.0']

setup_kwargs = {
    'name': 'ccautils',
    'version': '0.4.1',
    'description': 'A set of useful utilities for python programs',
    'long_description': '[![Tests](https://github.com/ccdale/ccautils/workflows/Tests/badge.svg)](https://github.com/ccdale/ccautils/actions?workflow=Tests)\n[![Codecov](https://codecov.io/gh/ccdale/ccautils/branch/master/graph/badge.svg)](https://codecov.io/gh/ccdale/ccautils)\n[![Python](https://img.shields.io/pypi/pyversions/ccautils)](https://pypi.org/project/ccautils/)\n[![PyPI](https://img.shields.io/pypi/v/ccautils)](https://pypi.org/project/ccautils/)\n# ccautils\n\na set of utilities for python3.6+ programs and scripts.\n\n<a name=headdd></a>\n* [Install](#install)\n* [Development](#devel)\n* [Testing](#testing)\n* [Error Utilities](#errors)\n* [Miscellaneous Utilities](#utils)\n    * [Usage](#uusage)\n* [File Utilities](#futils)\n    * [Usage](#fusage)\n\n\n<a name=install></a>\n## [Install](#headdd)\n\nInstall for the user:\n```\npip3 install ccautils --user\n```\n\nInstall for a virtual environment:\n```\npip install ccautils\n```\n\n<a name=devel></a>\n## [Development](#headdd)\n\nI use [poetry](https://python-poetry.org/) to manage these utilities.\nClone this repository and install `poetry`, then install the dependancies.\n\n```\ngit clone https://github.com/ccdale/ccautils.git\ncd ccautils\npoetry install\n```\n\n<a name=testing></a>\n## [Testing](#headdd)\nTo run the tests you must have `pytest`, `nox` and `poetry` installed.\n\ninstall nox into your python user environment.\n```\npip install nox --user\n```\n\nRun the tests with\n\n```\nnox -rs tests\n```\n\nRun the linter with\n\n```\nnox -rs lint\n```\n\nRun the console ask tests with\n\n```\nnox -rs tests -- -sm ask\n```\n\n<a name=errors></a>\n## Error Utilities(#headdd)\n\nSee the [code](https://github.com/ccdale/ccautils) for how to use these\nException helpers.\n\n\n<a name=utils></a>\n## [Miscellaneous Utilities](#headdd)\n\n<a name=uusage></a>\n### [Usage](#headdd)\n\n```\nimport ccautils.utils as UT\n```\n\n<a name=menu></a>\n* [addToString](#addtostring)\n* [delimitString](#delimitstring)\n* [makeDictFromString](#makedictfromstring)\n* [askMe](#askme)\n* [padStr](#padstr)\n* [reduceTime](#reducetime)\n* [displayValue](#displayvalue)\n* [secondsFromHMS](#secondsfromhms)\n* [hms](#hms)\n\n<a name=addtostring></a>\n### [addToString(xstr, xadd)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L26)\n\nReturns a string with `xadd` appended to `xstr`.  If `xadd` is a list, all\n`str` members of the list will be appended in order.\n\n```\nUT.addToString("hello", [" ", "world"])\n\n> "hello world"\n```\n\n<a name=delimitstring></a>\n### [delimitString(xstr, delimeter=" - ")](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L49)\n\n`xstr` can be a list or a string.  If it is a string, it is spit apart at\nspaces and delimeted with `delimeter`.  If it is a list, each member is\ndelimeted with `delimeter`.\n\n```\nUT.delimitString(["bright", "world"], " ")\n\n> "bright world"\n\nUT.delimitString("I wandered lonely as an artichoke", ".")\n\n> "I.wandered.lonely.as.an.artichoke"\n```\n\n<a name=makedictfromstring></a>\n### [makeDictFromString(istr)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L64)\n\nConstructs a dictionary from a string of parameters. Leading and trailing\nwhitespace is stripped.\n\n`istr` should be in the form `someparam=somevalue,someotherparam=otherval`\n\n```\nUT.makeDictFromString("sparam=sval, soparam = soval")\n\n> {"sparam": "sval", "soparam": "soval"}\n```\n\n<a name=askme></a>\n### [askMe(q, default)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L89)\n\nRequests input from the user.  Poses the question `q`. Returns the users\ninput or `default` if no input given.\n\n```\nUT.askMe("press 5, please", "8")\n\n> press 5, please: 5\n> 5\n```\n\n<a name=padstr></a>\n### [padStr(xstr, xlen=2, pad=" ", padleft=True)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L101)\n\nReturns `xstr` `pad`ded to the required length, either on the\nleft (`padleft` is True) or the right (`padleft` is False)\n\n```\nUT.padStr("23", 5, "0")\n\n> "00023"\n```\n\n<a name=reducetime></a>\n### [reduceTime(unit, secs)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L115)\n\nDivides `secs` by `unit` returning a tuple of (`units`, `remainder`)\n\nRaises a `ValueError` if `unit` is zero.\n\n```\nUT.reduceTime(3600, 3700)\n\n> (1, 100)\n```\n\n<a name=displayvalue></a>\n### [displayValue(val, label, zero=True)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L131)\n\nPluralises `label` if `val` > 1 or `val` is 0.\n\nWill return an empty string if `val` == 0 and `zero` == True\n\n```\nUT.displayValue(12, "table")\n\n> "12 tables"\n```\n\n<a name=secondsfromhms></a>\n### [secondsFromHMS(shms)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L142)\n\nconverts HMS strings into integer seconds\n\n```\nUT.secondsFromHMS("01:01:23.43")\n# 1 hour, 1 minute, 23 seconds + 0.43 second\n\n> 3683\n```\n\n<a name=hms></a>\n### [hms(secs, small=True, short=True, single=False, colons=False)](#menu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/utils.py#L214)\n\nConvert `secs` to days, hours, minutes and seconds\n\nif `small` is True then only return the higher values if they are > zero\n\nif `short` is True then the labels are their short form\n\nif `single` is True then the labels are single letters\n\nif `colons` is True then the output is of the form `01:03:23`\n\n```\nUT.hms(67)\n\n> "1 min and 7 secs"\n\nUT.hms(67, short=False)\n\n> "1 minute and 7 seconds"\n\nUT.hms(67, small=False, short=False)\n\n> "0 days, 0 hours, 1 minute and 7 seconds"\n\nsecs = 86400 + 7200 + 300 + 34\nUT.hms(secs, single=True)\n\n> "1d 2h 5m 34s"\n\nsecs = 345\nUT.hms(secs, colons=True)\n\n> "05:45"\n\nsecs = 86400 + 7200 + 300 + 34\nUT.hms(secs, colons=True)\n\n> "01:02:05:34"\n```\n\n<a name=futils></a>\n## [File Utilities](#headdd)\n\n<a name=fusage></a>\n### [Usage](#headdd)\n\n```\nimport ccautils.fileutils as FT\n```\n\n<a name=fmenu></a>\n* [fileExists](#fileexists)\n* [dirExists](#direxists)\n* [dfExists](#dfexists)\n* [makePath](#makepath)\n\n<a name=fileexists></a>\n### [fileExists(fqfn)](#fmenu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/fileutils.py#L30)\n\nTests for the existence of the fully-qualified (absolute) file name `fqfn`\n\nReturns: `True` if `fqfn` exists, else `False`\n\n```\nfn = "/home/chris/output.csv"\nif FT.fileExists(fn):\n    # do something\nelse:\n    raise(f"File {fn} does not exist")\n```\n\n<a name=direxists></a>\n### [dirExists(fqdn)](#fmenu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/fileutils.py#L38)\n\nTests for the existence of the fully-qualified (absolute) directory name `fqdn`\n\nReturns: `True` if `fqdn` exists, else `False`\n\n```\ndn = "/home/chris"\nif FT.dirExists(dn):\n    # do something\nelse:\n    raise(f"Directory {dn} does not exist")\n```\n\n<a name=dfexists></a>\n### [dfExists(fqdfn)](#fmenu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/fileutils.py#L46)\n\nTests to see if the file `fqdfn` exists, if not checks if `fqdfn` is\na directory that exists.\n\nReturns: `True` if `fqdfn` exists, else `False`\n\n```\ndn = "/home/chris"\nif FT.dfExists(dn):\n    # do something\nelse:\n    raise(f"File / Directory {dn} does not exist")\n```\n\n<a name=makepath></a>\n### [makePath(pn)](#fmenu)\n\n[Code](https://github.com/ccdale/ccautils/blob/master/ccautils/fileutils.py#L57)\n\nMakes the path `pn` including any missing parent directories.  Does\nnothing if path `pn` already exists.\n\nReturns: None\n```\ndn = "/home/chris/appdir/subdir"\nFT.makePath(dn)\n```\n\n\n[modeline]: # ( vim: set ft=markdown tw=74 fenc=utf-8 spell spl=en_gb mousemodel=popup: )\n',
    'author': 'ccdale',
    'author_email': 'chris.charles.allison+ccautils@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
