"use strict";
const assert_1 = require("@aws-cdk/assert");
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'basic usage'(test) {
        // GIVEN
        const { stack } = util_1.testFixtureNoVpc();
        const cluster = new lib_1.Cluster(stack, 'cluster');
        const manifest = [
            {
                apiVersion: 'v1',
                kind: 'Service',
                metadata: {
                    name: 'hello-kubernetes',
                },
                spec: {
                    type: 'LoadBalancer',
                    ports: [
                        { port: 80, targetPort: 8080 }
                    ],
                    selector: {
                        app: 'hello-kubernetes'
                    }
                }
            },
            {
                apiVersion: 'apps/v1',
                kind: 'Deployment',
                metadata: {
                    name: 'hello-kubernetes'
                },
                spec: {
                    replicas: 2,
                    selector: {
                        matchLabels: {
                            app: 'hello-kubernetes'
                        }
                    },
                    template: {
                        metadata: {
                            labels: {
                                app: 'hello-kubernetes'
                            }
                        },
                        spec: {
                            containers: [
                                {
                                    name: 'hello-kubernetes',
                                    image: 'paulbouwer/hello-kubernetes:1.5',
                                    ports: [
                                        { containerPort: 8080 }
                                    ]
                                }
                            ]
                        }
                    }
                }
            }
        ];
        // WHEN
        new lib_1.KubernetesResource(stack, 'manifest', {
            cluster,
            manifest
        });
        assert_1.expect(stack).to(assert_1.haveResource(lib_1.KubernetesResource.RESOURCE_TYPE, {
            Manifest: JSON.stringify(manifest)
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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