"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resources = [
    {
        apiVersion: 'v1',
        kind: 'Service',
        metadata: { name: 'hello-kubernetes' },
        spec: {
            type: 'LoadBalancer',
            ports: [{ port: 80, targetPort: 8080 }],
            selector: { app: 'hello-kubernetes' }
        }
    },
    {
        apiVersion: 'apps/v1',
        kind: 'Deployment',
        metadata: { name: 'hello-kubernetes' },
        spec: {
            replicas: 1,
            selector: { matchLabels: { app: 'hello-kubernetes' } },
            template: {
                metadata: {
                    labels: { app: 'hello-kubernetes' }
                },
                spec: {
                    containers: [
                        {
                            name: 'hello-kubernetes',
                            image: 'paulbouwer/hello-kubernetes:1.5',
                            ports: [{ containerPort: 8080 }]
                        }
                    ]
                }
            }
        }
    }
];
//# sourceMappingURL=data:application/json;base64,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