# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-07-05 17:02
from __future__ import unicode_literals

import django.db.models.deletion
import filebrowser.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('crm', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='TemplateSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('organisationname', models.CharField(max_length=200, verbose_name='Name of the Organisation')),
                ('title', models.CharField(max_length=100, verbose_name='Title')),
                ('logo', filebrowser.fields.FileBrowseField(blank=True, max_length=200, null=True,
                                                            verbose_name='Logo for the PDF generation')),
                ('bankingaccountref',
                 models.CharField(blank=True, max_length=60, null=True, verbose_name='Reference to Banking Account')),
                ('addresser', models.CharField(blank=True, max_length=200, null=True, verbose_name='Addresser')),
                ('fopConfigurationFile', filebrowser.fields.FileBrowseField(blank=True, max_length=200, null=True,
                                                                            verbose_name='FOP Configuration File')),
                ('footerTextsalesorders',
                 models.TextField(blank=True, null=True, verbose_name='Footer Text On Salesorders')),
                ('headerTextsalesorders',
                 models.TextField(blank=True, null=True, verbose_name='Header Text On Salesorders')),
                ('headerTextpurchaseorders',
                 models.TextField(blank=True, null=True, verbose_name='Header Text On Purchaseorders')),
                ('footerTextpurchaseorders',
                 models.TextField(blank=True, null=True, verbose_name='Footer Text On Purchaseorders')),
                ('pagefooterleft',
                 models.CharField(blank=True, max_length=40, null=True, verbose_name='Page Footer Left')),
                ('pagefootermiddle',
                 models.CharField(blank=True, max_length=40, null=True, verbose_name='Page Footer Middle')),
            ],
            options={
                'verbose_name': 'Templateset',
                'verbose_name_plural': 'Templatesets',
            },
        ),
        migrations.CreateModel(
            name='UserExtension',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('defaultCurrency', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.Currency')),
                ('defaultTemplateSet',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djangoUserExtension.TemplateSet')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'User Extention',
                'verbose_name_plural': 'User Extentions',
            },
        ),
        migrations.CreateModel(
            name='UserExtensionEmailAddress',
            fields=[
                ('emailaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.EmailAddress')),
                ('purpose', models.CharField(
                    choices=[('H', 'Private'), ('O', 'Business'), ('P', 'Mobile Private'), ('B', 'Mobile Business')],
                    max_length=1, verbose_name='Purpose')),
                ('userExtension', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                    to='djangoUserExtension.UserExtension')),
            ],
            options={
                'verbose_name': 'Email Address for User Extention',
                'verbose_name_plural': 'Email Address for User Extention',
            },
            bases=('crm.emailaddress',),
        ),
        migrations.CreateModel(
            name='UserExtensionPhoneAddress',
            fields=[
                ('phoneaddress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PhoneAddress')),
                ('purpose', models.CharField(
                    choices=[('H', 'Private'), ('O', 'Business'), ('P', 'Mobile Private'), ('B', 'Mobile Business')],
                    max_length=1, verbose_name='Purpose')),
                ('userExtension', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                    to='djangoUserExtension.UserExtension')),
            ],
            options={
                'verbose_name': 'Phonenumber for User Extention',
                'verbose_name_plural': 'Phonenumber for User Extention',
            },
            bases=('crm.phoneaddress',),
        ),
        migrations.CreateModel(
            name='UserExtensionPostalAddress',
            fields=[
                ('postaladdress_ptr',
                 models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True,
                                      primary_key=True, serialize=False, to='crm.PostalAddress')),
                ('purpose', models.CharField(
                    choices=[('H', 'Private'), ('O', 'Business'), ('P', 'Mobile Private'), ('B', 'Mobile Business')],
                    max_length=1, verbose_name='Purpose')),
                ('userExtension', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                    to='djangoUserExtension.UserExtension')),
            ],
            options={
                'verbose_name': 'Postal Address for User Extention',
                'verbose_name_plural': 'Postal Address for User Extention',
            },
            bases=('crm.postaladdress',),
        ),
        migrations.CreateModel(
            name='XSLFile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=100, null=True, verbose_name='Title')),
                ('xslfile', filebrowser.fields.FileBrowseField(max_length=200, verbose_name='XSL File')),
            ],
            options={
                'verbose_name': 'XSL File',
                'verbose_name_plural': 'XSL Files',
            },
        ),
        migrations.AddField(
            model_name='templateset',
            name='balancesheetXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_reltemplatebalancesheet', to='djangoUserExtension.XSLFile',
                                    verbose_name='XSL File for Balancesheet'),
        ),
        migrations.AddField(
            model_name='templateset',
            name='deilveryorderXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_reltemplatedeliveryorder', to='djangoUserExtension.XSLFile',
                                    verbose_name='XSL File for Deilvery Order'),
        ),
        migrations.AddField(
            model_name='templateset',
            name='invoiceXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltemplateinvoice',
                                    to='djangoUserExtension.XSLFile', verbose_name='XSL File for Invoice'),
        ),
        migrations.AddField(
            model_name='templateset',
            name='profitLossStatementXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_reltemplateprofitlossstatement', to='djangoUserExtension.XSLFile',
                                    verbose_name='XSL File for Profit Loss Statement'),
        ),
        migrations.AddField(
            model_name='templateset',
            name='purchaseconfirmationXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_reltemplatepurchaseconfirmation', to='djangoUserExtension.XSLFile',
                                    verbose_name='XSL File for Purchase Confirmation'),
        ),
        migrations.AddField(
            model_name='templateset',
            name='purchaseorderXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                    related_name='db_reltemplatepurchaseorder', to='djangoUserExtension.XSLFile',
                                    verbose_name='XSL File for Purchaseorder'),
        ),
        migrations.AddField(
            model_name='templateset',
            name='quoteXSLFile',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_reltemplatequote',
                                    to='djangoUserExtension.XSLFile', verbose_name='XSL File for Quote'),
        ),
    ]
