# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2017-12-10 18:05
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('djangoUserExtension', '0003_auto_20171110_1732'),
        ('crm', '0005_auto_20171110_1732'),
    ]

    operations = [
        migrations.CreateModel(
            name='DeliveryNote',
            fields=[
                ('salescontract_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.SalesContract')),
                ('status', models.CharField(choices=[('C', 'Created'), ('S', 'Sent'), ('R', 'Received'), ('R', 'Lost')], max_length=1)),
                ('derived_from_invoice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Invoice')),
            ],
            options={
                'verbose_name_plural': 'Delivery Notes',
                'verbose_name': 'Delivery Note',
            },
            bases=('crm.salescontract',),
        ),
        migrations.CreateModel(
            name='PaymentReminder',
            fields=[
                ('salescontract_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.SalesContract')),
                ('iteration_number', models.IntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(3)], verbose_name='Iteration Number')),
                ('status', models.CharField(choices=[('P', 'Payed'), ('C', 'Invoice created'), ('I', 'Invoice sent'), ('F', 'First reminder sent'), ('R', 'Second reminder sent'), ('U', 'Customer cant pay'), ('D', 'Deleted')], max_length=1)),
                ('derived_from_invoice', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Invoice')),
            ],
            options={
                'verbose_name_plural': 'Payment Reminders',
                'verbose_name': 'Payment Reminder',
            },
            bases=('crm.salescontract',),
        ),
        migrations.CreateModel(
            name='PurchaseConfirmation',
            fields=[
                ('salescontract_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='crm.SalesContract')),
                ('validuntil', models.DateField(verbose_name='Valid until')),
                ('status', models.CharField(choices=[('S', 'Success'), ('I', 'Quote created'), ('Q', 'Quote sent'), ('F', 'First reminder sent'), ('R', 'Second reminder sent'), ('D', 'Deleted')], max_length=1, verbose_name='Status')),
            ],
            options={
                'verbose_name_plural': 'Purchase Confirmations',
                'verbose_name': 'Purchase Confirmation',
            },
            bases=('crm.salescontract',),
        ),
        migrations.CreateModel(
            name='TextParagraphInSalesContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('purpose', models.CharField(choices=[('BS', 'Before subject'), ('AS', 'After subject'), ('BT', 'Before total'), ('AT', 'After total'), ('BW', 'Before wishes'), ('AW', 'After wishes'), ('C1', 'Custom 1'), ('C2', 'Custom 2'), ('C3', 'Custom 3'), ('C4', 'Custom 4')], max_length=1, verbose_name='Purpose')),
                ('text_paragraph', models.TextField(verbose_name='Text')),
            ],
            options={
                'verbose_name_plural': 'TextParagraphsInSalesContract',
                'verbose_name': 'TextParagraphInSalesContract',
            },
        ),
        migrations.AlterModelOptions(
            name='supplier',
            options={'verbose_name': 'Supplier', 'verbose_name_plural': 'Suppliers'},
        ),
        migrations.RemoveField(
            model_name='position',
            name='shipmentID',
        ),
        migrations.RemoveField(
            model_name='position',
            name='supplier',
        ),
        migrations.AddField(
            model_name='salescontract',
            name='template_set',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='djangoUserExtension.TemplateSet', verbose_name='Referred Template Set'),
        ),
        migrations.AddField(
            model_name='textparagraphinsalescontract',
            name='SalesContract',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='crm.SalesContract'),
        ),
    ]
