# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2017-10-09 19:49
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('accounting', '0003_remove_account_originalamount'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='account',
            options={'ordering': ['accountNumber'], 'verbose_name': 'Konto', 'verbose_name_plural': 'Konto'},
        ),
        migrations.AlterModelOptions(
            name='accountingperiod',
            options={'verbose_name': 'Abrechnungszeitraum', 'verbose_name_plural': 'Abrechnungszeiträume'},
        ),
        migrations.AlterModelOptions(
            name='booking',
            options={'verbose_name': 'Buchung', 'verbose_name_plural': 'Buchungen'},
        ),
        migrations.AlterModelOptions(
            name='productcategorie',
            options={'verbose_name': 'Produktekategorie', 'verbose_name_plural': 'Produktekategorien'},
        ),
        migrations.AlterField(
            model_name='account',
            name='accountNumber',
            field=models.IntegerField(verbose_name='Kontonummer'),
        ),
        migrations.AlterField(
            model_name='account',
            name='accountType',
            field=models.CharField(choices=[('E', 'Ertrag (Einnahmen)'), ('S', 'Aufwand (Ausgaben)'), ('L', 'Passiva (Schulden)'), ('A', 'Aktiva (Vermögen)')], max_length=1, verbose_name='Kontotyp'),
        ),
        migrations.AlterField(
            model_name='account',
            name='description',
            field=models.TextField(blank=True, null=True, verbose_name='Beschreibung'),
        ),
        migrations.AlterField(
            model_name='account',
            name='isACustomerPaymentAccount',
            field=models.BooleanField(verbose_name='Konto für Kundeneinzahlungen'),
        ),
        migrations.AlterField(
            model_name='account',
            name='isProductInventoryActiva',
            field=models.BooleanField(verbose_name='Konto für Lager'),
        ),
        migrations.AlterField(
            model_name='account',
            name='isopeninterestaccount',
            field=models.BooleanField(verbose_name='Konto für offene Forderungen'),
        ),
        migrations.AlterField(
            model_name='account',
            name='isopenreliabilitiesaccount',
            field=models.BooleanField(verbose_name='Konto für offene Rechungen'),
        ),
        migrations.AlterField(
            model_name='account',
            name='title',
            field=models.CharField(max_length=50, verbose_name='Kontobezeichnung'),
        ),
        migrations.AlterField(
            model_name='accountingperiod',
            name='begin',
            field=models.DateField(verbose_name='Anfang'),
        ),
        migrations.AlterField(
            model_name='accountingperiod',
            name='end',
            field=models.DateField(verbose_name='Ende'),
        ),
        migrations.AlterField(
            model_name='accountingperiod',
            name='title',
            field=models.CharField(max_length=200, verbose_name='Titel'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='accountingPeriod',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='accounting.AccountingPeriod', verbose_name='Abrechnungszeitraum'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='amount',
            field=models.DecimalField(decimal_places=2, max_digits=20, verbose_name='Betrag'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='bookingDate',
            field=models.DateTimeField(verbose_name='Buchung am'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='bookingReference',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='crm.Invoice', verbose_name='Buchungsreferenz'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='dateofcreation',
            field=models.DateTimeField(auto_now=True, verbose_name='Erstelldatum'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='description',
            field=models.CharField(blank=True, max_length=120, null=True, verbose_name='Beschreibung'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='fromAccount',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_booking_fromaccount', to='accounting.Account', verbose_name='Vom Konto (Soll)'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='lastmodification',
            field=models.DateTimeField(auto_now_add=True, verbose_name='Zuletzt geändert'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='lastmodifiedby',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='db_booking_lstmodified', to=settings.AUTH_USER_MODEL, verbose_name='Zuletzt geändert durch'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='staff',
            field=models.ForeignKey(blank=True, on_delete=django.db.models.deletion.CASCADE, related_name='db_booking_refstaff', to=settings.AUTH_USER_MODEL, verbose_name='Zuständiger Mitarbeiter'),
        ),
        migrations.AlterField(
            model_name='booking',
            name='toAccount',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_booking_toaccount', to='accounting.Account', verbose_name='Zu Konto (Haben)'),
        ),
        migrations.AlterField(
            model_name='productcategorie',
            name='lossAccount',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_loss_account', to='accounting.Account', verbose_name='Aufwand Konto'),
        ),
        migrations.AlterField(
            model_name='productcategorie',
            name='profitAccount',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='db_profit_account', to='accounting.Account', verbose_name='Ertrag Konto'),
        ),
        migrations.AlterField(
            model_name='productcategorie',
            name='title',
            field=models.CharField(max_length=50, verbose_name='Produktekategorie'),
        ),
    ]
