# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Const Class
# this is a auto generated file generated by Cheetah
# Libre Office Version: 7.3
# Namespace: com.sun.star.i18n
from typing_extensions import Literal


class TransliterationModulesExtra:
    """
    Const Class

    Extra transliteration module enumeration to use with XTransliteration.loadModule()
    
    The values used in this group need to be different from the ones in TransliterationModules and TransliterationModulesNew!

    See Also:
        `API TransliterationModulesExtra <https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1i18n_1_1TransliterationModulesExtra.html>`_
    """
    SENTENCE_CASE: Literal[200]
    """
    The first character of the sentence is put in upper case.
    """
    TITLE_CASE: Literal[201]
    """
    The first character of the word is put in upper case.
    
    This one is part
    """
    TOGGLE_CASE: Literal[202]
    """
    All characters of the word are to change their case from small letters to capital letters and vice versa.
    """
    IGNORE_DIACRITICS_CTL: Literal[1073741824]
    """
    Ignore diacritics.
    
    Despite the _CTL name suffix this is not only about CTL/Arabic diacritic characters, though these are handled as well, but the transliteration decomposes and removes any diacritic from characters.
    
    Because we cannot extend the TransliterationModules enum we use TransliterationModulesExtra and it will act the same way.
    """
    IGNORE_KASHIDA_CTL: Literal[2048]
    """
    Ignore Kashida mark.
    """
    END_OF_MODULE: Literal[0]

