# coding: utf-8
#
# Copyright 2022 :Barry-Thomas-Paul: Moss
#
# Licensed under the Apache License, Version 2.0 (the "License")
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http: // www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Struct Class
# this is a auto generated file generated by Cheetah
# Namespace: com.sun.star.i18n
# Libre Office Version: 7.3
from typing_extensions import Literal
import typing
from .boundary import Boundary as Boundary_7fe2098c


class TextConversionResult(object):
    """
    Struct Class

    Text conversion result to be used with XTextConversion.
    
    **since**
    
        OOo 1.1.2

    See Also:
        `API TextConversionResult <https://api.libreoffice.org/docs/idl/ref/structcom_1_1sun_1_1star_1_1i18n_1_1TextConversionResult.html>`_
    """
    typeName: Literal['com.sun.star.i18n.TextConversionResult']

    def __init__(self, Candidates: typing.Optional[typing.Tuple[str, ...]] = ..., Boundary: typing.Optional[Boundary_7fe2098c] = ...) -> None:
        """
        Constructor

        Arguments:
            Candidates (typing.Tuple[str, ...], optional): Candidates value.
            Boundary (Boundary, optional): Boundary value.
        """


    @property
    def Candidates(self) -> typing.Tuple[str, ...]:
        """
        A list of replacement candidates for the first convertible word found in the given text.
        """


    @property
    def Boundary(self) -> Boundary_7fe2098c:
        """
        The boundary of the first convertible word in the given text.
        
        If there is no convertible word found in the text, startPos and endPos for Boundary equal 0.
        """


