# Generated by Django 4.2.20 on 2025-05-28 18:51

from django.db import migrations, models


def set_area_access_has_ended(apps, schema_editor):
    AreaAccessRecord = apps.get_model("NEMO", "AreaAccessRecord")
    for index, area_access in enumerate(AreaAccessRecord.objects.order_by("id"), start=1):
        area_access.has_ended = 0 if area_access.end is None else index
        area_access.save(update_fields=["has_ended"])


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0117_usageevent_has_ended"),
    ]

    operations = [
        migrations.AddField(
            model_name="areaaccessrecord",
            name="has_ended",
            field=models.PositiveBigIntegerField(default=0),
        ),
        migrations.RunPython(set_area_access_has_ended, migrations.RunPython.noop),
        migrations.AddConstraint(
            model_name="areaaccessrecord",
            constraint=models.UniqueConstraint(
                fields=("customer", "area", "has_ended"), name="unique_area_user_has_ended"
            ),
        ),
    ]
