# Generated by Django 4.2.20 on 2025-05-28 14:10

from django.db import migrations, models


def set_usage_event_has_ended(apps, schema_editor):
    UsageEvent = apps.get_model("NEMO", "UsageEvent")
    for index, usage_event in enumerate(UsageEvent.objects.order_by("id"), start=1):
        usage_event.has_ended = 0 if usage_event.end is None else index
        usage_event.save(update_fields=["has_ended"])


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0116_comment_pinned"),
    ]

    operations = [
        migrations.AddField(
            model_name="usageevent",
            name="has_ended",
            field=models.PositiveBigIntegerField(default=0),
        ),
        migrations.RunPython(set_usage_event_has_ended, migrations.RunPython.noop),
        migrations.AddConstraint(
            model_name="usageevent",
            constraint=models.UniqueConstraint(fields=("tool", "has_ended"), name="unique_tool_has_ended"),
        ),
    ]
