# Generated by Django 4.2.19 on 2025-03-17 14:45

import NEMO.fields
from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0107_customization_remote_work_on_behalf_update"),
    ]

    def update_landing_page_choice(apps, schema_editor):
        LandingPageChoice = apps.get_model("NEMO", "LandingPageChoice")
        for choice in LandingPageChoice.objects.all():
            if choice.hide_from_users or choice.hide_from_staff:
                if not choice.hide_from_users:
                    choice.view_permissions = "non_staff_users"
                else:
                    choice.view_permissions = "is_facility_manager,is_superuser"
                    if not choice.hide_from_staff:
                        choice.view_permissions += ",is_staff,is_technician"
                choice.save()

    def update_landing_page_choice_reverse(apps, schema_editor):
        LandingPageChoice = apps.get_model("NEMO", "LandingPageChoice")
        for choice in LandingPageChoice.objects.all():
            if "is_authenticated" not in choice.view_permissions:
                if "non_staff_users" in choice.view_permissions:
                    choice.hide_from_users = False
                else:
                    choice.hide_from_users = True
                if "is_staff" in choice.view_permissions or "is_technician" in choice.view_permissions:
                    choice.hide_from_staff = False
                else:
                    choice.hide_from_staff = True
                choice.save()

    operations = [
        migrations.AddField(
            model_name="landingpagechoice",
            name="view_permissions",
            field=NEMO.fields.MultiRoleGroupPermissionChoiceField(
                default="is_authenticated",
                help_text="The roles/groups/permissions required for users to see this landing page item",
            ),
        ),
        migrations.RunPython(update_landing_page_choice, update_landing_page_choice_reverse),
        migrations.RemoveField(
            model_name="landingpagechoice",
            name="hide_from_staff",
        ),
        migrations.RemoveField(
            model_name="landingpagechoice",
            name="hide_from_users",
        ),
    ]
