# Generated by Django 4.2.11 on 2024-05-08 18:05

import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0099_rename_fundtype_projecttype_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_staff_assistance_request_replies",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")],
                default=1,
                help_text="Staff assistance request replies",
            ),
        ),
        migrations.CreateModel(
            name="StaffAssistanceRequest",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "creation_time",
                    models.DateTimeField(
                        default=django.utils.timezone.now, help_text="The date and time when the request was created."
                    ),
                ),
                ("description", models.TextField(help_text="The description of the request.")),
                (
                    "resolved",
                    models.BooleanField(
                        default=False, help_text="Indicates the request has been resolved and won't be shown anymore."
                    ),
                ),
                (
                    "deleted",
                    models.BooleanField(
                        default=False, help_text="Indicates the request has been deleted and won't be shown anymore."
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        help_text="The user who is submitting the request.",
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "ordering": ["-creation_time"],
            },
        ),
    ]
