# Generated by Django 4.2.15 on 2024-10-04 03:41

import re

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0091_adjustmentrequest_waive_charges"),
    ]

    operations = [
        migrations.AlterField(
            model_name="accounttype",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="alert",
            name="category",
            field=models.CharField(blank=True, help_text="A category/type for this alert.", max_length=255),
        ),
        migrations.AlterField(
            model_name="alert",
            name="title",
            field=models.CharField(blank=True, max_length=255),
        ),
        migrations.AlterField(
            model_name="alertcategory",
            name="name",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="area",
            name="category",
            field=models.CharField(
                blank=True,
                db_column="category",
                help_text='Create sub-categories using slashes. For example "Category 1/Sub-category 1".',
                max_length=1024,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="area",
            name="name",
            field=models.CharField(
                help_text="What is the name of this area? The name will be displayed on the tablet login and logout pages.",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="badgereader",
            name="name",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="chemical",
            name="name",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="chemical",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="chemicalhazard",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="configuration",
            name="configurable_item_name",
            field=models.CharField(
                blank=True,
                help_text="The name of the tool part being configured. This text is displayed as a label on the tool control page. Leave this field blank if there is only one configuration slot.",
                max_length=255,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="configuration",
            name="name",
            field=models.CharField(
                help_text="The name of this overall configuration. This text is displayed as a label on the tool control page.",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="contactinformationcategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="emaillog",
            name="subject",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="interlockcardcategory",
            name="name",
            field=models.CharField(help_text="The name for this interlock category", max_length=255),
        ),
        migrations.AlterField(
            model_name="landingpagechoice",
            name="name",
            field=models.CharField(
                help_text="The textual name that will be displayed underneath the image", max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="landingpagechoice",
            name="url",
            field=models.CharField(
                help_text="The URL that the choice leads to when clicked. Relative paths such as /calendar/ are used when linking within the site. Use fully qualified URL paths such as https://www.google.com/ to link to external sites.",
                verbose_name="URL",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="news",
            name="title",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="onboardingphase",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="project",
            name="name",
            field=models.CharField(max_length=1024),
        ),
        migrations.AlterField(
            model_name="projectdiscipline",
            name="name",
            field=models.CharField(help_text="The name of the discipline", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="projectdocuments",
            name="name",
            field=models.CharField(
                blank=True, help_text="The optional name to display for this document", max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="projectdocuments",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="recurringconsumablecharge",
            name="name",
            field=models.CharField(help_text="The name/identifier for this recurring charge.", max_length=255),
        ),
        migrations.AlterField(
            model_name="reservation",
            name="title",
            field=models.TextField(
                blank=True,
                default="",
                help_text="Shows a custom title for this reservation on the calendar. Leave this field blank to display the reservation's user name as the title (which is the default behaviour).",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="resource",
            name="name",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="resourcecategory",
            name="name",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="safetycategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="safetyissue",
            name="location",
            field=models.CharField(blank=True, max_length=255, null=True),
        ),
        migrations.AlterField(
            model_name="safetyitem",
            name="name",
            field=models.CharField(help_text="The safety item name.", max_length=255),
        ),
        migrations.AlterField(
            model_name="safetyitemdocuments",
            name="name",
            field=models.CharField(
                blank=True, help_text="The optional name to display for this document", max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="safetyitemdocuments",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="safetytraining",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="scheduledoutage",
            name="category",
            field=models.CharField(
                blank=True,
                help_text="A categorical reason for why this outage is scheduled. Useful for trend analytics.",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="scheduledoutage",
            name="reminder_days",
            field=models.CharField(
                blank=True,
                help_text="The number of days to send a reminder before a scheduled outage. A comma-separated list can be used for multiple reminders.",
                max_length=255,
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        re.compile("^\\d+(?:,\\d+)*\\Z"),
                        code="invalid",
                        message="Enter only digits separated by commas.",
                    )
                ],
            ),
        ),
        migrations.AlterField(
            model_name="scheduledoutagecategory",
            name="name",
            field=models.CharField(max_length=255),
        ),
        migrations.AlterField(
            model_name="staffavailabilitycategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="staffknowledgebasecategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="staffknowledgebaseitem",
            name="name",
            field=models.CharField(help_text="The item name.", max_length=255),
        ),
        migrations.AlterField(
            model_name="staffknowledgebaseitemdocuments",
            name="name",
            field=models.CharField(
                blank=True, help_text="The optional name to display for this document", max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="staffknowledgebaseitemdocuments",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="taskhistory",
            name="status",
            field=models.CharField(help_text="A text description of the task's status", max_length=255),
        ),
        migrations.AlterField(
            model_name="taskstatus",
            name="name",
            field=models.CharField(max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="tool",
            name="_category",
            field=models.CharField(
                blank=True,
                db_column="category",
                help_text='Create sub-categories using slashes. For example "Category 1/Sub-category 1".',
                max_length=1024,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="tooldocuments",
            name="name",
            field=models.CharField(
                blank=True, help_text="The optional name to display for this document", max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="tooldocuments",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="toolqualificationgroup",
            name="name",
            field=models.CharField(help_text="The name of this tool group", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="toolusagecounter",
            name="name",
            field=models.CharField(help_text="The name of this counter", max_length=255),
        ),
        migrations.AlterField(
            model_name="toolusagecounter",
            name="tool_usage_question",
            field=models.CharField(
                help_text="The name of the tool's post usage question which should be used to increment this counter",
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name="userdocuments",
            name="name",
            field=models.CharField(
                blank=True, help_text="The optional name to display for this document", max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="userdocuments",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="userknowledgebasecategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
        migrations.AlterField(
            model_name="userknowledgebaseitem",
            name="name",
            field=models.CharField(help_text="The item name.", max_length=255),
        ),
        migrations.AlterField(
            model_name="userknowledgebaseitemdocuments",
            name="name",
            field=models.CharField(
                blank=True, help_text="The optional name to display for this document", max_length=255, null=True
            ),
        ),
        migrations.AlterField(
            model_name="userknowledgebaseitemdocuments",
            name="url",
            field=models.URLField(blank=True, null=True, verbose_name="URL"),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="recurring_charges_reminder_days",
            field=models.CharField(
                blank=True,
                default="60,7",
                help_text="The number of days to send a reminder before a recurring charge is due. A comma-separated list can be used for multiple reminders.",
                max_length=255,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="usertype",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=255, unique=True),
        ),
    ]
