# Generated by Django 4.2.11 on 2024-05-24 18:17

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0083_toolcredentials"),
    ]

    def migrate_tool_delayed_logoff(apps, schema_editor):
        Tool = apps.get_model("NEMO", "Tool")
        for tool in Tool.objects.filter(_allow_delayed_logoff=True):
            tool._max_delayed_logoff = 120
            tool.save(update_fields=["_max_delayed_logoff"])

    def reverse_tool_delayed_logoff(apps, schema_editor):
        Tool = apps.get_model("NEMO", "Tool")
        for tool in Tool.objects.filter(_max_delayed_logoff__isnull=False):
            tool._allow_delayed_logoff = True
            tool.save(update_fields=["_allow_delayed_logoff"])

    operations = [
        migrations.AddField(
            model_name="tool",
            name="_max_delayed_logoff",
            field=models.PositiveIntegerField(
                blank=True,
                db_column="max_delayed_logoff",
                help_text='[Optional] Maximum delay in minutes that users may enter upon logging off before another user may use the tool. Some tools require "spin-down" or cleaning time after use. Leave blank to disable.',
                null=True,
            ),
        ),
        migrations.RunPython(migrate_tool_delayed_logoff, reverse_tool_delayed_logoff),
        migrations.RemoveField(
            model_name="tool",
            name="_allow_delayed_logoff",
        ),
    ]
