# Generated by Django 3.2.25 on 2024-04-05 14:42

import re

import django.core.validators
from django.db import migrations, models

import NEMO.fields


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0073_knowledge_safety_items_display_order"),
    ]

    operations = [
        migrations.AddField(
            model_name="scheduledoutage",
            name="reminder_days",
            field=models.CharField(
                blank=True,
                help_text="The number of days to send a reminder before a scheduled outage. A comma-separated list can be used for multiple reminders.",
                max_length=200,
                null=True,
                validators=[
                    django.core.validators.RegexValidator(
                        re.compile("^\\d+(?:,\\d+)*\\Z"),
                        code="invalid",
                        message="Enter only digits separated by commas.",
                    )
                ],
            ),
        ),
        migrations.AddField(
            model_name="scheduledoutage",
            name="reminder_emails",
            field=NEMO.fields.MultiEmailField(
                blank=True,
                help_text="The reminder email(s) will be sent to this address. A comma-separated list can be used.",
                max_length=2000,
                null=True,
            ),
        ),
    ]
