# Generated by Django 3.2.23 on 2024-03-18 23:10

import django.db.models
import mptt.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("NEMO", "0067_project_allow_staff_charges"),
    ]

    def migrate_door_areas_forward(apps, schema_editor):
        Door = apps.get_model("NEMO", "Door")
        for door in Door.objects.all():
            door.welcome_message = door.area.welcome_message
            door.save()
            door.areas.set([door.area])

    def migrate_door_areas_reverse(apps, schema_editor):
        Door = apps.get_model("NEMO", "Door")
        for door in Door.objects.all():
            door.area = door.areas.first()
            door.save()
            door.area.welcome_message = door.welcome_message
            door.area.save()

    operations = [
        migrations.RemoveField(
            model_name="door",
            name="adjacent_area",
        ),
        migrations.AddField(
            model_name="door",
            name="areas",
            field=mptt.fields.TreeManyToManyField(related_name="doors", to="NEMO.Area"),
        ),
        migrations.AddField(
            model_name="door",
            name="welcome_message",
            field=models.TextField(
                blank=True,
                help_text="The welcome message will be displayed on the tablet login page. You can use HTML and JavaScript.",
                null=True,
            ),
        ),
        migrations.RunPython(migrate_door_areas_forward, migrate_door_areas_reverse),
        migrations.AlterField(
            model_name="door",
            name="area",
            field=mptt.fields.TreeForeignKey(
                to="NEMO.Area", related_name="doors", on_delete=django.db.models.PROTECT, default=0
            ),
        ),
        migrations.RemoveField(
            model_name="door",
            name="area",
        ),
        migrations.RemoveField(
            model_name="area",
            name="welcome_message",
        ),
    ]
