# Generated by Django 4.2.20 on 2025-06-30 17:32
import datetime
from collections import defaultdict
from typing import Dict, Set

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models
from django.db.models import F, Q

import NEMO.utilities
from NEMO.migrations_utils import news_for_version_forward, news_for_version_reverse


# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the
# RunPython operations to refer to the local versions:
# NEMO.migrations.0038_version_4_0_0
# NEMO.migrations.0039_version_4_1_0
# NEMO.migrations.0040_version_4_2_0
# NEMO.migrations.0042_version_4_3_0
# NEMO.migrations.0044_version_4_4_0
# NEMO.migrations.0045_version_4_5_0
# NEMO.migrations.0046_version_4_6_0
# NEMO.migrations.0049_version_4_7_0
# NEMO.migrations.0051_request_reviewers_in_tool_and_area


def add_modbus_tcp_interlock_category(apps, schema_editor):
    InterlockCardCategory = apps.get_model("NEMO", "InterlockCardCategory")
    InterlockCardCategory.objects.create(name="ModbusTcp", key="modbus_tcp")


def migrate_qualifications(apps, schema_editor):
    User = apps.get_model(settings.AUTH_USER_MODEL)
    Qualification = apps.get_model("NEMO", "Qualification")
    for user in User.objects.all():
        for tool in user.qualifications.all():
            Qualification.objects.create(tool=tool, user=user)


def migrate_notification_types(apps, schema_editor):
    Notification = apps.get_model("NEMO", "Notification")
    for notification in Notification.objects.all():
        notification.notification_type = notification.content_type.model
        notification.save(update_fields=["notification_type"])


def migrate_request_messages(apps, schema_editor):
    RequestMessage = apps.get_model("NEMO", "RequestMessage")
    for request_message in RequestMessage.objects.all():
        request_type = apps.get_model("contenttypes", "ContentType").objects.get_for_model(
            request_message.buddy_request
        )
        request_message.content_type = request_type
        request_message.object_id = request_message.buddy_request.id
        request_message.save(update_fields=["content_type", "object_id"])


def set_remote_work_flag(apps, schema_editor):
    UsageEvent = apps.get_model("NEMO", "UsageEvent")
    # go through all previous tool usage and set them to be remote work if operator is different from user
    for tool_usage in UsageEvent.objects.exclude(user=F("operator")):
        if tool_usage.user != tool_usage.operator:
            tool_usage.remote_work = True
            tool_usage.save(update_fields=["remote_work"])


def migrate_adjustment_request_reviewers_forward(apps, schema_editor):
    Tool = apps.get_model("NEMO", "Tool")
    Area = apps.get_model("NEMO", "Area")
    User = apps.get_model(settings.AUTH_USER_MODEL)
    UserPreferences = apps.get_model("NEMO", "UserPreferences")
    tool_adjustments: Dict[int, Set] = defaultdict(set)
    area_adjustments: Dict[int, Set] = defaultdict(set)
    managers_all_tool_adjustments = User.objects.filter(
        is_active=True, is_facility_manager=True, preferences__tool_adjustment_notifications__isnull=True
    )
    managers_all_area_adjustments = User.objects.filter(
        is_active=True, is_facility_manager=True, preferences__area_adjustment_notifications__isnull=True
    )
    for user_preference in UserPreferences.objects.filter(
        Q(tool_adjustment_notifications__isnull=False) | Q(area_adjustment_notifications__isnull=False)
    ):
        for tool in user_preference.tool_adjustment_notifications.all():
            tool_adjustments[tool.id].add(user_preference.user)
            # Add managers who want to receive all
            tool_adjustments[tool.id].update(managers_all_tool_adjustments)
        for area in user_preference.area_adjustment_notifications.all():
            area_adjustments[area.id].add(user_preference.user)
            # Add managers who want to receive all
            area_adjustments[area.id].update(managers_all_area_adjustments)
    for tool in Tool.objects.in_bulk(tool_adjustments.keys()).values():
        tool._adjustment_request_reviewers.set(tool_adjustments[tool.id])
    for area in Area.objects.in_bulk(area_adjustments.keys()).values():
        area.adjustment_request_reviewers.set(area_adjustments[area.id])


def migrate_adjustment_request_reviewers_reverse(apps, schema_editor):
    Tool = apps.get_model("NEMO", "Tool")
    Area = apps.get_model("NEMO", "Area")
    for tool in Tool.objects.all():
        for user in tool._adjustment_request_reviewers.all():
            if user.preferences:
                user.preferences.tool_adjustment_notifications.add(tool)
    for area in Area.objects.all():
        for user in area.adjustment_request_reviewers.all():
            if user.preferences:
                user.preferences.area_adjustment_notifications.add(area)


class Migration(migrations.Migration):

    replaces = [
        ("NEMO", "0038_version_4_0_0"),
        ("NEMO", "0039_version_4_1_0"),
        ("NEMO", "0040_version_4_2_0"),
        ("NEMO", "0041_version_4_2_1"),
        ("NEMO", "0042_version_4_3_0"),
        ("NEMO", "0043_version_4_3_2"),
        ("NEMO", "0044_version_4_4_0"),
        ("NEMO", "0045_version_4_5_0"),
        ("NEMO", "0045_version_4_5_5"),
        ("NEMO", "0046_version_4_6_0"),
        ("NEMO", "0047_version_4_6_1"),
        ("NEMO", "0048_version_4_6_3"),
        ("NEMO", "0049_version_4_7_0"),
        ("NEMO", "0050_consumable_add_self_checkout_and_notes"),
        ("NEMO", "0051_request_reviewers_in_tool_and_area"),
        ("NEMO", "0052_area_add_auto_logout_time"),
        ("NEMO", "0053_consumable_withdraw_add_usage_event_link"),
        ("NEMO", "0054_documents_update_max_length"),
    ]

    dependencies = [
        ("NEMO", "0020_version_3_0_0_squashed"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.RunPython(news_for_version_forward("4.0.0"), news_for_version_reverse("4.0.0")),
        migrations.RunPython(add_modbus_tcp_interlock_category),
        migrations.AlterField(
            model_name="interlock",
            name="channel",
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name="Channel/Relay/Coil"),
        ),
        migrations.RunPython(news_for_version_forward("4.1.0"), news_for_version_reverse("4.1.0")),
        migrations.AddField(
            model_name="landingpagechoice",
            name="hide_from_staff",
            field=models.BooleanField(
                default=False,
                help_text="Hides this choice from staff and technicians. When checked, only normal users, facility managers and super-users can see the choice",
            ),
        ),
        migrations.AlterField(
            model_name="landingpagechoice",
            name="hide_from_users",
            field=models.BooleanField(
                default=False,
                help_text="Hides this choice from normal users. When checked, only staff, technicians, facility managers and super-users can see the choice",
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_alternate",
            field=models.EmailField(blank=True, max_length=254, null=True),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_access_request_updates",
            field=models.BooleanField(default=True, help_text="Send access request updates to my alternate email"),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_buddy_request_replies",
            field=models.BooleanField(default=True, help_text="Send buddy request replies to my alternate email"),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_reservation_emails",
            field=models.BooleanField(default=True, help_text="Send reservation emails to my alternate email"),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_reservation_ending_reminders",
            field=models.BooleanField(
                default=True, help_text="Send reservation ending reminders to my alternate email"
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_reservation_reminders",
            field=models.BooleanField(default=True, help_text="Send reservation reminders to my alternate email"),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_task_updates",
            field=models.BooleanField(default=True, help_text="Send task updates to my alternate email"),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_usage_reminders",
            field=models.BooleanField(default=True, help_text="Send usage reminders to my alternate email"),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_broadcast_emails",
            field=models.BooleanField(default=True, help_text="Send broadcast emails to my alternate email"),
        ),
        migrations.AlterField(
            model_name="emaillog",
            name="category",
            field=models.IntegerField(
                choices=[
                    (0, "General"),
                    (1, "System"),
                    (2, "Direct Contact"),
                    (3, "Broadcast Email"),
                    (4, "Timed Services"),
                    (5, "Feedback"),
                    (6, "Abuse"),
                    (7, "Safety"),
                    (8, "Tasks"),
                    (9, "Access Requests"),
                    (10, "Sensors"),
                ],
                default=0,
            ),
        ),
        migrations.RunPython(news_for_version_forward("4.2.0"), news_for_version_reverse("4.2.0")),
        migrations.AddField(
            model_name="staffabsence",
            name="manager_note",
            field=models.TextField(blank=True, help_text="A note only visible to managers.", null=True),
        ),
        migrations.AlterField(
            model_name="staffabsence",
            name="description",
            field=models.TextField(
                blank=True, help_text="The absence description. This will be visible to anyone.", null=True
            ),
        ),
        migrations.CreateModel(
            name="ChemicalHazard",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=200)),
                (
                    "display_order",
                    models.IntegerField(
                        help_text="Chemical hazards are sorted according to display order. The lowest value category is displayed first in the 'Safety data sheet' page."
                    ),
                ),
                (
                    "logo",
                    models.ImageField(
                        blank=True,
                        help_text="The logo for this hazard",
                        upload_to=NEMO.utilities.get_hazard_logo_filename,
                    ),
                ),
            ],
            options={
                "ordering": ["display_order", "name"],
            },
        ),
        migrations.CreateModel(
            name="Chemical",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=200)),
                (
                    "document",
                    models.FileField(
                        blank=True, max_length=500, null=True, upload_to=NEMO.utilities.get_chemical_document_filename
                    ),
                ),
                ("url", models.CharField(blank=True, max_length=200, null=True, verbose_name="URL")),
                ("keywords", models.TextField(blank=True, null=True)),
                (
                    "hazards",
                    models.ManyToManyField(
                        blank=True, help_text="Select the hazards for this chemical.", to="NEMO.chemicalhazard"
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.RunPython(news_for_version_forward("4.3.0"), news_for_version_reverse("4.3.0")),
        migrations.AddField(
            model_name="interlock",
            name="unit_id",
            field=models.PositiveIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="interlock",
            name="most_recent_reply_time",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_access_expiration_emails",
            field=models.BooleanField(default=True, help_text="Send access expiration emails to my alternate email"),
        ),
        migrations.AddField(
            model_name="user",
            name="notes",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.CreateModel(
            name="Qualification",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("qualified_on", models.DateField(default=datetime.date.today)),
                ("tool", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="NEMO.tool")),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.RunPython(migrate_qualifications),
        migrations.RemoveField(
            model_name="user",
            name="qualifications",
        ),
        migrations.AddField(
            model_name="user",
            name="qualifications",
            field=models.ManyToManyField(
                blank=True,
                help_text="Select the tools that the user is qualified to use.",
                through="NEMO.Qualification",
                to="NEMO.tool",
            ),
        ),
        migrations.AlterModelTable(
            name="qualification",
            table="NEMO_user_qualifications",
        ),
        migrations.AlterField(
            model_name="alert",
            name="contents",
            field=models.TextField(),
        ),
        migrations.AddField(
            model_name="consumable",
            name="reusable",
            field=models.BooleanField(
                default=False,
                help_text="Check this box if this item is reusable. The quantity of reusable items will not decrease when orders are made (storage bins for example).",
            ),
        ),
        migrations.AlterField(
            model_name="consumable",
            name="reminder_email",
            field=models.EmailField(
                blank=True,
                help_text="An email will be sent to this address when the quantity of this item falls below the reminder threshold.",
                max_length=254,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="consumable",
            name="reminder_threshold",
            field=models.IntegerField(
                blank=True,
                help_text="More of this item should be ordered when the quantity falls below this threshold.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="user",
            name="training_required",
            field=models.BooleanField(
                default=True,
                help_text="When selected, the user is blocked from all reservation and tool usage capabilities.",
                verbose_name="facility rules tutorial required",
            ),
        ),
        migrations.CreateModel(
            name="RecurringConsumableCharge",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The name/identifier for this recurring charge.", max_length=200)),
                ("last_updated", models.DateTimeField(help_text="The time this charge was last modified.")),
                (
                    "quantity",
                    models.PositiveIntegerField(
                        default=1,
                        help_text="The number of consumables to charge.",
                        validators=[django.core.validators.MinValueValidator(1)],
                    ),
                ),
                (
                    "last_charge",
                    models.DateTimeField(
                        blank=True, help_text="The date and time when the user was last charged.", null=True
                    ),
                ),
                (
                    "rec_start",
                    models.DateField(
                        blank=True, help_text="Start date of the recurring charge.", null=True, verbose_name="start"
                    ),
                ),
                (
                    "rec_frequency",
                    models.PositiveIntegerField(
                        blank=True,
                        choices=[
                            (1, "Day(s)"),
                            (2, "Week Day(s)"),
                            (3, "Weekend Day(s)"),
                            (4, "Week(s)"),
                            (5, "Month(s)"),
                            (6, "Year(s)"),
                        ],
                        help_text="The charge frequency.",
                        null=True,
                        verbose_name="frequency",
                    ),
                ),
                (
                    "rec_interval",
                    models.PositiveIntegerField(
                        default=1,
                        help_text="Recurring interval, i.e. every 5 days.",
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="interval",
                    ),
                ),
                (
                    "rec_until",
                    models.DateField(
                        blank=True, help_text="End date of the recurring charge.", null=True, verbose_name="until"
                    ),
                ),
                (
                    "rec_count",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="The number of recurrences to charge for.",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="count",
                    ),
                ),
                ("consumable", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="NEMO.consumable")),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        help_text="The user who will be charged.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="recurring_charge_customer",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "last_updated_by",
                    models.ForeignKey(
                        help_text="The user who last modified this charge (and will be used as merchant on the charge).",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="recurring_charge_updated",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        help_text="The project to bill.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NEMO.project",
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_recurring_charges_reminder_emails",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only"), (3, "Alternate email only"), (0, "Off")],
                default=1,
                help_text="Recurring charges reminders",
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="recurring_charges_reminder_days",
            field=models.CharField(
                blank=True,
                default="60,7",
                help_text="The number of days to send a reminder before a recurring charge is due. A comma-separated list can be used for multiple reminders.",
                max_length=200,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_access_expiration_emails",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Access expiration reminders"
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_access_request_updates",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Access request updates"
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_broadcast_emails",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Broadcast emails"
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_buddy_request_replies",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Buddy request replies"
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_reservation_emails",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Reservation emails"
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_task_updates",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Task updates"
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_reservation_ending_reminders",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only"), (3, "Alternate email only"), (0, "Off")],
                default=1,
                help_text="Reservation ending reminders",
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_reservation_reminders",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only"), (3, "Alternate email only"), (0, "Off")],
                default=1,
                help_text="Reservation reminders",
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_tool_qualification_expiration_emails",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")],
                default=1,
                help_text="Tool qualification expiration reminders",
            ),
        ),
        migrations.AlterField(
            model_name="userpreferences",
            name="email_send_usage_reminders",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only"), (3, "Alternate email only"), (0, "Off")],
                default=1,
                help_text="Usage reminders",
            ),
        ),
        migrations.CreateModel(
            name="Discipline",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The name of the discipline", max_length=200, unique=True)),
            ],
            options={
                "abstract": False,
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="SafetyTraining",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The name of the training", max_length=200, unique=True)),
                (
                    "display_order",
                    models.IntegerField(
                        help_text="Safety trainings are sorted according to display order. The lowest value category is displayed first in the 'Users' page."
                    ),
                ),
            ],
            options={
                "abstract": False,
                "ordering": ["display_order", "name"],
            },
        ),
        migrations.CreateModel(
            name="OnboardingPhase",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The name of the onboarding phase", max_length=200, unique=True)),
                (
                    "display_order",
                    models.IntegerField(
                        help_text="Onboarding phases are sorted according to display order. The lowest value category is displayed first in the 'Users' page."
                    ),
                ),
            ],
            options={
                "abstract": False,
                "ordering": ["display_order", "name"],
            },
        ),
        migrations.CreateModel(
            name="ProjectDocuments",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "document",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=NEMO.utilities.document_filename_upload,
                        verbose_name="Document",
                    ),
                ),
                ("url", models.CharField(blank=True, max_length=200, null=True, verbose_name="URL")),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="The optional name to display for this document",
                        max_length=200,
                        null=True,
                    ),
                ),
                ("uploaded_at", models.DateTimeField(auto_now_add=True)),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="project_documents", to="NEMO.project"
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Project documents",
                "ordering": ["-uploaded_at"],
            },
        ),
        migrations.AddField(
            model_name="project",
            name="discipline",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="NEMO.discipline"
            ),
        ),
        migrations.CreateModel(
            name="UserDocuments",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "document",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=NEMO.utilities.document_filename_upload,
                        verbose_name="Document",
                    ),
                ),
                ("url", models.CharField(blank=True, max_length=200, null=True, verbose_name="URL")),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="The optional name to display for this document",
                        max_length=200,
                        null=True,
                    ),
                ),
                ("uploaded_at", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_documents",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "User documents",
                "ordering": ["-uploaded_at"],
            },
        ),
        migrations.AddField(
            model_name="user",
            name="discipline",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="NEMO.discipline"
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="onboarding_phases",
            field=models.ManyToManyField(blank=True, to="NEMO.onboardingphase"),
        ),
        migrations.AddField(
            model_name="user",
            name="safety_trainings",
            field=models.ManyToManyField(blank=True, to="NEMO.safetytraining"),
        ),
        migrations.AddField(
            model_name="user",
            name="is_accounting_officer",
            field=models.BooleanField(
                default=False,
                help_text="Designates this user as Accounting officer. Accounting officers can manage projects, view user details, and check usage/billing.",
                verbose_name="accounting officer",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="is_user_office",
            field=models.BooleanField(
                default=False,
                help_text="Designates this user as part of the User Office. User Office staff can create and manage users and projects, charge supplies, check usage etc.",
                verbose_name="user office",
            ),
        ),
        migrations.AlterField(
            model_name="user",
            name="is_staff",
            field=models.BooleanField(
                default=False,
                help_text="Designates this user as technical staff. Technical staff can start remote projects, check maintenance, change configuration, train users etc.",
                verbose_name="staff",
            ),
        ),
        migrations.AlterField(
            model_name="physicalaccesslevel",
            name="allow_staff_access",
            field=models.BooleanField(
                default=False,
                help_text="Check this box to allow access to Staff and User Office members without explicitly granting them access",
            ),
        ),
        migrations.RunPython(news_for_version_forward("4.4.0"), news_for_version_reverse("4.4.0")),
        migrations.RemoveField(
            model_name="user",
            name="discipline",
        ),
        migrations.AlterField(
            model_name="chemicalhazard",
            name="display_order",
            field=models.IntegerField(
                help_text="The display order is used to sort these items. The lowest value category is displayed first."
            ),
        ),
        migrations.AlterField(
            model_name="chemicalhazard",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name="contactinformationcategory",
            name="display_order",
            field=models.IntegerField(
                help_text="The display order is used to sort these items. The lowest value category is displayed first."
            ),
        ),
        migrations.AlterField(
            model_name="contactinformationcategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name="onboardingphase",
            name="display_order",
            field=models.IntegerField(
                help_text="The display order is used to sort these items. The lowest value category is displayed first."
            ),
        ),
        migrations.AlterField(
            model_name="onboardingphase",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name="safetytraining",
            name="display_order",
            field=models.IntegerField(
                help_text="The display order is used to sort these items. The lowest value category is displayed first."
            ),
        ),
        migrations.AlterField(
            model_name="safetytraining",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name="staffavailabilitycategory",
            name="display_order",
            field=models.IntegerField(
                help_text="The display order is used to sort these items. The lowest value category is displayed first."
            ),
        ),
        migrations.AlterField(
            model_name="staffavailabilitycategory",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.CreateModel(
            name="SafetyCategory",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The unique name for this item", max_length=200, unique=True)),
                (
                    "display_order",
                    models.IntegerField(
                        help_text="The display order is used to sort these items. The lowest value category is displayed first."
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Safety categories",
                "ordering": ["display_order", "name"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SafetyItem",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The safety item name.", max_length=200)),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="The description for this safety item. HTML can be used.", null=True
                    ),
                ),
                (
                    "category",
                    models.ForeignKey(
                        blank=True,
                        help_text="The category for this safety item.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="NEMO.safetycategory",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SafetyItemDocuments",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "document",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=NEMO.utilities.document_filename_upload,
                        verbose_name="Document",
                    ),
                ),
                ("url", models.CharField(blank=True, max_length=200, null=True, verbose_name="URL")),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="The optional name to display for this document",
                        max_length=200,
                        null=True,
                    ),
                ),
                ("uploaded_at", models.DateTimeField(auto_now_add=True)),
                ("safety_item", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="NEMO.safetyitem")),
            ],
            options={
                "verbose_name_plural": "Safety item documents",
                "ordering": ["-uploaded_at"],
            },
        ),
        migrations.AddField(
            model_name="notification",
            name="notification_type",
            field=models.CharField(
                choices=[
                    ("news", "News creation and updates - notifies all users"),
                    ("safetyissue", "New safety issues - notifies staff only"),
                    ("buddyrequest", "New buddy request - notifies all users"),
                    (
                        "buddyrequestmessage",
                        "New buddy request reply - notifies request creator and users who have replied",
                    ),
                    (
                        "temporaryphysicalaccessrequest",
                        "New access request - notifies other users on request and reviewers",
                    ),
                ],
                max_length=100,
                null=True,
            ),
        ),
        migrations.RunPython(migrate_notification_types),
        migrations.AlterModelOptions(
            name="temporaryphysicalaccess",
            options={"ordering": ["-end_time"], "verbose_name_plural": "TemporaryPhysicalAccess"},
        ),
        migrations.RenameModel(
            old_name="Discipline",
            new_name="ProjectDiscipline",
        ),
        migrations.AlterField(
            model_name="notification",
            name="notification_type",
            field=models.CharField(
                choices=[
                    ("news", "News creation and updates - notifies all users"),
                    ("safetyissue", "New safety issues - notifies staff only"),
                    ("buddyrequest", "New buddy request - notifies all users"),
                    (
                        "buddyrequestmessage",
                        "New buddy request reply - notifies request creator and users who have replied",
                    ),
                    (
                        "temporaryphysicalaccessrequest",
                        "New access request - notifies other users on request and reviewers",
                    ),
                ],
                max_length=100,
            ),
        ),
        migrations.RenameModel(
            old_name="BuddyRequestMessage",
            new_name="RequestMessage",
        ),
        migrations.AddField(
            model_name="requestmessage",
            name="content_type",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"
            ),
        ),
        migrations.AddField(
            model_name="requestmessage",
            name="object_id",
            field=models.PositiveIntegerField(null=True),
        ),
        migrations.RunPython(migrate_request_messages),
        migrations.AlterField(
            model_name="requestmessage",
            name="content_type",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"),
        ),
        migrations.AlterField(
            model_name="requestmessage",
            name="object_id",
            field=models.PositiveIntegerField(),
        ),
        migrations.RemoveField(
            model_name="requestmessage",
            name="buddy_request",
        ),
        migrations.RemoveField(
            model_name="userpreferences",
            name="display_new_buddy_request_reply_notification",
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_new_adjustment_request_reply",
            field=models.BooleanField(
                default=True,
                help_text="Whether or not to email the user of replies on adjustment request he commented on",
                verbose_name="email_new_adjustment_request_reply",
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="email_send_adjustment_request_updates",
            field=models.PositiveIntegerField(
                choices=[(1, "Both emails"), (2, "Main email only")], default=1, help_text="Adjustment request updates"
            ),
        ),
        migrations.AlterField(
            model_name="emaillog",
            name="category",
            field=models.IntegerField(
                choices=[
                    (0, "General"),
                    (1, "System"),
                    (2, "Direct Contact"),
                    (3, "Broadcast Email"),
                    (4, "Timed Services"),
                    (5, "Feedback"),
                    (6, "Abuse"),
                    (7, "Safety"),
                    (8, "Tasks"),
                    (9, "Access Requests"),
                    (10, "Sensors"),
                    (11, "Adjustment Requests"),
                ],
                default=0,
            ),
        ),
        migrations.AlterField(
            model_name="landingpagechoice",
            name="notifications",
            field=models.CharField(
                blank=True,
                choices=[
                    ("news", "News creation and updates - notifies all users"),
                    ("safetyissue", "New safety issues - notifies staff only"),
                    ("buddyrequest", "New buddy request - notifies all users"),
                    (
                        "buddyrequestmessage",
                        "New buddy request reply - notifies request creator and users who have replied",
                    ),
                    ("adjustmentrequest", "New adjustment request - notifies facility managers only"),
                    (
                        "adjustmentrequestmessage",
                        "New adjustment request reply - notifies request creator and users who have replied",
                    ),
                    (
                        "temporaryphysicalaccessrequest",
                        "New access request - notifies other users on request and reviewers",
                    ),
                ],
                help_text="Displays a the number of new notifications for the user. For example, if the user has two unread news notifications then the number '2' would appear for the news icon on the landing page.",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="notification_type",
            field=models.CharField(
                choices=[
                    ("news", "News creation and updates - notifies all users"),
                    ("safetyissue", "New safety issues - notifies staff only"),
                    ("buddyrequest", "New buddy request - notifies all users"),
                    (
                        "buddyrequestmessage",
                        "New buddy request reply - notifies request creator and users who have replied",
                    ),
                    ("adjustmentrequest", "New adjustment request - notifies facility managers only"),
                    (
                        "adjustmentrequestmessage",
                        "New adjustment request reply - notifies request creator and users who have replied",
                    ),
                    (
                        "temporaryphysicalaccessrequest",
                        "New access request - notifies other users on request and reviewers",
                    ),
                ],
                max_length=100,
            ),
        ),
        migrations.CreateModel(
            name="AdjustmentRequest",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "creation_time",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The date and time when the request was created."
                    ),
                ),
                (
                    "last_updated",
                    models.DateTimeField(auto_now=True, help_text="The last time this request was modified."),
                ),
                ("item_id", models.PositiveIntegerField(blank=True, null=True)),
                ("description", models.TextField(blank=True, help_text="The description of the request.", null=True)),
                (
                    "manager_note",
                    models.TextField(
                        blank=True,
                        help_text="A manager's note to send to the user when a request is denied or to the user office when it is approved.",
                        null=True,
                    ),
                ),
                ("new_start", models.DateTimeField(blank=True, null=True)),
                ("new_end", models.DateTimeField(blank=True, null=True)),
                ("status", models.IntegerField(choices=[(0, "Pending"), (1, "Approved"), (2, "Denied")], default=0)),
                (
                    "deleted",
                    models.BooleanField(
                        default=False, help_text="Indicates the request has been deleted and won't be shown anymore."
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="adjustment_requests_created",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "item_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "last_updated_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="The last user who modified this request.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="adjustment_requests_updated",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "reviewer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="adjustment_requests_reviewed",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-creation_time"],
            },
        ),
        migrations.AddField(
            model_name="staffavailability",
            name="visible",
            field=models.BooleanField(
                default=True,
                help_text="Specifies whether this staff member should be displayed on the staff status page.",
            ),
        ),
        migrations.AlterModelOptions(
            name="accounttype",
            options={"ordering": ["display_order", "name"]},
        ),
        migrations.AlterModelOptions(
            name="projectdiscipline",
            options={"ordering": ["display_order", "name"]},
        ),
        migrations.AlterModelOptions(
            name="usertype",
            options={"ordering": ["display_order", "name"]},
        ),
        migrations.AddField(
            model_name="accounttype",
            name="display_order",
            field=models.IntegerField(
                default=0,
                help_text="The display order is used to sort these items. The lowest value category is displayed first.",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="projectdiscipline",
            name="display_order",
            field=models.IntegerField(
                default=0,
                help_text="The display order is used to sort these items. The lowest value category is displayed first.",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="usertype",
            name="display_order",
            field=models.IntegerField(
                default=0,
                help_text="The display order is used to sort these items. The lowest value category is displayed first.",
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="accounttype",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name="usertype",
            name="name",
            field=models.CharField(help_text="The unique name for this item", max_length=200, unique=True),
        ),
        migrations.AlterField(
            model_name="interlock",
            name="unit_id",
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name="Multiplier/Unit id"),
        ),
        migrations.AlterField(
            model_name="safetyissue",
            name="location",
            field=models.CharField(blank=True, max_length=200, null=True),
        ),
        migrations.AddField(
            model_name="areaaccessrecord",
            name="validated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="consumablewithdraw",
            name="validated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="reservation",
            name="validated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="trainingsession",
            name="validated",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="usageevent",
            name="remote_work",
            field=models.BooleanField(default=False),
        ),
        migrations.RunPython(set_remote_work_flag),
        migrations.AlterField(
            model_name="door",
            name="interlock",
            field=models.OneToOneField(
                blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="NEMO.interlock"
            ),
        ),
        migrations.CreateModel(
            name="ToolQualificationGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(help_text="The name of this tool group", max_length=200, unique=True)),
                ("tools", models.ManyToManyField(to="NEMO.tool")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="areaaccessrecord",
            name="validated_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="area_access_validated_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="consumablewithdraw",
            name="validated_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="consumable_withdrawal_validated_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="reservation",
            name="validated_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="reservation_validated_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="staffcharge",
            name="validated_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="staff_charge_validated_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="trainingsession",
            name="validated_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="training_validated_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="usageevent",
            name="validated_by",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="usage_event_validated_set",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.RunPython(news_for_version_forward("4.6.0"), news_for_version_reverse("4.6.0")),
        migrations.AddField(
            model_name="userpreferences",
            name="tool_freed_time_notifications",
            field=models.ManyToManyField(
                blank=True, help_text="Tools to receive notification when reservation time is freed.", to="NEMO.tool"
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="tool_freed_time_notifications_max_future_days",
            field=models.PositiveIntegerField(
                default=7, help_text="Maximum number of days in the future to receive a notification for."
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="tool_freed_time_notifications_min_time",
            field=models.PositiveIntegerField(
                default=120, help_text="Minimum amount of minutes freed to receive a notification."
            ),
        ),
        migrations.AddField(
            model_name="tool",
            name="_qualifications_never_expire",
            field=models.BooleanField(
                db_column="qualifications_never_expire",
                default=False,
                help_text="Check this box if qualifications for this tool should never expire (even if the tool qualification expiration feature is enabled).",
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="tool_adjustment_notifications",
            field=models.ManyToManyField(
                blank=True,
                help_text="Tools to see/receive adjustment notifications for. If empty all notifications will be received.",
                related_name="_NEMO_userpreferences_tool_adjustment_notifications_+",
                to="NEMO.tool",
            ),
        ),
        migrations.AlterField(
            model_name="user",
            name="is_facility_manager",
            field=models.BooleanField(
                default=False,
                help_text="Designates this user as facility manager. Facility managers receive updates on all reported problems in the facility and also review access and adjustment requests.",
                verbose_name="facility manager",
            ),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="tool_task_notifications",
            field=models.ManyToManyField(
                blank=True,
                help_text="Tools to see maintenance records and receive task notifications for. If empty all notifications will be received.",
                related_name="_NEMO_userpreferences_tool_task_notifications_+",
                to="NEMO.tool",
            ),
        ),
        migrations.AddField(
            model_name="consumablewithdraw",
            name="tool_usage",
            field=models.BooleanField(default=False, help_text="Whether this withdraw is from tool usage"),
        ),
        migrations.AlterField(
            model_name="customization",
            name="name",
            field=models.CharField(max_length=100, primary_key=True, serialize=False),
        ),
        migrations.AddField(
            model_name="userpreferences",
            name="area_adjustment_notifications",
            field=models.ManyToManyField(
                blank=True,
                help_text="Areas to see/receive adjustment notifications for. If empty all notifications will be received.",
                related_name="_NEMO_userpreferences_area_adjustment_notifications_+",
                to="NEMO.area",
            ),
        ),
        migrations.RunPython(
            news_for_version_forward(
                "4.7.0",
                "The new version of the calendar allows users to view multiple tool feeds at once by checking the box next to each tool you would like to see.",
            ),
            news_for_version_reverse("4.7.0"),
        ),
        migrations.AlterField(
            model_name="interlock",
            name="unit_id",
            field=models.PositiveIntegerField(blank=True, null=True, verbose_name="Multiplier/Unit id/Bank"),
        ),
        migrations.AddField(
            model_name="consumable",
            name="allow_self_checkout",
            field=models.BooleanField(
                default=True,
                help_text="Allow users to self checkout this consumable, only applicable when self checkout customization is enabled.",
            ),
        ),
        migrations.AddField(
            model_name="consumable",
            name="notes",
            field=models.TextField(blank=True, help_text="Notes about the consumable.", null=True),
        ),
        migrations.AddField(
            model_name="area",
            name="access_request_reviewers",
            field=models.ManyToManyField(
                blank=True,
                help_text="Users who can approve/deny access requests for this area. Defaults to facility managers if left blank.",
                related_name="access_request_reviewer_on_areas",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="area",
            name="adjustment_request_reviewers",
            field=models.ManyToManyField(
                blank=True,
                help_text="Users who can approve/deny adjustment requests for this area. Defaults to facility managers if left blank.",
                related_name="adjustment_request_reviewer_on_areas",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="tool",
            name="_adjustment_request_reviewers",
            field=models.ManyToManyField(
                blank=True,
                db_table="NEMO_tool_adjustment_request_reviewers",
                help_text="Users who can approve/deny adjustment requests for this tool. Defaults to facility managers if left blank.",
                related_name="adjustment_request_reviewer_on_tools",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.RunPython(
            migrate_adjustment_request_reviewers_forward,
            migrate_adjustment_request_reviewers_reverse,
        ),
        migrations.RemoveField(
            model_name="userpreferences",
            name="area_adjustment_notifications",
        ),
        migrations.RemoveField(
            model_name="userpreferences",
            name="tool_adjustment_notifications",
        ),
        migrations.AlterField(
            model_name="landingpagechoice",
            name="notifications",
            field=models.CharField(
                blank=True,
                choices=[
                    ("news", "News creation and updates - notifies all users"),
                    ("safetyissue", "New safety issues - notifies staff only"),
                    ("buddyrequest", "New buddy request - notifies all users"),
                    (
                        "buddyrequestmessage",
                        "New buddy request reply - notifies request creator and users who have replied",
                    ),
                    ("adjustmentrequest", "New adjustment request - notifies reviewers only"),
                    (
                        "adjustmentrequestmessage",
                        "New adjustment request reply - notifies request creator and users who have replied",
                    ),
                    (
                        "temporaryphysicalaccessrequest",
                        "New access request - notifies other users on request and reviewers",
                    ),
                ],
                help_text="Displays a the number of new notifications for the user. For example, if the user has two unread news notifications then the number '2' would appear for the news icon on the landing page.",
                max_length=100,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="notification_type",
            field=models.CharField(
                choices=[
                    ("news", "News creation and updates - notifies all users"),
                    ("safetyissue", "New safety issues - notifies staff only"),
                    ("buddyrequest", "New buddy request - notifies all users"),
                    (
                        "buddyrequestmessage",
                        "New buddy request reply - notifies request creator and users who have replied",
                    ),
                    ("adjustmentrequest", "New adjustment request - notifies reviewers only"),
                    (
                        "adjustmentrequestmessage",
                        "New adjustment request reply - notifies request creator and users who have replied",
                    ),
                    (
                        "temporaryphysicalaccessrequest",
                        "New access request - notifies other users on request and reviewers",
                    ),
                ],
                max_length=100,
            ),
        ),
        migrations.AddField(
            model_name="area",
            name="auto_logout_time",
            field=models.PositiveIntegerField(
                blank=True,
                help_text="Number of minutes after which users will be automatically logged out of this area.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="closure",
            name="staff_absent",
            field=models.BooleanField(
                default=True,
                help_text="Check this box and all staff members will be marked absent during this closure in staff status.",
                verbose_name="Staff absent entire day",
            ),
        ),
        migrations.RemoveField(
            model_name="consumablewithdraw",
            name="tool_usage",
        ),
        migrations.AddField(
            model_name="consumablewithdraw",
            name="usage_event",
            field=models.ForeignKey(
                blank=True,
                help_text="Whether this withdraw is from tool usage",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NEMO.usageevent",
            ),
        ),
        migrations.AlterField(
            model_name="projectdocuments",
            name="document",
            field=models.FileField(
                blank=True,
                max_length=255,
                null=True,
                upload_to=NEMO.utilities.document_filename_upload,
                verbose_name="Document",
            ),
        ),
        migrations.AlterField(
            model_name="safetyitemdocuments",
            name="document",
            field=models.FileField(
                blank=True,
                max_length=255,
                null=True,
                upload_to=NEMO.utilities.document_filename_upload,
                verbose_name="Document",
            ),
        ),
        migrations.AlterField(
            model_name="tooldocuments",
            name="document",
            field=models.FileField(
                blank=True,
                max_length=255,
                null=True,
                upload_to=NEMO.utilities.document_filename_upload,
                verbose_name="Document",
            ),
        ),
        migrations.AlterField(
            model_name="userdocuments",
            name="document",
            field=models.FileField(
                blank=True,
                max_length=255,
                null=True,
                upload_to=NEMO.utilities.document_filename_upload,
                verbose_name="Document",
            ),
        ),
    ]
