import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkflowsWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the workflow provided by the user. Must be at most 1000 unicode characters long.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#description WorkflowsWorkflow#description}
     */
    readonly description?: string;
    /**
     * A set of key/value label pairs to assign to this Workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#labels WorkflowsWorkflow#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the Workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#name WorkflowsWorkflow#name}
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#name_prefix WorkflowsWorkflow#name_prefix}.
     */
    readonly namePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#project WorkflowsWorkflow#project}.
     */
    readonly project?: string;
    /**
     * The region of the workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#region WorkflowsWorkflow#region}
     */
    readonly region?: string;
    /**
     * Name of the service account associated with the latest workflow version.
     *
     * This service
     * account represents the identity of the workflow and determines what permissions the workflow has.
     *
     * Format: projects/{project}/serviceAccounts/{account}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#service_account WorkflowsWorkflow#service_account}
     */
    readonly serviceAccount?: string;
    /**
     * Workflow code to be executed. The size limit is 32KB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#source_contents WorkflowsWorkflow#source_contents}
     */
    readonly sourceContents?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#timeouts WorkflowsWorkflow#timeouts}
     */
    readonly timeouts?: WorkflowsWorkflowTimeouts;
}
export interface WorkflowsWorkflowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#create WorkflowsWorkflow#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#delete WorkflowsWorkflow#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html#update WorkflowsWorkflow#update}.
     */
    readonly update?: string;
}
export declare class WorkflowsWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html google_workflows_workflow}.
 */
export declare class WorkflowsWorkflow extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/workflows_workflow.html google_workflows_workflow} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config?: WorkflowsWorkflowConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get revisionId(): string;
    private _serviceAccount?;
    get serviceAccount(): string | undefined;
    set serviceAccount(value: string | undefined);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _sourceContents?;
    get sourceContents(): string | undefined;
    set sourceContents(value: string | undefined);
    resetSourceContents(): void;
    get sourceContentsInput(): string | undefined;
    get state(): string;
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): WorkflowsWorkflowTimeoutsOutputReference;
    putTimeouts(value: WorkflowsWorkflowTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): WorkflowsWorkflowTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
