import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VertexAiDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
     * The user-defined name of the Dataset.
     *
     * The name can be up to 128 characters long and can be consist of any UTF-8 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#display_name VertexAiDataset#display_name}
     */
    readonly displayName: string;
    /**
     * A set of key/value label pairs to assign to this Workflow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#labels VertexAiDataset#labels}
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Points to a YAML file stored on Google Cloud Storage describing additional information about the Dataset.
     *
     * The schema is defined as an OpenAPI 3.0.2 Schema Object. The schema files that can be used here are found in gs://google-cloud-aiplatform/schema/dataset/metadata/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#metadata_schema_uri VertexAiDataset#metadata_schema_uri}
     */
    readonly metadataSchemaUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#project VertexAiDataset#project}.
     */
    readonly project?: string;
    /**
     * The region of the dataset. eg us-central1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#region VertexAiDataset#region}
     */
    readonly region?: string;
    /**
     * encryption_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#encryption_spec VertexAiDataset#encryption_spec}
     */
    readonly encryptionSpec?: VertexAiDatasetEncryptionSpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#timeouts VertexAiDataset#timeouts}
     */
    readonly timeouts?: VertexAiDatasetTimeouts;
}
export interface VertexAiDatasetEncryptionSpec {
    /**
     * Required.
     *
     * The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
     * Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#kms_key_name VertexAiDataset#kms_key_name}
     */
    readonly kmsKeyName?: string;
}
export declare class VertexAiDatasetEncryptionSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kmsKeyName?;
    get kmsKeyName(): string | undefined;
    set kmsKeyName(value: string | undefined);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface VertexAiDatasetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#create VertexAiDataset#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#delete VertexAiDataset#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html#update VertexAiDataset#update}.
     */
    readonly update?: string;
}
export declare class VertexAiDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html google_vertex_ai_dataset}.
 */
export declare class VertexAiDataset extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/vertex_ai_dataset.html google_vertex_ai_dataset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: VertexAiDatasetConfig);
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _metadataSchemaUri?;
    get metadataSchemaUri(): string;
    set metadataSchemaUri(value: string);
    get metadataSchemaUriInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get updateTime(): string;
    private _encryptionSpec?;
    private __encryptionSpecOutput;
    get encryptionSpec(): VertexAiDatasetEncryptionSpecOutputReference;
    putEncryptionSpec(value: VertexAiDatasetEncryptionSpec | undefined): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): VertexAiDatasetEncryptionSpec | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): VertexAiDatasetTimeoutsOutputReference;
    putTimeouts(value: VertexAiDatasetTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): VertexAiDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
