import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagsTagValueConfig extends cdktf.TerraformMetaArguments {
    /**
     * User-assigned description of the TagValue. Must not exceed 256 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#description TagsTagValue#description}
     */
    readonly description?: string;
    /**
     * Input only. The resource name of the new TagValue's parent. Must be of the form tagKeys/{tag_key_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#parent TagsTagValue#parent}
     */
    readonly parent: string;
    /**
     * Input only.
     *
     * User-assigned short name for TagValue. The short name should be unique for TagValues within the same parent TagKey.
     *
     * The short name must be 63 characters or less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#short_name TagsTagValue#short_name}
     */
    readonly shortName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#timeouts TagsTagValue#timeouts}
     */
    readonly timeouts?: TagsTagValueTimeouts;
}
export interface TagsTagValueTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#create TagsTagValue#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#delete TagsTagValue#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html#update TagsTagValue#update}.
     */
    readonly update?: string;
}
export declare class TagsTagValueTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html google_tags_tag_value}.
 */
export declare class TagsTagValue extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_tag_value.html google_tags_tag_value} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: TagsTagValueConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): TagsTagValueTimeoutsOutputReference;
    putTimeouts(value: TagsTagValueTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): TagsTagValueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
