import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TagsTagKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * User-assigned description of the TagKey. Must not exceed 256 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#description TagsTagKey#description}
     */
    readonly description?: string;
    /**
     * Input only. The resource name of the new TagKey's parent. Must be of the form organizations/{org_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#parent TagsTagKey#parent}
     */
    readonly parent: string;
    /**
     * Input only.
     *
     * The user friendly name for a TagKey. The short name should be unique for TagKeys within the same tag namespace.
     *
     * The short name must be 1-63 characters, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#short_name TagsTagKey#short_name}
     */
    readonly shortName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#timeouts TagsTagKey#timeouts}
     */
    readonly timeouts?: TagsTagKeyTimeouts;
}
export interface TagsTagKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#create TagsTagKey#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#delete TagsTagKey#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html#update TagsTagKey#update}.
     */
    readonly update?: string;
}
export declare class TagsTagKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html google_tags_tag_key}.
 */
export declare class TagsTagKey extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/tags_tag_key.html google_tags_tag_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: TagsTagKeyConfig);
    get createTime(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    get name(): string;
    get namespacedName(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    get updateTime(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): TagsTagKeyTimeoutsOutputReference;
    putTimeouts(value: TagsTagKeyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): TagsTagKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
