import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageTransferJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Unique description to identify the Transfer Job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#description StorageTransferJob#description}
     */
    readonly description: string;
    /**
     * The project in which the resource belongs. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#project StorageTransferJob#project}
     */
    readonly project?: string;
    /**
     * Status of the job.
     *
     * Default: ENABLED. NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#status StorageTransferJob#status}
     */
    readonly status?: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule StorageTransferJob#schedule}
     */
    readonly schedule: StorageTransferJobSchedule;
    /**
     * transfer_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#transfer_spec StorageTransferJob#transfer_spec}
     */
    readonly transferSpec: StorageTransferJobTransferSpec;
}
export interface StorageTransferJobScheduleScheduleEndDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#day StorageTransferJob#day}
     */
    readonly day: number;
    /**
     * Month of year. Must be from 1 to 12.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#month StorageTransferJob#month}
     */
    readonly month: number;
    /**
     * Year of date. Must be from 1 to 9999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#year StorageTransferJob#year}
     */
    readonly year: number;
}
export declare class StorageTransferJobScheduleScheduleEndDateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface StorageTransferJobScheduleScheduleStartDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#day StorageTransferJob#day}
     */
    readonly day: number;
    /**
     * Month of year. Must be from 1 to 12.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#month StorageTransferJob#month}
     */
    readonly month: number;
    /**
     * Year of date. Must be from 1 to 9999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#year StorageTransferJob#year}
     */
    readonly year: number;
}
export declare class StorageTransferJobScheduleScheduleStartDateOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface StorageTransferJobScheduleStartTimeOfDay {
    /**
     * Hours of day in 24 hour format. Should be from 0 to 23.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#hours StorageTransferJob#hours}
     */
    readonly hours: number;
    /**
     * Minutes of hour of day. Must be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#minutes StorageTransferJob#minutes}
     */
    readonly minutes: number;
    /**
     * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#nanos StorageTransferJob#nanos}
     */
    readonly nanos: number;
    /**
     * Seconds of minutes of the time. Must normally be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#seconds StorageTransferJob#seconds}
     */
    readonly seconds: number;
}
export declare class StorageTransferJobScheduleStartTimeOfDayOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface StorageTransferJobSchedule {
    /**
     * schedule_end_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule_end_date StorageTransferJob#schedule_end_date}
     */
    readonly scheduleEndDate?: StorageTransferJobScheduleScheduleEndDate;
    /**
     * schedule_start_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule_start_date StorageTransferJob#schedule_start_date}
     */
    readonly scheduleStartDate: StorageTransferJobScheduleScheduleStartDate;
    /**
     * start_time_of_day block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#start_time_of_day StorageTransferJob#start_time_of_day}
     */
    readonly startTimeOfDay?: StorageTransferJobScheduleStartTimeOfDay;
}
export declare class StorageTransferJobScheduleOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _scheduleEndDate?;
    private __scheduleEndDateOutput;
    get scheduleEndDate(): StorageTransferJobScheduleScheduleEndDateOutputReference;
    putScheduleEndDate(value: StorageTransferJobScheduleScheduleEndDate | undefined): void;
    resetScheduleEndDate(): void;
    get scheduleEndDateInput(): StorageTransferJobScheduleScheduleEndDate | undefined;
    private _scheduleStartDate?;
    private __scheduleStartDateOutput;
    get scheduleStartDate(): StorageTransferJobScheduleScheduleStartDateOutputReference;
    putScheduleStartDate(value: StorageTransferJobScheduleScheduleStartDate): void;
    get scheduleStartDateInput(): StorageTransferJobScheduleScheduleStartDate | undefined;
    private _startTimeOfDay?;
    private __startTimeOfDayOutput;
    get startTimeOfDay(): StorageTransferJobScheduleStartTimeOfDayOutputReference;
    putStartTimeOfDay(value: StorageTransferJobScheduleStartTimeOfDay | undefined): void;
    resetStartTimeOfDay(): void;
    get startTimeOfDayInput(): StorageTransferJobScheduleStartTimeOfDay | undefined;
}
export interface StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey {
    /**
     * AWS Key ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#access_key_id StorageTransferJob#access_key_id}
     */
    readonly accessKeyId: string;
    /**
     * AWS Secret Access Key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#secret_access_key StorageTransferJob#secret_access_key}
     */
    readonly secretAccessKey: string;
}
export declare class StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    get accessKeyIdInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    get secretAccessKeyInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecAwsS3DataSource {
    /**
     * S3 Bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     */
    readonly bucketName: string;
    /**
     * aws_access_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#aws_access_key StorageTransferJob#aws_access_key}
     */
    readonly awsAccessKey: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey;
}
export declare class StorageTransferJobTransferSpecAwsS3DataSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _awsAccessKey?;
    private __awsAccessKeyOutput;
    get awsAccessKey(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference;
    putAwsAccessKey(value: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): void;
    get awsAccessKeyInput(): StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
}
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials {
    /**
     * Azure shared access signature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#sas_token StorageTransferJob#sas_token}
     */
    readonly sasToken: string;
}
export declare class StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    get sasTokenInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSource {
    /**
     * The container to transfer from the Azure Storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#container StorageTransferJob#container}
     */
    readonly container: string;
    /**
     * Root path to transfer objects.
     *
     * Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     */
    readonly path?: string;
    /**
     * The name of the Azure Storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#storage_account StorageTransferJob#storage_account}
     */
    readonly storageAccount: string;
    /**
     * azure_credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#azure_credentials StorageTransferJob#azure_credentials}
     */
    readonly azureCredentials: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials;
}
export declare class StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _storageAccount?;
    get storageAccount(): string;
    set storageAccount(value: string);
    get storageAccountInput(): string | undefined;
    private _azureCredentials?;
    private __azureCredentialsOutput;
    get azureCredentials(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference;
    putAzureCredentials(value: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): void;
    get azureCredentialsInput(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
}
export interface StorageTransferJobTransferSpecGcsDataSink {
    /**
     * Google Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     */
    readonly bucketName: string;
    /**
     * Google Cloud Storage path in bucket to transfer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     */
    readonly path?: string;
}
export declare class StorageTransferJobTransferSpecGcsDataSinkOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecGcsDataSource {
    /**
     * Google Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     */
    readonly bucketName: string;
    /**
     * Google Cloud Storage path in bucket to transfer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     */
    readonly path?: string;
}
export declare class StorageTransferJobTransferSpecGcsDataSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _path?;
    get path(): string | undefined;
    set path(value: string | undefined);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecHttpDataSource {
    /**
     * The URL that points to the file that stores the object list entries.
     *
     * This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#list_url StorageTransferJob#list_url}
     */
    readonly listUrl: string;
}
export declare class StorageTransferJobTransferSpecHttpDataSourceOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _listUrl?;
    get listUrl(): string;
    set listUrl(value: string);
    get listUrlInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecObjectConditions {
    /**
     * exclude_prefixes must follow the requirements described for include_prefixes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#exclude_prefixes StorageTransferJob#exclude_prefixes}
     */
    readonly excludePrefixes?: string[];
    /**
     * If include_refixes is specified, objects that satisfy the object conditions must have names that start with one of the include_prefixes and that do not start with any of the exclude_prefixes.
     *
     * If include_prefixes is not specified, all objects except those that have names starting with one of the exclude_prefixes must satisfy the object conditions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#include_prefixes StorageTransferJob#include_prefixes}
     */
    readonly includePrefixes?: string[];
    /**
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#max_time_elapsed_since_last_modification StorageTransferJob#max_time_elapsed_since_last_modification}
     */
    readonly maxTimeElapsedSinceLastModification?: string;
    /**
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#min_time_elapsed_since_last_modification StorageTransferJob#min_time_elapsed_since_last_modification}
     */
    readonly minTimeElapsedSinceLastModification?: string;
}
export declare class StorageTransferJobTransferSpecObjectConditionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _excludePrefixes?;
    get excludePrefixes(): string[] | undefined;
    set excludePrefixes(value: string[] | undefined);
    resetExcludePrefixes(): void;
    get excludePrefixesInput(): string[] | undefined;
    private _includePrefixes?;
    get includePrefixes(): string[] | undefined;
    set includePrefixes(value: string[] | undefined);
    resetIncludePrefixes(): void;
    get includePrefixesInput(): string[] | undefined;
    private _maxTimeElapsedSinceLastModification?;
    get maxTimeElapsedSinceLastModification(): string | undefined;
    set maxTimeElapsedSinceLastModification(value: string | undefined);
    resetMaxTimeElapsedSinceLastModification(): void;
    get maxTimeElapsedSinceLastModificationInput(): string | undefined;
    private _minTimeElapsedSinceLastModification?;
    get minTimeElapsedSinceLastModification(): string | undefined;
    set minTimeElapsedSinceLastModification(value: string | undefined);
    resetMinTimeElapsedSinceLastModification(): void;
    get minTimeElapsedSinceLastModificationInput(): string | undefined;
}
export interface StorageTransferJobTransferSpecTransferOptions {
    /**
     * Whether objects should be deleted from the source after they are transferred to the sink.
     *
     * Note that this option and delete_objects_unique_in_sink are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#delete_objects_from_source_after_transfer StorageTransferJob#delete_objects_from_source_after_transfer}
     */
    readonly deleteObjectsFromSourceAfterTransfer?: boolean | cdktf.IResolvable;
    /**
     * Whether objects that exist only in the sink should be deleted.
     *
     * Note that this option and delete_objects_from_source_after_transfer are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#delete_objects_unique_in_sink StorageTransferJob#delete_objects_unique_in_sink}
     */
    readonly deleteObjectsUniqueInSink?: boolean | cdktf.IResolvable;
    /**
     * Whether overwriting objects that already exist in the sink is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#overwrite_objects_already_existing_in_sink StorageTransferJob#overwrite_objects_already_existing_in_sink}
     */
    readonly overwriteObjectsAlreadyExistingInSink?: boolean | cdktf.IResolvable;
}
export declare class StorageTransferJobTransferSpecTransferOptionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _deleteObjectsFromSourceAfterTransfer?;
    get deleteObjectsFromSourceAfterTransfer(): boolean | cdktf.IResolvable | undefined;
    set deleteObjectsFromSourceAfterTransfer(value: boolean | cdktf.IResolvable | undefined);
    resetDeleteObjectsFromSourceAfterTransfer(): void;
    get deleteObjectsFromSourceAfterTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteObjectsUniqueInSink?;
    get deleteObjectsUniqueInSink(): boolean | cdktf.IResolvable | undefined;
    set deleteObjectsUniqueInSink(value: boolean | cdktf.IResolvable | undefined);
    resetDeleteObjectsUniqueInSink(): void;
    get deleteObjectsUniqueInSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _overwriteObjectsAlreadyExistingInSink?;
    get overwriteObjectsAlreadyExistingInSink(): boolean | cdktf.IResolvable | undefined;
    set overwriteObjectsAlreadyExistingInSink(value: boolean | cdktf.IResolvable | undefined);
    resetOverwriteObjectsAlreadyExistingInSink(): void;
    get overwriteObjectsAlreadyExistingInSinkInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageTransferJobTransferSpec {
    /**
     * aws_s3_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#aws_s3_data_source StorageTransferJob#aws_s3_data_source}
     */
    readonly awsS3DataSource?: StorageTransferJobTransferSpecAwsS3DataSource;
    /**
     * azure_blob_storage_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#azure_blob_storage_data_source StorageTransferJob#azure_blob_storage_data_source}
     */
    readonly azureBlobStorageDataSource?: StorageTransferJobTransferSpecAzureBlobStorageDataSource;
    /**
     * gcs_data_sink block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#gcs_data_sink StorageTransferJob#gcs_data_sink}
     */
    readonly gcsDataSink?: StorageTransferJobTransferSpecGcsDataSink;
    /**
     * gcs_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#gcs_data_source StorageTransferJob#gcs_data_source}
     */
    readonly gcsDataSource?: StorageTransferJobTransferSpecGcsDataSource;
    /**
     * http_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#http_data_source StorageTransferJob#http_data_source}
     */
    readonly httpDataSource?: StorageTransferJobTransferSpecHttpDataSource;
    /**
     * object_conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#object_conditions StorageTransferJob#object_conditions}
     */
    readonly objectConditions?: StorageTransferJobTransferSpecObjectConditions;
    /**
     * transfer_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#transfer_options StorageTransferJob#transfer_options}
     */
    readonly transferOptions?: StorageTransferJobTransferSpecTransferOptions;
}
export declare class StorageTransferJobTransferSpecOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _awsS3DataSource?;
    private __awsS3DataSourceOutput;
    get awsS3DataSource(): StorageTransferJobTransferSpecAwsS3DataSourceOutputReference;
    putAwsS3DataSource(value: StorageTransferJobTransferSpecAwsS3DataSource | undefined): void;
    resetAwsS3DataSource(): void;
    get awsS3DataSourceInput(): StorageTransferJobTransferSpecAwsS3DataSource | undefined;
    private _azureBlobStorageDataSource?;
    private __azureBlobStorageDataSourceOutput;
    get azureBlobStorageDataSource(): StorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference;
    putAzureBlobStorageDataSource(value: StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined): void;
    resetAzureBlobStorageDataSource(): void;
    get azureBlobStorageDataSourceInput(): StorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    private _gcsDataSink?;
    private __gcsDataSinkOutput;
    get gcsDataSink(): StorageTransferJobTransferSpecGcsDataSinkOutputReference;
    putGcsDataSink(value: StorageTransferJobTransferSpecGcsDataSink | undefined): void;
    resetGcsDataSink(): void;
    get gcsDataSinkInput(): StorageTransferJobTransferSpecGcsDataSink | undefined;
    private _gcsDataSource?;
    private __gcsDataSourceOutput;
    get gcsDataSource(): StorageTransferJobTransferSpecGcsDataSourceOutputReference;
    putGcsDataSource(value: StorageTransferJobTransferSpecGcsDataSource | undefined): void;
    resetGcsDataSource(): void;
    get gcsDataSourceInput(): StorageTransferJobTransferSpecGcsDataSource | undefined;
    private _httpDataSource?;
    private __httpDataSourceOutput;
    get httpDataSource(): StorageTransferJobTransferSpecHttpDataSourceOutputReference;
    putHttpDataSource(value: StorageTransferJobTransferSpecHttpDataSource | undefined): void;
    resetHttpDataSource(): void;
    get httpDataSourceInput(): StorageTransferJobTransferSpecHttpDataSource | undefined;
    private _objectConditions?;
    private __objectConditionsOutput;
    get objectConditions(): StorageTransferJobTransferSpecObjectConditionsOutputReference;
    putObjectConditions(value: StorageTransferJobTransferSpecObjectConditions | undefined): void;
    resetObjectConditions(): void;
    get objectConditionsInput(): StorageTransferJobTransferSpecObjectConditions | undefined;
    private _transferOptions?;
    private __transferOptionsOutput;
    get transferOptions(): StorageTransferJobTransferSpecTransferOptionsOutputReference;
    putTransferOptions(value: StorageTransferJobTransferSpecTransferOptions | undefined): void;
    resetTransferOptions(): void;
    get transferOptionsInput(): StorageTransferJobTransferSpecTransferOptions | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html google_storage_transfer_job}.
 */
export declare class StorageTransferJob extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html google_storage_transfer_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageTransferJobConfig);
    get creationTime(): string;
    get deletionTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get id(): string;
    get lastModificationTime(): string;
    get name(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _schedule?;
    private __scheduleOutput;
    get schedule(): StorageTransferJobScheduleOutputReference;
    putSchedule(value: StorageTransferJobSchedule): void;
    get scheduleInput(): StorageTransferJobSchedule | undefined;
    private _transferSpec?;
    private __transferSpecOutput;
    get transferSpec(): StorageTransferJobTransferSpecOutputReference;
    putTransferSpec(value: StorageTransferJobTransferSpec): void;
    get transferSpecInput(): StorageTransferJobTransferSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
