import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageObjectAclConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#bucket StorageObjectAcl#bucket}.
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#object StorageObjectAcl#object}.
     */
    readonly object: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#predefined_acl StorageObjectAcl#predefined_acl}.
     */
    readonly predefinedAcl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#role_entity StorageObjectAcl#role_entity}.
     */
    readonly roleEntity?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html google_storage_object_acl}.
 */
export declare class StorageObjectAcl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html google_storage_object_acl} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageObjectAclConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get id(): string;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
    private _predefinedAcl?;
    get predefinedAcl(): string | undefined;
    set predefinedAcl(value: string | undefined);
    resetPredefinedAcl(): void;
    get predefinedAclInput(): string | undefined;
    private _roleEntity?;
    get roleEntity(): string[] | undefined;
    set roleEntity(value: string[] | undefined);
    resetRoleEntity(): void;
    get roleEntityInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
