import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageObjectAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#bucket StorageObjectAccessControl#bucket}
     */
    readonly bucket: string;
    /**
     * The entity holding the permission, in one of the following forms: user-{{userId}} user-{{email}} (such as "user-liz@example.com") group-{{groupId}} group-{{email}} (such as "group-example@googlegroups.com") domain-{{domain}} (such as "domain-example.com") project-team-{{projectId}} allUsers allAuthenticatedUsers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#entity StorageObjectAccessControl#entity}
     */
    readonly entity: string;
    /**
     * The name of the object to apply the access control to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#object StorageObjectAccessControl#object}
     */
    readonly object: string;
    /**
     * The access permission for the entity. Possible values: ["OWNER", "READER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#role StorageObjectAccessControl#role}
     */
    readonly role: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#timeouts StorageObjectAccessControl#timeouts}
     */
    readonly timeouts?: StorageObjectAccessControlTimeouts;
}
export declare class StorageObjectAccessControlProjectTeam extends cdktf.ComplexComputedList {
    get projectNumber(): string;
    get team(): string;
}
export interface StorageObjectAccessControlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#create StorageObjectAccessControl#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#delete StorageObjectAccessControl#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#update StorageObjectAccessControl#update}.
     */
    readonly update?: string;
}
export declare class StorageObjectAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html google_storage_object_access_control}.
 */
export declare class StorageObjectAccessControl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html google_storage_object_access_control} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageObjectAccessControlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get domain(): string;
    get email(): string;
    private _entity?;
    get entity(): string;
    set entity(value: string);
    get entityInput(): string | undefined;
    get entityId(): string;
    get generation(): number;
    get id(): string;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
    projectTeam(index: string): StorageObjectAccessControlProjectTeam;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): StorageObjectAccessControlTimeoutsOutputReference;
    putTimeouts(value: StorageObjectAccessControlTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageObjectAccessControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
