import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageNotificationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html#bucket StorageNotification#bucket}
     */
    readonly bucket: string;
    /**
     * A set of key/value attribute pairs to attach to each Cloud Pub/Sub message published for this notification subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html#custom_attributes StorageNotification#custom_attributes}
     */
    readonly customAttributes?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * List of event type filters for this notification config.
     *
     * If not specified, Cloud Storage will send notifications for all event types. The valid types are: "OBJECT_FINALIZE", "OBJECT_METADATA_UPDATE", "OBJECT_DELETE", "OBJECT_ARCHIVE"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html#event_types StorageNotification#event_types}
     */
    readonly eventTypes?: string[];
    /**
     * Specifies a prefix path filter for this notification config.
     *
     * Cloud Storage will only send notifications for objects in this bucket whose names begin with the specified prefix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html#object_name_prefix StorageNotification#object_name_prefix}
     */
    readonly objectNamePrefix?: string;
    /**
     * The desired content of the Payload. One of "JSON_API_V1" or "NONE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html#payload_format StorageNotification#payload_format}
     */
    readonly payloadFormat: string;
    /**
     * The Cloud Pub/Sub topic to which this subscription publishes.
     *
     * Expects either the  topic name, assumed to belong to the default GCP provider project, or the project-level name,  i.e. projects/my-gcp-project/topics/my-topic or my-topic. If the project is not set in the provider, you will need to use the project-level name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html#topic StorageNotification#topic}
     */
    readonly topic: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html google_storage_notification}.
 */
export declare class StorageNotification extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_notification.html google_storage_notification} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageNotificationConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    set customAttributes(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    resetCustomAttributes(): void;
    get customAttributesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _eventTypes?;
    get eventTypes(): string[] | undefined;
    set eventTypes(value: string[] | undefined);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    get id(): string;
    get notificationId(): string;
    private _objectNamePrefix?;
    get objectNamePrefix(): string | undefined;
    set objectNamePrefix(value: string | undefined);
    resetObjectNamePrefix(): void;
    get objectNamePrefixInput(): string | undefined;
    private _payloadFormat?;
    get payloadFormat(): string;
    set payloadFormat(value: string);
    get payloadFormatInput(): string | undefined;
    get selfLink(): string;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
