import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageHmacKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#project StorageHmacKey#project}.
     */
    readonly project?: string;
    /**
     * The email address of the key's associated service account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#service_account_email StorageHmacKey#service_account_email}
     */
    readonly serviceAccountEmail: string;
    /**
     * The state of the key.
     *
     * Can be set to one of ACTIVE, INACTIVE. Default value: "ACTIVE" Possible values: ["ACTIVE", "INACTIVE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#state StorageHmacKey#state}
     */
    readonly state?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#timeouts StorageHmacKey#timeouts}
     */
    readonly timeouts?: StorageHmacKeyTimeouts;
}
export interface StorageHmacKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#create StorageHmacKey#create}.
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#delete StorageHmacKey#delete}.
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html#update StorageHmacKey#update}.
     */
    readonly update?: string;
}
export declare class StorageHmacKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    get create(): string | undefined;
    set create(value: string | undefined);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string | undefined;
    set delete(value: string | undefined);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string | undefined;
    set update(value: string | undefined);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html google_storage_hmac_key}.
 */
export declare class StorageHmacKey extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_hmac_key.html google_storage_hmac_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    constructor(scope: Construct, id: string, config: StorageHmacKeyConfig);
    get accessId(): string;
    get id(): string;
    private _project?;
    get project(): string | undefined;
    set project(value: string | undefined);
    resetProject(): void;
    get projectInput(): string | undefined;
    get secret(): string;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    get serviceAccountEmailInput(): string | undefined;
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    resetState(): void;
    get stateInput(): string | undefined;
    get timeCreated(): string;
    get updated(): string;
    private _timeouts?;
    private __timeoutsOutput;
    get timeouts(): StorageHmacKeyTimeoutsOutputReference;
    putTimeouts(value: StorageHmacKeyTimeouts | undefined): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageHmacKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
